/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.SegmentIndexConstraints;
import com.ibm.pdp.util.RandomBuilder;

public class SegmentIndexConstraintsTest {
    protected static RandomBuilder random;
    protected static final IEngineFactory engine;
    protected static int checkCount;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        engine = new EngineFactory();
    }

    public static void main(String[] args) {
        long seed = System.currentTimeMillis();
        random = new RandomBuilder(seed);
        System.out.println("Start, seed=" + seed + "L");
        SegmentIndexConstraintsTest.test(20);
        System.out.println("Stop, " + checkCount + " checkings performed.");
    }

    protected static void test(int testSize) {
        try {
            Segment segment;
            Segment refSegment;
            int atomRank;
            IGeneratedInfo generatedInfo = SegmentIndexConstraintsTest.makeGeneratedInfo(testSize);
            UserChangeSet refChangeSet = new UserChangeSet();
            refChangeSet.setGeneratedInfo(generatedInfo);
            UserChangeSet modifiedChangeSet = new UserChangeSet();
            modifiedChangeSet.setGeneratedInfo(generatedInfo);
            modifiedChangeSet.setText("");
            modifiedChangeSet.setText(generatedInfo.getText());
            int length = modifiedChangeSet.length();
            int nbAtoms = modifiedChangeSet.nbOfAtomicSegments();
            SegmentIndexConstraints matchingState = new SegmentIndexConstraints(modifiedChangeSet);
            int loop = 0;
            while (!matchingState.isResolved()) {
                atomRank = random.nextInt(nbAtoms);
                refSegment = refChangeSet.atomAt(atomRank);
                segment = modifiedChangeSet.atomAt(atomRank);
                int beginIndex = refSegment.beginIndex();
                int endIndex = refSegment.endIndex();
                int index = random.nextInt(length);
                if (beginIndex > index) {
                    matchingState.addSegmentBeginIndexConstraint(segment, ConstraintType.GreaterThan, index);
                } else if (endIndex < index) {
                    matchingState.addSegmentEndIndexConstraint(segment, ConstraintType.LowerThan, index);
                } else {
                    matchingState.addSegmentBeginIndexConstraint(segment, ConstraintType.LowerOrEqual, index);
                    matchingState.addSegmentEndIndexConstraint(segment, ConstraintType.GreaterOrEqual, index);
                }
                ++loop;
            }
            System.out.println("Loops=" + loop);
            matchingState.applyConstraints();
            atomRank = 0;
            while (atomRank < nbAtoms) {
                refSegment = refChangeSet.atomAt(atomRank);
                segment = modifiedChangeSet.atomAt(atomRank);
                SegmentIndexConstraintsTest.check(refSegment.beginIndex() == segment.beginIndex() && refSegment.endIndex() == segment.endIndex());
                ++atomRank;
            }
        }
        catch (Throwable t) {
            System.out.println("Error after check #" + checkCount + ":");
            t.printStackTrace(System.out);
        }
    }

    protected static void check(boolean condition) {
        ++checkCount;
        if (!condition) {
            throw new RuntimeException("Wrong check #" + checkCount);
        }
    }

    protected static IGeneratedInfo makeGeneratedInfo(int complexity) {
        IGeneratedInfoFactory factory = engine.newGeneratedInfoFactory();
        factory.beginTag("T0");
        SegmentIndexConstraintsTest.makeSubTags(factory, 1, complexity, 0);
        factory.endTag();
        return factory.createGeneratedInfo();
    }

    protected static int makeSubTags(IGeneratedInfoFactory factory, int level, int complexity, int tagCount) {
        String enclosingTag = "T" + tagCount;
        if (complexity == 0) {
            SegmentIndexConstraintsTest.appendText(factory, level, enclosingTag, enclosingTag, enclosingTag);
            return tagCount;
        }
        String fromTag = enclosingTag;
        String toTag = "T" + ++tagCount;
        SegmentIndexConstraintsTest.appendText(factory, level, enclosingTag, fromTag, toTag);
        int t = 0;
        while (t < complexity - 1) {
            factory.beginTag(toTag);
            tagCount = SegmentIndexConstraintsTest.makeSubTags(factory, level + 1, complexity / 10, tagCount);
            factory.endTag();
            fromTag = toTag;
            toTag = "T" + ++tagCount;
            SegmentIndexConstraintsTest.appendText(factory, level, enclosingTag, fromTag, toTag);
            ++t;
        }
        factory.beginTag(toTag);
        tagCount = SegmentIndexConstraintsTest.makeSubTags(factory, level + 1, complexity / 10, tagCount);
        factory.endTag();
        SegmentIndexConstraintsTest.appendText(factory, level, enclosingTag, toTag, enclosingTag);
        return tagCount;
    }

    protected static void appendText(IGeneratedInfoFactory factory, int level, String enclosingTag, String fromTag, String toTag) {
        if (random.nextInt(3) == 0) {
            return;
        }
        boolean fromEqualsTo = fromTag.equals(toTag);
        if (enclosingTag.equals(fromTag)) {
            if (fromEqualsTo) {
                factory.appendText((CharSequence)"[Tag ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)"]");
            } else {
                factory.appendText((CharSequence)"[First part of ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)" before ");
                factory.appendText((CharSequence)toTag);
                factory.appendText((CharSequence)"\n");
                SegmentIndexConstraintsTest.indent(factory, level);
            }
        } else if (enclosingTag.equals(toTag)) {
            factory.appendText((CharSequence)"\n");
            SegmentIndexConstraintsTest.indent(factory, level);
            factory.appendText((CharSequence)"Last part of ");
            factory.appendText((CharSequence)enclosingTag);
            factory.appendText((CharSequence)" after ");
            factory.appendText((CharSequence)fromTag);
            factory.appendText((CharSequence)"]");
        } else {
            factory.appendText((CharSequence)"\n");
            SegmentIndexConstraintsTest.indent(factory, level);
            factory.appendText((CharSequence)"Middle part of ");
            factory.appendText((CharSequence)enclosingTag);
            factory.appendText((CharSequence)" between ");
            factory.appendText((CharSequence)fromTag);
            factory.appendText((CharSequence)" and ");
            factory.appendText((CharSequence)toTag);
            factory.appendText((CharSequence)"\n");
            SegmentIndexConstraintsTest.indent(factory, level);
        }
    }

    protected static void indent(IGeneratedInfoFactory factory, int level) {
        int i = 0;
        while (i < level) {
            factory.appendText((CharSequence)"    ");
            ++i;
        }
    }
}

