/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.SegmentIndexConstraints;
import java.util.Iterator;

public class SegmentIndexConstraintsIntervalCursor {
    private Iterator<Segment> iter;
    private Segment minAtom;
    private Segment maxAtom;
    private Segment minSegment;
    private Segment maxSegment;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    SegmentIndexConstraintsIntervalCursor(UserChangeSet changeSet, SegmentIndexConstraints constraints) {
        this.minAtom = constraints.minAtom();
        this.maxAtom = constraints.maxAtom();
        SegmentSelectionParameter ssp = changeSet.newSegmentSelection(true, this.minAtom, false, this.maxAtom, true, false);
        ssp.setFilter(this.beginIndexResolvedFilter(constraints));
        this.iter = changeSet.segments(ssp);
    }

    public SegmentFilter beginIndexResolvedFilter(final SegmentIndexConstraints constraints) {
        return new SegmentFilter(){

            @Override
            public boolean skip(Segment segment) {
                return !constraints.isBeginIndexResolved(segment);
            }

            @Override
            public boolean skipSons(Segment segment) {
                return false;
            }
        };
    }

    public boolean searchNextInterval() {
        if (this.maxSegment == this.maxAtom && this.maxAtom != null) {
            return false;
        }
        Segment firstAtom = null;
        Segment lastAtom = null;
        firstAtom = this.maxSegment == null ? this.minAtom : this.maxSegment.nextAtom();
        while (this.iter.hasNext()) {
            Segment segment = this.iter.next();
            if (firstAtom.nextAtom() == segment) {
                firstAtom = segment;
                continue;
            }
            lastAtom = segment.previousAtom();
            break;
        }
        if (firstAtom == null) {
            return false;
        }
        if (lastAtom == null) {
            lastAtom = this.maxAtom;
        }
        if (lastAtom == firstAtom) {
            return false;
        }
        this.minSegment = firstAtom;
        this.maxSegment = lastAtom;
        return true;
    }

    public Segment getMinSegment() {
        return this.minSegment;
    }

    public Segment getMaxSegment() {
        return this.maxSegment;
    }
}

