/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.util.containers.EditBuffer;
import java.util.Iterator;

public class SegmentIndexConstraints {
    protected UserChangeSet changeSet;
    protected int startAtomRank;
    protected int stopAtomRank;
    protected int startIndex;
    protected int stopIndex;
    protected int toResolve;
    protected int nbConstraint;
    protected int holeRank;
    protected AtomIndexConstraint[] constraints;
    protected boolean generateException = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SegmentIndexConstraints(UserChangeSet changeSet) {
        this(changeSet, 0, changeSet.nbOfAtomicSegments(), 0, changeSet.length());
    }

    public SegmentIndexConstraints(UserChangeSet changeSet, Segment minDirtySegment, Segment maxDirtySegment) {
        this.changeSet = changeSet;
        minDirtySegment = minDirtySegment.firstAtom();
        maxDirtySegment = maxDirtySegment.lastAtom();
        this.startIndex = minDirtySegment.beginIndex();
        this.stopIndex = maxDirtySegment.endIndex();
        this.startAtomRank = minDirtySegment.minRank();
        this.stopAtomRank = maxDirtySegment.maxRank() + 1;
        this.init();
    }

    public SegmentIndexConstraints(UserChangeSet changeSet, int beginIdx, int endIdx) {
        this.changeSet = changeSet;
        this.startIndex = beginIdx;
        this.stopIndex = endIdx;
        this.computeAtomInterval(0, changeSet.nbOfAtomicSegments());
        this.init();
    }

    public SegmentIndexConstraints(UserChangeSet changeSet, int beginRank, int endRank, int beginIdx, int endIdx) {
        this.changeSet = changeSet;
        this.startIndex = beginIdx;
        this.stopIndex = endIdx;
        this.startAtomRank = beginRank;
        this.stopAtomRank = endRank;
        this.init();
    }

    protected void init() {
        this.toResolve = this.startIndex < this.stopIndex ? this.stopAtomRank - this.startAtomRank - 1 : 0;
        this.constraints = this.newConstraintArray(Math.min(this.toResolve, 8));
    }

    protected AtomIndexConstraint[] newConstraintArray(int length) {
        return new AtomIndexConstraint[length];
    }

    protected void computeAtomInterval(int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            Segment segment = this.changeSet.atomAt(middleAtomRank);
            if (segment.beginIndex() > this.stopIndex) {
                endAtomRank = middleAtomRank;
                continue;
            }
            if (segment.endIndex() < this.startIndex) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            this.startAtomRank = this.lastAtomTouching(this.startIndex, beginAtomRank, middleAtomRank + 1);
            this.stopAtomRank = this.firstAtomTouching(this.stopIndex, middleAtomRank, endAtomRank);
            return;
        }
    }

    protected int firstAtomTouching(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            if (this.changeSet.atomAt(middleAtomRank).beginIndex() >= index) {
                endAtomRank = middleAtomRank;
                continue;
            }
            beginAtomRank = middleAtomRank + 1;
        }
        return beginAtomRank;
    }

    protected int lastAtomTouching(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            if (this.changeSet.atomAt(middleAtomRank).endIndex() <= index) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            endAtomRank = middleAtomRank;
        }
        return beginAtomRank;
    }

    public boolean addSegmentBeginIndexConstraint(Segment segment, ConstraintType type, int index) {
        return this.addAtomBeginIndexConstraint(segment.minRank(), type, index);
    }

    public boolean addSegmentEndIndexConstraint(Segment segment, ConstraintType type, int index) {
        return this.addAtomBeginIndexConstraint(segment.maxRank() + 1, type, index);
    }

    public int minBeginIndexForSegment(Segment segment) {
        return this.minBeginIndex(segment.minRank());
    }

    public int maxBeginIndexForSegment(Segment segment) {
        return this.maxBeginIndex(segment.minRank());
    }

    public int minEndIndexForSegment(Segment segment) {
        return this.minBeginIndex(segment.maxRank() + 1);
    }

    public int maxEndIndexForSegment(Segment segment) {
        return this.maxBeginIndex(segment.maxRank() + 1);
    }

    protected int minBeginIndex(int atomRank) {
        if (atomRank < this.startAtomRank || atomRank > this.stopAtomRank) {
            throw new RuntimeException("Segment outside of the defined scope");
        }
        if (atomRank == this.startAtomRank) {
            return this.startIndex;
        }
        if (atomRank == this.stopAtomRank) {
            return this.stopIndex;
        }
        int constraintRank = this.constraintRankForAtom(atomRank);
        if (constraintRank >= 0) {
            return this.constraintAt((int)constraintRank).min;
        }
        return (constraintRank ^= 0xFFFFFFFF) > 0 ? this.constraintAt((int)(constraintRank - 1)).min : this.startIndex;
    }

    protected int maxBeginIndex(int atomRank) {
        if (atomRank < this.startAtomRank || atomRank > this.stopAtomRank) {
            throw new RuntimeException("Segment outside of the defined scope");
        }
        if (atomRank == this.startAtomRank) {
            return this.startIndex;
        }
        if (atomRank == this.stopAtomRank) {
            return this.stopIndex;
        }
        int constraintRank = this.constraintRankForAtom(atomRank);
        if (constraintRank >= 0) {
            return this.constraintAt((int)constraintRank).max;
        }
        return (constraintRank ^= 0xFFFFFFFF) < this.nbConstraint ? this.constraintAt((int)constraintRank).max : this.stopIndex;
    }

    public Segment minAtom() {
        return this.changeSet.atomAt(this.startAtomRank);
    }

    public Segment maxAtom() {
        return this.changeSet.atomAt(this.stopAtomRank - 1);
    }

    public boolean isBeginIndexInScope(Segment segment) {
        return this.isAtomInScope(segment.minRank());
    }

    public boolean isEndIndexInScope(Segment segment) {
        return this.isAtomInScope(segment.maxRank() + 1);
    }

    protected boolean isAtomInScope(int atomRank) {
        return this.startAtomRank < atomRank && atomRank < this.stopAtomRank;
    }

    public boolean isResolved(Segment segment) {
        return this.isBeginIndexResolved(segment) && this.isEndIndexResolved(segment);
    }

    public boolean isBeginIndexResolved(Segment segment) {
        return this.isBeginIndexResolved(segment.minRank());
    }

    public boolean isEndIndexResolved(Segment segment) {
        return this.isBeginIndexResolved(segment.maxRank() + 1);
    }

    protected boolean isBeginIndexResolved(int atomRank) {
        return this.minBeginIndex(atomRank) == this.maxBeginIndex(atomRank);
    }

    public boolean isResolved() {
        return this.toResolve == 0;
    }

    public boolean applyConstraints() {
        return this.isResolved() ? this.applyConstraintsResolved() : this.applyConstraintsNotResolved();
    }

    protected boolean applyConstraintsResolved() {
        Segment segment;
        boolean changed = false;
        int index = this.startIndex;
        int atomRank = this.startAtomRank + 1;
        Iterator constraintsIter = EditBuffer.iterator((Object[])this.constraints, (int)this.holeRank, (int)this.nbConstraint);
        AtomIndexConstraint nextConstraint = constraintsIter.hasNext() ? (AtomIndexConstraint)constraintsIter.next() : null;
        while (nextConstraint != null) {
            if (nextConstraint.atomRank == atomRank) {
                index = nextConstraint.min;
                AtomIndexConstraint atomIndexConstraint = nextConstraint = constraintsIter.hasNext() ? (AtomIndexConstraint)constraintsIter.next() : null;
            }
            if (!this.applyConstraint(segment = this.changeSet.atomAt(atomRank++), index)) continue;
            changed = true;
        }
        while (atomRank < this.stopAtomRank) {
            if (!this.applyConstraint(segment = this.changeSet.atomAt(atomRank++), index)) continue;
            changed = true;
        }
        return changed;
    }

    protected boolean applyConstraintsNotResolved() {
        Segment segment;
        boolean changed = false;
        int atomRank = this.startAtomRank + 1;
        int minIndex = this.startIndex;
        int maxIndex = this.stopIndex;
        Iterator constraintsIter = EditBuffer.iterator((Object[])this.constraints, (int)this.holeRank, (int)this.nbConstraint);
        AtomIndexConstraint nextConstraint = constraintsIter.hasNext() ? (AtomIndexConstraint)constraintsIter.next() : null;
        while (nextConstraint != null) {
            if (nextConstraint.atomRank == atomRank) {
                minIndex = Math.max(nextConstraint.min, minIndex);
                maxIndex = nextConstraint.max;
                nextConstraint = constraintsIter.hasNext() ? (AtomIndexConstraint)constraintsIter.next() : null;
            } else {
                maxIndex = Math.max(nextConstraint.min, minIndex);
            }
            segment = this.changeSet.atomAt(atomRank++);
            if (this.applyConstraint(segment, minIndex, maxIndex)) {
                changed = true;
            }
            minIndex = segment.beginIndex();
        }
        maxIndex = this.stopIndex;
        while (atomRank < this.stopAtomRank) {
            if (this.applyConstraint(segment = this.changeSet.atomAt(atomRank++), minIndex, maxIndex)) {
                changed = true;
            }
            minIndex = segment.beginIndex();
        }
        return changed;
    }

    protected boolean applyConstraint(Segment segment, int index) {
        if (segment.beginIndex() == index) {
            return false;
        }
        this.checkDirty(segment);
        segment.setBeginIndex(index);
        return true;
    }

    protected boolean applyConstraint(Segment segment, int minIndex, int maxIndex) {
        int beginIdx = segment.beginIndex();
        if (beginIdx < minIndex) {
            this.checkDirty(segment);
            segment.setBeginIndex(minIndex);
            return true;
        }
        if (beginIdx > maxIndex) {
            this.checkDirty(segment);
            segment.setBeginIndex(maxIndex);
            return true;
        }
        return false;
    }

    protected void checkDirty(Segment segment) {
    }

    protected boolean addAtomBeginIndexConstraint(int atomRank, ConstraintType type, int index) {
        if (atomRank < this.startAtomRank || atomRank > this.stopAtomRank) {
            if (!this.generateException) {
                return false;
            }
            throw new RuntimeException("Segment outside of the defined scope");
        }
        if (atomRank == this.startAtomRank) {
            this.checkIndexComplyToConstraint(this.minAtom().beginIndex(), type, index);
            return false;
        }
        if (atomRank == this.stopAtomRank) {
            this.checkIndexComplyToConstraint(this.maxAtom().endIndex(), type, index);
            return false;
        }
        int constraintRank = this.constraintRankForAtom(atomRank);
        if (constraintRank < 0) {
            return this.insertNewConstraint(~constraintRank, atomRank, type, index);
        }
        if (!this.addConstraint(constraintRank, type, index)) {
            return false;
        }
        this.propagateConstraint(constraintRank, type, index);
        return true;
    }

    protected boolean addConstraint(int constraintRank, ConstraintType type, int index) {
        AtomIndexConstraint constraint = this.constraintAt(constraintRank);
        boolean alreadyResolved = constraint.isResolved();
        if (!constraint.addConstraint(type, index)) {
            return false;
        }
        if (!alreadyResolved && constraint.isResolved()) {
            this.decrementToResolveCount(constraintRank, constraint);
        }
        return true;
    }

    protected void decrementToResolveCount(int constraintRank, AtomIndexConstraint constraint) {
        --this.toResolve;
        if (constraintRank > 0) {
            AtomIndexConstraint previous = this.constraintAt(constraintRank - 1);
            if (previous.isResolved() && previous.max == constraint.min) {
                this.toResolve -= constraint.atomRank - previous.atomRank - 1;
            }
        } else if (constraint.min == this.startIndex) {
            this.toResolve -= constraint.atomRank - this.startAtomRank - 1;
        }
        if (constraintRank < this.nbConstraint - 1) {
            AtomIndexConstraint next = this.constraintAt(constraintRank + 1);
            if (next.isResolved() && constraint.max == next.min) {
                this.toResolve -= next.atomRank - constraint.atomRank - 1;
            }
        } else if (constraint.max == this.stopIndex) {
            this.toResolve -= this.stopAtomRank - constraint.atomRank - 1;
        }
    }

    protected boolean insertNewConstraint(int constraintRank, int atomRank, ConstraintType type, int index) {
        AtomIndexConstraint constraint = this.newSegmentIndexConstraint(atomRank, this.minIndexForNewConstraint(constraintRank), this.maxIndexForNewConstraint(constraintRank));
        this.insertConstraint(constraintRank, constraint);
        if (!this.addConstraint(constraintRank, type, index)) {
            this.deleteConstraint(constraintRank);
            return false;
        }
        this.propagateConstraint(constraintRank, type, index);
        return true;
    }

    protected int minIndexForNewConstraint(int newConstraintRank) {
        return newConstraintRank > 0 ? this.constraintAt((int)(newConstraintRank - 1)).min : this.startIndex;
    }

    protected int maxIndexForNewConstraint(int newConstraintRank) {
        return newConstraintRank < this.nbConstraint ? this.constraintAt((int)newConstraintRank).max : this.stopIndex;
    }

    protected void propagateConstraint(int constraintRank, ConstraintType type, int index) {
        this.propagateConstraintBefore(constraintRank, type, index);
        this.propagateConstraintAfter(constraintRank, type, index);
    }

    protected void propagateConstraintAfter(int constraintRank, ConstraintType type, int index) {
        switch (type) {
            case LowerThan: 
            case LowerOrEqual: {
                return;
            }
            case Equal: {
                type = ConstraintType.GreaterOrEqual;
            }
        }
        while (++constraintRank < this.nbConstraint) {
            if (this.addConstraint(constraintRank, type, index)) continue;
            return;
        }
    }

    protected void propagateConstraintBefore(int constraintRank, ConstraintType type, int index) {
        switch (type) {
            case GreaterThan: 
            case GreaterOrEqual: {
                return;
            }
            case Equal: {
                type = ConstraintType.LowerOrEqual;
            }
        }
        while (--constraintRank >= 0) {
            if (this.addConstraint(constraintRank, type, index)) continue;
            return;
        }
    }

    protected AtomIndexConstraint constraintAt(int constraintRank) {
        return (AtomIndexConstraint)EditBuffer.getElementAt((Object[])this.constraints, (int)this.holeRank, (int)this.nbConstraint, (int)constraintRank);
    }

    protected void insertConstraint(int constraintRank, AtomIndexConstraint constraint) {
        this.constraints = (AtomIndexConstraint[])EditBuffer.insert((Object[])this.constraints, (int)this.holeRank, (int)this.nbConstraint, (int)constraintRank, (int)1);
        this.constraints[constraintRank] = constraint;
        this.holeRank = constraintRank + 1;
        ++this.nbConstraint;
    }

    protected void deleteConstraint(int constraintRank) {
        this.constraints = (AtomIndexConstraint[])EditBuffer.delete((Object[])this.constraints, (int)this.holeRank, (int)this.nbConstraint, (int)constraintRank, (int)1);
        this.holeRank = constraintRank;
        --this.nbConstraint;
    }

    protected int constraintRankForAtom(int atomRank) {
        return this.constraintRankForAtom(atomRank, 0, this.nbConstraint - 1);
    }

    protected int constraintRankForAtom(int atomRank, int low, int high) {
        while (low <= high) {
            int middleRank = low + high >> 1;
            AtomIndexConstraint middle = this.constraintAt(middleRank);
            if (atomRank < middle.atomRank) {
                high = middleRank - 1;
                continue;
            }
            if (atomRank > middle.atomRank) {
                low = middleRank + 1;
                continue;
            }
            return middleRank;
        }
        return ~low;
    }

    protected boolean check(boolean condition) {
        if (!this.generateException) {
            return condition;
        }
        if (!condition) {
            throw new RuntimeException("New constraint is not consistent with previous constraints");
        }
        return true;
    }

    protected void setGenerateException(boolean generateException) {
        this.generateException = generateException;
    }

    protected AtomIndexConstraint newSegmentIndexConstraint(int atomRank, int minIndex, int maxIndex) {
        return new AtomIndexConstraint(atomRank, minIndex, maxIndex);
    }

    protected void checkIndexComplyToConstraint(int index, ConstraintType constraintType, int constraintIndex) {
        switch (constraintType) {
            case Equal: {
                this.check(index == constraintIndex);
                return;
            }
            case LowerThan: {
                this.check(index < constraintIndex);
                return;
            }
            case LowerOrEqual: {
                this.check(index <= constraintIndex);
                return;
            }
            case GreaterThan: {
                this.check(index > constraintIndex);
                return;
            }
            case GreaterOrEqual: {
                this.check(index >= constraintIndex);
                return;
            }
        }
    }

    protected class AtomIndexConstraint {
        protected int atomRank;
        protected int min;
        protected int max;

        protected AtomIndexConstraint(int atomRank) {
            this.atomRank = atomRank;
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
        }

        protected AtomIndexConstraint(int atomRank, int minBeginIdx, int maxBeginIdx) {
            this.atomRank = atomRank;
            this.min = minBeginIdx;
            this.max = maxBeginIdx;
        }

        protected boolean addConstraint(ConstraintType type, int index) {
            switch (type) {
                case Equal: {
                    if (!SegmentIndexConstraints.this.check(this.min <= index && this.max >= index)) {
                        return false;
                    }
                    if (this.min == index && this.max == index) {
                        return false;
                    }
                    this.min = this.max = index;
                    return true;
                }
                case LowerThan: {
                    if (!SegmentIndexConstraints.this.check(this.min < index)) {
                        return false;
                    }
                    if (this.max < index) {
                        return false;
                    }
                    this.max = index - 1;
                    return true;
                }
                case GreaterThan: {
                    if (!SegmentIndexConstraints.this.check(this.max > index)) {
                        return false;
                    }
                    if (this.min > index) {
                        return false;
                    }
                    this.min = index + 1;
                    return true;
                }
                case LowerOrEqual: {
                    if (!SegmentIndexConstraints.this.check(this.min <= index)) {
                        return false;
                    }
                    if (this.max <= index) {
                        return false;
                    }
                    this.max = index;
                    return true;
                }
                case GreaterOrEqual: {
                    if (!SegmentIndexConstraints.this.check(this.max >= index)) {
                        return false;
                    }
                    if (this.min >= index) {
                        return false;
                    }
                    this.min = index;
                    return true;
                }
            }
            return false;
        }

        protected boolean isResolved() {
            return this.min == this.max;
        }
    }
}

