/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class MatcherUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private static int level = 0;

    public static String dumpGeneratedInfo(IGeneratedInfo generatedInfo, String suffix) {
        EngineFactory engine = new EngineFactory();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        engine.writeGeneratedInfo(generatedInfo, outStream);
        return MatcherUtil.dumpToTmpFile(new String(outStream.toByteArray()), suffix);
    }

    public static synchronized String dumpToTmpFile(String contents, String suffix) {
        try {
            File dir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/RppMatcher");
            dir.mkdirs();
            File temp = new File(String.valueOf(dir.getAbsolutePath()) + "/Matcher." + simpleFormat.format(new Date()) + "." + suffix);
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(contents);
            out.close();
            return temp.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CharSequence dumpGeneratedInfoTree(IGeneratedInfo generatedInfo) {
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Root>\n";
        result = String.valueOf(result) + MatcherUtil.dumpGeneratedInfoTree(generatedInfo.getRootTag());
        result = String.valueOf(result) + "</Root>\n";
        return result;
    }

    private static CharSequence dumpGeneratedInfoTree(IGeneratedTag tag) {
        String result = "";
        Iterator nodes = tag.sons();
        while (nodes.hasNext()) {
            IGeneratedTag generatedTag = (IGeneratedTag)nodes.next();
            MatcherUtil.indent();
            int i = 0;
            while (i < level) {
                result = String.valueOf(result) + " ";
                ++i;
            }
            result = String.valueOf(result) + "<" + generatedTag.getName() + ">\n";
            result = String.valueOf(result) + MatcherUtil.dumpGeneratedInfoTree(generatedTag);
            i = 0;
            while (i < level) {
                result = String.valueOf(result) + " ";
                ++i;
            }
            result = String.valueOf(result) + "</" + generatedTag.getName() + ">\n";
            MatcherUtil.unindent();
        }
        return result;
    }

    private static void indent() {
        ++level;
    }

    private static void unindent() {
        --level;
    }

    public static String dumpAtoms(UserChangeSet changeSet, Segment segment) {
        StringBuilder sb = new StringBuilder();
        SegmentSelectionParameter ssp = changeSet.newSegmentSelection(true, null, true, null, true, false);
        Iterator<Segment> it = changeSet.segments(ssp);
        while (it.hasNext()) {
            Segment segment2 = it.next();
            sb.append(MatcherUtil.writeAtom(segment2));
        }
        return sb.toString();
    }

    private static String writeAtom(Segment segment) {
        StringBuilder sb = new StringBuilder();
        sb.append("[Atom:");
        sb.append(segment.minRank());
        sb.append(segment.isTagged() ? " T" : " P");
        sb.append("(" + segment.enclosingTagName() + ")");
        sb.append("]");
        sb.append(segment.getText());
        return sb.toString();
    }
}

