/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.TextPartitionTranslator;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.AbstractMatcher;
import com.ibm.pdp.engine.turbo.match.DiffMix;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.IntSequence;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Matcher
extends AbstractMatcher {
    protected Segment segment;
    private int currentAtomGeneratedIndex;
    private int currentAtomTextIndex;
    private ITextPartition generatedRootPartition;
    private ITextPartition rootPartition;
    protected boolean busy;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private List<DirtyZone> findDirtyZones() {
        SegmentSelectionParameter ssp = this.segment == null ? this.changeSet.newSegmentSelection(true, null, true, null, true, false) : this.changeSet.newSubtreeSelection(true, this.segment, true, false);
        ssp.setFilter(this.changeSet.dirtyAtomicSegmentFilter());
        Iterator<Segment> it = this.changeSet.segments(ssp);
        ArrayList<DirtyZone> results = new ArrayList<DirtyZone>();
        DirtyZone dirtyZone = new DirtyZone();
        if (this.segment != null && this.segment.firstAtom().getChangeNature() == ChangeNature.Dirty) {
            it.next();
            dirtyZone.firstAtomicSegment = dirtyZone.lastAtomicSegment = this.segment.firstAtom();
            Segment previousSegment = dirtyZone.firstAtomicSegment.previousAtom();
            while (previousSegment != null && previousSegment.getChangeNature() == ChangeNature.Dirty) {
                dirtyZone.firstAtomicSegment = previousSegment;
                previousSegment = previousSegment.previousAtom();
            }
        }
        while (it.hasNext()) {
            Segment nextDirtySegment = it.next();
            if (dirtyZone.firstAtomicSegment == null) {
                dirtyZone.firstAtomicSegment = nextDirtySegment;
            } else if (dirtyZone.lastAtomicSegment.nextAtom() != nextDirtySegment) {
                results.add(dirtyZone);
                dirtyZone = new DirtyZone();
                dirtyZone.firstAtomicSegment = nextDirtySegment;
            }
            dirtyZone.lastAtomicSegment = nextDirtySegment;
        }
        if (dirtyZone.firstAtomicSegment == null) {
            return results;
        }
        if (this.segment == null) {
            results.add(dirtyZone);
            return results;
        }
        if (this.segment.lastAtom() == dirtyZone.lastAtomicSegment) {
            Segment nextSegment = dirtyZone.lastAtomicSegment.nextAtom();
            while (nextSegment != null && nextSegment.getChangeNature() == ChangeNature.Dirty) {
                dirtyZone.lastAtomicSegment = nextSegment;
                nextSegment = nextSegment.nextAtom();
            }
        }
        results.add(dirtyZone);
        return results;
    }

    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public boolean match_() {
        this.setSegment(null);
        return this.oldMatch();
    }

    protected boolean oldMatch() {
        this.generatedRootPartition = this.changeSet.generatedTextPartition();
        this.rootPartition = this.changeSet.textPartition();
        List<DirtyZone> dirtyZones = this.findDirtyZones();
        for (DirtyZone dirtyZone : dirtyZones) {
            this.matchDirtyPortion(dirtyZone.firstAtomicSegment, dirtyZone.lastAtomicSegment);
        }
        return true;
    }

    @Override
    public boolean match_(Segment segment) {
        this.setSegment(segment);
        return this.oldMatch();
    }

    private void assignChangenature(Segment firstSegmentOfZone, Segment lastSegmentOfZone) {
        Segment atom = firstSegmentOfZone;
        while (true) {
            if (atom.getChangeNature() != ChangeNature.Dirty) {
                throw new RuntimeException("Matcher:assignChangeNature : try to refresh a no dirty segment");
            }
            ISubTextPartition textPartition = this.changeSet.textPartition().subTextPartition(atom.beginIndex(), atom.endIndex());
            ISubTextPartition generatedTextPartition = this.changeSet.generatedTextPartition().subTextPartition(atom.generatedBeginIndex(), atom.generatedEndIndex());
            IntSequence words = textPartition.getWords();
            IntSequence generatedWords = generatedTextPartition.getWords();
            DiffCursor dc = Ints.newDiffCursor((IntSequence)generatedWords, (IntSequence)words);
            if (dc.searchNextDifference()) {
                atom.setChangeNature(ChangeNature.Modified);
            } else {
                CharSequence generatedText;
                CharSequence text = atom.getText();
                if (Strings.compareCharSequences((CharSequence)text, (CharSequence)(generatedText = atom.generatedText())) == 0) {
                    atom.setChangeNature(ChangeNature.Unchanged);
                } else {
                    atom.setChangeNature(ChangeNature.Reformated);
                }
            }
            if (atom == lastSegmentOfZone) break;
            atom = atom.nextAtom();
        }
    }

    @Override
    protected void matchZone(Segment minSegment, Segment maxSegment) {
        this.matchZone_(minSegment, maxSegment);
        this.assignChangenature(minSegment, maxSegment);
    }

    private void matchZone_(Segment start, Segment end) {
        this.currentAtomGeneratedIndex = start.generatedBeginIndex();
        int n = this.currentAtomTextIndex = start.beginIndex() != -1 ? start.beginIndex() : 0;
        if (start.minRank() >= end.maxRank() || start == end) {
            return;
        }
        ISubTextPartition textPartition = this.changeSet.textPartition().subTextPartition(start.beginIndex(), end.endIndex());
        ISubTextPartition generatedTextPartition = this.changeSet.generatedTextPartition().subTextPartition(start.generatedBeginIndex(), end.generatedEndIndex());
        IntSequence words = textPartition.getWords();
        IntSequence generatedWords = generatedTextPartition.getWords();
        DiffCursor dc = Ints.newDiffCursor((IntSequence)generatedWords, (IntSequence)words);
        boolean differenceFound = dc.searchNextDifference();
        if (!differenceFound) {
            CharSequence subGeneratedText;
            CharSequence subText = this.changeSet.getText().subSequence(start.beginIndex(), end.endIndex());
            int comp = Strings.compareCharSequences((CharSequence)subText, (CharSequence)(subGeneratedText = this.changeSet.generatedText().subSequence(start.generatedBeginIndex(), end.generatedEndIndex())));
            if (comp == 0) {
                this.copyBeginIndexes(start, end);
            } else {
                this.matchSpacesForEquality2(textPartition, generatedTextPartition, start, end, end);
            }
        } else {
            int textPartitionBegin;
            int textPartitionEnd;
            int generatedTextPartitionBegin;
            Segment atom = start;
            int lastGeneratedDifferenceEndRank = 0;
            int lastDifferenceEndRank = -1;
            int currentGeneratedWordRank = 0;
            while (differenceFound) {
                int startModifGeneratedWordRank = dc.getReferenceBeginIndex();
                if (startModifGeneratedWordRank > currentGeneratedWordRank) {
                    Segment lastSegment = this.lastSegmentBeforeIndex(generatedTextPartition, generatedTextPartition.wordBeginIndex(startModifGeneratedWordRank - 1), atom, end);
                    if (lastSegment != atom) {
                        int textPartitionBegin2;
                        boolean isFirstWordOfSegment = lastDifferenceEndRank == -1 ? false : this.isFirstWordIndexOfSegment(generatedTextPartition.wordBeginIndex(lastGeneratedDifferenceEndRank), generatedTextPartition, atom);
                        boolean isLastWordOfSegment = this.isLastWordIndexOfSegment(generatedTextPartition.wordBeginIndex(startModifGeneratedWordRank - 1), generatedTextPartition, lastSegment);
                        int generatedTextPartitionBegin2 = lastDifferenceEndRank == -1 ? 0 : generatedTextPartition.wordBeginIndex(lastGeneratedDifferenceEndRank);
                        int n2 = textPartitionBegin2 = lastDifferenceEndRank == -1 ? 0 : textPartition.wordBeginIndex(lastDifferenceEndRank);
                        if (isFirstWordOfSegment) {
                            generatedTextPartitionBegin2 -= generatedTextPartition.spaceBeforeWord(lastGeneratedDifferenceEndRank);
                            textPartitionBegin2 -= textPartition.spaceBeforeWord(lastDifferenceEndRank);
                        }
                        int generatedTextPartitionEnd = generatedTextPartition.wordBeginIndex(dc.getReferenceBeginIndex());
                        int textPartitionEnd2 = textPartition.wordBeginIndex(dc.getModifiedBeginIndex());
                        if (!isLastWordOfSegment) {
                            generatedTextPartitionEnd -= generatedTextPartition.spaceBeforeWord(dc.getReferenceBeginIndex());
                            textPartitionEnd2 -= textPartition.spaceBeforeWord(dc.getModifiedBeginIndex());
                        }
                        ISubTextPartition subGeneratedTextPartition = generatedTextPartition.subTextPartition(generatedTextPartitionBegin2, generatedTextPartitionEnd);
                        ISubTextPartition subTextPartition = textPartition.subTextPartition(textPartitionBegin2, textPartitionEnd2);
                        int comp = Strings.compareCharSequences((CharSequence)subTextPartition.getText(), (CharSequence)subGeneratedTextPartition.getText());
                        if (comp == 0) {
                            this.copyBeginIndexes(atom, lastSegment);
                            atom = lastSegment;
                        } else {
                            atom = this.matchSpacesForEquality2(subTextPartition, subGeneratedTextPartition, atom, lastSegment, end);
                        }
                    }
                    currentGeneratedWordRank = startModifGeneratedWordRank;
                }
                if (atom == end) {
                    return;
                }
                lastGeneratedDifferenceEndRank = dc.getReferenceEndIndex();
                lastDifferenceEndRank = dc.getModifiedEndIndex();
                int endDifferenceGeneratedWordRank = lastGeneratedDifferenceEndRank;
                if (atom.nextAtom() != null && endDifferenceGeneratedWordRank < generatedTextPartition.getWordsCount()) {
                    int afterDifferenceWordEndIndex = generatedTextPartition.wordBeginIndex(endDifferenceGeneratedWordRank);
                    int nextAtomGeneratedBeginIndex = TextPartitionTranslator.translateIndex(atom.nextAtom().generatedBeginIndex(), this.generatedRootPartition, generatedTextPartition);
                    if (nextAtomGeneratedBeginIndex > afterDifferenceWordEndIndex) {
                        currentGeneratedWordRank = endDifferenceGeneratedWordRank;
                        differenceFound = dc.searchNextDifference();
                        this.currentAtomGeneratedIndex = TextPartitionTranslator.translateIndex(afterDifferenceWordEndIndex, generatedTextPartition, this.generatedRootPartition);
                        this.currentAtomTextIndex = TextPartitionTranslator.translateIndex(textPartition.wordBeginIndex(lastDifferenceEndRank), textPartition, this.rootPartition);
                        continue;
                    }
                }
                if ((generatedTextPartitionBegin = generatedTextPartition.wordBeginIndex(dc.getReferenceBeginIndex()) - generatedTextPartition.spaceBeforeWord(dc.getReferenceBeginIndex())) < 0) {
                    generatedTextPartitionBegin = 0;
                }
                int generatedTextPartitionEnd = generatedTextPartition.wordBeginIndex(dc.getReferenceEndIndex());
                int textPartitionBegin3 = textPartition.wordBeginIndex(dc.getModifiedBeginIndex()) - textPartition.spaceBeforeWord(dc.getModifiedBeginIndex());
                if (textPartitionBegin3 < 0) {
                    textPartitionBegin3 = 0;
                }
                textPartitionEnd = textPartition.wordBeginIndex(dc.getModifiedEndIndex());
                ISubTextPartition subGeneratedTextPartition = generatedTextPartition.subTextPartition(generatedTextPartitionBegin, generatedTextPartitionEnd);
                ISubTextPartition subTextPartition = textPartition.subTextPartition(textPartitionBegin3, textPartitionEnd);
                Segment lastSegment = atom.nextAtom();
                int lastGeneratedDifferenceEndIndex = generatedTextPartition.wordBeginIndex(lastGeneratedDifferenceEndRank);
                while (lastSegment != end && lastGeneratedDifferenceEndIndex >= TextPartitionTranslator.translateIndex(lastSegment.nextAtom().generatedBeginIndex(), this.generatedRootPartition, generatedTextPartition)) {
                    lastSegment = lastSegment.nextAtom();
                }
                if (subGeneratedTextPartition.getWordsCount() == 0 && subTextPartition.getWordsCount() != 0) {
                    this.manageInsertion(subGeneratedTextPartition, subTextPartition, atom, lastSegment, end);
                } else {
                    this.diffMix(subGeneratedTextPartition, subTextPartition, atom, lastSegment, end);
                }
                atom = lastSegment;
                currentGeneratedWordRank = endDifferenceGeneratedWordRank;
                differenceFound = dc.searchNextDifference();
            }
            if (atom == end) {
                return;
            }
            Segment lastSegment = end;
            boolean isFirstWordOfSegment = this.isFirstWordIndexOfSegment(generatedTextPartition.wordBeginIndex(lastGeneratedDifferenceEndRank), generatedTextPartition, atom);
            generatedTextPartitionBegin = lastDifferenceEndRank == -1 ? 0 : generatedTextPartition.wordBeginIndex(lastGeneratedDifferenceEndRank);
            int n3 = textPartitionBegin = lastDifferenceEndRank == -1 ? 0 : textPartition.wordBeginIndex(lastDifferenceEndRank);
            if (isFirstWordOfSegment) {
                generatedTextPartitionBegin -= generatedTextPartition.spaceBeforeWord(lastGeneratedDifferenceEndRank);
                textPartitionBegin -= textPartition.spaceBeforeWord(lastDifferenceEndRank);
            }
            int generatedTextPartitionEnd = generatedTextPartition.getTextLength();
            textPartitionEnd = textPartition.getTextLength();
            ISubTextPartition subGeneratedTextPartition = generatedTextPartition.subTextPartition(generatedTextPartitionBegin, generatedTextPartitionEnd);
            ISubTextPartition subTextPartition = textPartition.subTextPartition(textPartitionBegin, textPartitionEnd);
            int comp = Strings.compareCharSequences((CharSequence)subTextPartition.getText(), (CharSequence)subGeneratedTextPartition.getText());
            if (comp == 0) {
                this.copyBeginIndexes(atom, lastSegment);
                atom = lastSegment;
            } else {
                atom = this.matchSpacesForEquality2(subTextPartition, subGeneratedTextPartition, atom, lastSegment, end);
            }
        }
    }

    private void manageInsertion(ISubTextPartition subGeneratedTextPartition, ISubTextPartition subTextPartition, Segment atom, Segment lastSegment, Segment end) {
        Segment bestSegment = atom;
        Segment currentSegment = atom;
        do {
            currentSegment = currentSegment.nextAtom();
            bestSegment = Matcher.getBestCandidateForInsertion(bestSegment, currentSegment);
        } while (currentSegment != lastSegment);
        int beginOfBestSegmentIndex = TextPartitionTranslator.translateIndex(bestSegment.generatedBeginIndex(), this.generatedRootPartition, subGeneratedTextPartition);
        int endOfEndSegmentIndex = TextPartitionTranslator.translateIndex(bestSegment.generatedEndIndex(), this.generatedRootPartition, subGeneratedTextPartition);
        CharSequence spaceBeforeInsertion = subTextPartition.getTextInterval(0, subTextPartition.wordBeginIndex(0));
        int lastWordEndIndex = subTextPartition.wordEndIndex(subTextPartition.getWordsCount() - 1);
        CharSequence spaceAfterInsertion = subTextPartition.getTextInterval(lastWordEndIndex, subTextPartition.getTextLength());
        int delta = TextPartitionTranslator.translateIndex(0, subTextPartition, this.rootPartition) - TextPartitionTranslator.translateIndex(0, subGeneratedTextPartition, this.generatedRootPartition);
        if (bestSegment != atom) {
            CharSequence generatedSpaceBeforeInsertion = subGeneratedTextPartition.getTextInterval(0, beginOfBestSegmentIndex);
            int firstDifferenceIndex = Matcher.getFirstDifferentCharIndex(generatedSpaceBeforeInsertion, spaceBeforeInsertion, false);
            int firstDifferenceInGeneratedRoot = TextPartitionTranslator.translateIndex(firstDifferenceIndex, subGeneratedTextPartition, this.generatedRootPartition);
            int firstDifferenceInRoot = TextPartitionTranslator.translateIndex(firstDifferenceIndex, subTextPartition, this.rootPartition);
            currentSegment = atom.nextAtom();
            while (currentSegment != bestSegment) {
                if (currentSegment.generatedBeginIndex() < firstDifferenceInGeneratedRoot) {
                    currentSegment.setBeginIndex(currentSegment.generatedBeginIndex() + delta);
                } else {
                    currentSegment.setBeginIndex(firstDifferenceInRoot);
                }
                currentSegment = currentSegment.nextAtom();
            }
            currentSegment.setBeginIndex(firstDifferenceInRoot);
        } else {
            currentSegment = atom;
        }
        if (bestSegment != lastSegment) {
            CharSequence generatedSpaceAfterInsertion = subGeneratedTextPartition.getTextInterval(endOfEndSegmentIndex, subGeneratedTextPartition.getTextLength());
            int lastDifferenceIndex = Matcher.getFirstDifferentCharIndex(generatedSpaceAfterInsertion, spaceAfterInsertion, true);
            int lastDifferenceInGeneratedRoot = TextPartitionTranslator.translateIndex(subGeneratedTextPartition.getTextLength() - lastDifferenceIndex, subGeneratedTextPartition, this.generatedRootPartition);
            int lastDifferenceInRoot = TextPartitionTranslator.translateIndex(subTextPartition.getTextLength() - lastDifferenceIndex, subTextPartition, this.rootPartition);
            delta = lastDifferenceInRoot - lastDifferenceInGeneratedRoot;
            this.currentAtomGeneratedIndex = lastDifferenceInGeneratedRoot;
            this.currentAtomTextIndex = lastDifferenceInRoot;
            do {
                if ((currentSegment = currentSegment.nextAtom()).generatedBeginIndex() < lastDifferenceInGeneratedRoot) {
                    currentSegment.setBeginIndex(lastDifferenceInRoot);
                    continue;
                }
                currentSegment.setBeginIndex(currentSegment.generatedBeginIndex() + delta);
            } while (currentSegment != lastSegment);
        } else {
            this.currentAtomGeneratedIndex = TextPartitionTranslator.translateIndex(subGeneratedTextPartition.getTextLength(), subGeneratedTextPartition, this.generatedRootPartition);
            this.currentAtomTextIndex = TextPartitionTranslator.translateIndex(subTextPartition.getTextLength(), subTextPartition, this.rootPartition);
        }
    }

    private static int getFirstDifferentCharIndex(CharSequence left, CharSequence right, boolean fromEnd) {
        int leftLength;
        if (left == null || right == null) {
            return 0;
        }
        int length = leftLength = left.length();
        if (left == right) {
            return length;
        }
        int rightLength = right.length();
        length = Math.min(length, rightLength);
        int i = 0;
        while (i < length) {
            if (fromEnd ? left.charAt(--leftLength) != right.charAt(--rightLength) : left.charAt(i) != right.charAt(i)) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private boolean isFirstWordIndexOfSegment(int wordIndex, ISubTextPartition generatedSubTextPartition, Segment atom) {
        int atomFirstWordIndex;
        int wordIndexInRoot = TextPartitionTranslator.translateIndex(wordIndex, generatedSubTextPartition, this.generatedRootPartition);
        int atomFirstIndex = atom.generatedBeginIndex();
        int atomEndIndex = atom.generatedEndIndex();
        if (wordIndexInRoot > atomEndIndex || wordIndexInRoot < atomFirstIndex) {
            return false;
        }
        int atomFirstWordRank = this.changeSet.generatedTextPartition().wordRankFromIndex(atomFirstIndex);
        if (atomFirstWordRank < 0) {
            atomFirstWordRank ^= 0xFFFFFFFF;
        }
        return (atomFirstWordIndex = this.changeSet.generatedTextPartition().wordBeginIndex(atomFirstWordRank)) == wordIndexInRoot;
    }

    private boolean isLastWordIndexOfSegment(int wordIndex, ISubTextPartition generatedSubTextPartition, Segment atom) {
        int wordIndexInRoot = TextPartitionTranslator.translateIndex(wordIndex, generatedSubTextPartition, this.generatedRootPartition);
        int atomFirstIndex = atom.generatedBeginIndex();
        int atomEndIndex = atom.generatedEndIndex();
        if (wordIndexInRoot > atomEndIndex || wordIndexInRoot < atomFirstIndex) {
            return false;
        }
        int nextAtomFirstWordRank = this.changeSet.generatedTextPartition().wordRankFromIndex(atomEndIndex);
        if (nextAtomFirstWordRank < 0) {
            nextAtomFirstWordRank ^= 0xFFFFFFFF;
        }
        if (nextAtomFirstWordRank == 0) {
            return false;
        }
        int atomLastWordBeginIndex = this.changeSet.generatedTextPartition().wordBeginIndex(nextAtomFirstWordRank - 1);
        return atomLastWordBeginIndex == wordIndexInRoot;
    }

    private Segment lastSegmentBeforeIndex(ISubTextPartition generatedTextPartition, int wordIndex, Segment start, Segment end) {
        int wordIndexInRootPartition = TextPartitionTranslator.translateIndex(wordIndex, generatedTextPartition, this.generatedRootPartition);
        Segment nextAtom = start.nextAtom();
        while (nextAtom != null && wordIndexInRootPartition >= nextAtom.generatedBeginIndex() && start != end) {
            start = nextAtom;
            nextAtom = start.nextAtom();
        }
        return start;
    }

    private Segment matchSpacesForEquality2(ISubTextPartition textPartition, ISubTextPartition generatedTextPartition, Segment atom, Segment lastAtom, Segment endOfDirtyZoneSegment) {
        Segment nextLastAtomic;
        if (atom == endOfDirtyZoneSegment) {
            return atom;
        }
        if (lastAtom == atom) {
            return lastAtom;
        }
        Segment next = atom;
        do {
            int startOfNextSegmentIndex;
            int startOfNextSegmentWordRank;
            if ((startOfNextSegmentWordRank = generatedTextPartition.wordRankFromIndex(startOfNextSegmentIndex = TextPartitionTranslator.translateIndex((next = atom.nextAtom()).generatedBeginIndex(), this.generatedRootPartition, generatedTextPartition))) < 0) {
                startOfNextSegmentWordRank ^= 0xFFFFFFFF;
            }
            int startOfNextGeneratedWord = generatedTextPartition.wordBeginIndex(startOfNextSegmentWordRank);
            int startOfNextWord = textPartition.wordBeginIndex(startOfNextSegmentWordRank);
            int endOfGeneratedWord = startOfNextSegmentWordRank == 0 ? 0 : generatedTextPartition.wordBeginIndex(startOfNextSegmentWordRank - 1) + generatedTextPartition.wordLength(startOfNextSegmentWordRank - 1);
            int endOfWord = startOfNextSegmentWordRank == 0 ? 0 : textPartition.wordBeginIndex(startOfNextSegmentWordRank - 1) + textPartition.wordLength(startOfNextSegmentWordRank - 1);
            nextLastAtomic = this.lastSegmentBeforeIndex(generatedTextPartition, startOfNextGeneratedWord, atom, endOfDirtyZoneSegment);
            if (nextLastAtomic.generatedBeginIndex() < next.generatedBeginIndex()) {
                int startWordIndex = generatedTextPartition.wordBeginIndex(startOfNextSegmentWordRank);
                int endWordIndex = startWordIndex + generatedTextPartition.wordLength(startOfNextSegmentWordRank);
                String realWord = generatedTextPartition.getTextInterval(startWordIndex, endWordIndex).toString();
                throw new RuntimeException(MessageFormat.format("Invalid word partition in Matcher. The word ''{0}''  is cut by the generated segments.", realWord));
            }
            ISubTextPartition generatedTextPartitionSpaces = generatedTextPartition.subTextPartition(endOfGeneratedWord, startOfNextGeneratedWord);
            ISubTextPartition textPartitionSpaces = textPartition.subTextPartition(endOfWord, startOfNextWord);
            if (Strings.sameCharSequences((CharSequence)generatedTextPartitionSpaces.getText(), (CharSequence)textPartitionSpaces.getText())) {
                int rootGeneratedBeginIndex = TextPartitionTranslator.translateIndex(endOfGeneratedWord, generatedTextPartition, this.generatedRootPartition);
                int rootBeginIndex = TextPartitionTranslator.translateIndex(endOfWord, textPartition, this.rootPartition);
                this.copyBeginIndexesFromEquality(atom, nextLastAtomic, rootGeneratedBeginIndex, rootBeginIndex);
            } else {
                this.diffMix(generatedTextPartitionSpaces, textPartitionSpaces, atom, nextLastAtomic, endOfDirtyZoneSegment);
            }
            atom = nextLastAtomic;
        } while (next != lastAtom && nextLastAtomic != lastAtom);
        return lastAtom;
    }

    private void copyBeginIndexesFromEquality(Segment start, Segment lastSegmentToCopy, int generatedWhiteBeginIndex, int whiteBeginIndex) {
        this.copyBeginIndexes_(start, lastSegmentToCopy, whiteBeginIndex - generatedWhiteBeginIndex);
    }

    private void copyBeginIndexes(Segment start, Segment lastSegmentToCopy) {
        int delta = this.currentAtomGeneratedIndex >= start.generatedBeginIndex() ? this.currentAtomTextIndex - this.currentAtomGeneratedIndex : start.beginIndex() - start.generatedBeginIndex();
        this.copyBeginIndexes_(start, lastSegmentToCopy, delta);
    }

    private void copyBeginIndexes_(Segment start, Segment lastSegmentToCopy, int delta) {
        if (start == lastSegmentToCopy) {
            return;
        }
        Segment next = start;
        do {
            next = next.nextAtom();
            DiffMix.slideBeginIndexes(next, next.generatedBeginIndex() + delta, lastSegmentToCopy);
            this.currentAtomGeneratedIndex = next.generatedBeginIndex();
            this.currentAtomTextIndex = next.beginIndex();
        } while (next != lastSegmentToCopy);
    }

    private void diffMix(ISubTextPartition generatedTextPartition, ISubTextPartition textPartition, Segment start, Segment end, Segment endOfZoneSegment) {
        DiffMix diffMix = new DiffMix(this.changeSet, generatedTextPartition, textPartition);
        diffMix.diffMixMatch(start, end, endOfZoneSegment);
        this.currentAtomGeneratedIndex = diffMix.getCurrentAtomGeneratedIndex();
        this.currentAtomTextIndex = diffMix.getCurrentAtomTextIndex();
    }

    private void setSegment(Segment segment) {
        this.segment = segment;
    }

    @Override
    public void setChangeSet(UserChangeSet newChangeSet) {
        super.setChangeSet(newChangeSet);
        this.setUserChangeSet(newChangeSet);
    }

    public void setUserChangeSet(UserChangeSet userChangeSet) {
        this.generatedRootPartition = userChangeSet.generatedTextPartition();
        this.rootPartition = userChangeSet.textPartition();
    }

    private void initAllBeginIndex(Segment first, Segment last) {
        if (first == last) {
            return;
        }
        Segment next = first;
        do {
            next = next.nextAtom();
            next.setBeginIndex(-1);
        } while (next != last);
    }

    @Override
    protected void matchDirtyPortion(Segment minSegment, Segment maxSegment) {
        if (this.isUniqueAtomicSegmentDirtyPortion(minSegment, maxSegment)) {
            return;
        }
        this.initAllBeginIndex(minSegment, maxSegment);
        super.matchDirtyPortion(minSegment, maxSegment);
    }

    protected class DirtyZone {
        protected Segment firstAtomicSegment;
        protected Segment lastAtomicSegment;

        protected DirtyZone() {
        }
    }
}

