/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.engine.turbo.core.AppendedDictionary;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.IWord;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.TextPartitionTranslator;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.Matcher;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.ArrayIntSequence;
import com.ibm.pdp.util.ints.IntSequence;
import java.util.Arrays;

public class DiffMix {
    private ISubTextPartition generatedTextPartition;
    private ISubTextPartition textPartition;
    private AppendedDictionary dic;
    private int currentAtomGeneratedIndex;
    private int currentAtomTextIndex;
    private UserChangeSet userChangeSet;
    private int[] spaceAndWordsPositions;
    private int[] generatedSpaceAndWordsPositions;
    private IntSequence generatedSequenceToCompare;
    private IntSequence sequenceToCompare;
    public static final int SPACE_CATEGORY = -24356;
    static final int NEW_LINE_WEIGHT = 10;
    static final int TAB_WEIGHT = 4;
    static final int OTHER_WEIGHT = 2;
    static int count = 0;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public int getCurrentAtomGeneratedIndex() {
        return this.currentAtomGeneratedIndex;
    }

    public int getCurrentAtomTextIndex() {
        return this.currentAtomTextIndex;
    }

    public DiffMix(UserChangeSet ucs, ISubTextPartition generatedTextPartition, ISubTextPartition textPartition) {
        this.generatedTextPartition = generatedTextPartition;
        this.textPartition = textPartition;
        this.userChangeSet = ucs;
        this.dic = new AppendedDictionary(this.userChangeSet.getDictionary());
    }

    /*
     * Unable to fully structure code
     */
    private void buildString(boolean isGenerated) {
        sub = isGenerated != false ? this.generatedTextPartition : this.textPartition;
        text = sub.getText();
        textLength = text.length();
        result = new int[textLength * 2];
        resultLength = 0;
        nextWordIndex = 0;
        nextWordBeginIndex = sub.wordBeginIndex(nextWordIndex);
        words = sub.getWords();
        wordLength = words.length();
        r = "\r";
        ignoreNextLineFeed = false;
        token = null;
        i = 0;
        while (i < textLength) {
            block15: {
                block16: {
                    block14: {
                        if (i != nextWordBeginIndex) break block14;
                        i += sub.wordLength(nextWordIndex) - 1;
                        if (result.length == resultLength) {
                            result = Arrays.copyOf(result, resultLength + (resultLength >> 4) + 4);
                        }
                        result[resultLength++] = words.intAt(nextWordIndex++);
                        nextWordBeginIndex = nextWordIndex != wordLength ? sub.wordBeginIndex(nextWordIndex) : -1;
                        ignoreNextLineFeed = false;
                        break block15;
                    }
                    ch = text.charAt(i);
                    if (ch != 13) break block16;
                    ignoreNextLineFeed = true;
                    ** GOTO lbl46
                }
                if (ch == 10) {
                    if (ignoreNextLineFeed) {
                        ignoreNextLineFeed = false;
                    } else {
                        ch = 13;
                        if (token == null) {
                            token = new TextToken(0, 1, -24356, false, ch);
                        } else {
                            token.beginIdx = 0;
                            token.endIdx = 1;
                            token.hash = ch;
                        }
                        word = this.dic.addWord(r, token);
                        if (result.length == resultLength) {
                            result = Arrays.copyOf(result, resultLength + (resultLength >> 4) + 4);
                        }
                        result[resultLength++] = word.getId();
                    }
                } else {
                    ignoreNextLineFeed = false;
lbl46:
                    // 2 sources

                    if (token == null) {
                        token = new TextToken(i, i + 1, -24356, false, ch);
                    } else {
                        token.beginIdx = i;
                        token.endIdx = i + 1;
                        token.hash = ch;
                    }
                    word = this.dic.addWord(text, token);
                    if (result.length == resultLength) {
                        result = Arrays.copyOf(result, resultLength + (resultLength >> 4) + 4);
                    }
                    result[resultLength++] = word.getId();
                }
            }
            ++i;
        }
        if (isGenerated) {
            this.generatedSequenceToCompare = new ArrayIntSequence(Arrays.copyOf(result, resultLength));
        } else {
            this.sequenceToCompare = new ArrayIntSequence(Arrays.copyOf(result, resultLength));
        }
        this.buildSpaceAndWordPositions(isGenerated, sub, (IntSequence)new ArrayIntSequence(Arrays.copyOf(result, resultLength)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSpaceAndWordPositions(boolean isGenerated, ISubTextPartition partition, IntSequence diffText) {
        ++count;
        int size = diffText.length();
        int[] result = new int[size];
        CharSequence text = partition.getText();
        int nextWordIndex = 0;
        int nextTextIndex = 0;
        int wordRank = 0;
        boolean ignoreNextChar = false;
        int i = 0;
        while (i < size) {
            IWord word = this.dic.getWordFromId(diffText.intAt(i));
            if (word.getCategory() == -24356) {
                char nextChar;
                char wordChar = word.charAt(0);
                block5: while (true) {
                    nextChar = text.charAt(nextTextIndex);
                    switch (nextChar) {
                        case '\r': {
                            ignoreNextChar = true;
                            break block5;
                        }
                        case '\n': {
                            if (!ignoreNextChar) break block5;
                            ignoreNextChar = false;
                            nextChar = text.charAt(++nextTextIndex);
                            continue block5;
                        }
                        default: {
                            ignoreNextChar = false;
                        }
                    }
                    break;
                }
                if (nextChar == wordChar) {
                    result[i] = nextTextIndex++;
                } else {
                    if (nextChar != '\n' || wordChar != '\r') throw new RuntimeException("DiffMix : buildString incorect");
                    result[i] = nextTextIndex++;
                }
            } else {
                ignoreNextChar = false;
                result[i] = partition.wordBeginIndex(nextWordIndex++);
                nextTextIndex = result[i] + partition.wordLength(wordRank++);
            }
            ++i;
        }
        if (isGenerated) {
            this.generatedSpaceAndWordsPositions = result;
            return;
        } else {
            this.spaceAndWordsPositions = result;
        }
    }

    private int convertDiffMixIndexToRootIndex(int index, boolean isGenerated) {
        if (isGenerated) {
            int indexInSubText = index == this.generatedSpaceAndWordsPositions.length ? this.generatedTextPartition.getTextLength() : this.generatedSpaceAndWordsPositions[index];
            return TextPartitionTranslator.translateIndex(indexInSubText, this.generatedTextPartition, this.userChangeSet.generatedTextPartition());
        }
        int indexInSubText = index == this.spaceAndWordsPositions.length ? this.textPartition.getTextLength() : this.spaceAndWordsPositions[index];
        return TextPartitionTranslator.translateIndex(indexInSubText, this.textPartition, this.userChangeSet.textPartition());
    }

    public void diffMixMatch(Segment start, Segment end, Segment endOfZoneSegment) {
        this.currentAtomGeneratedIndex = -1;
        this.currentAtomTextIndex = -1;
        this.buildString(true);
        this.buildString(false);
        DiffCursor cursor = Ints.newDiffCursor((IntSequence)this.generatedSequenceToCompare, (IntSequence)this.sequenceToCompare);
        boolean differenceFound = cursor.searchNextDifference();
        if (!differenceFound) {
            throw new RuntimeException("DiffMix:diffMixMatch() no difference found.");
        }
        Segment atom = start;
        int currentGeneratedDiffMixIndex = 0;
        Segment nextAtom = atom.nextAtom();
        while (differenceFound) {
            boolean differenceOnMultipleGeneratedAtoms;
            int generatedTextEndDifferenceIndex;
            int generatedDiffMixBeginWord = cursor.getReferenceBeginIndex();
            if (atom == endOfZoneSegment) {
                return;
            }
            if (nextAtom == null) {
                return;
            }
            if (generatedDiffMixBeginWord != currentGeneratedDiffMixIndex) {
                int textEndEqualityIndex;
                boolean isEqualityOnMultipldeSegment;
                int generatedTextEndEqualityIndex;
                currentGeneratedDiffMixIndex = generatedDiffMixBeginWord;
                this.currentAtomGeneratedIndex = generatedTextEndEqualityIndex = this.convertDiffMixIndexToRootIndex(generatedDiffMixBeginWord, true);
                boolean bl = isEqualityOnMultipldeSegment = atom != end && nextAtom != null && nextAtom.generatedBeginIndex() <= generatedTextEndEqualityIndex;
                if (isEqualityOnMultipldeSegment) {
                    while (isEqualityOnMultipldeSegment) {
                        int delta = generatedTextEndEqualityIndex - nextAtom.generatedBeginIndex();
                        atom = nextAtom;
                        textEndEqualityIndex = this.convertDiffMixIndexToRootIndex(cursor.getModifiedBeginIndex(), false);
                        this.currentAtomTextIndex = textEndEqualityIndex - delta;
                        DiffMix.slideBeginIndexes(atom, textEndEqualityIndex - delta, endOfZoneSegment);
                        nextAtom = atom.nextAtom();
                        boolean bl2 = isEqualityOnMultipldeSegment = nextAtom != null && nextAtom.generatedBeginIndex() < generatedTextEndEqualityIndex;
                    }
                } else {
                    int diffMixEndWord = cursor.getModifiedBeginIndex();
                    this.currentAtomTextIndex = textEndEqualityIndex = this.convertDiffMixIndexToRootIndex(diffMixEndWord, false);
                }
            }
            if (nextAtom == null) {
                return;
            }
            cursor.getDifferenceNature();
            int generatedDiffMixEndWord = cursor.getReferenceEndIndex();
            this.currentAtomGeneratedIndex = generatedTextEndDifferenceIndex = this.convertDiffMixIndexToRootIndex(generatedDiffMixEndWord, true);
            boolean bl = differenceOnMultipleGeneratedAtoms = atom != end && nextAtom != null && nextAtom.generatedBeginIndex() <= generatedTextEndDifferenceIndex;
            if (differenceOnMultipleGeneratedAtoms) {
                while (differenceOnMultipleGeneratedAtoms) {
                    int generatedTextBeginDifferenceIndex = this.convertDiffMixIndexToRootIndex(generatedDiffMixBeginWord, true);
                    Segment lastAtom = nextAtom;
                    while (lastAtom != end && lastAtom.nextAtom().generatedBeginIndex() <= generatedTextEndDifferenceIndex) {
                        lastAtom = lastAtom.nextAtom();
                    }
                    int textBeginDifferenceIndex = this.convertDiffMixIndexToRootIndex(cursor.getModifiedBeginIndex(), false);
                    int textEndDifferenceIndex = this.convertDiffMixIndexToRootIndex(cursor.getModifiedEndIndex(), false);
                    this.matchDiffMixDifference(cursor, atom, lastAtom, generatedTextBeginDifferenceIndex, generatedTextEndDifferenceIndex, textBeginDifferenceIndex, textEndDifferenceIndex, endOfZoneSegment);
                    this.currentAtomTextIndex = textEndDifferenceIndex;
                    atom = lastAtom;
                    if (atom != end) {
                        nextAtom = atom.nextAtom();
                        boolean bl3 = differenceOnMultipleGeneratedAtoms = nextAtom != null && nextAtom.generatedBeginIndex() <= generatedTextEndDifferenceIndex;
                        continue;
                    }
                    break;
                }
            } else {
                int textEndDiffernceIndex;
                if (atom == endOfZoneSegment) {
                    return;
                }
                int diffMixEndWord = cursor.getModifiedEndIndex();
                this.currentAtomTextIndex = textEndDiffernceIndex = this.convertDiffMixIndexToRootIndex(diffMixEndWord, false);
            }
            currentGeneratedDiffMixIndex = generatedDiffMixEndWord;
            differenceFound = cursor.searchNextDifference();
        }
        if (this.generatedSequenceToCompare.length() != currentGeneratedDiffMixIndex) {
            int textEndEqualityIndex;
            boolean isEqualityInOnlyOneSegment;
            int generatedTextEndEqualityIndex;
            this.currentAtomGeneratedIndex = generatedTextEndEqualityIndex = this.convertDiffMixIndexToRootIndex(this.generatedSequenceToCompare.length(), true);
            boolean bl = isEqualityInOnlyOneSegment = atom != end && nextAtom != null && nextAtom.generatedBeginIndex() < generatedTextEndEqualityIndex;
            if (isEqualityInOnlyOneSegment) {
                while (isEqualityInOnlyOneSegment) {
                    int delta = generatedTextEndEqualityIndex - nextAtom.generatedBeginIndex();
                    atom = nextAtom;
                    textEndEqualityIndex = this.convertDiffMixIndexToRootIndex(this.sequenceToCompare.length(), false);
                    this.currentAtomTextIndex = textEndEqualityIndex - delta;
                    DiffMix.slideBeginIndexes(atom, textEndEqualityIndex - delta, endOfZoneSegment);
                    nextAtom = atom.nextAtom();
                    boolean bl4 = isEqualityInOnlyOneSegment = nextAtom != null && nextAtom.generatedBeginIndex() < generatedTextEndEqualityIndex;
                }
            } else {
                int diffMixEndWord = this.sequenceToCompare.length();
                this.currentAtomTextIndex = textEndEqualityIndex = this.convertDiffMixIndexToRootIndex(diffMixEndWord, false);
            }
        }
        while (nextAtom != null && nextAtom.minRank() <= end.minRank()) {
            if (nextAtom.beginIndex() == -1) {
                DiffMix.slideBeginIndexes(nextAtom, this.currentAtomTextIndex, end);
            }
            nextAtom = nextAtom.nextAtom();
        }
    }

    public static void slideBeginIndexes(Segment atom, int beginIndex, Segment lastDirtyZoneAtom) {
        atom.setBeginIndex(beginIndex);
    }

    private void matchDiffMixDifference(DiffCursor cursor, Segment start, Segment lastAtom, int generatedTextBeginDifferenceIndex, int generatedTextEndDifferenceIndex, int textBeginDifferenceIndex, int textEndDifferenceIndex, Segment endOfZoneSegment) {
        if (textBeginDifferenceIndex == textEndDifferenceIndex) {
            Segment atom = start.nextAtom();
            while (true) {
                DiffMix.slideBeginIndexes(atom, textBeginDifferenceIndex, endOfZoneSegment);
                if (atom != lastAtom) {
                    atom = atom.nextAtom();
                    continue;
                }
                break;
            }
        } else {
            if (generatedTextBeginDifferenceIndex != generatedTextEndDifferenceIndex) {
                Segment allDifferenceSegment = null;
                Segment atom = start.nextAtom();
                while (atom.generatedBeginIndex() <= generatedTextBeginDifferenceIndex) {
                    if (atom.generatedEndIndex() >= generatedTextEndDifferenceIndex) {
                        allDifferenceSegment = atom;
                        break;
                    }
                    if (atom == lastAtom) break;
                    atom = atom.nextAtom();
                }
                atom = start.nextAtom();
                if (allDifferenceSegment != null) {
                    boolean found = false;
                    while (true) {
                        if (!found) {
                            DiffMix.slideBeginIndexes(atom, textBeginDifferenceIndex, endOfZoneSegment);
                        } else {
                            DiffMix.slideBeginIndexes(atom, textEndDifferenceIndex, endOfZoneSegment);
                        }
                        if (atom == allDifferenceSegment) {
                            found = true;
                        }
                        if (atom == lastAtom) break;
                        atom = atom.nextAtom();
                    }
                    return;
                }
                Segment[] segmentInterval = new Segment[]{start, lastAtom};
                this.trimEmptyGeneratedSegment(segmentInterval, generatedTextEndDifferenceIndex, textEndDifferenceIndex, endOfZoneSegment);
                atom = segmentInterval[0];
                lastAtom = segmentInterval[1];
                if (atom == lastAtom) {
                    return;
                }
            }
            Segment atom = start;
            Segment smallestSegment = start.nextAtom();
            do {
                atom = atom.nextAtom();
                smallestSegment = Matcher.getBestCandidateForInsertion(smallestSegment, atom);
            } while (atom != lastAtom);
            atom = start.nextAtom();
            boolean smallerSegmentFound = false;
            while (true) {
                if (!smallerSegmentFound) {
                    DiffMix.slideBeginIndexes(atom, textBeginDifferenceIndex, endOfZoneSegment);
                } else {
                    DiffMix.slideBeginIndexes(atom, textEndDifferenceIndex, endOfZoneSegment);
                }
                if (atom == smallestSegment) {
                    smallerSegmentFound = true;
                }
                if (atom == lastAtom) break;
                atom = atom.nextAtom();
            }
        }
    }

    private void trimEmptyGeneratedSegment(Segment[] segmentInterval, int generatedTextEndDifferenceIndex, int textEndDifferenceIndex, Segment endOfZoneSegment) {
        Segment previousSegment;
        int endIndex;
        Segment startSegment = segmentInterval[0];
        Segment endSegment = segmentInterval[1];
        if (startSegment == endSegment) {
            return;
        }
        Segment currentSegment = startSegment;
        while (currentSegment != null && currentSegment.generatedLength() == 0) {
            Segment nextSegment = currentSegment.nextAtom();
            if (nextSegment == null) {
                return;
            }
            nextSegment.setBeginIndex(startSegment.beginIndex());
            segmentInterval[0] = nextSegment;
            if (nextSegment == endSegment) {
                return;
            }
            currentSegment = nextSegment;
        }
        currentSegment = endSegment;
        if (currentSegment != null && currentSegment.generatedBeginIndex() == generatedTextEndDifferenceIndex) {
            currentSegment.setBeginIndex(textEndDifferenceIndex);
            endIndex = textEndDifferenceIndex;
            segmentInterval[1] = currentSegment = (previousSegment = currentSegment.previousAtom());
        } else {
            if (endSegment == null) {
                return;
            }
            boolean endOfZone = endSegment == endOfZoneSegment;
            int beginIndexOfNextZone = 0;
            if (endOfZone) {
                Segment nextAtom = endOfZoneSegment.nextAtom();
                beginIndexOfNextZone = nextAtom == null ? currentSegment.getChangeSet().getText().length() : nextAtom.beginIndex();
                endIndex = beginIndexOfNextZone;
            } else {
                endIndex = textEndDifferenceIndex;
            }
        }
        while (currentSegment != null && currentSegment.generatedLength() == 0) {
            currentSegment.setBeginIndex(endIndex);
            segmentInterval[1] = currentSegment = (previousSegment = currentSegment.previousAtom());
        }
    }
}

