/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.ConstraintType;
import com.ibm.pdp.engine.extension.ITextMatcher;
import com.ibm.pdp.engine.extension.ITextMatcherConstraints;
import com.ibm.pdp.engine.extension.ITextMatcherContext;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.TextNatureCursor;
import com.ibm.pdp.engine.turbo.match.AbstractMatcher;
import com.ibm.pdp.engine.turbo.match.Matcher;
import com.ibm.pdp.engine.turbo.match.SegmentIndexConstraints;
import com.ibm.pdp.engine.turbo.match.SegmentIndexConstraintsIntervalCursor;
import com.ibm.pdp.engine.turbo.match.TextMatcherConstraints;
import com.ibm.pdp.engine.turbo.match.TextMatcherContext;
import com.ibm.pdp.engine.turbo.match.TextPartitionDiffCursor;
import com.ibm.pdp.engine.turbo.match.TextPartitionDifferencer;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.Iterator;

public class DiffMatcher
extends AbstractMatcher {
    private SegmentIndexConstraints constraints;
    protected ITextMatcher textMatcher;
    private static int MINIMUM_LEVEL_RULE = 0;
    private static int ALREADY_MODIFIED_RULE = 1;
    private static int TRIM_EMPTY_GENERATED_RULE = 2;
    private static int MATCHING_EXTENSION = 3;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public boolean match_() {
        if (this.changeSet.getChangeNature() != ChangeNature.Dirty) {
            return false;
        }
        TextNatureCursor dirtyPortions = new TextNatureCursor(this.changeSet);
        dirtyPortions.setAcceptedChangeNatures(TextNatureCursor.DirtyCodeNature);
        while (dirtyPortions.searchNextTextPortion()) {
            this.matchDirtyPortion(dirtyPortions.minSegment(), dirtyPortions.maxSegment());
        }
        return true;
    }

    @Override
    public boolean match_(Segment segment) {
        if (!this.isDirty(segment)) {
            return false;
        }
        return segment.isAtomic() ? this.matchAtom(segment) : this.matchFromTo(segment, segment);
    }

    @Override
    public boolean match(Segment minSegment, Segment maxSegment) {
        if (minSegment == maxSegment) {
            return this.match(minSegment);
        }
        if (this.changeSet.getChangeNature() != ChangeNature.Dirty) {
            return false;
        }
        Segment ancestor = Segment.commonAncestorOf(minSegment, maxSegment);
        if (ancestor != null && !this.isDirty(ancestor)) {
            return false;
        }
        return this.matchFromTo(minSegment, maxSegment);
    }

    @Override
    public boolean match(int beginIdx, int endIdx) {
        if (this.changeSet.getChangeNature() != ChangeNature.Dirty) {
            return false;
        }
        TextNatureCursor interval = new TextNatureCursor(this.changeSet, beginIdx, endIdx);
        return this.match(interval.getFirstSegment(), interval.getLastSegment());
    }

    protected boolean matchAtom(Segment atom) {
        Segment firstAtom = atom;
        Segment previousAtom = atom.previousAtom();
        while (previousAtom != null && this.isDirty(previousAtom)) {
            firstAtom = previousAtom;
            previousAtom = previousAtom.previousAtom();
        }
        Segment lastAtom = atom;
        Segment nextAtom = lastAtom.nextAtom();
        while (nextAtom != null && this.isDirty(nextAtom)) {
            lastAtom = nextAtom;
            nextAtom = nextAtom.nextAtom();
        }
        this.matchDirtyPortion(firstAtom, lastAtom);
        return true;
    }

    protected boolean matchFromTo(Segment minSegment, Segment maxSegment) {
        Segment lastAtom;
        boolean foundDirty = false;
        Segment firstAtom = minSegment.firstAtom();
        if (this.isDirty(firstAtom)) {
            Segment previousAtom = firstAtom.previousAtom();
            while (previousAtom != null && this.isDirty(previousAtom)) {
                firstAtom = previousAtom;
                previousAtom = previousAtom.previousAtom();
            }
        }
        if (this.isDirty(lastAtom = maxSegment.lastAtom())) {
            Segment nextAtom = lastAtom.nextAtom();
            while (nextAtom != null && this.isDirty(nextAtom)) {
                lastAtom = nextAtom;
                nextAtom = nextAtom.nextAtom();
            }
        }
        TextNatureCursor dirtyPortions = new TextNatureCursor(this.changeSet, firstAtom, lastAtom);
        dirtyPortions.setAcceptedChangeNatures(TextNatureCursor.DirtyCodeNature);
        while (dirtyPortions.searchNextTextPortion()) {
            foundDirty = true;
            this.matchDirtyPortion(dirtyPortions.minSegment(), dirtyPortions.maxSegment());
        }
        return foundDirty;
    }

    protected boolean isDirty(Segment segment) {
        return segment.getTreeChangeNature() == ChangeNature.Dirty;
    }

    @Override
    protected void matchZone(Segment minSegment, Segment maxSegment) {
        int refIdxShift = minSegment.generatedBeginIndex();
        ISubTextPartition reference = this.changeSet.generatedTextPartition().subTextPartition(refIdxShift, maxSegment.generatedEndIndex());
        int idxShift = minSegment.beginIndex();
        ISubTextPartition modified = this.changeSet.textPartition().subTextPartition(idxShift, maxSegment.endIndex());
        TextPartitionDiffCursor diffCursor = this.newPartitionDiffCursor(reference, modified);
        this.constraints = new SegmentIndexConstraints(this.changeSet, minSegment, maxSegment);
        int minAtomRank = minSegment.minRank();
        int maxAtomRank = maxSegment.maxRank();
        int atomRank = minAtomRank + 1;
        while (atomRank <= maxAtomRank && !this.constraints.isResolved()) {
            Segment atom = this.changeSet.atomAt(atomRank);
            int refBeginIdx = atom.generatedBeginIndex() - refIdxShift;
            if (diffCursor.moveToReferenceIndex(refBeginIdx)) {
                int beginIdx = idxShift + diffCursor.getModifiedBeginIndex();
                int endIdx = idxShift + diffCursor.getModifiedEndIndex();
                this.constraints.addSegmentBeginIndexConstraint(atom, ConstraintType.GreaterOrEqual, beginIdx);
                this.constraints.addSegmentBeginIndexConstraint(atom, ConstraintType.LowerOrEqual, endIdx);
            } else {
                int index = idxShift + diffCursor.getModifiedBeginIndex();
                this.constraints.addSegmentBeginIndexConstraint(atom, ConstraintType.Equal, index);
            }
            ++atomRank;
        }
        this.callMatchingExtension();
        this.addConstraintsForRules(diffCursor, TRIM_EMPTY_GENERATED_RULE);
        this.addConstraintsForRules(diffCursor, ALREADY_MODIFIED_RULE);
        this.addConstraintsForRules(diffCursor, MINIMUM_LEVEL_RULE);
        this.constraints.applyConstraints();
        this.constraints = null;
        atomRank = minAtomRank;
        while (atomRank <= maxAtomRank) {
            this.computeChangeNature(this.changeSet.atomAt(atomRank));
            ++atomRank;
        }
    }

    private void addConstraintsForRules(TextPartitionDiffCursor diffCursor, int ruleType) {
        if (this.constraints.maxBeginIndexForSegment(this.constraints.minAtom()) == this.constraints.maxEndIndexForSegment(this.constraints.maxAtom())) {
            return;
        }
        SegmentIndexConstraintsIntervalCursor sicic = new SegmentIndexConstraintsIntervalCursor(this.changeSet, this.constraints);
        while (sicic.searchNextInterval()) {
            Segment firstAtom = sicic.getMinSegment();
            Segment lastAtom = sicic.getMaxSegment();
            this.addConstraintsForSegmentInterval(firstAtom, lastAtom, ruleType, diffCursor);
        }
    }

    private void addConstraintsForSegmentInterval(Segment firstAtom, Segment lastAtom, int ruleType, TextPartitionDiffCursor diffCursor) {
        Segment atom = firstAtom;
        while (true) {
            if (atom == this.constraints.minAtom() || this.constraints.isBeginIndexResolved(atom)) {
                if (atom == lastAtom) break;
                atom = atom.nextAtom();
                continue;
            }
            Segment startOfInterval = null;
            Segment previousAtom = atom.previousAtom();
            if (previousAtom == this.constraints.minAtom() || this.constraints.isBeginIndexResolved(previousAtom) || this.constraints.maxBeginIndexForSegment(previousAtom) < this.constraints.minEndIndexForSegment(previousAtom)) {
                startOfInterval = previousAtom;
            }
            Segment endOfInterval = null;
            Segment nextAtom = startOfInterval;
            do {
                if ((nextAtom = nextAtom.nextAtom()) != this.constraints.maxAtom() && !this.constraints.isEndIndexResolved(nextAtom) && this.constraints.maxBeginIndexForSegment(nextAtom) >= this.constraints.minEndIndexForSegment(nextAtom)) continue;
                endOfInterval = nextAtom;
                break;
            } while (nextAtom != lastAtom);
            if (ruleType == MINIMUM_LEVEL_RULE) {
                this.addConstrainstForMinimumLevel_(startOfInterval, endOfInterval);
            } else if (ruleType == ALREADY_MODIFIED_RULE) {
                this.addConstraintsForPartiallyModifiedSegments_(startOfInterval, endOfInterval, diffCursor);
            } else if (ruleType == TRIM_EMPTY_GENERATED_RULE) {
                this.addConstraintsForEmptyGeneratedTagExtremities(startOfInterval, endOfInterval, diffCursor);
            } else if (ruleType == MATCHING_EXTENSION) {
                this.addConstraintsForMatchingExtension(startOfInterval, endOfInterval);
            }
            if (endOfInterval == lastAtom) break;
            atom = endOfInterval.nextAtom();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addConstraintsForMatchingExtension(Segment startOfInterval, Segment endOfInterval) {
        startOfInterval = startOfInterval.nextAtom();
        segmentAfterInterval = endOfInterval;
        endOfInterval = endOfInterval.previousAtom();
        if (startOfInterval.maxRank() > endOfInterval.maxRank() + 1) {
            return;
        }
        textBeginIndex = this.constraints.minBeginIndexForSegment(startOfInterval);
        textEndIndex = this.constraints.maxEndIndexForSegment(endOfInterval);
        beginTagExt = this.getTagExt(startOfInterval, true);
        endTagExt = this.getTagExt(endOfInterval, false);
        afterIntervalTagExt = this.getTagExt(segmentAfterInterval, false);
        genInfo = this.changeSet.getGeneratedInfo();
        allText = this.changeSet.getText();
        context = new TextMatcherContext(genInfo, allText, textBeginIndex, textEndIndex, beginTagExt.getTag(), beginTagExt.isTagStart(), endTagExt.getTag(), endTagExt.isTagStart(), afterIntervalTagExt.getTag(), afterIntervalTagExt.isTagStart(), this);
        matcherConstraints = new TextMatcherConstraints();
        try {
            this.textMatcher.determineConstraints((ITextMatcherContext)context, (ITextMatcherConstraints)matcherConstraints);
        }
        catch (Throwable th) {
            System.out.println(th.getMessage());
        }
        iter = matcherConstraints.getConstraintsTagExtremityIterator();
        if (iter != null) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            constraintsTagExtremity = iter.next();
            b = this.checkConstraint(constraintsTagExtremity);
            if (!b) continue;
            this.slideConstraintsTagExtremity(constraintsTagExtremity);
            segment = this.getSegmentForConstraintTagExtremity(constraintsTagExtremity);
            this.constraints.setGenerateException(false);
            this.constraints.addSegmentBeginIndexConstraint(segment, constraintsTagExtremity.getType(), constraintsTagExtremity.getIndexInText());
lbl32:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl33:
        // 1 sources

    }

    private void trace(Segment segment, TextMatcherConstraints.ConstraintsTagExtremity constraintsTagExtremity) {
        System.out.println("DiffMatcher : segment min rank=" + segment.minRank() + " " + constraintsTagExtremity.getType() + " " + constraintsTagExtremity.getIndexInText());
    }

    private void addConstraintsForEmptyGeneratedTagExtremities(Segment startOfInterval, Segment endOfInterval, TextPartitionDiffCursor diffCursor) {
        int nbManagedFrontiers = this.processEmptyGeneratedTagExtremities(startOfInterval, endOfInterval, diffCursor, false);
        if (nbManagedFrontiers == endOfInterval.maxRank() - startOfInterval.maxRank()) {
            this.processEmptyGeneratedTagExtremities(startOfInterval, endOfInterval, diffCursor, true);
        }
    }

    protected int processEmptyGeneratedTagExtremities(Segment startOfInterval, Segment endOfInterval, TextPartitionDiffCursor diffCursor, boolean modifyConstraints) {
        int minBegin;
        int maxBegin;
        int tagFrontiers = 0;
        int textBeginIndex = this.constraints.maxBeginIndexForSegment(startOfInterval);
        int textEndIndex = this.constraints.maxEndIndexForSegment(endOfInterval);
        Segment startSegment = startOfInterval;
        Segment endSegment = endOfInterval;
        if (startSegment == endSegment) {
            return tagFrontiers;
        }
        int beginIndex = textBeginIndex;
        Segment currentSegment = startSegment.nextAtom();
        int refIDxShift = this.constraints.minAtom().generatedBeginIndex();
        boolean isOnDifference = diffCursor.moveToReferenceIndex(currentSegment.generatedBeginIndex() - refIDxShift);
        if (isOnDifference && diffCursor.getDifferenceNature() == DifferenceNature.Replacement) {
            int beginGeneratedReplacement = diffCursor.getReferenceBeginIndex() + refIDxShift;
            if (beginGeneratedReplacement == currentSegment.generatedBeginIndex()) {
                int idxShift = this.constraints.minAtom().beginIndex();
                int beginModifiedReplacement = diffCursor.getModifiedBeginIndex() + idxShift;
                int maxBegin2 = this.constraints.maxBeginIndexForSegment(currentSegment);
                int minBegin2 = this.constraints.minBeginIndexForSegment(currentSegment);
                beginIndex = beginModifiedReplacement;
                if (beginModifiedReplacement >= minBegin2 && beginModifiedReplacement <= maxBegin2) {
                    ++tagFrontiers;
                    if (modifyConstraints) {
                        this.constraints.addSegmentBeginIndexConstraint(currentSegment, ConstraintType.Equal, beginModifiedReplacement);
                    }
                }
            }
            while (currentSegment != null && currentSegment.generatedLength() == 0) {
                Segment nextSegment = currentSegment.nextAtom();
                if (nextSegment == null) {
                    return tagFrontiers;
                }
                maxBegin = this.constraints.maxBeginIndexForSegment(nextSegment);
                minBegin = this.constraints.minBeginIndexForSegment(nextSegment);
                if (beginIndex < minBegin || beginIndex > maxBegin) break;
                ++tagFrontiers;
                if (modifyConstraints) {
                    this.constraints.addSegmentBeginIndexConstraint(nextSegment, ConstraintType.Equal, beginIndex);
                }
                if (nextSegment == endSegment) {
                    return tagFrontiers;
                }
                currentSegment = nextSegment;
            }
        }
        currentSegment = endSegment;
        int endIndex = textEndIndex;
        isOnDifference = diffCursor.moveToReferenceIndex(currentSegment.generatedBeginIndex() - refIDxShift);
        if (isOnDifference && diffCursor.getDifferenceNature() == DifferenceNature.Replacement) {
            int endGeneratedReplacement = diffCursor.getReferenceEndIndex() + refIDxShift;
            if (endGeneratedReplacement == currentSegment.generatedBeginIndex()) {
                int idxShift = this.constraints.minAtom().beginIndex();
                int endModifiedReplacement = diffCursor.getModifiedEndIndex() + idxShift;
                int maxBegin3 = this.constraints.maxBeginIndexForSegment(currentSegment);
                int minBegin3 = this.constraints.minBeginIndexForSegment(currentSegment);
                endIndex = endModifiedReplacement;
                if (endModifiedReplacement >= minBegin3 && endModifiedReplacement <= maxBegin3) {
                    ++tagFrontiers;
                    if (modifyConstraints) {
                        this.constraints.addSegmentBeginIndexConstraint(currentSegment, ConstraintType.Equal, endModifiedReplacement);
                    }
                }
                currentSegment = currentSegment.previousAtom();
            }
            while (currentSegment != null && currentSegment.generatedLength() == 0) {
                maxBegin = this.constraints.maxBeginIndexForSegment(currentSegment);
                minBegin = this.constraints.minBeginIndexForSegment(currentSegment);
                if (endIndex < minBegin || endIndex > maxBegin) break;
                ++tagFrontiers;
                if (modifyConstraints) {
                    this.constraints.addSegmentBeginIndexConstraint(currentSegment, ConstraintType.Equal, endIndex);
                }
                if ((currentSegment = currentSegment.previousAtom()) != startSegment) continue;
                return tagFrontiers;
            }
        }
        return tagFrontiers;
    }

    private void callMatchingExtension() {
        if (this.extension == null) {
            return;
        }
        if (this.textMatcher == null) {
            this.textMatcher = this.extension.newTextMatcher();
        }
        if (this.textMatcher == null) {
            return;
        }
        if (this.constraints.maxBeginIndexForSegment(this.constraints.minAtom()) == this.constraints.maxEndIndexForSegment(this.constraints.maxAtom())) {
            return;
        }
        SegmentIndexConstraintsIntervalCursor sicic = new SegmentIndexConstraintsIntervalCursor(this.changeSet, this.constraints);
        while (sicic.searchNextInterval()) {
            Segment firstAtom = sicic.getMinSegment();
            Segment lastAtom = sicic.getMaxSegment();
            this.addConstraintsForSegmentInterval(firstAtom, lastAtom, MATCHING_EXTENSION, null);
        }
    }

    private Segment getSegmentForConstraintTagExtremity(TextMatcherConstraints.ConstraintsTagExtremity constraintsTagExtremity) {
        Segment tagSegment = this.changeSet.segmentFromTagName(constraintsTagExtremity.getTag().getName(), 0);
        if (constraintsTagExtremity.isBeginIndex()) {
            return tagSegment.firstAtom();
        }
        return tagSegment.lastAtom().nextAtom();
    }

    private boolean checkConstraint(TextMatcherConstraints.ConstraintsTagExtremity constraintsTagExtremity) {
        int indexInText = constraintsTagExtremity.getIndexInText();
        int wordRank = this.changeSet.textPartition().wordRankFromIndex(indexInText);
        if (wordRank < 0) {
            return true;
        }
        return this.changeSet.textPartition().wordBeginIndex(wordRank) == indexInText;
    }

    private boolean slideConstraintsTagExtremity(TextMatcherConstraints.ConstraintsTagExtremity constraintsTagExtremity) {
        if (constraintsTagExtremity.getType() != ConstraintType.LowerThan && constraintsTagExtremity.getType() != ConstraintType.GreaterThan) {
            return false;
        }
        if (constraintsTagExtremity.getType() == ConstraintType.LowerThan) {
            int index = constraintsTagExtremity.getIndexInText();
            int wordRank = this.changeSet.textPartition().wordRankFromIndex(--index);
            if (wordRank < 0) {
                constraintsTagExtremity.setIndexInText(index);
                constraintsTagExtremity.setType(ConstraintType.LowerOrEqual);
            } else {
                constraintsTagExtremity.setIndexInText(this.changeSet.textPartition().wordBeginIndex(wordRank));
                constraintsTagExtremity.setType(ConstraintType.LowerOrEqual);
            }
            return true;
        }
        if (constraintsTagExtremity.getType() == ConstraintType.GreaterThan) {
            int index = constraintsTagExtremity.getIndexInText();
            int wordRank = this.changeSet.textPartition().wordRankFromIndex(++index);
            if (wordRank < 0) {
                constraintsTagExtremity.setIndexInText(index);
                constraintsTagExtremity.setType(ConstraintType.GreaterOrEqual);
            } else {
                constraintsTagExtremity.setIndexInText(this.changeSet.textPartition().wordBeginIndex(wordRank) + this.changeSet.textPartition().wordLength(wordRank));
                constraintsTagExtremity.setType(ConstraintType.GreaterOrEqual);
            }
            return true;
        }
        return false;
    }

    private TagExt getTagExt(Segment atom, boolean beginOfAtom) {
        IGeneratedTag enclosingTag = atom.enclosingTag();
        if (enclosingTag == null) {
            if (atom.minRank() == 0) {
                if (beginOfAtom) {
                    return new TagExt(null, true);
                }
                return this.getTagExt(atom.nextAtom(), true);
            }
            if (beginOfAtom) {
                return this.getTagExt(atom.previousAtom(), false);
            }
            return new TagExt(null, false);
        }
        if (atom.isTagged()) {
            return new TagExt(enclosingTag, beginOfAtom);
        }
        if (atom.isFirstPart()) {
            if (beginOfAtom) {
                return new TagExt(enclosingTag, true);
            }
            IGeneratedTag firstSon = (IGeneratedTag)enclosingTag.sons().next();
            return new TagExt(firstSon, true);
        }
        if (atom.isLastPart()) {
            if (!beginOfAtom) {
                return new TagExt(enclosingTag, false);
            }
            IGeneratedTag lastSon = null;
            Iterator sons = enclosingTag.sons();
            while (sons.hasNext()) {
                lastSon = (IGeneratedTag)sons.next();
            }
            return new TagExt(lastSon, false);
        }
        if (beginOfAtom) {
            return new TagExt(atom.previousAtom().enclosingTag(), false);
        }
        return new TagExt(atom.nextAtom().enclosingTag(), true);
    }

    @Override
    protected void matchDirtyPortion(Segment minSegment, Segment maxSegment) {
        if (this.isUniqueAtomicSegmentDirtyPortion(minSegment, maxSegment)) {
            return;
        }
        super.matchDirtyPortion(minSegment, maxSegment);
    }

    protected TextPartitionDiffCursor newPartitionDiffCursor(ITextPartition reference, ITextPartition modified) {
        return new TextPartitionDifferencer(reference, modified).newDiffCursor();
    }

    private void addConstraintsForPartiallyModifiedSegments_(Segment startOfInterval, Segment endOfInterval, TextPartitionDiffCursor diffCursor) {
        if (startOfInterval == endOfInterval) {
            return;
        }
        int refIDxShift = this.constraints.minAtom().generatedBeginIndex();
        boolean isOnDifference = diffCursor.moveToReferenceIndex(startOfInterval.generatedEndIndex() - refIDxShift);
        if (!isOnDifference) {
            return;
        }
        DifferenceNature nature = diffCursor.getDifferenceNature();
        if (nature == DifferenceNature.Deletion || nature == DifferenceNature.Insertion) {
            return;
        }
        int beginGeneratedReplacement = diffCursor.getReferenceBeginIndex() + refIDxShift;
        int endGeneratedReplacement = diffCursor.getReferenceEndIndex() + refIDxShift;
        if (beginGeneratedReplacement < startOfInterval.generatedBeginIndex() || endGeneratedReplacement > endOfInterval.generatedEndIndex()) {
            return;
        }
        Segment currentSegment = startOfInterval;
        while (currentSegment != endOfInterval) {
            if (currentSegment.generatedLength() != 0 && currentSegment.generatedBeginIndex() >= beginGeneratedReplacement && currentSegment.generatedEndIndex() <= endGeneratedReplacement) {
                return;
            }
            currentSegment = currentSegment.nextAtom();
        }
        currentSegment = startOfInterval;
        Segment firstPartiallyModifiedSegment = null;
        while (currentSegment != endOfInterval) {
            if (currentSegment.generatedLength() == 0) {
                currentSegment = currentSegment.nextAtom();
                continue;
            }
            if (currentSegment.generatedBeginIndex() >= beginGeneratedReplacement || currentSegment.generatedEndIndex() == beginGeneratedReplacement) break;
            if (currentSegment.generatedEndIndex() <= endGeneratedReplacement) {
                firstPartiallyModifiedSegment = currentSegment;
                break;
            }
            currentSegment = currentSegment.nextAtom();
        }
        currentSegment = endOfInterval;
        Segment lastPartiallyModifiedSegment = null;
        while (currentSegment != startOfInterval) {
            if (currentSegment.generatedLength() == 0) {
                currentSegment = currentSegment.previousAtom();
                continue;
            }
            if (currentSegment.generatedEndIndex() <= endGeneratedReplacement || currentSegment.generatedBeginIndex() == endGeneratedReplacement) break;
            if (currentSegment.generatedBeginIndex() >= beginGeneratedReplacement) {
                lastPartiallyModifiedSegment = currentSegment;
                break;
            }
            currentSegment = currentSegment.previousAtom();
        }
        if (firstPartiallyModifiedSegment != null && lastPartiallyModifiedSegment != null) {
            return;
        }
        if (firstPartiallyModifiedSegment == null && lastPartiallyModifiedSegment == null) {
            return;
        }
        int idxShift = this.constraints.minAtom().beginIndex();
        if (firstPartiallyModifiedSegment != null) {
            int endModifiedReplacement = diffCursor.getModifiedEndIndex() + idxShift;
            int maxEnd = this.constraints.maxEndIndexForSegment(firstPartiallyModifiedSegment);
            int minEnd = this.constraints.minEndIndexForSegment(firstPartiallyModifiedSegment);
            if (endModifiedReplacement >= minEnd && endModifiedReplacement <= maxEnd) {
                this.constraints.addSegmentEndIndexConstraint(firstPartiallyModifiedSegment, ConstraintType.Equal, endModifiedReplacement);
            }
            return;
        }
        if (lastPartiallyModifiedSegment != null) {
            int beginModifiedReplacement = diffCursor.getModifiedBeginIndex() + idxShift;
            int maxBegin = this.constraints.maxBeginIndexForSegment(lastPartiallyModifiedSegment);
            int minBegin = this.constraints.minBeginIndexForSegment(lastPartiallyModifiedSegment);
            if (beginModifiedReplacement >= minBegin && beginModifiedReplacement <= maxBegin) {
                this.constraints.addSegmentBeginIndexConstraint(lastPartiallyModifiedSegment, ConstraintType.Equal, beginModifiedReplacement);
            }
        }
    }

    private void addConstrainstForMinimumLevel_(Segment startOfInterval, Segment endOfInterval) {
        boolean smallerSegmentFound;
        Segment smallestSegment = startOfInterval;
        Segment currentSegment = startOfInterval;
        do {
            currentSegment = currentSegment.nextAtom();
            smallestSegment = Matcher.getBestCandidateForInsertion(smallestSegment, currentSegment);
        } while (currentSegment != endOfInterval);
        currentSegment = startOfInterval.nextAtom();
        boolean bl = smallerSegmentFound = smallestSegment == startOfInterval;
        while (true) {
            if (!smallerSegmentFound) {
                int minBegin = this.constraints.minBeginIndexForSegment(currentSegment);
                this.constraints.addSegmentBeginIndexConstraint(currentSegment, ConstraintType.Equal, minBegin);
            } else {
                int maxBegin = this.constraints.maxBeginIndexForSegment(currentSegment);
                this.constraints.addSegmentBeginIndexConstraint(currentSegment, ConstraintType.Equal, maxBegin);
            }
            if (currentSegment == smallestSegment) {
                smallerSegmentFound = true;
            }
            if (currentSegment == endOfInterval) break;
            currentSegment = currentSegment.nextAtom();
        }
    }

    public String _getParentTagNameForIndex(int index) {
        if (this.constraints == null) {
            return null;
        }
        if (index < this.constraints.startIndex || index > this.constraints.stopIndex) {
            int startAtomRank = this.constraints.startAtomRank;
            int i = startAtomRank - 1;
            while (i > 0) {
                Segment seg = this.getChangeSet().atomAt(i);
                if (seg.beginIndex() < index) {
                    if (seg.endIndex() <= index) break;
                    return seg.parent().enclosingTagName();
                }
                --i;
            }
            return null;
        }
        Segment minAtom = this.constraints.minAtom();
        Segment maxAtom = this.constraints.maxAtom();
        Segment atom = minAtom;
        int nbCandidate = 0;
        Segment candidate = null;
        while (this.constraints.minBeginIndexForSegment(atom) <= index) {
            if (this.constraints.maxEndIndexForSegment(atom) > index) {
                if (this.constraints.isResolved(atom)) {
                    return atom.parent().enclosingTagName();
                }
                ++nbCandidate;
                candidate = atom;
            }
            if (atom == maxAtom) break;
            atom = atom.nextAtom();
        }
        if (nbCandidate == 1) {
            return candidate.parent().enclosingTagName();
        }
        return null;
    }

    public class TagExt {
        private IGeneratedTag _tag;
        private boolean _isTagStart;

        public TagExt(IGeneratedTag tag, boolean isStart) {
            this._tag = tag;
            this._isTagStart = isStart;
        }

        public IGeneratedTag getTag() {
            return this._tag;
        }

        public boolean isTagStart() {
            return this._isTagStart;
        }
    }
}

