/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.match;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.IMatchingExtension;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import com.ibm.pdp.engine.turbo.match.MatcherUtil;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.containers.ArraySortedSet;
import com.ibm.pdp.util.diff.DefaultArrayDifferencer;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.ints.IntSequence;
import com.ibm.pdp.util.iterators.TwoWayIterator;
import java.util.Collection;
import java.util.Comparator;

public abstract class AbstractMatcher
implements IMatcher {
    protected IMatchingExtension extension;
    protected UserChangeSet changeSet;
    protected boolean busy;
    protected ITextAnalyzer textAnalyzer;
    private TagExtremityComparator tagExtremityComparator;
    private TagExtremityIndexComparator tagExtremityIndexComparator;
    private static ITracerDelegate tracer = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ITracerDelegate getTracer() {
        return tracer;
    }

    public AbstractMatcher() {
        if (tracer == null) {
            tracer = new Tracer();
        }
    }

    @Override
    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(UserChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    @Override
    public IMatchingExtension getMatchingExtension() {
        return this.extension;
    }

    @Override
    public void setMatchingExtension(IMatchingExtension matchingExtension) {
        this.extension = matchingExtension;
    }

    @Override
    public boolean match() {
        if (this.busy) {
            return false;
        }
        try {
            this.busy = true;
            boolean bl = this.match_();
            return bl;
        }
        finally {
            this.busy = false;
            this.writeTrace(null, 0L);
        }
    }

    protected abstract boolean match_();

    @Override
    public boolean match(Segment segment) {
        if (this.busy) {
            return false;
        }
        long matchingTime = 0L;
        try {
            this.busy = true;
            matchingTime = System.currentTimeMillis();
            boolean bl = this.match_(segment);
            return bl;
        }
        finally {
            this.busy = false;
            this.writeTrace(segment, matchingTime);
        }
    }

    protected abstract boolean match_(Segment var1);

    @Override
    public boolean match(Segment minSegment, Segment maxSegment) {
        return false;
    }

    @Override
    public boolean match(int beginIndex, int endIndex) {
        return false;
    }

    protected abstract void matchZone(Segment var1, Segment var2);

    protected void matchDirtyPortion(Segment minSegment, Segment maxSegment) {
        if (this.extension == null) {
            this.matchZone(minSegment, maxSegment);
            return;
        }
        if (this.textAnalyzer == null) {
            this.textAnalyzer = this.extension.newTextAnalyzer();
        }
        if (this.textAnalyzer != null) {
            this.textAnalyzer.setEditTree(this.changeSet.getTextProcessor().getEditTree());
            this.textAnalyzer.setText(this.changeSet.getText());
        }
        if (this.textAnalyzer == null) {
            this.matchZone(minSegment, maxSegment);
            return;
        }
        ITextScanner scanner = this.textAnalyzer.newScanner(minSegment.beginIndex(), maxSegment.endIndex());
        boolean b = false;
        if (scanner == null || !(b = scanner.scan())) {
            this.matchZone(minSegment, maxSegment);
            return;
        }
        ArraySortedSet<TagExtremity> validTagExtremities = new ArraySortedSet<TagExtremity>((Comparator)this.getTagExtremityComparator());
        boolean isValid = true;
        while (b) {
            isValid = this.checkTagExtremities(minSegment, maxSegment, validTagExtremities, scanner);
            if (!isValid) break;
            b = scanner.scan();
        }
        if (!isValid) {
            validTagExtremities = this.selectBestResults(minSegment, maxSegment, validTagExtremities, scanner);
        }
        Segment atomicSegmentFromPreviousValidTagExtremity = minSegment;
        Segment atomicSegment = null;
        if (validTagExtremities.size() != 0) {
            for (TagExtremity tagExtremity : validTagExtremities) {
                Segment segment = this.changeSet.segmentFromTagName(tagExtremity.getTagName(), 0);
                if (tagExtremity.isTagStart()) {
                    atomicSegment = segment.isAtomic() ? segment : segment.firstAtom();
                } else {
                    atomicSegment = segment.isAtomic() ? segment : segment.lastAtom();
                    atomicSegment = atomicSegment.nextAtom();
                }
                atomicSegment.setBeginIndex(tagExtremity.getIndex());
                if (atomicSegmentFromPreviousValidTagExtremity != atomicSegment) {
                    this.matchZone(atomicSegmentFromPreviousValidTagExtremity, atomicSegment.previousAtom());
                }
                atomicSegmentFromPreviousValidTagExtremity = atomicSegment;
            }
        }
        Segment firstSegmentOfZone = atomicSegment == null ? minSegment : atomicSegment;
        this.matchZone(firstSegmentOfZone, maxSegment);
    }

    private ArraySortedSet<TagExtremity> selectBestResults(Segment minSegment, Segment maxSegment, ArraySortedSet<TagExtremity> validTagExtremities, ITextScanner scanner) {
        ArraySortedSet scannerTagExtremities = new ArraySortedSet((Comparator)this.getTagExtremityIndexComparator());
        scannerTagExtremities.addAll((Collection)validTagExtremities.asList());
        TagExtremity tagExtremity = new TagExtremity(scanner.getTagName(), scanner.index(), scanner.isBeginIndex());
        validTagExtremities.add((Object)tagExtremity);
        scannerTagExtremities.add((Object)tagExtremity);
        boolean b = scanner.scan();
        while (b) {
            boolean tagExist = this.checkTagExistence(minSegment, maxSegment, scanner);
            if (tagExist) {
                tagExtremity = new TagExtremity(scanner.getTagName(), scanner.index(), scanner.isBeginIndex());
                validTagExtremities.add((Object)tagExtremity);
                scannerTagExtremities.add((Object)tagExtremity);
            }
            b = scanner.scan();
        }
        Object[] arr = new TagExtremity[]{};
        Object[] referenceTagExtremities = (TagExtremity[])validTagExtremities.toArray(arr);
        DefaultArrayDifferencer differencer = new DefaultArrayDifferencer(referenceTagExtremities, (Object[])((TagExtremity[])scannerTagExtremities.toArray(arr)));
        DiffCursor diff = differencer.newDiffCursor();
        diff.searchNextDifference();
        ArraySortedSet result = validTagExtremities;
        int lastValidTagExtramityEndDiffEndex = 0;
        if (diff.hasFoundDifference()) {
            result = new ArraySortedSet((Comparator)this.getTagExtremityComparator());
            while (diff.hasFoundDifference()) {
                int validTagExtremityBeginDiffIndex = diff.getReferenceBeginIndex();
                int validTagExtramityEndDiffEndex = diff.getReferenceEndIndex();
                if (validTagExtramityEndDiffEndex != validTagExtremityBeginDiffIndex) {
                    int i = lastValidTagExtramityEndDiffEndex;
                    while (i < validTagExtremityBeginDiffIndex) {
                        result.add(referenceTagExtremities[i]);
                        ++i;
                    }
                    lastValidTagExtramityEndDiffEndex = validTagExtramityEndDiffEndex;
                }
                diff.searchNextDifference();
            }
            int i = lastValidTagExtramityEndDiffEndex;
            while (i < validTagExtremities.size()) {
                result.add(referenceTagExtremities[i]);
                ++i;
            }
        }
        return result;
    }

    protected void computeChangeNature(Segment atom) {
        if (Strings.sameCharSequences((CharSequence)atom.getText(), (CharSequence)atom.generatedText())) {
            atom.setChangeNature(ChangeNature.Unchanged);
            return;
        }
        ISubTextPartition modified = this.changeSet.textPartition().subTextPartition(atom.beginIndex(), atom.endIndex());
        ISubTextPartition reference = this.changeSet.generatedTextPartition().subTextPartition(atom.generatedBeginIndex(), atom.generatedEndIndex());
        atom.setChangeNature(Ints.sameIntSequences((IntSequence)modified.getWords(), (IntSequence)reference.getWords()) ? ChangeNature.Reformated : ChangeNature.Modified);
    }

    protected final boolean isUniqueAtomicSegmentDirtyPortion(Segment minSegment, Segment maxSegment) {
        if (minSegment == maxSegment && minSegment.isAtomic()) {
            this.computeChangeNature(minSegment);
            return true;
        }
        return false;
    }

    private boolean checkTagExtremities(Segment minSegment, Segment maxSegment, ArraySortedSet<TagExtremity> validTagExtremities, ITextScanner scanner) {
        int nextTagIndex;
        boolean oldCode = false;
        boolean tagExist = this.checkTagExistence(minSegment, maxSegment, scanner);
        if (!tagExist) {
            return true;
        }
        String tagName = scanner.getTagName();
        TagExtremity tagExtremity = new TagExtremity(tagName, scanner.index(), scanner.isBeginIndex());
        if (!validTagExtremities.add((Object)tagExtremity)) {
            this.traceBadScannerMessage("Matcher : Bad scanner result : Tag already added : " + tagName);
            return oldCode;
        }
        TwoWayIterator iter = validTagExtremities.iteratorFrom((Object)tagExtremity, true);
        if (iter.hasPrevious()) {
            int previousTagIndex = ((TagExtremity)iter.previous()).getIndex();
            if (previousTagIndex > tagExtremity.getIndex()) {
                validTagExtremities.remove((Object)tagExtremity);
                this.traceBadScannerMessage("Matcher : Bad scanner result : result not compatible with previous result " + tagName);
                return oldCode;
            }
            iter.next();
        }
        if (iter.hasNext()) {
            iter.next();
        }
        if (iter.hasNext() && (nextTagIndex = ((TagExtremity)iter.next()).getIndex()) < tagExtremity.getIndex()) {
            this.traceBadScannerMessage("Matcher : Bad scanner result : result not compatible with previous result : " + tagName);
            validTagExtremities.remove((Object)tagExtremity);
            return oldCode;
        }
        return true;
    }

    private boolean checkTagExistence(Segment minSegment, Segment maxSegment, ITextScanner scanner) {
        if (!scanner.foundTag()) {
            return false;
        }
        String tagName = scanner.getTagName();
        int tagIndex = scanner.index();
        if (tagIndex < minSegment.beginIndex() || tagIndex > maxSegment.endIndex()) {
            this.traceBadScannerMessage("Matcher : Bad scanner result : Outside the dirty zone : " + tagName);
            return false;
        }
        Segment seg = this.changeSet.segmentFromTagName(tagName, 0);
        if (seg == null) {
            this.traceBadScannerMessage("Matcher : Bad scanner result : Tag does not exist : " + tagName);
            return false;
        }
        return AbstractMatcher.isAtomBeginIndexDirty(scanner.isBeginIndex() ? seg.minRank() : seg.maxRank() + 1, minSegment, maxSegment);
    }

    public TagExtremityComparator getTagExtremityComparator() {
        if (this.tagExtremityComparator == null) {
            this.tagExtremityComparator = new TagExtremityComparator();
        }
        return this.tagExtremityComparator;
    }

    public TagExtremityIndexComparator getTagExtremityIndexComparator() {
        if (this.tagExtremityIndexComparator == null) {
            this.tagExtremityIndexComparator = new TagExtremityIndexComparator();
        }
        return this.tagExtremityIndexComparator;
    }

    protected static boolean isAtomBeginIndexDirty(int atomRank, Segment minSegment, Segment maxSegment) {
        return atomRank > minSegment.minRank() && atomRank <= maxSegment.maxRank();
    }

    public static Segment getBestCandidateForInsertion(Segment seg1, Segment seg2) {
        int length2;
        int level2;
        int level1 = seg1.generatedLevel();
        if (level1 < (level2 = seg2.generatedLevel())) {
            return seg1;
        }
        if (level2 < level1) {
            return seg2;
        }
        if (seg1.isPart() && !seg2.isPart()) {
            return seg1;
        }
        if (!seg1.isPart() && seg2.isPart()) {
            return seg2;
        }
        int length1 = seg1.generatedLength();
        if (length1 > (length2 = seg2.generatedLength())) {
            return seg2;
        }
        return seg1;
    }

    private void writeTrace(Segment segment, long matchingTime) {
        if (AbstractMatcher.getTracer().isDebugModeEnabled()) {
            if (matchingTime != 0L) {
                matchingTime = System.currentTimeMillis() - matchingTime;
                tracer.debug((Object)this, "Matcher", "Time in matcher : " + matchingTime);
            }
            tracer.debug((Object)this, "Matcher", "Generated Info");
            tracer.debug((Object)this, "Matcher", "\n" + MatcherUtil.dumpGeneratedInfo(this.changeSet.getGeneratedInfo(), "geninfo.xml"));
            tracer.debug((Object)this, "Matcher", "Text");
            tracer.debug((Object)this, "Matcher", "\n" + MatcherUtil.dumpToTmpFile(this.changeSet.getText().toString(), "txt"));
            CharSequence xmlContents = MatcherUtil.dumpGeneratedInfoTree(this.changeSet.getGeneratedInfo());
            tracer.debug((Object)this, "Generated Info Tree", "\n" + MatcherUtil.dumpToTmpFile(xmlContents.toString(), "geninfo.tree.xml"));
            tracer.debug((Object)this, "Matcher", "Atomic segments after matching");
            String atoms = MatcherUtil.dumpAtoms(this.changeSet, segment);
            tracer.debug((Object)this, "Matcher", "\n" + MatcherUtil.dumpToTmpFile(atoms, "atoms.txt"));
        }
    }

    private void traceBadScannerMessage(String message) {
        if (AbstractMatcher.getTracer().isDebugModeEnabled()) {
            tracer.debug((Object)this, "checkTagExtremities", message);
        }
    }

    public class TagExtremity {
        private int _index;
        private String _tagName;
        private boolean _isTagStart;

        public TagExtremity(String tagName, int index, boolean isStart) {
            this._tagName = tagName;
            this._index = index;
            this._isTagStart = isStart;
        }

        public int getIndex() {
            return this._index;
        }

        public String getTagName() {
            return this._tagName;
        }

        public boolean isTagStart() {
            return this._isTagStart;
        }
    }

    public class TagExtremityComparator
    implements Comparator<TagExtremity> {
        @Override
        public int compare(TagExtremity leftTagExtremity, TagExtremity rightTagExtremity) {
            int rightRank;
            IGeneratedTag rightTag;
            if (leftTagExtremity == rightTagExtremity) {
                return 0;
            }
            Segment leftSegment = AbstractMatcher.this.changeSet.segmentFromTagName(leftTagExtremity.getTagName(), 0);
            Segment rightSegment = AbstractMatcher.this.changeSet.segmentFromTagName(rightTagExtremity.getTagName(), 0);
            if (leftSegment == null || rightSegment == null) {
                return 0;
            }
            IGeneratedTag leftTag = leftSegment.enclosingTag();
            if (leftTag == (rightTag = rightSegment.enclosingTag())) {
                if (leftTagExtremity.isTagStart() == rightTagExtremity.isTagStart()) {
                    return 0;
                }
                return leftTagExtremity.isTagStart() ? -1 : 1;
            }
            int leftRank = leftTagExtremity.isTagStart() ? leftSegment.minRank() : leftSegment.maxRank();
            int cmp = leftRank - (rightRank = rightTagExtremity.isTagStart() ? rightSegment.minRank() : rightSegment.maxRank());
            if (cmp != 0) {
                return cmp;
            }
            if (leftTagExtremity.isTagStart() != rightTagExtremity.isTagStart()) {
                throw new RuntimeException("TagExtremityComparator:compare()");
            }
            int leftLevel = leftSegment.generatedLevel();
            int rightLevel = rightSegment.generatedLevel();
            if (leftTagExtremity.isTagStart()) {
                return leftLevel - rightLevel;
            }
            return rightLevel - leftLevel;
        }
    }

    public class TagExtremityIndexComparator
    extends TagExtremityComparator {
        @Override
        public int compare(TagExtremity leftTagExtremity, TagExtremity rightTagExtremity) {
            if (leftTagExtremity == rightTagExtremity) {
                return 0;
            }
            int result = leftTagExtremity.getIndex() - rightTagExtremity.getIndex();
            if (result != 0) {
                return result;
            }
            return super.compare(leftTagExtremity, rightTagExtremity);
        }
    }

    public static class Tracer
    implements ITracerDelegate {
        public boolean isDebugModeEnabled() {
            int traceLevel = PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.framework");
            return traceLevel > 0;
        }

        public void info(Object sourceObject, String methodName, String message) {
            PTTraceManager.getInstance().trace(sourceObject == null ? AbstractMatcher.class : sourceObject.getClass(), "com.ibm.pdp.framework", 1, String.valueOf(methodName) + "() " + message);
        }

        public void debug(Object sourceObject, String methodName, String message) {
            PTTraceManager.getInstance().trace(sourceObject == null ? AbstractMatcher.class : sourceObject.getClass(), "com.ibm.pdp.framework", 3, String.valueOf(methodName) + "() " + message);
        }
    }
}

