/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.impl.TextSegment;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TextSegmentIterator
implements Iterator<ITextSegment> {
    protected UserChangeSet changes;
    protected IMatcher matcher;
    protected Iterator<Segment> segments;
    protected Segment nextModifiedSegment;
    protected int idx;
    protected int max;
    protected CharSequence actualText;
    protected CharSequence generatedText;
    protected TextSegment nextOne;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected TextSegmentIterator() {
    }

    protected TextSegmentIterator(TextProcessor processor) {
        this.changes = processor.getChangeSet();
        this.matcher = processor.getMatcher();
        this.segments = this.changes.changedAtomicSegments();
        this.max = this.changes.length();
        this.actualText = this.changes.getText();
        this.generatedText = this.changes.getGeneratedInfo().getText();
    }

    protected TextSegmentIterator(TextProcessor processor, int fromIdx, int toIdx) {
        this.changes = processor.getChangeSet();
        this.matcher = processor.getMatcher();
        SegmentSelectionParameter selection = this.changes.newIntervalSelection(true, fromIdx, toIdx, false);
        selection.setFilter(this.changes.changedSegmentFilter());
        this.segments = this.changes.segments(selection);
        this.idx = fromIdx;
        this.max = toIdx;
        this.actualText = this.changes.getText();
        this.generatedText = this.changes.getGeneratedInfo().getText();
    }

    @Override
    public boolean hasNext() {
        return this.nextOne != null || this.findNextOne();
    }

    @Override
    public ITextSegment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("ITextProcessor.segments");
        }
        TextSegment toReturn = this.nextOne;
        this.nextOne = null;
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TextSegmentIterator.remove");
    }

    protected boolean findNextOne() {
        int beginIdx;
        if (this.nextModifiedSegment == null) {
            if (!this.segments.hasNext()) {
                if (this.idx >= this.max) {
                    return false;
                }
                this.nextOne = new TextSegment(this.actualText, this.idx, this.max, 1, this.actualText, this.idx, this.max);
                this.idx = this.max;
                return true;
            }
            this.nextModifiedSegment = this.segments.next();
        }
        if ((beginIdx = this.nextModifiedSegment.beginIndex()) > this.idx) {
            this.nextOne = new TextSegment(this.actualText, this.idx, beginIdx, 1, this.actualText, this.idx, beginIdx);
            this.idx = beginIdx;
            return true;
        }
        int status = this.makeStatusForSegment(this.nextModifiedSegment);
        int endIdx = this.nextModifiedSegment.endIndex();
        int generatedBeginIdx = this.nextModifiedSegment.generatedBeginIndex();
        int generatedEndIdx = this.nextModifiedSegment.generatedEndIndex();
        this.nextModifiedSegment = null;
        while (this.segments.hasNext()) {
            Segment modifiedSegment = this.segments.next();
            if (modifiedSegment.beginIndex() != endIdx || this.makeStatusForSegment(modifiedSegment) != status) {
                this.nextModifiedSegment = modifiedSegment;
                break;
            }
            endIdx = modifiedSegment.endIndex();
            generatedEndIdx = modifiedSegment.generatedEndIndex();
        }
        this.nextOne = new TextSegment(this.actualText, beginIdx, endIdx, status, this.generatedText, generatedBeginIdx, generatedEndIdx);
        this.idx = endIdx;
        return true;
    }

    protected int makeStatusForSegment(Segment s) {
        ChangeNature nature = s.getChangeNature();
        if (nature == ChangeNature.Dirty) {
            this.matcher.match(s);
            nature = s.getChangeNature();
        }
        switch (nature) {
            case Unchanged: {
                return 1;
            }
            case Reformated: {
                return 3;
            }
        }
        return 8;
    }
}

