/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.internal.ITextSegment;

public class TextSegment
implements ITextSegment {
    protected CharSequence actualText;
    protected int actualBeginIdx;
    protected int actualEndIdx;
    protected CharSequence referenceText;
    protected int referenceBeginIdx;
    protected int referenceEndIdx;
    protected int status;
    protected static final int GENERATED = 1;
    protected static final int REFORMATED = 2;
    protected static final int MACRO = 4;
    protected static final int MODIFIED = 8;
    protected static final int INSERTED = 16;
    protected static final int REMOVED = 32;
    protected static final int NOT_EDITABLE = 64;
    protected static final int DETAIL_MP = 3;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected TextSegment(CharSequence actualFullText, int actualBeginIndex, int actualEndIndex, int changeStatus, CharSequence referenceFullText, int referenceBeginIndex, int referenceEndIndex) {
        this.actualText = actualFullText;
        this.actualBeginIdx = actualBeginIndex;
        this.actualEndIdx = actualEndIndex;
        this.referenceText = referenceFullText;
        this.referenceBeginIdx = referenceBeginIndex;
        this.referenceEndIdx = referenceEndIndex;
        this.status = changeStatus;
    }

    public char charAt(int index) {
        return this.actualText.charAt(this.actualBeginIdx + index);
    }

    public int length() {
        return this.actualEndIdx - this.actualBeginIdx;
    }

    public CharSequence subSequence(int start, int end) {
        return this.actualText.subSequence(this.actualBeginIdx + start, this.actualBeginIdx + end);
    }

    public String toString() {
        return this.actualText.subSequence(this.actualBeginIdx, this.actualEndIdx).toString();
    }

    public int beginIndex() {
        return this.actualBeginIdx;
    }

    public int endIndex() {
        return this.actualEndIdx;
    }

    public CharSequence fullText() {
        return this.actualText;
    }

    public boolean isGenerated() {
        return (this.status & 1) != 0;
    }

    public boolean isReformated() {
        return (this.status & 2) != 0;
    }

    public boolean isModified() {
        return (this.status & 8) != 0;
    }

    public boolean isInserted() {
        return (this.status & 0x10) != 0;
    }

    public boolean isRemoved() {
        return (this.status & 0x20) != 0;
    }

    public boolean isEditable() {
        return (this.status & 0x40) == 0;
    }

    public boolean isFromMacro() {
        return (this.status & 4) != 0;
    }

    public CharSequence generatedText() {
        return this.referenceText != null ? this.referenceText.subSequence(this.referenceBeginIdx, this.referenceEndIdx) : null;
    }
}

