/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternGenerationExtension;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.ITextChangeEvent;
import com.ibm.pdp.engine.ITextChangeListener;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.extension.DefaultTextPartitioner;
import com.ibm.pdp.engine.extension.IEditTreeExtension;
import com.ibm.pdp.engine.extension.IExtensionManager;
import com.ibm.pdp.engine.extension.IMatchingExtension;
import com.ibm.pdp.engine.extension.IMicroPatternHandlerManager;
import com.ibm.pdp.engine.extension.IProcessingStatus;
import com.ibm.pdp.engine.extension.IReformatExtension;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.internal.IGenericProblem;
import com.ibm.pdp.engine.internal.IOrganizeExtension;
import com.ibm.pdp.engine.internal.IReconcileExtension;
import com.ibm.pdp.engine.internal.ITextProcessorExtension;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.core.UserSyntacticInfo;
import com.ibm.pdp.engine.turbo.impl.DetailedTextSegmentIterator;
import com.ibm.pdp.engine.turbo.impl.DetailedTextSegmentWithPropertiesIterator;
import com.ibm.pdp.engine.turbo.impl.GenInfoUtil;
import com.ibm.pdp.engine.turbo.impl.MicroPatternEngine;
import com.ibm.pdp.engine.turbo.impl.MicroPatternGenerationProblem;
import com.ibm.pdp.engine.turbo.impl.MicroPatternProcessingContext;
import com.ibm.pdp.engine.turbo.impl.SpecificTagAndTextRemover;
import com.ibm.pdp.engine.turbo.impl.SpecificTagRemover;
import com.ibm.pdp.engine.turbo.impl.SyntacticTagMerger;
import com.ibm.pdp.engine.turbo.impl.TextChangeEvent;
import com.ibm.pdp.engine.turbo.impl.TextChangeEventRedirector;
import com.ibm.pdp.engine.turbo.impl.TextSegment;
import com.ibm.pdp.engine.turbo.match.DiffMatcher;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import com.ibm.pdp.engine.turbo.reconcile.IReconciler;
import com.ibm.pdp.engine.turbo.reconcile.IReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.ReconcileUtil;
import com.ibm.pdp.engine.turbo.reconcile.ReconcilerState;
import com.ibm.pdp.engine.turbo.reconcile.SegmentReconciler;
import com.ibm.pdp.engine.turbo.tree.EditTree;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.iterators.CatenateIterator;
import com.ibm.pdp.util.iterators.FilterIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TextProcessor
implements ITextProcessor,
com.ibm.pdp.engine.internal.ITextProcessor {
    public static final String VERSION = "0";
    private static final String TRACE_DIR = PdpConstants.IS_UNIX_OS ? "/tmp/" : "c:/temp/";
    protected EngineFactory factory;
    protected UserChangeSet changeSet;
    protected IReconcilerState reconcileState;
    protected com.ibm.pdp.engine.extension.ITextProcessorExtension extension;
    protected TextChangeEventRedirector eventRedirector;
    protected EditTree editTree;
    protected IMatcher matcher;
    protected com.ibm.pdp.engine.extension.IReconcileExtension reconcileExtension;
    protected MicroPatternProcessingContext microPatternContext;
    protected ArrayList<IProblem> mpGenerationProblems;
    protected List<IGenericProblem> genericProblems;
    protected Map<String, Object> globalContext;
    private boolean debugEnabled = "true".equals(System.getProperty("textProcessorDebug"));
    protected IGeneratedInfo oldGenInfoBeforeMicroPatternExpansion;
    protected IGeneratedInfo oldGenInfoAfterMicroPatternExpansionWithSpecificText;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextProcessor(EngineFactory engineFactory) {
        this.factory = engineFactory;
        this.changeSet = this.newUserChangeSet();
    }

    public void initialize(IGeneratedInfo info) {
        this.initializeTextProcessorExtension(info);
        this.changeSet.setGeneratedInfo(info);
    }

    public IEngineFactory getFactory() {
        return this.factory;
    }

    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    protected UserChangeSet newUserChangeSet() {
        return new UserChangeSet(this);
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.changeSet.getGeneratedInfo();
    }

    public void setGeneratedInfo(IGeneratedInfo newGeneratedInfo) {
        this.initializeTextProcessorExtension(newGeneratedInfo);
        switch (this.getMicroPatternExpansionMode(newGeneratedInfo)) {
            default: {
                this.setGeneratedInfoNew5(newGeneratedInfo);
                break;
            }
            case 1: {
                this.setGeneratedInfoOld(newGeneratedInfo);
                break;
            }
            case 2: {
                this.setGeneratedInfoNew1(newGeneratedInfo);
                break;
            }
            case 3: {
                this.setGeneratedInfoNew2(newGeneratedInfo);
                break;
            }
            case 4: {
                this.setGeneratedInfoNew4(newGeneratedInfo);
                break;
            }
            case 5: {
                this.setGeneratedInfoNew5(newGeneratedInfo);
                break;
            }
            case 6: {
                this.setGeneratedInfoNew6(newGeneratedInfo);
            }
        }
    }

    protected int getMicroPatternExpansionMode(IGeneratedInfo genInfo) {
        if (genInfo == null) {
            return 0;
        }
        String text = genInfo.getText().toString();
        int authorIdx = text.indexOf("*AUTHOR");
        if (authorIdx == -1) {
            return 0;
        }
        int i = authorIdx + 7;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                return 0;
            }
            if (c == '{') {
                if (i + 1 >= text.length()) {
                    return 0;
                }
                char nextChar = text.charAt(i + 1);
                if (nextChar >= '0' && nextChar <= '9') {
                    return nextChar - 48;
                }
                return 0;
            }
            ++i;
        }
        return 0;
    }

    protected void setGeneratedInfoOld(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTagsAndExpandMicroPatterns(newGeneratedInfo);
        this.initializeTextProcessorExtension(newGeneratedInfo);
        if (this.changeSet.getGeneratedInfo() == null) {
            this.changeSet.setGeneratedInfo(newGeneratedInfo);
            this.generateMicroPattern();
        } else if (this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            this.changeSet.setGeneratedInfo(newGeneratedInfo);
        } else {
            this.reconcile(newGeneratedInfo);
            this.generateMicroPattern();
        }
    }

    protected void setGeneratedInfoNew1(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.oldGenInfoBeforeMicroPatternExpansion = null;
            this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = null;
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
        IGeneratedInfo generatedInfo = this.changeSet.getGeneratedInfo();
        if (generatedInfo == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
            this.oldGenInfoBeforeMicroPatternExpansion = newGeneratedInfo;
            this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = generatedInfoAfterMicroPatternExpansion;
            this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
            this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
            return;
        }
        CharSequence oldText = this.changeSet.getText();
        UserChangeSet changeSetWithoutMicroPatternGeneratedCode = this.disconnectedReconcile(this.changeSet, this.oldGenInfoBeforeMicroPatternExpansion);
        UserChangeSet changeSetBeforeMicroPatternExpansion = this.disconnectedReconcile(changeSetWithoutMicroPatternGeneratedCode, newGeneratedInfo);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificText = this.exportAsGeneratedInfo(changeSetBeforeMicroPatternExpansion, false);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificText);
        IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificCode(newGenInfoAfterMicroPatternExpansionWithSpecificText);
        this.initializeTextProcessorExtension(newFullGeneneratedInfo);
        this.changeSet.setGeneratedInfoKeepActualText(this.oldGenInfoAfterMicroPatternExpansionWithSpecificText);
        this.silentReconcile(newGenInfoAfterMicroPatternExpansionWithSpecificText, 1);
        this.changeSet.setGeneratedInfoKeepActualText(newFullGeneneratedInfo);
        this.oldGenInfoBeforeMicroPatternExpansion = newGeneratedInfo;
        this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = newGenInfoAfterMicroPatternExpansionWithSpecificText;
        if (this.hasListener()) {
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        }
    }

    protected void setGeneratedInfoNew2(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.oldGenInfoBeforeMicroPatternExpansion = null;
            this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = null;
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
        IGeneratedInfo generatedInfo = this.changeSet.getGeneratedInfo();
        if (generatedInfo == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
            this.oldGenInfoBeforeMicroPatternExpansion = newGeneratedInfo;
            this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = generatedInfoAfterMicroPatternExpansion;
            this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
            this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
            return;
        }
        CharSequence oldText = this.changeSet.getText();
        UserChangeSet changeSetWithoutMicroPatternGeneratedCode = this.disconnectedReconcile(this.changeSet, this.oldGenInfoBeforeMicroPatternExpansion);
        UserChangeSet changeSetBeforeMicroPatternExpansion = this.disconnectedReconcile(changeSetWithoutMicroPatternGeneratedCode, newGeneratedInfo);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText = this.exportAsGeneratedInfo(changeSetBeforeMicroPatternExpansion, true);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificText = this.removeSpecificTags(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificTagsAndText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        this.initializeTextProcessorExtension(newFullGeneneratedInfo);
        this.changeSet.setGeneratedInfo(this.oldGenInfoAfterMicroPatternExpansionWithSpecificText);
        this.silentReconcile(newGenInfoAfterMicroPatternExpansionWithSpecificText, 1);
        this.changeSet.setGeneratedInfoKeepActualText(newFullGeneneratedInfo);
        this.oldGenInfoBeforeMicroPatternExpansion = newGeneratedInfo;
        this.oldGenInfoAfterMicroPatternExpansionWithSpecificText = newGenInfoAfterMicroPatternExpansionWithSpecificText;
        if (this.hasListener()) {
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        }
    }

    protected void setGeneratedInfoNew3(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
        IGeneratedInfo generatedInfo = this.changeSet.getGeneratedInfo();
        if (generatedInfo == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
            this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
            this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
            return;
        }
        CharSequence oldText = this.changeSet.getText();
        this.silentReconcile(newGeneratedInfo, 1);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText = this.exportAsGeneratedInfo(this.changeSet, true);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificTagsAndText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        this.initializeTextProcessorExtension(newFullGeneneratedInfo);
        this.silentReconcile(newFullGeneneratedInfo, 2);
        if (this.hasListener()) {
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        }
    }

    protected void setGeneratedInfoNew4(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
        IGeneratedInfo generatedInfo = this.changeSet.getGeneratedInfo();
        if (generatedInfo == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
            this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
            this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
            return;
        }
        CharSequence oldText = this.changeSet.getText();
        this.silentReconcile(newGeneratedInfo, 1);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificText = this.exportAsGeneratedInfo(this.changeSet, false);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText = this.exportAsGeneratedInfo(this.changeSet, true);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificText = this.removeSpecificTags(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificTagsAndText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        this.initializeTextProcessorExtension(newFullGeneneratedInfo);
        this.changeSet.setGeneratedInfo(newGenInfoBeforeMicroPatternExpansionWithSpecificText);
        this.silentReconcile(newGenInfoAfterMicroPatternExpansionWithSpecificText, 2);
        this.changeSet.setGeneratedInfoKeepActualText(newFullGeneneratedInfo);
        if (this.hasListener()) {
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        }
    }

    protected void setGeneratedInfoNew5(IGeneratedInfo newGeneratedInfo) {
        File temp;
        if (this.debugEnabled && !(temp = new File(TRACE_DIR)).exists() && !temp.mkdir()) {
            this.debugEnabled = false;
        }
        IGeneratedInfo oldGeneratedInfo = this.changeSet.getGeneratedInfo();
        CharSequence oldText = this.changeSet.getText();
        try {
            IGeneratedInfo newFullGeneneratedInfo2;
            IGeneratedInfo generatedInfo;
            if (newGeneratedInfo == null) {
                this.changeSet.setGeneratedInfo(null);
                return;
            }
            newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
            if (this.debugEnabled) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "00_newgeninfo.xml"), (String)newGeneratedInfo.toString());
            }
            if ((generatedInfo = oldGeneratedInfo) == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
                IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
                if (this.debugEnabled) {
                    Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "00_newgeninfo_after_mp.xml"), (String)generatedInfoAfterMicroPatternExpansion.toString());
                }
                this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
                this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
                return;
            }
            this.changeSet.setSilent(true);
            IGeneratedInfo[] result = this.takeIntoAccountSpecific(newGeneratedInfo, true);
            if (result[0] != null) {
                generatedInfo = result[0];
            }
            newGeneratedInfo = result[1];
            if (this.debugEnabled) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "10_initial.xml"), (String)this.exportAsGeneratedInfo(this.changeSet, true).toString());
            }
            GenInfoUtil.CompareGeneratedInfos(generatedInfo, newGeneratedInfo, this);
            this.silentReconcile(newGeneratedInfo, 1);
            IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText = this.exportAsGeneratedInfo(this.changeSet, true);
            if (this.debugEnabled) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "20_before_mp.xml"), (String)newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText.toString());
            }
            IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText);
            if (this.debugEnabled) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "21_after_mp.xml"), (String)newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText.toString());
            }
            IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificTagsAndText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
            this.initializeTextProcessorExtension(newFullGeneneratedInfo);
            this.changeSet.setGeneratedInfo(newFullGeneneratedInfo);
            this.changeSet.setText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText.getText(), false);
            this.silentReconcile(newFullGeneneratedInfo, 2);
            this.changeSet.setSilent(false);
            IOrganizeExtension orgExt = this.getOrganizeExtension();
            if (orgExt != null && orgExt.isVirtualMacroUsed(newFullGeneneratedInfo) && (newFullGeneneratedInfo2 = orgExt.cleanVirtualMacroTags(newFullGeneneratedInfo)) != newFullGeneneratedInfo) {
                this.changeSet.setGeneratedInfo(newFullGeneneratedInfo2);
            }
            if (this.debugEnabled) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "30_final.xml"), (String)this.exportAsGeneratedInfo(this.changeSet, true).toString());
            }
            if (this.hasListener()) {
                CharSequence newText = this.changeSet.getText();
                this.fireTextChange(oldText, newText, 0);
            }
        }
        catch (Throwable t) {
            this.changeSet.setGeneratedInfo(oldGeneratedInfo);
            this.changeSet.setText(oldText);
            throw Util.rethrow((Throwable)t);
        }
    }

    public IOrganizeExtension getOrganizeExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension procExt;
        if (this.getTextProcessorExtension() != null && (procExt = this.getTextProcessorExtension()) instanceof ITextProcessorExtension) {
            return ((ITextProcessorExtension)procExt).getOrganizeExtension();
        }
        return null;
    }

    public IGeneratedInfo[] takeIntoAccountSpecific(IGeneratedInfo newGeneratedInfo, boolean dependingOnVirtualMacroEnabled) {
        IOrganizeExtension orgExt = this.getOrganizeExtension();
        IGeneratedInfo[] result = new IGeneratedInfo[2];
        result[1] = newGeneratedInfo;
        if (orgExt != null) {
            IGeneratedInfo generatedInfo = null;
            this.matchIfNecessary();
            TextProcessor newTextProcessor = null;
            newTextProcessor = dependingOnVirtualMacroEnabled && orgExt.isVirtualMacroUsed(newGeneratedInfo) ? orgExt.instanciateNewTextProcessor(this.getGeneratedInfo(), newGeneratedInfo) : this;
            IGeneratedInfo refactoredGenInfo = orgExt.refactor((ITextProcessor)newTextProcessor);
            if (refactoredGenInfo != null) {
                this.changeSet.setGeneratedInfoKeepActualText(refactoredGenInfo);
                generatedInfo = refactoredGenInfo;
                this.matchIfNecessary();
            }
            if (!dependingOnVirtualMacroEnabled || !orgExt.isVirtualMacroUsed(newGeneratedInfo)) {
                IGeneratedInfo correctedGenInfo = orgExt.moveDeletedSubFunctions();
                if (correctedGenInfo != null) {
                    this.changeSet.setGeneratedInfoKeepActualText(correctedGenInfo);
                    generatedInfo = correctedGenInfo;
                    this.matchIfNecessary();
                }
                newGeneratedInfo = orgExt.mergeSyntacticTagsWithGeneratedInfo(newGeneratedInfo);
            }
            result[0] = generatedInfo;
            result[1] = newGeneratedInfo;
        }
        return result;
    }

    protected void setGeneratedInfoNew6(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.changeSet.setGeneratedInfo(null);
            return;
        }
        newGeneratedInfo = this.extractSyntacticTags(newGeneratedInfo);
        IGeneratedInfo generatedInfo = this.changeSet.getGeneratedInfo();
        if (generatedInfo == null || this.changeSet.getChangeNature() == ChangeNature.Unchanged && !this.hasReconcileProblem()) {
            IGeneratedInfo generatedInfoAfterMicroPatternExpansion = this.expandAllMicroPatterns(newGeneratedInfo);
            this.initializeTextProcessorExtension(generatedInfoAfterMicroPatternExpansion);
            this.changeSet.setGeneratedInfo(generatedInfoAfterMicroPatternExpansion);
            return;
        }
        CharSequence oldText = this.changeSet.getText();
        this.silentReconcile(newGeneratedInfo, 1);
        IGeneratedInfo newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText = this.exportAsGeneratedInfo(this.changeSet, true);
        IGeneratedInfo newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText = this.expandAllMicroPatterns(newGenInfoBeforeMicroPatternExpansionWithSpecificTagsAndText);
        IGeneratedInfo newFullGeneneratedInfo = this.removeSpecificTagsAndText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText);
        this.initializeTextProcessorExtension(newFullGeneneratedInfo);
        this.changeSet.setGeneratedInfoKeepActualText(newFullGeneneratedInfo);
        this.changeSet.setText(newGenInfoAfterMicroPatternExpansionWithSpecificTagsAndText.getText(), false);
        if (this.hasListener()) {
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        }
    }

    public List<IGenericProblem> getGenericProblems() {
        if (this.genericProblems == null) {
            this.genericProblems = new ArrayList<IGenericProblem>();
        }
        return this.genericProblems;
    }

    public void setGenericProblems(List<IGenericProblem> elip) {
        this.genericProblems = elip;
    }

    public void setGeneratedInfoKeepActualText(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo != null) {
            this.changeSet.setGeneratedInfoKeepActualText(newGeneratedInfo);
        }
    }

    protected IGeneratedInfo removeSpecificTags(IGeneratedInfo generatedInfo) {
        SpecificTagRemover specificTagRemover = new SpecificTagRemover(this.factory.newGeneratedInfoFactory());
        IGeneratedInfo genInfoWithoutSpecificTags = specificTagRemover.convert(generatedInfo);
        return genInfoWithoutSpecificTags;
    }

    protected IGeneratedInfo removeSpecificTagsAndText(IGeneratedInfo generatedInfo) {
        SpecificTagAndTextRemover specificTagRemover = new SpecificTagAndTextRemover(this.factory.newGeneratedInfoFactory());
        IGeneratedInfo genInfoWithoutSpecificTags = specificTagRemover.convert(generatedInfo);
        return genInfoWithoutSpecificTags;
    }

    protected IGeneratedInfo removeSpecificCode(IGeneratedInfo generatedInfoWithSpecificCode) {
        IGeneratedInfo fullOldGenInfo = this.exportAsGeneratedInfo();
        UserChangeSet ucs = new UserChangeSet(this, fullOldGenInfo);
        ucs.setText(generatedInfoWithSpecificCode.getText());
        UserChangeSet ucs1 = this.disconnectedReconcile(ucs, this.changeSet.getGeneratedInfo());
        ucs1.setGeneratedInfo(generatedInfoWithSpecificCode);
        if (ucs1.getChangeNature() == ChangeNature.Dirty) {
            this.newMatcher(ucs1).match();
        }
        IGeneratedInfo pureFullGenInfo = this.exportAsGeneratedInfo(ucs1, false);
        return pureFullGenInfo;
    }

    protected UserChangeSet disconnectedReconcile(UserChangeSet oldChangeSet, IGeneratedInfo newGeneratedInfo) {
        if (oldChangeSet.getChangeNature() == ChangeNature.Dirty) {
            this.newMatcher(oldChangeSet).match();
        }
        IReconciler reconciler = this.newReconciler(1);
        IReconcilerState state = reconciler.newReconcilerState(oldChangeSet);
        UserChangeSet newChangeSet = new UserChangeSet(this);
        newChangeSet.setDictionary(oldChangeSet.getDictionary());
        newChangeSet.setGeneratedInfo(newGeneratedInfo);
        reconciler.reconcile(state, newChangeSet);
        return newChangeSet;
    }

    protected IGeneratedInfo extractSyntacticTags(IGeneratedInfo generatedInfo) {
        SyntacticInfo syntacticInfo = this.newSyntacticInfoFromGeneratedInfo(generatedInfo);
        if (syntacticInfo == null) {
            return generatedInfo;
        }
        IGeneratedInfo completedGenInfo = this.mergeSyntacticTagsWithGeneratedTags(generatedInfo, syntacticInfo);
        return completedGenInfo;
    }

    protected SyntacticInfo newSyntacticInfoFromGeneratedInfo(IGeneratedInfo generatedInfo) {
        ITextAnalyzer analyzer = this.newAnalyzerForGeneratedInfo(generatedInfo);
        if (analyzer == null) {
            return null;
        }
        SyntacticInfo syntacticInfo = new SyntacticInfo(analyzer);
        CharSequence text = generatedInfo.getText();
        syntacticInfo.setText(text);
        syntacticInfo.declareDirtyPortion(0, text.length());
        return syntacticInfo;
    }

    protected IGeneratedInfo expandAllMicroPatterns(IGeneratedInfo originalGeneratedInfo) {
        IMicroPatternHandlerManager extension = this.getMicroPatternGenerationExtension();
        if (extension == null) {
            return originalGeneratedInfo;
        }
        MicroPatternEngine mpEngine = new MicroPatternEngine(extension, this.getTextProcessorExtension().getGenerationPostProcessorExtension());
        this.initializeMicroPatternGenerationProcess();
        this.microPatternContext.setGeneratedInfo(originalGeneratedInfo);
        SyntacticInfo syntacticInfo = this.newSyntacticInfoFromGeneratedInfo(originalGeneratedInfo);
        IGeneratedInfo newGeneratedInfoStruct = mpEngine.expandMicroPatterns(this.microPatternContext, syntacticInfo, this.getMicroPatternGenerationExtension().getMicroPatternGenerationExtensions((IMicroPatternProcessingContext)this.microPatternContext, (ITextProcessor)this), this.getGlobalContext());
        Iterator<IProcessingStatus> i = this.microPatternContext.statusStack();
        if (i.hasNext()) {
            if (this.mpGenerationProblems == null) {
                this.mpGenerationProblems = new ArrayList(10);
            }
            while (i.hasNext()) {
                IProcessingStatus aStatus = i.next();
                MicroPatternGenerationProblem problem = new MicroPatternGenerationProblem(aStatus);
                this.mpGenerationProblems.add(problem);
            }
        }
        return newGeneratedInfoStruct;
    }

    public List<IMicroPattern> getMicroPatterns() {
        IMicroPatternHandlerManager extension = this.getMicroPatternGenerationExtension();
        if (extension == null) {
            return Collections.emptyList();
        }
        if (this.microPatternContext == null) {
            this.microPatternContext = new MicroPatternProcessingContext(null, false);
        }
        IGeneratedInfo generatedInfo = this.exportAsGeneratedInfo(this.changeSet, false, true);
        this.microPatternContext.setGeneratedInfo(generatedInfo);
        MicroPatternEngine mpEngine = new MicroPatternEngine(extension, this.getTextProcessorExtension().getGenerationPostProcessorExtension());
        return mpEngine.collectMicroPatterns(this.microPatternContext, this.newSyntacticInfoFromGeneratedInfo(generatedInfo));
    }

    protected boolean hasReconcileProblem() {
        return this.reconcileState != null && this.reconcileState.problems().hasNext();
    }

    protected void generateMicroPattern() {
        IMicroPatternHandlerManager microPatternExtension = this.getMicroPatternGenerationExtension();
        if (microPatternExtension == null) {
            return;
        }
        ITracerDelegate tracer = microPatternExtension.getTracerDelegate();
        if (tracer == null) {
            tracer = new DefaultTracerDelegate();
        }
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "generateMicroPattern", "Entering method");
        }
        MicroPatternEngine mpEngine = new MicroPatternEngine(microPatternExtension, this.getTextProcessorExtension().getGenerationPostProcessorExtension());
        IGeneratedInfo originalGeneratedInfo = this.exportAsGeneratedInfo("MicroPattern");
        this.initializeMicroPatternGenerationProcess();
        this.microPatternContext.setUserCode(true);
        this.microPatternContext.setGeneratedInfo(originalGeneratedInfo);
        long t1 = System.currentTimeMillis();
        IGeneratedInfo newGeneratedInfoStruct = mpEngine.expandMicroPatterns(this.microPatternContext, this.changeSet.getSyntacticInfo(), null, this.getGlobalContext());
        long t2 = System.currentTimeMillis();
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "generateMicroPattern", "MicroPattern Processing took " + (t2 - t1) + "msec.");
        }
        Iterator it = microPatternExtension.getMicroPatternGenerationExtensions((IMicroPatternProcessingContext)this.microPatternContext, (ITextProcessor)this).iterator();
        while (it.hasNext()) {
            ((IMicroPatternGenerationExtension)it.next()).end((IMicroPatternProcessingContext)this.microPatternContext);
        }
        Iterator<IProcessingStatus> i = this.microPatternContext.statusStack();
        if (i.hasNext()) {
            if (this.mpGenerationProblems == null) {
                this.mpGenerationProblems = new ArrayList(10);
            }
            while (i.hasNext()) {
                IProcessingStatus aStatus = i.next();
                MicroPatternGenerationProblem problem = new MicroPatternGenerationProblem(aStatus);
                this.mpGenerationProblems.add(problem);
            }
        }
        if (this.microPatternContext.getStatus() == 0 || this.microPatternContext.getStatus() == 4 || this.microPatternContext.getStatus() == 5) {
            if (newGeneratedInfoStruct != originalGeneratedInfo) {
                this.setText(newGeneratedInfoStruct.getText());
                long t3 = System.currentTimeMillis();
                if (tracer.isDebugModeEnabled()) {
                    tracer.debug((Object)this, "generateMicroPattern", "Text substitution took " + (t3 - t2) + "msec.");
                }
            } else if (tracer.isDebugModeEnabled()) {
                tracer.debug((Object)this, "generateMicroPattern", "Leaving method without any substitution");
            }
        } else {
            if (tracer.isDebugModeEnabled()) {
                tracer.debug((Object)this, "generateMicroPattern", "Leaving method on unrecoverable Error");
            }
            this.microPatternContext = null;
        }
    }

    protected IGeneratedInfo extractSyntacticTagsAndExpandMicroPatterns(IGeneratedInfo generatedInfo) {
        ITextAnalyzer analyzer = this.newAnalyzerForGeneratedInfo(generatedInfo);
        if (analyzer == null) {
            return generatedInfo;
        }
        SyntacticInfo syntacticInfo = new SyntacticInfo(analyzer);
        CharSequence text = generatedInfo.getText();
        syntacticInfo.setText(text);
        syntacticInfo.declareDirtyPortion(0, text.length());
        IGeneratedInfo completedGenInfo = this.mergeSyntacticTagsWithGeneratedTags(generatedInfo, syntacticInfo);
        IGeneratedInfo fullGenInfo = this.firstMicroPatternExpansion(completedGenInfo, syntacticInfo);
        return fullGenInfo;
    }

    protected IGeneratedInfo mergeSyntacticTagsWithGeneratedTags(IGeneratedInfo genInfo, SyntacticInfo syntacticInfo) {
        SyntacticTagMerger merger = new SyntacticTagMerger(syntacticInfo);
        return merger.convert(genInfo);
    }

    protected IGeneratedInfo firstMicroPatternExpansion(IGeneratedInfo gi, SyntacticInfo syntacticInfo) {
        Iterator<IProcessingStatus> i;
        IMicroPatternHandlerManager mpExtension = this.getMicroPatternGenerationExtension();
        if (mpExtension == null) {
            return gi;
        }
        ITracerDelegate tracer = mpExtension.getTracerDelegate();
        if (tracer == null) {
            tracer = new DefaultTracerDelegate();
        }
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "extractSyntacticTags", "Entering method");
        }
        this.initializeMicroPatternGenerationProcess();
        this.microPatternContext.setGeneratedInfo(gi);
        MicroPatternEngine mpEngine = new MicroPatternEngine(mpExtension, this.getTextProcessorExtension().getGenerationPostProcessorExtension());
        long t1 = System.currentTimeMillis();
        IGeneratedInfo newGeneratedInfoStruct = mpEngine.expandMicroPatterns(this.microPatternContext, syntacticInfo, null, this.getGlobalContext());
        long t2 = System.currentTimeMillis();
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "extractSyntacticTags", "MicroPattern Processing took " + (t2 - t1) + "msec.");
        }
        if (this.microPatternContext.getStatus() == 0 || this.microPatternContext.getStatus() == 4 || this.microPatternContext.getStatus() == 5) {
            if (tracer.isDebugModeEnabled()) {
                tracer.debug((Object)this, "extractSyntacticTags", "Leaving method");
            }
            return newGeneratedInfoStruct;
        }
        if (tracer.isDebugModeEnabled()) {
            tracer.debug((Object)this, "extractSyntacticTags", "Leaving method on unrecoverable Error");
        }
        if ((i = this.microPatternContext.statusStack()).hasNext()) {
            if (this.mpGenerationProblems == null) {
                this.mpGenerationProblems = new ArrayList(10);
            }
            while (i.hasNext()) {
                IProcessingStatus aStatus = i.next();
                MicroPatternGenerationProblem problem = new MicroPatternGenerationProblem(aStatus);
                this.mpGenerationProblems.add(problem);
            }
        }
        this.microPatternContext = null;
        return gi;
    }

    protected void initializeMicroPatternGenerationProcess() {
        if (this.microPatternContext == null) {
            this.microPatternContext = new MicroPatternProcessingContext(null, false);
        } else {
            this.microPatternContext.reset();
            this.microPatternContext.setUserCode(false);
        }
        if (this.mpGenerationProblems != null) {
            this.mpGenerationProblems.clear();
        }
        List extensions = this.getMicroPatternGenerationExtension().getMicroPatternGenerationExtensions((IMicroPatternProcessingContext)this.microPatternContext, (ITextProcessor)this);
        for (IMicroPatternGenerationExtension extention : extensions) {
            extention.start((IMicroPatternProcessingContext)this.microPatternContext);
        }
    }

    protected ITextAnalyzer newAnalyzerForGeneratedInfo(IGeneratedInfo genInfo) {
        if (this.factory == null) {
            return null;
        }
        IExtensionManager extensionMgr = this.factory.getExtensionManager();
        if (extensionMgr == null) {
            return null;
        }
        com.ibm.pdp.engine.extension.ITextProcessorExtension processorExt = extensionMgr.newTextProcessorExtension(genInfo);
        if (processorExt == null) {
            return null;
        }
        IEditTreeExtension editTreeExt = processorExt.getEditTreeExtension();
        if (editTreeExt == null) {
            return null;
        }
        return editTreeExt.newTextAnalyzer();
    }

    protected void silentReconcile(IGeneratedInfo newGeneratedInfo, int step) {
        String xmlContents;
        this.matchIfNecessary();
        UserChangeSet oldChangeSet = this.changeSet;
        IReconciler reconciler = this.newReconciler(step);
        if (reconciler instanceof SegmentReconciler && ((SegmentReconciler)reconciler).getTracer().isDebugModeEnabled()) {
            xmlContents = ReconcileUtil.dumpTopSegmentTree(this.changeSet.topSegment(), true, true, true);
            ((SegmentReconciler)reconciler).getTracer().debug((Object)this, "OLD Segments Tree Before Filter", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.before.filter.xml", step == 1));
        }
        this.filterSyntacticTagsBeforeReconciliation(oldChangeSet, newGeneratedInfo, reconciler.getReconcileExtension(), step);
        if (reconciler instanceof SegmentReconciler && ((SegmentReconciler)reconciler).getTracer().isDebugModeEnabled()) {
            xmlContents = ReconcileUtil.dumpTopSegmentTree(this.changeSet.topSegment(), true, true, true);
            ((SegmentReconciler)reconciler).getTracer().debug((Object)this, "OLD Segments Tree After Filter", "\n" + ReconcileUtil.dumpToTmpFile(xmlContents.toString(), "segments.old.after.filter.xml", step == 1));
        }
        IReconcilerState state = this.reconcileState == null ? reconciler.newReconcilerState(oldChangeSet) : this.reconcileState;
        UserChangeSet newChangeSet = new UserChangeSet(this);
        newChangeSet.setDictionary(oldChangeSet.getDictionary());
        newChangeSet.setGeneratedInfo(newGeneratedInfo);
        newChangeSet.setSilent(this.changeSet.isSilent());
        if (this.debugEnabled) {
            Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + step + step + "_0_before_reconcile.xml"), (String)this.exportAsGeneratedInfo(newChangeSet, true).toString());
        }
        IReconcilerState newState = null;
        newState = reconciler instanceof SegmentReconciler ? ((SegmentReconciler)reconciler).reconcile(state, newChangeSet, step) : reconciler.reconcile(state, newChangeSet);
        if (this.debugEnabled) {
            Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + step + step + "_1_after_reconcile.xml"), (String)this.exportAsGeneratedInfo(newChangeSet, true, false).toString());
        }
        this.changeSet = newChangeSet;
        if (this.matcher != null) {
            this.matcher.setChangeSet(newChangeSet);
        }
        if (this.editTree != null) {
            this.editTree.setChangeSet(newChangeSet);
        }
        if (this.debugEnabled) {
            Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + step + step + "_2_after_matcher.xml"), (String)this.exportAsGeneratedInfo(this.changeSet, true).toString());
        }
        this.reconcileState = newState;
    }

    protected void filterSyntacticTagsBeforeReconciliation(UserChangeSet ucs, IGeneratedInfo newGenInfo, com.ibm.pdp.engine.extension.IReconcileExtension reconcileExtension, int step) {
        UserSyntacticInfo si = (UserSyntacticInfo)ucs.getSyntacticInfo();
        if (si == null) {
            return;
        }
        HashSet<String> tagNames = new HashSet<String>();
        this.collectTagNames(newGenInfo.getRootTag(), tagNames, ucs, reconcileExtension, step);
        si.setAcceptedTagNames(tagNames);
        si.declareDirtyPortion(0, this.getTextLength());
        ucs.refreshSyntacticSegments();
    }

    protected void collectTagNames(IGeneratedTag tag, Set<String> tagNames, UserChangeSet ucs, com.ibm.pdp.engine.extension.IReconcileExtension reconcileExtension, int step) {
        if (reconcileExtension == null || !((IReconcileExtension)reconcileExtension).filterSyntacticTagsBeforeReconciliation((Object)ucs, tag, step)) {
            tagNames.add(tag.getName());
        }
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            this.collectTagNames((IGeneratedTag)sons.next(), tagNames, ucs, reconcileExtension, step);
        }
    }

    protected IGeneratedInfo filterTagsBeforeReconciliationBuildSkippedList(IGeneratedInfo genInfo, final Set<String> skippedTagNames) {
        GeneratedInfoConverter converter = new GeneratedInfoConverter(this.factory.newGeneratedInfoFactory()){

            protected boolean toConvert(IGeneratedInfo generatedInfo) {
                return true;
            }

            protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
                if ("Ignore".equalsIgnoreCase(tag.getProperty("ReconcileMode"))) {
                    skippedTagNames.add(tag.getName());
                    return TagConversionMode.SkipTag;
                }
                return TagConversionMode.CopyTagAndText;
            }
        };
        return converter.convert(genInfo);
    }

    protected IGeneratedInfo filterTagsBeforeReconciliationBuildKeptList(IGeneratedInfo genInfo, final Set<String> keptTagNames) {
        GeneratedInfoConverter converter = new GeneratedInfoConverter(this.factory.newGeneratedInfoFactory()){

            protected boolean toConvert(IGeneratedInfo generatedInfo) {
                return true;
            }

            protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
                if ("Ignore".equalsIgnoreCase(tag.getProperty("ReconcileMode"))) {
                    return TagConversionMode.SkipTag;
                }
                keptTagNames.add(tag.getName());
                return TagConversionMode.CopyTagAndText;
            }
        };
        return converter.convert(genInfo);
    }

    protected void reconcile(IGeneratedInfo newGeneratedInfo) {
        if (this.hasListener()) {
            CharSequence oldText = this.changeSet.getText();
            this.silentReconcile(newGeneratedInfo, 1);
            CharSequence newText = this.changeSet.getText();
            this.fireTextChange(oldText, newText, 0);
        } else {
            this.silentReconcile(newGeneratedInfo, 1);
        }
    }

    public IReconciler getNewReconciler() {
        return new SegmentReconciler();
    }

    protected IReconciler newReconciler(int step) {
        IReconciler rec = this.getNewReconciler();
        com.ibm.pdp.engine.extension.IReconcileExtension reconcileExtension = this.getReconcileExtension();
        if (reconcileExtension != null) {
            rec.setReconcileExtension(reconcileExtension);
        }
        return rec;
    }

    public int getTextLength() {
        return this.changeSet.length();
    }

    public CharSequence getText() {
        return this.changeSet.getText();
    }

    public void setText(CharSequence newText) {
        this.changeSet.setText(newText);
    }

    public SyntacticInfo getSyntacticInfo() {
        return this.changeSet.getSyntacticInfo();
    }

    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        this.changeSet.replaceText(beginIdx, endIdx, newText);
    }

    public void restoreGeneratedCode() {
        this.changeSet.restoreGeneratedText();
    }

    public void restoreGeneratedCode(int beginIdx, int endIdx) {
        this.changeSet.restoreGeneratedText(beginIdx, endIdx);
    }

    public Iterator<ITextSegment> segments() {
        if (this.changeSet.getGeneratedInfo() == null) {
            return this.changeSet.getText() == null ? this.emptyTextSegmentIterator() : this.newSingleInsertedSegmentIterator();
        }
        return this.newTextSegmentIterator();
    }

    public Iterator<ITextSegment> segments(int beginIdx, int endIdx) {
        if (this.changeSet.getGeneratedInfo() == null) {
            return this.changeSet.getText() == null ? this.emptyTextSegmentIterator() : this.newSingleInsertedSegmentIterator();
        }
        return this.newTextSegmentIterator(beginIdx, endIdx);
    }

    public Iterator<ITextSegment> segments(int beginIdx, int endIdx, Set<String> propertyNames) {
        if (this.changeSet.getGeneratedInfo() == null) {
            return this.changeSet.getText() == null ? this.emptyTextSegmentIterator() : this.newSingleInsertedSegmentIterator();
        }
        return this.newTextSegmentIterator(beginIdx, endIdx, propertyNames);
    }

    protected Iterator<ITextSegment> emptyTextSegmentIterator() {
        return Iterators.emptyIterator();
    }

    protected Iterator<ITextSegment> newSingleInsertedSegmentIterator() {
        return new Iterator<ITextSegment>(){
            protected boolean done;

            @Override
            public boolean hasNext() {
                return this.done;
            }

            @Override
            public ITextSegment next() {
                if (this.done) {
                    throw new NoSuchElementException("Iterator<ITextSegment>.next");
                }
                this.done = true;
                return new TextSegment(TextProcessor.this.getText(), 0, TextProcessor.this.getTextLength(), 16, null, 0, 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator<ITextSegment>.remove");
            }
        };
    }

    protected Iterator<ITextSegment> newTextSegmentIterator() {
        return new DetailedTextSegmentIterator(this);
    }

    protected Iterator<ITextSegment> newTextSegmentIterator(int beginIdx, int endIdx) {
        return new DetailedTextSegmentIterator(this, beginIdx, endIdx);
    }

    protected Iterator<ITextSegment> newTextSegmentIterator(int beginIdx, int endIdx, Set<String> propertyNames) {
        return new DetailedTextSegmentWithPropertiesIterator(this, beginIdx, endIdx, propertyNames);
    }

    protected IMatcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = this.newMatcher(this.changeSet);
        } else {
            this.matcher.setMatchingExtension(this.getMatchingExtension());
        }
        return this.matcher;
    }

    protected IMatcher newMatcher(UserChangeSet userChangeSet) {
        DiffMatcher m = new DiffMatcher();
        m.setChangeSet(userChangeSet);
        m.setMatchingExtension(this.getMatchingExtension());
        return m;
    }

    public Iterator<IProblem> problems() {
        CatenateIterator iter = new CatenateIterator();
        if (this.reconcileState != null) {
            iter.addIterator(this.reconcileState.problems());
        }
        if (this.mpGenerationProblems != null && this.mpGenerationProblems.size() > 0) {
            iter.addIterator(this.mpGenerationProblems.iterator());
        }
        if (this.genericProblems != null && this.genericProblems.size() > 0) {
            iter.addIterator(this.genericProblems.iterator());
        }
        if (this.changeSet.getSyntacticInfo() != null) {
            iter.addIterator(this.changeSet.getSyntacticInfo().problems());
        }
        return iter;
    }

    public Iterator<IProblem> problems(final int beginIdx, final int endIdx) {
        return new FilterIterator<IProblem>(this.problems()){

            protected boolean accept(IProblem candidate) {
                int candidateIndex = candidate.beginIndex();
                return candidateIndex >= beginIdx && candidateIndex <= endIdx;
            }
        };
    }

    public IProblem problem(int beginIdx, int endIdx, String id) {
        Iterator<IProblem> iterator = this.problems(beginIdx, endIdx);
        if (iterator != null) {
            while (iterator.hasNext()) {
                IProblem problem = iterator.next();
                if (!id.equals(problem.id())) continue;
                return problem;
            }
        }
        return null;
    }

    public void removeAllProblems() {
        this.reconcileState = null;
    }

    public IEditTree getEditTree() {
        if (this.editTree == null) {
            this.editTree = this.newEditTree();
            this.editTree.setMatcher(this.getMatcher());
        }
        return this.editTree;
    }

    protected EditTree newEditTree() {
        return new EditTree(this.changeSet);
    }

    public IGeneratedInfo exportAsGeneratedInfo() {
        this.matchIfNecessary();
        return this.changeSet.exportAsGeneratedInfo(this.factory.newGeneratedInfoFactory(), false);
    }

    protected IGeneratedInfo exportAsGeneratedInfo(UserChangeSet changeSetToExport, boolean tagSpecificCode, boolean match) {
        if (match && changeSetToExport.getChangeNature() == ChangeNature.Dirty) {
            this.newMatcher(changeSetToExport).match();
        }
        return changeSetToExport.exportAsGeneratedInfo(this.factory.newGeneratedInfoFactory(), tagSpecificCode);
    }

    protected IGeneratedInfo exportAsGeneratedInfo(UserChangeSet changeSetToExport, boolean tagSpecificCode) {
        return this.exportAsGeneratedInfo(changeSetToExport, tagSpecificCode, true);
    }

    public IGeneratedInfo exportAsGeneratedInfo(String rootTagName) {
        this.matchIfNecessary();
        return this.changeSet.exportAsGeneratedInfo(this.factory.newGeneratedInfoFactory(), rootTagName);
    }

    protected IGeneratedInfo exportAsGeneratedInfo(UserChangeSet changeSetToExport, String rootTagName) {
        if (changeSetToExport.getChangeNature() == ChangeNature.Dirty) {
            this.newMatcher(changeSetToExport).match();
        }
        return changeSetToExport.exportAsGeneratedInfo(this.factory.newGeneratedInfoFactory(), rootTagName);
    }

    protected void matchIfNecessary() {
        if (this.changeSet.getChangeNature() == ChangeNature.Dirty) {
            this.getMatcher().match();
        }
    }

    public void addTextChangeListener(ITextChangeListener listener) {
        this.getEventRedirector().addListener(listener);
    }

    public void addTextChangeListener(ITextChangeListener listener, boolean isTransient, boolean isWeak) {
        this.getEventRedirector().addListener(listener, isTransient, isWeak);
    }

    protected TextChangeEventRedirector getEventRedirector() {
        if (this.eventRedirector == null) {
            this.eventRedirector = this.newEventRedirector();
        }
        return this.eventRedirector;
    }

    protected TextChangeEventRedirector newEventRedirector() {
        return new TextChangeEventRedirector();
    }

    public void removeTextChangeListener(ITextChangeListener listener) {
        if (this.eventRedirector != null) {
            this.eventRedirector.removeListener(listener);
        }
    }

    public boolean hasListener() {
        return this.eventRedirector != null && this.eventRedirector.hasListener();
    }

    public void fireTextChange(CharSequence removed, CharSequence added, int index) {
        this.fireEvent(this.newTextChangeEvent(removed, added, index));
    }

    public ITextChangeEvent newTextChangeEvent(CharSequence removed, CharSequence added, int index) {
        return new TextChangeEvent(this, removed, added, index);
    }

    public void fireEvent(ITextChangeEvent event) {
        if (!this.hasListener()) {
            throw new RuntimeException("Should use TextProcessor.hasListener to avoid event creation");
        }
        this.eventRedirector.textChanged(event);
    }

    protected com.ibm.pdp.engine.extension.ITextProcessorExtension getTextProcessorExtension() {
        return this.extension;
    }

    protected com.ibm.pdp.engine.extension.ITextProcessorExtension getTextProcessorExtension(IGeneratedInfo generatedInfo) {
        this.initializeTextProcessorExtension(generatedInfo);
        return this.extension;
    }

    protected void initializeTextProcessorExtension(IGeneratedInfo generatedInfo) {
        if (generatedInfo == null) {
            this.extension = null;
        } else if (this.extension == null) {
            this.extension = this.newTextProcessorExtension(generatedInfo);
        } else if (this.extension.getGeneratedInfo() != generatedInfo) {
            this.extension.setGeneratedInfo(generatedInfo);
        }
    }

    protected com.ibm.pdp.engine.extension.ITextProcessorExtension newTextProcessorExtension(IGeneratedInfo generatedInfo) {
        if (this.factory == null) {
            return null;
        }
        IExtensionManager mgr = this.factory.getExtensionManager();
        if (mgr == null) {
            return null;
        }
        return mgr.newTextProcessorExtension(generatedInfo);
    }

    public IEditTreeExtension getEditTreeExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension ext = this.getTextProcessorExtension();
        return ext != null ? ext.getEditTreeExtension() : null;
    }

    public IMatchingExtension getMatchingExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension ext = this.getTextProcessorExtension();
        return ext != null ? ext.getMatchingExtension() : null;
    }

    public IMicroPatternHandlerManager getMicroPatternGenerationExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension ext = this.getTextProcessorExtension();
        return ext != null ? ext.getMicroPatternGenerationExtension() : null;
    }

    public com.ibm.pdp.engine.extension.IReconcileExtension getReconcileExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension ext = this.getTextProcessorExtension();
        return ext != null ? ext.getReconcileExtension() : null;
    }

    public IReformatExtension getReformatExtension() {
        com.ibm.pdp.engine.extension.ITextProcessorExtension ext = this.getTextProcessorExtension();
        return ext != null ? ext.getReformatExtension() : null;
    }

    public void setEditTreeExtension(IEditTreeExtension newEditTreeExtension) {
        throw new UnsupportedOperationException("EditTreeExtension not yet supported in turbo engine");
    }

    public void setMatchingExtension(IMatchingExtension newMatchingExtension) {
        throw new RuntimeException("Deprecated");
    }

    public void setReformatExtension(IReformatExtension newReformatExtension) {
        throw new UnsupportedOperationException("ReformatExtension not yet supported in turbo engine");
    }

    public ITextPartitioner newTextPartitioner() {
        IMatchingExtension matchingExtension = this.getMatchingExtension();
        if (matchingExtension == null) {
            return this.newDefaultTextPartitioner();
        }
        ITextPartitioner partitioner = matchingExtension.newTextPartitioner();
        return partitioner != null ? partitioner : this.newDefaultTextPartitioner();
    }

    protected ITextPartitioner newDefaultTextPartitioner() {
        return new DefaultTextPartitioner();
    }

    public IReconcilerState getReconcileState() {
        return this.reconcileState;
    }

    public void setReconcileState(IReconcilerState reconcileState) {
        this.reconcileState = reconcileState;
    }

    public IMicroPatternProcessingContext getMicroPatternProcessingContext() {
        return this.microPatternContext;
    }

    public ArrayList<IProblem> getMpGenerationProblems() {
        if (this.mpGenerationProblems == null) {
            this.mpGenerationProblems = new ArrayList();
        }
        return this.mpGenerationProblems;
    }

    public Map<String, Object> getGlobalContext() {
        if (this.globalContext == null) {
            this.globalContext = new HashMap<String, Object>();
        }
        return this.globalContext;
    }

    public void duplicateFrom(TextProcessor textProcessor) {
        IGenInfoBuilder genBuilder = textProcessor.getGeneratedInfo().toGeneratedInfoBuilder();
        IGeneratedInfo duplicatedGenInfo = genBuilder.toGeneratedInfo();
        this.initialize(duplicatedGenInfo);
        CharSequence oldCompleteText = textProcessor.getText();
        this.setText(oldCompleteText);
        IReconciler newReconciler = this.getNewReconciler();
        IReconcilerState newState = newReconciler.newReconcilerState(this.changeSet);
        IReconcilerState oldState = textProcessor.reconcileState;
        if (oldState != null && oldState instanceof ReconcilerState && newState instanceof ReconcilerState) {
            ((ReconcilerState)newState).duplicateFrom((ReconcilerState)oldState);
        }
        this.reconcileState = newState;
        if (textProcessor.mpGenerationProblems != null) {
            for (IProblem iProblem : textProcessor.mpGenerationProblems) {
                if (!(iProblem instanceof MicroPatternGenerationProblem)) continue;
                MicroPatternGenerationProblem mpGenProb = (MicroPatternGenerationProblem)iProblem;
                if (this.mpGenerationProblems == null) {
                    this.mpGenerationProblems = new ArrayList(10);
                }
                MicroPatternGenerationProblem newMPGenProb = new MicroPatternGenerationProblem();
                newMPGenProb.duplicateFrom(mpGenProb);
                this.mpGenerationProblems.add(newMPGenProb);
            }
        }
    }

    private class DefaultTracerDelegate
    implements ITracerDelegate {
        private boolean DEBUG_MODE = true;

        private DefaultTracerDelegate() {
        }

        public boolean isDebugModeEnabled() {
            return this.DEBUG_MODE;
        }

        public void info(Object sourceObject, String methodName, String message) {
            System.out.println(sourceObject == null ? "static" : String.valueOf(sourceObject.getClass().getCanonicalName()) + "#" + methodName + "() I " + message);
        }

        public void debug(Object sourceObject, String methodName, String message) {
            System.out.println(sourceObject == null ? "static" : String.valueOf(sourceObject.getClass().getCanonicalName()) + "#" + methodName + "() D " + message);
        }
    }
}

