/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.ITextChangeEvent;
import com.ibm.pdp.engine.ITextInterval;
import com.ibm.pdp.engine.turbo.impl.TextInterval;
import com.ibm.pdp.util.events.CharSequenceChangeEvent;

public class TextChangeEvent
extends CharSequenceChangeEvent
implements ITextChangeEvent {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextChangeEvent() {
    }

    public TextChangeEvent(Object source) {
        super(source);
    }

    public TextChangeEvent(Object source, CharSequence removedChars, CharSequence addedChars, int idx) {
        super(source, removedChars, addedChars, idx);
    }

    public int idx() {
        return this.index;
    }

    public CharSequence addedText() {
        return this.added;
    }

    public CharSequence removedText() {
        return this.removed;
    }

    public ITextInterval translateInterval(int beginIdx, int endIdx) {
        return this.basicTranslate(beginIdx, endIdx);
    }

    protected ITextInterval basicTranslate(int beginIdx, int endIdx) {
        if (endIdx <= this.index) {
            return this.newTextInterval(beginIdx, endIdx);
        }
        int addedLength = this.nbCharsAdded();
        int removedLength = this.nbCharsRemoved();
        int variation = addedLength - removedLength;
        int oldEndIdx = this.index + removedLength;
        if (beginIdx >= oldEndIdx) {
            return this.newTextInterval(beginIdx + variation, endIdx + variation);
        }
        if (beginIdx > this.index) {
            beginIdx = this.index + addedLength;
            endIdx = endIdx >= oldEndIdx ? (endIdx += variation) : beginIdx;
        } else {
            endIdx = endIdx >= oldEndIdx ? (endIdx += variation) : this.index;
        }
        return this.newTextInterval(beginIdx, endIdx);
    }

    protected ITextInterval newTextInterval(int beginIndex, int endIndex) {
        return new TextInterval(beginIndex, endIndex);
    }
}

