/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SyntacticTagMerger
extends GeneratedInfoConverter {
    protected SyntacticInfo syntacticInfo;
    protected Iterator<SyntacticMark> syntacticMarks;
    protected List<String> openedTag;
    protected SyntacticMark currentMark;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SyntacticTagMerger() {
        this(new GenInfoFactory());
    }

    public SyntacticTagMerger(IGeneratedInfoFactory factory) {
        super(factory);
    }

    public SyntacticTagMerger(SyntacticInfo syntacticInformation) {
        this(new GenInfoFactory(), syntacticInformation);
    }

    public SyntacticTagMerger(IGeneratedInfoFactory factory, SyntacticInfo syntacticInformation) {
        super(factory);
        this.syntacticInfo = syntacticInformation;
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        String analyzed = generatedInfo.getProperty("DoNotAnalyze");
        if (analyzed != null) {
            return false;
        }
        if (this.syntacticInfo == null) {
            return false;
        }
        this.syntacticMarks = this.syntacticInfo.marks();
        return this.currentSyntacticMark() != null;
    }

    protected void initializeConversion(IGeneratedInfo generatedInfoToConvert) {
        super.initializeConversion(generatedInfoToConvert);
        this.openedTag = new ArrayList<String>();
    }

    protected void convertGeneratedInfo(IGeneratedInfo generatedInfoToConvert) {
        this.convertProperties(generatedInfoToConvert);
        this.factory.setProperty("DoNotAnalyze", "True");
        this.convertTag(generatedInfoToConvert.getRootTag());
        this.processRemainingMarks();
    }

    protected void processRemainingMarks() {
        SyntacticMark mark;
        int endIdx = this.text.length();
        while ((mark = this.currentSyntacticMark()) != null) {
            if (mark.index() != endIdx) {
                throw new RuntimeException("Wrong syntactic tag index " + mark.index() + ": beyond text end");
            }
            if (mark.isBeginMark()) {
                this.processBeginTagMark();
                continue;
            }
            this.processEndTagMark();
        }
    }

    protected void convertTag(IGeneratedTag tag) {
        this.processMarksBeforeTagStart(tag);
        this.beginTag(tag.getName());
        this.convertProperties(tag);
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            this.convertText(previousIdx, son.getBeginIndex());
            this.convertTag(son);
            previousIdx = son.getEndIndex();
        }
        this.convertText(previousIdx, tag.getEndIndex());
        this.processMarksBeforeTagStop(tag);
        this.endTag(tag.getName());
    }

    protected void processMarksBeforeTagStart(IGeneratedTag tag) {
        SyntacticMark mark;
        String tagName = tag.getName();
        int beginIdx = tag.getBeginIndex();
        int endIdx = tag.getEndIndex();
        while ((mark = this.currentSyntacticMark()) != null && mark.index() == beginIdx) {
            if (mark.isEndMark()) {
                this.processEndTagMark();
                continue;
            }
            SyntacticTag syntacticTag = mark.toTag();
            if (syntacticTag.getName().equals(tagName)) {
                if (syntacticTag.endIndex() != endIdx) {
                    throw new RuntimeException("Wrong end index for syntactic tag : " + tagName);
                }
                this.ignoreCurrentMark();
                return;
            }
            if (syntacticTag.endIndex() < endIdx) {
                return;
            }
            this.processBeginTagMark();
        }
    }

    protected void processMarksBeforeTagStop(IGeneratedTag tag) {
        SyntacticMark mark;
        String tagName = tag.getName();
        int beginIdx = tag.getBeginIndex();
        int endIdx = tag.getEndIndex();
        while ((mark = this.currentSyntacticMark()) != null && mark.index() == endIdx) {
            if (mark.isBeginMark()) {
                if (mark.getPeer().index() > endIdx) {
                    return;
                }
                this.processBeginTagMark();
                continue;
            }
            String syntacticTagName = mark.toTag().getName();
            if (syntacticTagName.equals(tagName)) {
                this.ignoreCurrentMark();
                return;
            }
            if (mark.getPeer().index() < beginIdx || !this.isLastOpenedTag(syntacticTagName)) {
                return;
            }
            this.processEndTagMark();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void convertText(int beginIdx, int endIdx) {
        if (beginIdx <= endIdx) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (markIdx > beginIdx) {
                this.factory.appendText(this.text.subSequence(beginIdx, markIdx));
                beginIdx = markIdx;
            }
            if (mark.isBeginMark()) {
                this.processBeginTagMark();
                continue;
            }
            this.processEndTagMark();
lbl10:
            // 3 sources

            ** while ((mark = this.currentSyntacticMark()) != null && (markIdx = mark.index()) < endIdx)
        }
lbl11:
        // 1 sources

        if (beginIdx < endIdx) {
            this.factory.appendText(this.text.subSequence(beginIdx, endIdx));
        }
    }

    protected void ignoreCurrentMark() {
        this.currentMark = null;
    }

    protected void processBeginTagMark() {
        this.beginTag(this.currentMark.toTag().getName());
        this.currentMark = null;
    }

    protected void processEndTagMark() {
        this.checkLastOpenedTag(this.currentMark.toTag().getName());
        this.currentMark = null;
        this.endTag(null);
    }

    protected void checkLastOpenedTag(String tagName) {
        int size = this.openedTag.size();
        if (size == 0) {
            throw new RuntimeException("No opened tag where" + tagName + " was expected");
        }
        String lastOpenedTag = this.openedTag.get(size - 1);
        if (!lastOpenedTag.equals(tagName)) {
            throw new RuntimeException("Found end of tag " + tagName + " where " + lastOpenedTag + " was expected");
        }
    }

    protected boolean isLastOpenedTag(String tagName) {
        int size = this.openedTag.size();
        return size > 0 && this.openedTag.get(size - 1).equals(tagName);
    }

    protected void beginTag(String tagName) {
        this.factory.beginTag(tagName);
        this.openedTag.add(tagName);
    }

    protected void endTag(String tagName) {
        this.openedTag.remove(this.openedTag.size() - 1);
        this.factory.endTag();
    }

    protected SyntacticMark currentSyntacticMark() {
        if (this.currentMark == null) {
            while (this.syntacticMarks.hasNext()) {
                SyntacticMark mark = this.syntacticMarks.next();
                if (!mark.isTag() || mark.toTag().getProperty("category") != null && mark.toTag().getProperty("category").equals("micro_pattern")) continue;
                this.currentMark = mark;
                break;
            }
        }
        return this.currentMark;
    }
}

