/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.util.geninfo.GeneratedInfoConverter;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import java.util.ArrayList;

public class SpecificTagAndTextRemover
extends GeneratedInfoConverter {
    protected ArrayList<IGeneratedTag> tagStack;
    protected String replacementText;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SpecificTagAndTextRemover() {
    }

    public SpecificTagAndTextRemover(IGeneratedInfoFactory factory) {
        super(factory);
    }

    protected boolean toConvert(IGeneratedInfo generatedInfo) {
        return true;
    }

    protected void initializeConversion(IGeneratedInfo generatedInfoToConvert) {
        super.initializeConversion(generatedInfoToConvert);
        this.tagStack = new ArrayList();
    }

    protected void convertTag(IGeneratedTag tag) {
        this.tagStack.add(tag);
        super.convertTag(tag);
        this.tagStack.remove(this.tagStack.size() - 1);
    }

    protected IGeneratedTag currentTag() {
        if (this.tagStack.isEmpty()) {
            return null;
        }
        return this.tagStack.get(this.tagStack.size() - 1);
    }

    protected TagConversionMode tagConversionMode(IGeneratedTag tag) {
        String syntacticTag = tag.getProperty("SyntacticTag");
        if (syntacticTag != null) {
            return TagConversionMode.SkipTag;
        }
        String specificCode = tag.getProperty("SpecificTag");
        if (specificCode == null) {
            return TagConversionMode.Convert;
        }
        this.replacementText = tag.getProperty("GeneratedText");
        return TagConversionMode.SkipTag;
    }

    protected void convertText(int beginIdx, int endIdx) {
        if (this.replacementText != null) {
            this.factory.appendText((CharSequence)this.replacementText);
            this.replacementText = null;
            return;
        }
        IGeneratedTag currentTag = this.currentTag();
        if (currentTag == null || currentTag.getProperty("SpecificTag") == null) {
            super.convertText(beginIdx, endIdx);
        }
    }

    protected String convertPropertyName(String name) {
        return name.startsWith("+") ? null : name;
    }
}

