/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternGenerationProperties;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.extension.IProcessingStatus;
import com.ibm.pdp.engine.internal.IPostProcessorParticipant;
import com.ibm.pdp.engine.turbo.impl.ProcessingStatus;
import com.ibm.pdp.util.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MicroPatternProcessingContext
implements IMicroPatternProcessingContext {
    private IGeneratedInfo generatedInfo;
    private int status = 0;
    private boolean userCode = true;
    private Set<Object> references;
    private HashMap<String, Object> attributes;
    private ArrayList<IPostProcessorParticipant> participants;
    private ArrayList<IProcessingStatus> statusStack;
    private ArrayList<TemporaryStatus> statusStackMP;
    private IMicroPatternGenerationProperties generationProperties;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010,2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MicroPatternProcessingContext(IGeneratedInfo generatedInfo, boolean userCode) {
        this.generatedInfo = generatedInfo;
        this.userCode = userCode;
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    public void setUserCode(boolean userCode) {
        this.userCode = userCode;
    }

    public void setGeneratedInfo(IGeneratedInfo generatedInfo) {
        this.generatedInfo = generatedInfo;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean inUserCode() {
        return this.userCode;
    }

    public Iterator<Object> generationReferenceIterator() {
        return this.references != null ? this.references.iterator() : Iterators.emptyIterator();
    }

    public void registerGenerationReference(Object data) {
        if (this.references == null) {
            this.references = new HashSet<Object>(10);
        }
        this.references.add(data);
    }

    public String getAttribute(String attributeName) {
        Object value = this.attributes.get(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setAttribute(String attributeName, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap(20);
        }
        this.attributes.put(attributeName, value);
    }

    public Iterator<String> getAllAttributeNames() {
        return this.attributes != null ? this.attributes.keySet().iterator() : Collections.emptyList().iterator();
    }

    public void setData(String key, Object data) {
        if (this.attributes == null) {
            this.attributes = new HashMap(20);
        }
        this.attributes.put(key, data);
    }

    public Object getData(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public void reset() {
        this.status = 0;
        if (this.statusStack != null) {
            this.statusStack.clear();
        }
        if (this.statusStackMP != null) {
            this.statusStackMP.clear();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.references != null) {
            this.references.clear();
        }
        if (this.participants != null) {
            this.participants.clear();
        }
    }

    protected void registerPostProcessor(IPostProcessorParticipant participant) {
        if (this.participants == null) {
            this.participants = new ArrayList(10);
        }
        this.participants.add(participant);
    }

    protected Iterator<IPostProcessorParticipant> getAllParticipants() {
        return this.participants != null ? this.participants.iterator() : Iterators.emptyIterator();
    }

    public void setStatus(int status, int location, String msg, String userAction) {
        ProcessingStatus processingStatus = new ProcessingStatus(status, location, msg, userAction);
        if (this.statusStack == null) {
            this.statusStack = new ArrayList(5);
        }
        this.statusStack.add(processingStatus);
        if (status > this.status) {
            this.status = status;
        }
    }

    public void setStatus(int status, IMicroPattern microPattern, String msg, String userAction) {
        TemporaryStatus ts = new TemporaryStatus();
        ts.status = status;
        ts.microPattern = microPattern;
        ts.msg = msg;
        ts.userAction = userAction;
        if (this.statusStackMP == null) {
            this.statusStackMP = new ArrayList();
        }
        this.statusStackMP.add(ts);
        if (status > this.status) {
            this.status = status;
        }
    }

    public void setStatus(int status, IBuilderTag tag, String msg, String userAction) {
        TemporaryStatus ts = new TemporaryStatus();
        ts.status = status;
        ts.tag = tag;
        ts.msg = msg;
        ts.userAction = userAction;
        if (this.statusStackMP == null) {
            this.statusStackMP = new ArrayList();
        }
        this.statusStackMP.add(ts);
        if (status > this.status) {
            this.status = status;
        }
    }

    public boolean IsMPHasStatus(IMicroPattern mp) {
        if (this.statusStackMP != null && this.statusStackMP.size() != 0) {
            for (TemporaryStatus ts : this.statusStackMP) {
                if (!mp.equals(ts.microPattern)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<IProcessingStatus> statusStack() {
        if (this.statusStackMP != null) {
            for (TemporaryStatus ts : this.statusStackMP) {
                int index = 0;
                if (ts.microPattern != null) {
                    index = ts.microPattern.getLocation().getBeginIndex();
                } else if (ts.tag != null) {
                    index = ts.tag.getBeginIndex();
                }
                this.setStatus(ts.status, index, ts.msg, ts.userAction);
            }
        }
        return this.statusStack != null ? this.statusStack.iterator() : Iterators.emptyIterator();
    }

    public void setGenerationProperties(IMicroPatternGenerationProperties properties) {
        this.generationProperties = properties;
    }

    public IMicroPatternGenerationProperties getGenerationProperties() {
        return this.generationProperties;
    }

    class TemporaryStatus {
        int status;
        IMicroPattern microPattern;
        IBuilderTag tag;
        String msg;
        String userAction;

        TemporaryStatus() {
        }
    }
}

