/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.IProcessingStatus;
import com.ibm.pdp.engine.turbo.impl.ProcessingStatus;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.Util;
import java.util.Iterator;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class MicroPatternGenerationProblem
implements IProblem {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IProcessingStatus internalStatus;

    public MicroPatternGenerationProblem() {
    }

    public MicroPatternGenerationProblem(IProcessingStatus status) {
        this.internalStatus = status;
    }

    public int beginIndex() {
        return this.internalStatus.getLocation();
    }

    public int endIndex() {
        return this.internalStatus.getLocation();
    }

    public int length() {
        return 0;
    }

    public boolean isWarning() {
        return this.internalStatus.getStatusCode() == 4;
    }

    public boolean isError() {
        return this.internalStatus.getStatusCode() == 6 || this.internalStatus.getStatusCode() == 5;
    }

    public void remove() {
    }

    public String code() {
        return "MP000";
    }

    public String[] parameters() {
        return new String[0];
    }

    public String message() {
        return String.valueOf(this.internalStatus.getStatusMessage()) + (this.internalStatus.getRecommendedUserAction() != null ? " - " + this.internalStatus.getRecommendedUserAction() : "");
    }

    public Iterator<IProblem.IQuickFixAction> actions() {
        return Iterators.emptyIterator();
    }

    public void write(XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Problem");
            if (this.internalStatus.getStatusCode() == 5) {
                xmlWriter.writeAttribute("severity", "E");
            } else if (this.internalStatus.getStatusCode() == 4) {
                xmlWriter.writeAttribute("severity", "W");
            } else {
                xmlWriter.writeAttribute("severity", "S");
            }
            xmlWriter.writeAttribute("message", this.internalStatus.getStatusMessage());
            if (!Util.IS_JAVA_SUN_XML_FRAMEWORK || this.internalStatus.getRecommendedUserAction() != null) {
                xmlWriter.writeAttribute("useraction", this.internalStatus.getRecommendedUserAction());
            }
            xmlWriter.writeAttribute("location", Integer.toString(this.beginIndex()));
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    public void read(XMLStreamReader xmlReader) {
        int nbOfAtt = xmlReader.getAttributeCount();
        if (nbOfAtt == 0) {
            return;
        }
        String msg = null;
        String action = null;
        int code = 6;
        int location = 0;
        int i = 0;
        while (i < nbOfAtt) {
            String name = xmlReader.getAttributeLocalName(i);
            String value = xmlReader.getAttributeValue(i);
            if ("severity".equals(name)) {
                code = "W".equals(value) ? 4 : ("E".equals(value) ? 5 : 6);
            } else if ("message".equals(name)) {
                msg = value;
            } else if ("useraction".equals(name)) {
                action = value.length() != 0 ? value : null;
            } else if ("location".equals(name)) {
                location = Integer.parseInt(value);
            }
            ++i;
        }
        this.internalStatus = new ProcessingStatus(code, location, msg, action);
    }

    public String id() {
        return null;
    }

    void duplicateFrom(MicroPatternGenerationProblem mpgp) {
        if (mpgp != null && mpgp.internalStatus != null) {
            this.internalStatus = new ProcessingStatus(mpgp.internalStatus.getStatusCode(), mpgp.internalStatus.getLocation(), mpgp.internalStatus.getStatusMessage(), mpgp.internalStatus.getRecommendedUserAction());
        }
    }
}

