/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.ICommonMicroPatternHandler;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternFilter;
import com.ibm.pdp.engine.IMicroPatternGenerationExtension;
import com.ibm.pdp.engine.IMicroPatternHandler;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.ITextArtefactLocation;
import com.ibm.pdp.engine.extension.IGenerationPostProcessorExtension;
import com.ibm.pdp.engine.extension.IMicroPatternHandlerManager;
import com.ibm.pdp.engine.extension.IMicroPatternHeaderHelper;
import com.ibm.pdp.engine.extension.IMicroPatternParser;
import com.ibm.pdp.engine.extension.IMicroPatternParsingEventHandler;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.extension.TextArtefactLocation;
import com.ibm.pdp.engine.internal.IPostProcessorParticipant;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.impl.GenInfoBuilder;
import com.ibm.pdp.engine.turbo.impl.MicroPattern;
import com.ibm.pdp.engine.turbo.impl.MicroPatternProcessingContext;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MicroPatternEngine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TRACE_DIR = PdpConstants.IS_UNIX_OS ? "/tmp/" : "c:/temp/";
    public static final String SPECIFIC_TAG_PROPERTY = "SpecificTag";
    public static final String MICRO_PATTERN_TAG = "micro_pattern";
    public static final String CATEGORY_PROPERTY = "category";
    public static final String RANK_PROPERTY = "tagRank";
    public static final int INDEX_MP_HEADER_BEGIN = 0;
    public static final int TAG_RANK_MP_HEADER_BEGIN = 1;
    public static final int INDEX_MP_HEADER_END = 1;
    public static final int TAG_RANK_MP_HEADER_END = 2;
    public static final int INDEX_COUNT = 2;
    private IMicroPatternHandlerManager mpExtension;
    private ITracerDelegate tracer;
    IGenerationPostProcessorExtension _generationPostProcessorExtension;

    public MicroPatternEngine(IMicroPatternHandlerManager mpExtension, IGenerationPostProcessorExtension genPostProcessorExt) {
        this.mpExtension = mpExtension;
        this._generationPostProcessorExtension = genPostProcessorExt;
        this.tracer = mpExtension.getTracerDelegate();
        if (this.tracer == null) {
            this.tracer = new DefaultTracerDelegate();
        }
    }

    public IGeneratedInfo expandMicroPatterns(MicroPatternProcessingContext context, SyntacticInfo syntacticInfo, List<IMicroPatternGenerationExtension> extensions, Map<String, Object> contextFromTextProcessor) {
        if (this.tracer.isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "expandMicroPatterns", "Entering method");
        }
        if (syntacticInfo == null) {
            return context.getGeneratedInfo();
        }
        if (contextFromTextProcessor != null) {
            for (String key : contextFromTextProcessor.keySet()) {
                context.setData(key, contextFromTextProcessor.get(key));
            }
        }
        IGeneratedInfo updatedGeneratedInfo = null;
        List<IMicroPattern> microPatterns = this.collectMicroPatterns(context, syntacticInfo);
        if (this.checkStatus(context)) {
            IGenInfoBuilder giBuilder = context.getGeneratedInfo().toGeneratedInfoBuilder();
            ((GenInfoBuilder)giBuilder).setMicroPatternGenearationProcess(true);
            microPatterns = this.clean(microPatterns);
            microPatterns = this.filtersMicroPatterns(microPatterns, context);
            context.setData("_micro.patterns", microPatterns);
            this.expandComplexMicroPatterns(microPatterns, giBuilder, context);
            updatedGeneratedInfo = giBuilder.getGeneratedInfo();
            if (!microPatterns.isEmpty() && this.tracer.isDebugModeEnabled()) {
                Strings.stringToFile((File)new File(String.valueOf(TRACE_DIR) + "updatedGeninfo_afterMP.xml"), (String)updatedGeneratedInfo.toString());
            }
            if (this.checkStatus(context) && context.inUserCode()) {
                if (this.tracer.isDebugModeEnabled()) {
                    this.tracer.debug((Object)this, "expandMicroPatterns", "Handling registered Post-processor");
                }
                if (updatedGeneratedInfo != null) {
                    context.setGeneratedInfo(updatedGeneratedInfo);
                }
                Iterator<IPostProcessorParticipant> participants = context.getAllParticipants();
                while (participants.hasNext()) {
                    IPostProcessorParticipant aParticipant = participants.next();
                    if (this.tracer.isDebugModeEnabled()) {
                        this.tracer.debug((Object)this, "expandMicroPatterns", " - executing " + aParticipant.getClass().getName());
                    }
                    aParticipant.postProcess(giBuilder);
                }
            }
            if (this._generationPostProcessorExtension != null) {
                this._generationPostProcessorExtension.postProcess((IMicroPatternProcessingContext)context);
            }
            if (extensions != null) {
                for (IMicroPatternGenerationExtension extension : extensions) {
                    extension.end((IMicroPatternProcessingContext)context);
                }
            }
            updatedGeneratedInfo = giBuilder.getGeneratedInfo();
        }
        if (updatedGeneratedInfo == null) {
            updatedGeneratedInfo = context.getGeneratedInfo();
        }
        if (this.tracer.isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "expandMicroPatterns", "Leaving method");
        }
        return updatedGeneratedInfo;
    }

    private void expandComplexMicroPatterns(List<IMicroPattern> microPatternList, IGenInfoBuilder genInfoBuilder, MicroPatternProcessingContext context) {
        if (microPatternList.isEmpty()) {
            return;
        }
        if (genInfoBuilder instanceof GenInfoBuilder) {
            ((GenInfoBuilder)genInfoBuilder).setMicroPatternsList(microPatternList);
        }
        Iterator<IMicroPattern> i = microPatternList.iterator();
        while (i.hasNext() && this.checkStatus(context)) {
            IMicroPattern microPattern = i.next();
            ICommonMicroPatternHandler handler = this.mpExtension.findSuitableHandler(microPattern);
            if (!(handler instanceof IMicroPatternHandler)) continue;
            IMicroPatternHandler currentHandler = (IMicroPatternHandler)handler;
            if (this.tracer.isDebugModeEnabled()) {
                this.tracer.debug((Object)this, "expandComplexMicroPatterns", " - handler is a " + handler.getClass().getCanonicalName());
            }
            currentHandler.init();
            currentHandler.process(microPattern, genInfoBuilder);
            if (!(genInfoBuilder instanceof GenInfoBuilder) || context.IsMPHasStatus(microPattern)) continue;
            ((GenInfoBuilder)genInfoBuilder).removeMicroPatternFromList(microPattern);
        }
    }

    private List<IMicroPattern> clean(List<IMicroPattern> microPatternList) {
        if (microPatternList.isEmpty()) {
            return microPatternList;
        }
        ArrayList<IMicroPattern> badDecls = new ArrayList<IMicroPattern>(microPatternList.size());
        for (IMicroPattern mp : microPatternList) {
            if (mp.isWellFormed()) continue;
            badDecls.add(mp);
        }
        if (!badDecls.isEmpty()) {
            for (IMicroPattern mp : badDecls) {
                microPatternList.remove(mp);
            }
        }
        return microPatternList;
    }

    private List<IMicroPattern> filtersMicroPatterns(List<IMicroPattern> microPatterns, MicroPatternProcessingContext context) {
        IGenInfoBuilder genInfoBuilder;
        if (this.tracer.isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "filtersMicroPatterns", "Entering method");
        }
        if ((genInfoBuilder = context.getGeneratedInfo().toGeneratedInfoBuilder()) instanceof GenInfoBuilder) {
            ((GenInfoBuilder)genInfoBuilder).setMicroPatternsList(microPatterns);
        }
        Iterator filters = this.mpExtension.getFilters().iterator();
        List updatedMicroPatternList = microPatterns;
        while (filters.hasNext()) {
            IMicroPatternFilter filter = (IMicroPatternFilter)filters.next();
            updatedMicroPatternList = filter.filters(updatedMicroPatternList, (IMicroPatternProcessingContext)context);
        }
        return updatedMicroPatternList;
    }

    private boolean checkStatus(IMicroPatternProcessingContext context) {
        return context.getStatus() == 0 || context.getStatus() == 4 || context.getStatus() == 5;
    }

    public List<IMicroPattern> collectMicroPatterns(MicroPatternProcessingContext context, SyntacticInfo syntacticInfo) {
        if (this.tracer.isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "collectMicroPatterns", "Entering method");
        }
        Iterator<SyntacticTag> it = syntacticInfo.tags();
        ArrayList<IMicroPattern> microPatterns = new ArrayList<IMicroPattern>(20);
        Stack<MicroPatternDeclaration> mpDeclStack = new Stack<MicroPatternDeclaration>();
        Stack<MicroPattern> microPatternsStack = new Stack<MicroPattern>();
        Stack<Integer> levelStack = new Stack<Integer>();
        int level = 0;
        block3: while (it.hasNext() && (context.getStatus() == 0 || context.getStatus() == 4 || context.getStatus() == 5)) {
            SyntacticTag tag = it.next();
            if (!MICRO_PATTERN_TAG.equals(tag.getProperty(CATEGORY_PROPERTY))) continue;
            int tagRank = Integer.parseInt(tag.getProperty(RANK_PROPERTY));
            switch (tagRank) {
                case 1: {
                    ++level;
                    MicroPatternDeclaration mpDecl = new MicroPatternDeclaration();
                    mpDeclStack.push(mpDecl);
                    mpDecl.setDeclarationBeginIndex(tag.beginIndex());
                    mpDecl = (MicroPatternDeclaration)mpDeclStack.peek();
                    IMicroPattern microPattern = this.retrieveMicroPattern(context, mpDecl);
                    if (context.getStatus() != 0 && context.getStatus() != 4 && context.getStatus() != 5) continue block3;
                    if (!microPatternsStack.isEmpty()) {
                        int stackedMPLevel = (Integer)levelStack.peek();
                        while (level < stackedMPLevel) {
                            levelStack.pop();
                            IMicroPattern stackedMicroPattern = (IMicroPattern)microPatternsStack.pop();
                            ((MicroPattern)microPattern).addChild(stackedMicroPattern);
                            if (this.tracer.isDebugModeEnabled()) {
                                this.tracer.debug((Object)this, "collectMicroPatterns", "- adding child Micro-Pattern ID='" + stackedMicroPattern.getId() + "'  to current Micro-Pattern ID='" + microPattern.getId() + "'");
                            }
                            stackedMPLevel = !levelStack.isEmpty() ? (Integer)levelStack.peek() : -1;
                        }
                    }
                    if (level > 1) {
                        microPatternsStack.push((MicroPattern)microPattern);
                        levelStack.push(level);
                    } else {
                        microPatterns.add(microPattern);
                    }
                    --level;
                }
            }
        }
        return microPatterns;
    }

    protected IMicroPattern retrieveMicroPattern(MicroPatternProcessingContext context, MicroPatternDeclaration mpDecl) {
        if (this.tracer.isDebugModeEnabled()) {
            this.tracer.debug((Object)this, "retrieveMicroPattern", "Entering method");
        }
        IMicroPatternParser parser = this.mpExtension.getMicroPatternHeaderParser();
        IMicroPatternHeaderHelper helper = this.mpExtension.getMicroPatternHeaderHelper();
        final MicroPattern microPattern = new MicroPattern();
        microPattern.setHeaderHelper(helper);
        microPattern.setLocation((ITextArtefactLocation)new TextArtefactLocation(mpDecl.getDeclarationBeginIndex(), mpDecl.getDeclarationBeginIndex()));
        parser.setParsingEventHandler(new IMicroPatternParsingEventHandler(){

            public void setAttribute(String name, String value) {
                if (MicroPatternEngine.this.tracer.isDebugModeEnabled()) {
                    MicroPatternEngine.this.tracer.debug((Object)this, "retrieveMicroPattern", "- attribute: " + name + "=" + value);
                }
                microPattern.setAttribute(name, value);
            }

            public void setConfigurationArea(String configurationArea) {
                if (MicroPatternEngine.this.tracer.isDebugModeEnabled()) {
                    MicroPatternEngine.this.tracer.debug((Object)this, "retrieveMicroPattern", "- configuration area: " + configurationArea);
                }
                microPattern.setConfigurationArea(configurationArea);
            }

            public void setIdentifier(String identifier) {
                if (MicroPatternEngine.this.tracer.isDebugModeEnabled()) {
                    MicroPatternEngine.this.tracer.debug((Object)this, "retrieveMicroPattern", "Micro-Pattern ID: " + identifier);
                }
                microPattern.setId(identifier);
            }

            public void setHeaderDelimiter(String sequence) {
                if (MicroPatternEngine.this.tracer.isDebugModeEnabled()) {
                    MicroPatternEngine.this.tracer.debug((Object)this, "retrieveMicroPattern", "- header delimiter sequence: " + sequence);
                }
                microPattern.setHeaderDelimiterSequence(sequence);
            }

            public void tagAsWellFormed() {
                microPattern.setWellFormed(true);
            }

            public void setHeader(String header) {
                microPattern.setHeaderDecl(header);
            }
        });
        parser.parse((IMicroPattern)microPattern, (IMicroPatternProcessingContext)context);
        microPattern.setContext(context);
        return microPattern;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean ReplaceText(IGenInfoBuilder giBuilder, IBuilderTag currentTag, int startIndex, int endIndex, String newText, boolean allowTagDeletion) {
        if (allowTagDeletion) {
            tagBegin = giBuilder.includingTag(startIndex, startIndex);
            tagEnd = giBuilder.includingTag(endIndex, endIndex);
            if (tagBegin != null) {
                if (tagEnd == null || tagBegin.getEndIndex() == endIndex) {
                    tagEnd = tagBegin;
                }
            } else if (tagEnd != null && (tagBegin == null || tagEnd.getBeginIndex() == startIndex)) {
                tagBegin = tagEnd;
            }
            if (tagEnd != tagBegin) {
                stackBegin = new Stack<IBuilderTag>();
                tmpTag = tagBegin;
                while (tmpTag != null) {
                    stackBegin.insertElementAt(tmpTag, 0);
                    tmpTag = tmpTag.getParent();
                }
                stackEnd = new Stack<IBuilderTag>();
                tmpTag = tagEnd;
                while (tmpTag != null) {
                    stackEnd.insertElementAt(tmpTag, 0);
                    tmpTag = tmpTag.getParent();
                }
                tmpTagBegin = (IBuilderTag)stackBegin.peek();
                tmpTagEnd = (IBuilderTag)stackEnd.peek();
                while (!(stackBegin.isEmpty() || stackEnd.isEmpty() || stackBegin.contains(tmpTagEnd) || stackEnd.contains(tmpTagBegin))) {
                    tmpTagBegin = (IBuilderTag)stackBegin.pop();
                    tmpTagEnd = (IBuilderTag)stackEnd.pop();
                }
                commonTag = tmpTagBegin;
                if (stackBegin.contains(tmpTagEnd)) {
                    commonTag = tmpTagEnd;
                }
                while (tagBegin != commonTag) {
                    tmpTag = tagBegin.getParent();
                    giBuilder.removeTag(tagBegin);
                    tagBegin = tmpTag;
                }
                while (tagEnd != commonTag) {
                    tmpTag = tagEnd.getParent();
                    giBuilder.removeTag(tagEnd);
                    tagEnd = tmpTag;
                }
                if (commonTag.hasSon()) {
                    tmpTag = commonTag.firstSon();
                    while (tmpTag != null && tmpTag.getBeginIndex() < endIndex) {
                        if (tmpTag.getBeginIndex() > startIndex && tmpTag.getEndIndex() < endIndex) {
                            giBuilder.removeTag(tmpTag);
                        }
                        tmpTag = tmpTag.nextTag();
                    }
                }
            }
        }
        if ((tag = currentTag) == null) {
            tag = giBuilder.includingTag(startIndex, endIndex);
        } else if (tag.getBeginIndex() > startIndex || tag.getEndIndex() < endIndex) {
            tag = giBuilder.includingTag(startIndex, endIndex);
        }
        beg = tag.getBeginIndex();
        relativeStartIndex = startIndex - beg;
        relativeEndIndex = endIndex - beg;
        if (!tag.hasSon()) {
            relativeTagText = new StringBuilder(tag.getText());
            relativeTagText.replace(relativeStartIndex, relativeEndIndex, newText);
            tag.setText((CharSequence)relativeTagText);
            return true;
        }
        current = tag.firstSon();
        if (current.getRelativeBeginIndex() < relativeStartIndex || current.getRelativeBeginIndex() < relativeEndIndex) ** GOTO lbl71
        textBefore = new StringBuilder(current.getTextBefore());
        textBefore.replace(relativeStartIndex, relativeEndIndex, newText);
        current.setTextBefore((CharSequence)textBefore);
        return true;
lbl-1000:
        // 1 sources

        {
            current = current.nextTag();
lbl71:
            // 2 sources

            ** while (current != null && current.getRelativeBeginIndex() < relativeStartIndex)
        }
lbl72:
        // 1 sources

        if (current == null) ** GOTO lbl94
        if (relativeEndIndex <= current.getRelativeBeginIndex()) {
            textBefore = new StringBuilder(current.getTextBefore());
            beg = current.previousTag().getRelativeEndIndex();
            textBefore.replace(relativeStartIndex - beg, relativeEndIndex - beg, newText);
            current.setTextBefore((CharSequence)textBefore);
            return true;
        }
        if (allowTagDeletion) {
            next = current.nextTag();
            giBuilder.removeTag(current);
            while (next != null && next.getEndIndex() < endIndex) {
                current = next.nextTag();
                giBuilder.removeTag(next);
                next = current;
            }
            MicroPatternEngine.ReplaceText(giBuilder, null, startIndex, endIndex, newText, allowTagDeletion);
        } else {
            if (MicroPatternEngine.ReplaceTextInSpecificTag(giBuilder, current, startIndex, endIndex, newText)) {
                return true;
            }
            throw new UnsupportedOperationException("MicroPatternEngine - IGenInfoBuilder : You must insert your text in one tag");
lbl94:
            // 1 sources

            if (tag.lastSon().getRelativeEndIndex() <= relativeStartIndex && tag.getEndIndex() >= endIndex) {
                textAfter = new StringBuilder(tag.lastSon().getTextAfter());
                beg = tag.lastSon().getRelativeEndIndex();
                textAfter.replace(relativeStartIndex - beg, relativeEndIndex - beg, newText);
                tag.lastSon().setTextAfter((CharSequence)textAfter);
                return true;
            }
            if (allowTagDeletion) {
                giBuilder.removeTag(tag.lastSon());
                MicroPatternEngine.ReplaceText(giBuilder, null, startIndex, endIndex, newText, allowTagDeletion);
            } else {
                if (MicroPatternEngine.ReplaceTextInSpecificTag(giBuilder, currentTag, startIndex, endIndex, newText)) {
                    return true;
                }
                throw new UnsupportedOperationException("MicroPatternEngine - IGenInfoBuilder : You must insert your text in one tag");
            }
        }
        return false;
    }

    private static boolean ReplaceTextInSpecificTag(IGenInfoBuilder giBuilder, IBuilderTag currentSpecificTag, int startIndex, int endIndex, String newText) {
        if (currentSpecificTag.getBeginIndex() > startIndex) {
            String originalText = giBuilder.getText().subSequence(startIndex, endIndex).toString();
            int beforeSpecificTag = currentSpecificTag.getBeginIndex();
            int relativeIndex = beforeSpecificTag - startIndex;
            boolean beginMatch = true;
            int currentIndex = 0;
            while (currentIndex < relativeIndex && beginMatch) {
                beginMatch = originalText.charAt(currentIndex) == newText.charAt(currentIndex);
                ++currentIndex;
            }
            if (currentIndex == relativeIndex) {
                String realNewText = newText.substring(relativeIndex);
                int realStartIndex = startIndex + relativeIndex;
                MicroPatternEngine.ReplaceText(giBuilder, null, realStartIndex, endIndex, realNewText, false);
                return true;
            }
        } else if (currentSpecificTag.getEndIndex() < endIndex) {
            StringBuilder originalTextReverse = new StringBuilder(giBuilder.getText().subSequence(startIndex, endIndex)).reverse();
            StringBuilder newTextReverse = new StringBuilder(newText).reverse();
            int afterSpecificTag = currentSpecificTag.getEndIndex();
            int relativeIndex = endIndex - afterSpecificTag;
            boolean endMatch = true;
            int currentIndex = 0;
            while (currentIndex < relativeIndex && endMatch) {
                endMatch = originalTextReverse.charAt(currentIndex) == newTextReverse.charAt(currentIndex);
                ++currentIndex;
            }
            if (currentIndex == relativeIndex) {
                newTextReverse.replace(0, relativeIndex, "");
                String realNewText = newTextReverse.reverse().toString();
                int realEndIndex = endIndex - relativeIndex;
                MicroPatternEngine.ReplaceText(giBuilder, null, startIndex, realEndIndex, realNewText, false);
                return true;
            }
        }
        return false;
    }

    private static void RemoveAllTextIn(IBuilderTag current) {
        if (current.hasSon()) {
            IBuilderTag tag = current.firstSon();
            while (tag != null) {
                tag.setTextBefore((CharSequence)"");
                MicroPatternEngine.RemoveAllTextIn(tag);
                tag.setTextAfter((CharSequence)"");
                tag = tag.nextTag();
            }
        } else {
            current.setText((CharSequence)"");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean RemoveText(IGenInfoBuilder giBuilder, IBuilderTag fromTag, int startIndex, int endIndex) {
        IBuilderTag tag = fromTag == null ? giBuilder.includingTag(startIndex, endIndex) : fromTag;
        int beg = tag.getBeginIndex();
        int relativeStartIndex = startIndex > beg ? startIndex - beg : 0;
        int relativeEndIndex = endIndex - beg;
        if (!tag.hasSon()) {
            StringBuilder relativeTagText = new StringBuilder(tag.getText());
            relativeTagText.delete(relativeStartIndex, relativeEndIndex);
            tag.setText((CharSequence)relativeTagText);
            return true;
        }
        IBuilderTag current = tag.lastSon();
        boolean finish = relativeEndIndex == relativeStartIndex;
        while (current != null && !finish) {
            IBuilderTag prev;
            int tbBegin;
            int indexEnd;
            int indexBeg;
            if (current.getRelativeBeginIndex() < relativeEndIndex && current.getRelativeEndIndex() < relativeEndIndex) {
                if (current.getRelativeEndIndex() >= relativeStartIndex) {
                    int index = relativeEndIndex - current.getRelativeEndIndex();
                    String ta = current.getTextAfter().toString();
                    ta = ta.substring(index);
                    current.setTextAfter((CharSequence)ta);
                    relativeEndIndex -= index;
                } else {
                    StringBuilder sb = new StringBuilder();
                    String ta = current.getTextAfter().toString();
                    indexBeg = relativeStartIndex - current.getRelativeEndIndex();
                    indexEnd = relativeEndIndex - current.getRelativeEndIndex();
                    sb.append(ta.substring(0, indexBeg));
                    sb.append(ta.substring(indexEnd));
                    current.setTextAfter((CharSequence)sb.toString());
                    relativeEndIndex = relativeStartIndex;
                }
            }
            boolean bl = finish = relativeEndIndex == relativeStartIndex;
            if (!finish) {
                int length;
                if (current.getRelativeEndIndex() == relativeEndIndex) {
                    if (current.getRelativeBeginIndex() < relativeStartIndex) {
                        MicroPatternEngine.RemoveText(giBuilder, current, startIndex, beg + relativeEndIndex);
                        return true;
                    }
                    length = current.getRelativeEndIndex() - current.getRelativeBeginIndex();
                    MicroPatternEngine.RemoveAllTextIn(current);
                    relativeEndIndex -= length;
                } else if (current.getRelativeEndIndex() > relativeEndIndex && current.getRelativeBeginIndex() <= relativeEndIndex) {
                    if (current.getRelativeBeginIndex() < relativeStartIndex) {
                        MicroPatternEngine.RemoveText(giBuilder, current, startIndex, beg + relativeEndIndex);
                        return true;
                    }
                    length = relativeEndIndex - current.getRelativeBeginIndex();
                    MicroPatternEngine.RemoveText(giBuilder, current, startIndex, beg + relativeEndIndex);
                    relativeEndIndex -= length;
                }
            }
            boolean bl2 = finish = relativeEndIndex == relativeStartIndex;
            if (!finish && current.getTextBefore().length() > 0 && current.getRelativeBeginIndex() >= relativeEndIndex && (indexBeg = relativeStartIndex - (tbBegin = (prev = current.previousTag()) != null ? prev.getRelativeEndIndex() : 0)) <= (indexEnd = relativeEndIndex - tbBegin) && indexBeg >= 0) {
                StringBuilder sb = new StringBuilder();
                String tb = current.getTextBefore().toString();
                sb.append(tb.substring(0, indexBeg));
                sb.append(tb.substring(indexEnd));
                current.setTextBefore((CharSequence)sb.toString());
                relativeEndIndex = relativeEndIndex - indexEnd + indexBeg;
            }
            boolean bl3 = finish = relativeEndIndex == relativeStartIndex;
            if (finish) continue;
            current = current.previousTag();
        }
        return false;
    }

    private class DefaultTracerDelegate
    implements ITracerDelegate {
        private boolean DEBUG_MODE = true;

        private DefaultTracerDelegate() {
        }

        public boolean isDebugModeEnabled() {
            return this.DEBUG_MODE;
        }

        public void info(Object sourceObject, String methodName, String message) {
            System.out.println(sourceObject == null ? "static" : String.valueOf(sourceObject.getClass().getSimpleName()) + "#" + methodName + "() I " + message);
        }

        public void debug(Object sourceObject, String methodName, String message) {
            System.out.println(sourceObject == null ? "static" : String.valueOf(sourceObject.getClass().getSimpleName()) + "#" + methodName + "() D " + message);
        }
    }

    private class MicroPatternDeclaration {
        int beginIndex;

        private MicroPatternDeclaration() {
        }

        public void setDeclarationBeginIndex(int index) {
            this.beginIndex = index;
        }

        public int getDeclarationBeginIndex() {
            return this.beginIndex;
        }
    }
}

