/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.engine.ITextArtefactLocation;
import com.ibm.pdp.engine.extension.IMicroPatternHeaderHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MicroPattern
implements IMicroPattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String id;
    private HashMap<String, String> attributeMap = new LinkedHashMap<String, String>(10);
    private IAnalyzerResult mpAnalyzerResult = null;
    private String configurationArea = "";
    private String headerDecl;
    private String headerDelimiterTag;
    private ITextArtefactLocation location;
    private IMicroPatternProcessingContext context;
    private IMicroPatternHeaderHelper headerHelper;
    private String usageId;
    private ArrayList<IMicroPattern> children;
    private boolean wellFormed;

    public String getAttribute(String attributeName) {
        return this.attributeMap.get(attributeName);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributeMap.put(attributeName, attributeValue);
    }

    public Map<String, String> getAttributes() {
        return this.attributeMap;
    }

    public IAnalyzerResult getAnalyzerResult() {
        return this.mpAnalyzerResult;
    }

    public void setAnalyzerResult(IAnalyzerResult mpAnalyzerResult) {
        this.mpAnalyzerResult = mpAnalyzerResult;
    }

    public String getConfigurationArea() {
        return this.configurationArea;
    }

    public String getOriginalHeaderDeclaration() {
        return this.headerDecl;
    }

    public String getId() {
        return this.usageId;
    }

    public String getVisibleId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.usageId = id;
    }

    public ITextArtefactLocation getLocation() {
        return this.location;
    }

    public void setConfigurationArea(String configurationArea) {
        this.configurationArea = configurationArea;
    }

    public void setHeaderDecl(String headerDecl) {
        this.headerDecl = headerDecl;
    }

    public void setLocation(ITextArtefactLocation location) {
        this.location = location;
    }

    public void setHeaderDelimiterSequence(String headerDelimiterTag) {
        this.headerDelimiterTag = headerDelimiterTag;
    }

    public String getHeaderDelimiterSequence() {
        return this.headerDelimiterTag;
    }

    public IMicroPatternProcessingContext getProcessingContext() {
        return this.context;
    }

    public void setContext(IMicroPatternProcessingContext context) {
        this.context = context;
    }

    public String getStandardHeaderArea() {
        if (this.headerHelper == null) {
            return this.getOriginalHeaderDeclaration();
        }
        return this.headerHelper.reformatStandardHeader((IMicroPattern)this, this.id);
    }

    public void setUsageId(String usageId) {
        this.usageId = usageId;
    }

    public void setHeaderHelper(IMicroPatternHeaderHelper headerHelper) {
        this.headerHelper = headerHelper;
    }

    public IMicroPatternHeaderHelper getHeaderHelper() {
        return this.headerHelper;
    }

    public List<IMicroPattern> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(IMicroPattern child) {
        if (this.children == null) {
            this.children = new ArrayList(5);
        }
        this.children.add(0, child);
    }

    public boolean isWellFormed() {
        return this.wellFormed;
    }

    public void setWellFormed(boolean wellFormed) {
        this.wellFormed = wellFormed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Beginning of MicroPattern at " + this.getLocation().toString() + (this.wellFormed ? " (ok)" : " (badly declared)"));
        sb.append("\n");
        sb.append(this.getOriginalHeaderDeclaration());
        CharSequence cs = this.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder().getText();
        int from = this.getLocation().getBeginIndex() + this.getOriginalHeaderDeclaration().length();
        sb.append((CharSequence)new StringBuilder(cs.subSequence(from, from + 20)));
        sb.append("...");
        return sb.toString();
    }
}

