/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.internal.IGenericProblem;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class GenericProblem
implements IGenericProblem {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DELIM = "!?\u00a3";
    int _beginIdx;
    int _endIdx;
    String _message;
    List<String> _parameters;
    String _markerType;
    boolean _isWarning;

    public GenericProblem() {
    }

    public GenericProblem(int beginIdx, int endIdx, String message, String markerType, boolean isWarning) {
        this.setBeginIndex(beginIdx);
        this.setEndIndex(endIdx);
        this._message = message;
        this._isWarning = isWarning;
        this._markerType = markerType;
    }

    public GenericProblem(int beginIdx, int endIdx, List<String> parameters, String markerType, boolean isWarning) {
        this.setBeginIndex(beginIdx);
        this.setEndIndex(endIdx);
        this._parameters = parameters;
        this._isWarning = isWarning;
        this._markerType = markerType;
    }

    public int beginIndex() {
        return this._beginIdx;
    }

    public void setBeginIndex(int i) {
        this._beginIdx = i;
    }

    public int endIndex() {
        return this._endIdx;
    }

    public void setEndIndex(int i) {
        this._endIdx = i;
    }

    public int length() {
        return this._endIdx - this.beginIndex();
    }

    public boolean isWarning() {
        return this._isWarning;
    }

    public void setWarning(boolean b) {
        this._isWarning = b;
    }

    public boolean isError() {
        return !this._isWarning;
    }

    public void remove() {
    }

    public String code() {
        return null;
    }

    public String[] parameters() {
        return null;
    }

    public String message() {
        return this._message;
    }

    public void setMessage(String s) {
        this._message = s;
    }

    public void setParameters(List<String> l) {
        this._parameters = l;
    }

    public Iterator<IProblem.IQuickFixAction> actions() {
        return null;
    }

    public String id() {
        return null;
    }

    public void read(XMLStreamReader xmlReader) {
        int nbOfAtt = xmlReader.getAttributeCount();
        if (nbOfAtt == 0) {
            return;
        }
        int i = 0;
        while (i < nbOfAtt) {
            String name = xmlReader.getAttributeLocalName(i);
            String value = xmlReader.getAttributeValue(i);
            if ("severity".equals(name)) {
                if ("W".equals(value)) {
                    this.setWarning(true);
                }
            } else if ("message".equals(name)) {
                this.setMessage(value);
            } else if ("parameters".equals(name)) {
                this.setParameters(this.convertParametersToList(value));
            } else if ("markerType".equals(name)) {
                this.setMarkerType(value);
            } else if ("beginIndex".equals(name)) {
                this.setBeginIndex(Integer.parseInt(value));
            } else if ("endIndex".equals(name)) {
                this.setEndIndex(Integer.parseInt(value));
            }
            ++i;
        }
    }

    public void write(XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeStartElement("Problem");
            xmlWriter.writeAttribute("beginIndex", String.valueOf(this.beginIndex()));
            xmlWriter.writeAttribute("endIndex", String.valueOf(this.endIndex()));
            xmlWriter.writeAttribute("severity", "W");
            if (this._message != null) {
                xmlWriter.writeAttribute("message", this._message);
            }
            if (this._parameters != null) {
                xmlWriter.writeAttribute("parameters", this.convertParametersToString(this._parameters));
            }
            xmlWriter.writeAttribute("markerType", this._markerType);
            xmlWriter.writeEndElement();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    public void modify(IEditTree iet) {
        if (iet.nodeFromTagName("PROCEDURE") != null) {
            if (this.beginIndex() > 0) {
                this.setBeginIndex(iet.nodeFromTagName("PROCEDURE").beginIndex());
            }
            if (this.endIndex() > 0) {
                this.setEndIndex(iet.nodeFromTagName("PROCEDURE").beginIndex());
            }
        } else {
            this.setBeginIndex(0);
            this.setEndIndex(0);
        }
    }

    public void setMarkerType(String markerType) {
        this._markerType = markerType;
    }

    public String getMarkerType() {
        return this._markerType;
    }

    public boolean isCompatibleWith(String fileName) {
        return !"com.ibm.pdp.macrooverlapping.marker".equals(this._markerType) || !fileName.endsWith(".bms");
    }

    public List<String> getParameters() {
        return this._parameters;
    }

    private String convertParametersToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            sb.append(list.get(i));
            if (i != list.size() - 1) {
                sb.append(DELIM);
            }
            ++i;
        }
        return sb.toString();
    }

    private List<String> convertParametersToList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, DELIM);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list;
    }
}

