/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.impl.GenInfo;
import com.ibm.pdp.engine.turbo.properties.PropertiesIgnoreCase;
import com.ibm.pdp.util.Iterators;
import java.util.ArrayList;
import java.util.Iterator;

public class GenTag
extends PropertiesIgnoreCase
implements IGeneratedTag {
    protected String name;
    protected GenInfo generatedInfo;
    protected GenTag parent;
    protected Object sons;
    protected int beginIndex;
    protected int endIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected GenTag() {
    }

    protected GenTag(GenInfo genInfo, String tagName) {
        if (genInfo.rootTag != null) {
            throw new RuntimeException("Wrong generated info: creation of several root tags is forbidden : " + tagName);
        }
        this.generatedInfo = genInfo;
        this.name = tagName;
        genInfo.rootTag = this;
    }

    protected GenTag(GenTag parentTag, String tagName) {
        this.generatedInfo = parentTag.generatedInfo;
        this.parent = parentTag;
        this.name = tagName;
        parentTag.addSon(this);
        this.beginIndex = this.generatedInfo.text.length();
    }

    protected GenTag(GenInfo genInfo, GenTag parentTag, IGeneratedTag tagToCopy) {
        this.generatedInfo = genInfo;
        this.parent = parentTag;
        this.name = tagToCopy.getName();
        this.copyPropertiesFrom(tagToCopy);
        int idxShift = this.indexDifference(parentTag, tagToCopy.getParent());
        this.beginIndex = tagToCopy.getBeginIndex() + idxShift;
        this.endIndex = tagToCopy.getEndIndex() + idxShift;
        this.sons = this.copySons(tagToCopy);
    }

    protected int indexDifference(IGeneratedTag left, IGeneratedTag right) {
        int leftIdx = left != null ? left.getBeginIndex() : 0;
        int rightIdx = right != null ? right.getBeginIndex() : 0;
        return leftIdx - rightIdx;
    }

    protected GenTag(GenInfo genInfo, GenTag parentTag, int beginIdx, IGeneratedTag tagToCopy) {
        this.generatedInfo = genInfo;
        this.parent = parentTag;
        this.name = tagToCopy.getName();
        this.copyPropertiesFrom(tagToCopy);
        this.beginIndex = beginIdx;
        this.endIndex = beginIdx + tagToCopy.getEndIndex() - tagToCopy.getBeginIndex();
        this.sons = this.copySons(tagToCopy);
    }

    protected Object copySons(IGeneratedTag tagToCopy) {
        if (!(tagToCopy instanceof GenTag)) {
            return tagToCopy.nbOfSons() > 0 ? tagToCopy : null;
        }
        GenTag toCopy = (GenTag)tagToCopy;
        return toCopy.sons == null || toCopy.sons instanceof IGeneratedTag ? toCopy.sons : toCopy;
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    public String getName() {
        return this.name;
    }

    public IGeneratedTag getParent() {
        return this.parent;
    }

    public int nbOfSons() {
        if (this.sons == null) {
            return 0;
        }
        if (this.sons instanceof IGeneratedTag) {
            return ((IGeneratedTag)this.sons).nbOfSons();
        }
        return ((IGeneratedTag[])this.sons).length;
    }

    public Iterator<IGeneratedTag> sons() {
        if (this.sons == null) {
            return Iterators.emptyIterator();
        }
        if (this.sons instanceof IGeneratedTag) {
            this.sons = this.createSonsArray((IGeneratedTag)this.sons);
        }
        return Iterators.iterator((Object[])((IGeneratedTag[])this.sons));
    }

    protected IGeneratedTag[] createSonsArray(IGeneratedTag peer) {
        int nbOfSons = peer.nbOfSons();
        IGeneratedTag[] array = new IGeneratedTag[nbOfSons];
        Iterator sonsIter = peer.sons();
        int i = 0;
        while (i < array.length) {
            array[i] = new GenTag(this.generatedInfo, this, (IGeneratedTag)sonsIter.next());
            ++i;
        }
        return array;
    }

    protected void copyPropertiesFrom(IGeneratedTag tag) {
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            super.setProperty(name, tag.getProperty(name));
        }
    }

    protected void addSon(IGeneratedTag newSon) {
        if (this.sons == null) {
            this.sons = new ArrayList();
        }
        ((ArrayList)this.sons).add(newSon);
    }

    protected void close() {
        this.endIndex = this.generatedInfo.text.length();
        if (this.sons instanceof ArrayList) {
            ArrayList list = (ArrayList)this.sons;
            this.sons = list.toArray(new IGeneratedTag[list.size()]);
        }
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public String toString() {
        return this.generatedInfo.getText().subSequence(this.beginIndex, this.endIndex).toString();
    }
}

