/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.ITracerDelegate;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class GenInfoUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EOL = System.getProperty("line.separator");
    private static String PreviousGenInfoName = null;
    private static StringBuilder Buffer = new StringBuilder();
    public static final String BUILD_WKS_LOC = "build.wks.loc";
    private static ITracerDelegate tracer = null;

    public static void CompareGeneratedInfosOld(IGeneratedInfo oldGenInfo, IGeneratedInfo newGenInfo) {
        if (newGenInfo == null || oldGenInfo == null) {
            return;
        }
        String currentGenInfoName = newGenInfo.getProperty("TranscientDesignFilePath");
        if (!GenInfoUtil.getTracer().isDebugModeEnabled() || currentGenInfoName == null) {
            return;
        }
        boolean suppressDouble = true;
        if (suppressDouble) {
            if (PreviousGenInfoName == null) {
                PreviousGenInfoName = currentGenInfoName;
                Buffer = new StringBuilder();
            } else {
                if (PreviousGenInfoName.equals(currentGenInfoName)) {
                    Buffer = new StringBuilder();
                    return;
                }
                if (Buffer != null && Buffer.length() != 0) {
                    GenInfoUtil.getTracer().info(null, "CompareGeneratedInfos", PreviousGenInfoName);
                    GenInfoUtil.getTracer().info(null, "       -> ", Buffer.toString());
                }
                PreviousGenInfoName = currentGenInfoName;
                Buffer = new StringBuilder();
            }
        }
        IGenInfoBuilder oldBuilder = oldGenInfo.toGeneratedInfoBuilder();
        IGenInfoBuilder newBuilder = newGenInfo.toGeneratedInfoBuilder();
        IBuilderTag oldTag = oldBuilder.getRootTag();
        IBuilderTag newTag = newBuilder.getRootTag();
        boolean continu = GenInfoUtil.CompareTags(oldTag, newTag);
        if (!suppressDouble && !continu) {
            GenInfoUtil.getTracer().info(null, "CompareGeneratedInfos", newGenInfo.getProperty("TranscientDesignFilePath"));
            GenInfoUtil.getTracer().info(null, "       -> ", Buffer.toString());
        }
    }

    public static boolean CompareTags(IBuilderTag oldTag, IBuilderTag newTag) {
        String newAscendance;
        String oldAscendance = GenInfoUtil.CalculateAscendance(oldTag);
        if (oldAscendance.equals(newAscendance = GenInfoUtil.CalculateAscendance(newTag))) {
            IBuilderTag tag = oldTag.firstSon();
            while (tag != null) {
                IBuilderTag tmpTag = newTag.getGenInfoBuilder().tagFromName(tag.getName());
                if (tmpTag != null && !GenInfoUtil.CompareTags(tag, tmpTag)) {
                    return false;
                }
                tag = tag.nextTag();
            }
        } else {
            if (!oldAscendance.contains("PROCEDURE#") && newAscendance.contains("PROCEDURE#") && oldAscendance.equals(newAscendance = newAscendance.replace("PROCEDURE#", ""))) {
                return true;
            }
            Buffer.append(String.valueOf(oldAscendance) + " / " + newAscendance);
            return false;
        }
        return true;
    }

    public static String CalculateAscendance(IBuilderTag tag) {
        StringBuilder ascendance = new StringBuilder();
        ascendance.append(tag.getName());
        while (tag.getParent() != null) {
            ascendance.append("#");
            tag = tag.getParent();
            ascendance.append(tag.getName());
        }
        return ascendance.toString();
    }

    public static void CompareGeneratedInfos(IGeneratedInfo oldGeneratedInfo, IGeneratedInfo newGeneratedInfo, TextProcessor textProcessor) {
        try {
            String transcientDesignFilePath = newGeneratedInfo.getProperty("TranscientDesignFilePath");
            String transcientCobolFilePath = newGeneratedInfo.getProperty("TranscientCobolFilePath");
            if (!GenInfoUtil.getTracer().isDebugModeEnabled() || transcientDesignFilePath == null) {
                return;
            }
            UserChangeSet oldChangeSet = textProcessor.changeSet;
            if (oldChangeSet.getChangeNature() == ChangeNature.Dirty) {
                textProcessor.getMatcher().match();
            }
            BufferedWriter writer = null;
            if (System.getProperty("MIGRATION_REPORT_FOLDER") != null) {
                String outputFileName = String.valueOf(System.getProperty("MIGRATION_REPORT_FOLDER")) + "/MigrationMiaAndRppGenInfoDiffList.csv";
                File file = new File(outputFileName);
                boolean fileExists = file.exists();
                file.getParentFile().mkdirs();
                FileWriter fstream = new FileWriter(outputFileName, fileExists);
                writer = new BufferedWriter(fstream);
                if (!fileExists) {
                    writer.write("Model;Cobol;State;Name;Leaf;Generated Code\r\n");
                }
            }
            IGeneratedTag newRootTag = newGeneratedInfo.getRootTag();
            IGeneratedTag oldRootTag = oldGeneratedInfo.getRootTag();
            LinkedList<Node> newNodes = new LinkedList<Node>();
            Node newRootNode = new Node(newRootTag);
            Node oldRootNode = new Node(oldRootTag);
            GenInfoUtil.populateListFromTags(newRootNode, newNodes);
            GenInfoUtil.populateListFromTags(oldRootNode, null);
            LinkedList<Node> newNodes2 = new LinkedList<Node>();
            Iterator iter = newNodes.iterator();
            while (iter.hasNext()) {
                newNodes2.add((Node)iter.next());
            }
            HashSet<Node> nodesDeletedInNew = new HashSet<Node>();
            HashSet<Node> nodesInsertedInNew = new HashSet<Node>();
            HashSet<Node> nodesParentDiffer = new HashSet<Node>();
            HashSet<Node> nodesOrderDiffer = new HashSet<Node>();
            HashSet<Node> nodesOrderWithoutNewDeletedDiffer = new HashSet<Node>();
            GenInfoUtil.compareInsertedAndRemovedGeneratedNodes(oldRootNode, newNodes, null, nodesDeletedInNew);
            ListIterator newNodesIter = newNodes.listIterator();
            while (newNodesIter.hasNext()) {
                Node newNode = (Node)newNodesIter.next();
                nodesInsertedInNew.add(newNode);
                newNode.isNew = true;
                GenInfoUtil.addLine(transcientDesignFilePath, transcientCobolFilePath, "new", newNode, oldChangeSet, writer);
            }
            GenInfoUtil.compareMovedNodesGeneratedNodes(oldRootNode, newNodes2, null, nodesInsertedInNew, nodesDeletedInNew, nodesParentDiffer, nodesOrderDiffer, nodesOrderWithoutNewDeletedDiffer);
            for (Node deletedNode : nodesDeletedInNew) {
                GenInfoUtil.addLine(transcientDesignFilePath, transcientCobolFilePath, "deleted", deletedNode, oldChangeSet, writer);
            }
            for (Node node : nodesParentDiffer) {
                GenInfoUtil.addLine(transcientDesignFilePath, transcientCobolFilePath, "parent", node, oldChangeSet, writer);
            }
            for (Node node : nodesOrderDiffer) {
                if (nodesDeletedInNew.contains(node)) continue;
                GenInfoUtil.addLine(transcientDesignFilePath, transcientCobolFilePath, "order", node, oldChangeSet, writer);
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addLine(String modelFileName, String cobolFileName, String type, Node node, UserChangeSet userChangeSet, BufferedWriter writer) {
        Segment segment = userChangeSet.segmentFromTagName(node.tag.getName(), 0);
        String message = String.valueOf(modelFileName) + ";" + cobolFileName + ";" + type + ";" + node.toString() + ";" + (node.nbOfSons() == 0) + ";" + (segment == null ? "true" : Boolean.valueOf(segment.getChangeNature().isGeneratedCode()));
        if (writer != null) {
            try {
                writer.write(message);
                writer.write(EOL);
            }
            catch (Exception exception) {}
        } else {
            System.out.println(message);
        }
    }

    protected boolean isBuildEnv() {
        return System.getProperty(BUILD_WKS_LOC) != null;
    }

    private static ListIterator<Node> compareInsertedAndRemovedGeneratedNodes(Node node, LinkedList<Node> list, ListIterator<Node> listIter, HashSet<Node> nodesDeletedInNew) {
        int nbSons;
        if (listIter == null) {
            listIter = list.listIterator();
        }
        boolean sameTagFound = false;
        boolean atFirstPosition = true;
        while (listIter.hasNext()) {
            Node newNode = listIter.next();
            if (newNode.name == node.name) {
                listIter.remove();
                sameTagFound = true;
                break;
            }
            atFirstPosition = false;
        }
        if (!sameTagFound || !atFirstPosition) {
            listIter = null;
        }
        if (!sameTagFound) {
            node.isDeleted = true;
            nodesDeletedInNew.add(node);
        }
        if ((nbSons = node.nbOfSons()) != 0) {
            Iterator<Node> sons = node.sons();
            while (sons.hasNext()) {
                Node son = sons.next();
                listIter = GenInfoUtil.compareInsertedAndRemovedGeneratedNodes(son, list, listIter, nodesDeletedInNew);
            }
        }
        return listIter;
    }

    private static ListIterator<Node> compareMovedNodesGeneratedNodes(Node node, LinkedList<Node> list, ListIterator<Node> listIter, HashSet<Node> nodesInsertedInNew, HashSet<Node> nodesDeletedInNew, HashSet<Node> nodesParentDiffer, HashSet<Node> nodesOrderDiffer, HashSet<Node> nodesOrderWithoutNewDeletedDiffer) {
        int nbSons;
        if (listIter == null) {
            listIter = list.listIterator();
        }
        boolean sameTagFound = false;
        boolean atFirstPosition = true;
        while (listIter.hasNext()) {
            Node newGeneratedNode = listIter.next();
            if (newGeneratedNode.name == node.name) {
                boolean result;
                listIter.remove();
                sameTagFound = true;
                if (!GenInfoUtil.isSameParent(newGeneratedNode, node)) {
                    newGeneratedNode.miaParentName = node.parent == null ? "null" : node.parent.name;
                    nodesParentDiffer.add(newGeneratedNode);
                    break;
                }
                Node p1Before = newGeneratedNode.getNodeBefore(true);
                Node p1After = newGeneratedNode.getNodeAfter(true);
                Node p2Before = node.getNodeBefore(true);
                Node p2After = node.getNodeAfter(true);
                boolean bl = result = p1Before.name == p2Before.name && p1After.name.equals(p2After.name);
                if (result) break;
                node.beforeName = p1Before.name;
                node.afterName = p1After.name;
                node.miaBeforeName = p2Before.name;
                node.miaAfterName = p2After.name;
                nodesOrderDiffer.add(node);
                break;
            }
            atFirstPosition = false;
        }
        if (!sameTagFound || !atFirstPosition) {
            listIter = null;
        }
        if ((nbSons = node.nbOfSons()) != 0) {
            Iterator<Node> sons = node.sons();
            while (sons.hasNext()) {
                Node son = sons.next();
                listIter = GenInfoUtil.compareMovedNodesGeneratedNodes(son, list, listIter, nodesInsertedInNew, nodesDeletedInNew, nodesParentDiffer, nodesOrderDiffer, nodesOrderWithoutNewDeletedDiffer);
            }
        }
        return listIter;
    }

    private static boolean isRejectedValidTag(IGeneratedTag tag) {
        return tag.getProperty("mp") != null || tag.getName().endsWith("-LTH") || tag.getName().startsWith("BATCH_WORKING_");
    }

    private static boolean isSameParent(Node node1, Node node2) {
        String s1 = String.valueOf(node1.name) + (node1.parent == null ? "" : "#" + node1.parent.name);
        String s2 = String.valueOf(node2.name) + (node2.parent == null ? "" : "#" + node2.parent.name);
        boolean result = s1.equals(s2);
        return result;
    }

    private static void populateListFromTags(Node node, List<Node> list) {
        int nbSons;
        if (list != null) {
            list.add(node);
        }
        if ((nbSons = node.tag.nbOfSons()) != 0) {
            Iterator sons = node.tag.sons();
            while (sons.hasNext()) {
                IGeneratedTag son = (IGeneratedTag)sons.next();
                if (GenInfoUtil.isRejectedValidTag(son)) continue;
                Node sonNode = new Node(son);
                node.addSon(sonNode);
                GenInfoUtil.populateListFromTags(sonNode, list);
            }
        }
    }

    private static ITracerDelegate getTracer() {
        if (tracer == null) {
            tracer = new DefaultTracerDelegate();
        }
        return tracer;
    }

    private static class DefaultTracerDelegate
    implements ITracerDelegate {
        private boolean DEBUG_MODE = "true".equals(System.getProperty("compareRppAndMiaTags"));

        private DefaultTracerDelegate() {
        }

        public boolean isDebugModeEnabled() {
            return this.DEBUG_MODE;
        }

        public void info(Object sourceObject, String methodName, String message) {
            System.out.println(String.valueOf(methodName) + " " + message);
        }

        public void debug(Object sourceObject, String methodName, String message) {
            System.out.println(String.valueOf(methodName) + " " + message);
        }
    }

    private static class Node {
        String name;
        Node parent;
        IGeneratedTag tag;
        List<Node> sons;
        boolean isNew = false;
        boolean isDeleted = false;
        public String beforeName;
        public String afterName;
        public String miaBeforeName;
        public String miaAfterName;
        public String miaParentName;

        public Node(IGeneratedTag tag) {
            this.tag = tag;
            this.name = tag.getName().intern();
        }

        private void addSon(Node son) {
            if (this.sons == null) {
                this.sons = new ArrayList<Node>();
            }
            this.sons.add(son);
            son.parent = this;
        }

        public int nbOfSons() {
            if (this.sons == null) {
                return 0;
            }
            return this.sons.size();
        }

        public Iterator<Node> sons() {
            if (this.sons == null) {
                return new ArrayList().iterator();
            }
            return this.sons.iterator();
        }

        public Node getNodeBefore(boolean ignoredNewAndDeleted) {
            if (this.parent != null) {
                List<Node> _sons = this.parent.getFilteredSons(ignoredNewAndDeleted);
                int idx = _sons.indexOf(this);
                if (idx == 0) {
                    return this.parent;
                }
                return _sons.get(idx - 1);
            }
            return this;
        }

        public Node getNodeAfter(boolean ignoredNewAndDeleted) {
            if (this.parent != null) {
                List<Node> _sons = this.parent.getFilteredSons(ignoredNewAndDeleted);
                int idx = _sons.indexOf(this);
                if (idx == _sons.size() - 1) {
                    return this.parent;
                }
                return _sons.get(idx + 1);
            }
            return this;
        }

        private List<Node> getFilteredSons(boolean ignoredNewAndDeleted) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node son : this.sons) {
                if (ignoredNewAndDeleted && (son.isDeleted || son.isNew)) continue;
                nodes.add(son);
            }
            return nodes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(50);
            builder.append(this.name);
            if (this.beforeName != null) {
                builder.append("#" + this.beforeName);
            }
            if (this.afterName != null) {
                builder.append("#" + this.afterName);
            }
            if (this.miaBeforeName != null) {
                builder.append("#" + this.miaBeforeName);
            }
            if (this.miaAfterName != null) {
                builder.append("#" + this.miaAfterName);
            }
            if (this.miaParentName != null) {
                builder.append("#" + this.parent.name + "#" + this.miaParentName);
            }
            return builder.toString();
        }
    }
}

