/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.impl.GenInfo;
import com.ibm.pdp.engine.turbo.impl.GenTag;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GenInfoFactory
implements IGeneratedInfoFactory {
    protected GenInfo currentInfo = new GenInfo();
    protected GenTag currentTag;
    protected Set<String> tagNames = new HashSet<String>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setProperty(String name, String value) {
        if (this.currentTag == null) {
            this.currentInfo.setProperty(name, value);
        } else {
            this.currentTag.setProperty(name, value);
        }
    }

    public void setProperties(Properties newProperties) {
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            this.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void beginTag(String name) {
        if (!this.tagNames.add(name)) {
            throw new RuntimeException("Wrong generated info: tags names must be unique (duplicate=" + name + ")");
        }
        this.currentTag = this.currentTag == null ? new GenTag(this.currentInfo, name) : new GenTag(this.currentTag, name);
    }

    public void beginTag(String name, Properties properties) {
        this.beginTag(name);
        this.setProperties(properties);
    }

    public void appendText(CharSequence text) {
        if (this.currentTag == null) {
            throw new RuntimeException("Wrong generated info: text outside of a tag is forbidden");
        }
        this.currentInfo.appendText(text);
    }

    public void appendTextInterval(int beginIdx, int endIdx, CharSequence text) {
        if (this.currentTag == null) {
            throw new RuntimeException("Wrong generated info: text outside of a tag is forbidden");
        }
        this.currentInfo.appendTextInterval(beginIdx, endIdx, text);
    }

    public void endTag() {
        if (this.currentTag == null) {
            throw new RuntimeException("Wrong generated info: attempt to close tag when no tag has been opened");
        }
        this.currentTag.close();
        this.currentTag = this.currentTag.parent;
    }

    public void appendTagAndText(IGeneratedTag tagToCopy) {
        GenTag newTag = new GenTag(this.currentInfo, this.currentTag, this.currentInfo.text.length(), tagToCopy);
        if (this.currentTag == null) {
            this.currentInfo.rootTag = newTag;
        } else {
            this.currentTag.addSon(newTag);
        }
    }

    public IGeneratedInfo createGeneratedInfo() {
        if (this.currentInfo.rootTag == null) {
            throw new RuntimeException("Wrong generated info: must contain a root tag");
        }
        if (this.currentTag != null) {
            throw new RuntimeException("Wrong generated info: all tags must have been closed");
        }
        this.currentInfo.close();
        GenInfo toReturn = this.currentInfo;
        this.currentInfo = new GenInfo();
        this.tagNames = new HashSet<String>();
        return toReturn;
    }
}

