/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IBuilderTree;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.turbo.core.PatchCharSequence;
import com.ibm.pdp.engine.turbo.impl.BuilderTag;
import com.ibm.pdp.engine.turbo.impl.BuilderTree;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.engine.turbo.properties.Properties;
import com.ibm.pdp.util.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenInfoBuilder
implements IGenInfoBuilder {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IGeneratedInfo generatedInfo;
    protected boolean share;
    protected BuilderTag rootTag;
    protected PatchCharSequence text;
    protected Map<String, String> properties;
    protected Map<String, IBuilderTag> tagsFromName = new HashMap<String, IBuilderTag>();
    protected boolean isInMPGenContext = false;
    protected List<IMicroPattern> allMicroPatterns;

    public GenInfoBuilder(IGeneratedInfo generatedInfo) {
        this.initialize(generatedInfo);
    }

    public IBuilderTag addTag(int beginIndex, int endIndex, String tagName) {
        Properties newTag = null;
        if (beginIndex >= 0 && beginIndex <= endIndex && endIndex <= this.rootTag.tagLength) {
            BuilderTag currentTag = null;
            if (beginIndex < endIndex) {
                currentTag = this.rootTag.searchTagBetweenIndexes(beginIndex, endIndex, 0);
            } else if (beginIndex == endIndex) {
                currentTag = this.rootTag.searchTagWithSimpleIndex(beginIndex, 0);
            }
            if (currentTag == null) {
                currentTag = this.rootTag;
            }
            int newRelativeBeginIndex = beginIndex - currentTag.getBeginIndex();
            newTag = this.instanciateBuilderTag(newRelativeBeginIndex, endIndex - beginIndex, tagName);
            ((BuilderTag)newTag).parent = currentTag;
            currentTag.insertSon((BuilderTag)newTag);
            this.share = false;
        }
        if (this.isInMPGenContext) {
            newTag.setProperty("mp", "true");
        }
        return newTag;
    }

    public IBuilderTag addTagAfter(String tagNameToCreate, String existingTagName) {
        BuilderTag newTag = null;
        BuilderTag existingTag = (BuilderTag)this.tagFromName(existingTagName);
        if (existingTag == null) {
            return null;
        }
        int creationIndex = existingTag.getRelativeEndIndex();
        newTag = this.instanciateBuilderTag(creationIndex, 0, tagNameToCreate);
        newTag.parent = existingTag.getParent();
        existingTag.getParent().insertSonAfter(newTag, existingTag);
        if (this.isInMPGenContext) {
            newTag.setProperty("mp", "true");
        }
        return newTag;
    }

    public IBuilderTag addTagBefore(String tagNameToCreate, String existingTagName) {
        BuilderTag newTag = null;
        BuilderTag existingTag = (BuilderTag)this.tagFromName(existingTagName);
        if (existingTag == null) {
            return null;
        }
        int creationIndex = existingTag.getRelativeBeginIndex();
        newTag = this.instanciateBuilderTag(creationIndex, 0, tagNameToCreate);
        newTag.parent = existingTag.getParent();
        existingTag.getParent().insertSonBefore(newTag, existingTag);
        if (this.isInMPGenContext) {
            newTag.setProperty("mp", "true");
        }
        return newTag;
    }

    public void addTree(int index, IBuilderTree tree, String parentName) {
        BuilderTag parentTag = (BuilderTag)this.tagFromName(parentName);
        if (parentTag == null) {
            return;
        }
        int parentBeginIndex = parentTag.getBeginIndex();
        if (parentBeginIndex <= index && parentTag.getEndIndex() >= index) {
            BuilderTree newTree = (BuilderTree)tree;
            String newSonTempName = String.valueOf(newTree.getRootTag().getName()) + "_tmp";
            while (this.tagFromName(newSonTempName) != null) {
                newSonTempName = String.valueOf(newSonTempName) + "_tmp";
            }
            BuilderTag newSon = this.instanciateBuilderTag(index - parentBeginIndex, 0, newSonTempName);
            newSon.parent = parentTag;
            parentTag.insertSon(newSon);
            this.share = false;
            newSon.insertSon(newTree.getRootTag());
            this.referenceTag(newTree.getRootTag());
            this.text.replace(index, index, newTree.getText());
            newSon.modifyAllIndexes(index, newTree.getText().length());
            this.removeTag(newSon);
        }
    }

    public IBuilderTag addTag(int beginIndex, int endIndex, String tagName, String parentName) {
        BuilderTag parentTag = (BuilderTag)this.tagFromName(parentName);
        if (parentTag == null) {
            return null;
        }
        int parentBeginIndex = parentTag.getBeginIndex();
        if (parentBeginIndex <= beginIndex && parentTag.getEndIndex() >= endIndex) {
            BuilderTag newSon = this.instanciateBuilderTag(beginIndex - parentBeginIndex, endIndex - beginIndex, tagName);
            newSon.parent = parentTag;
            parentTag.insertSon(newSon);
            this.share = false;
            if (this.isInMPGenContext) {
                newSon.setProperty("mp", "true");
            }
            return newSon;
        }
        return null;
    }

    public IGeneratedInfo getGeneratedInfo() {
        if (!this.share) {
            this.share = true;
            this.generatedInfo = this.toGeneratedInfo();
        }
        return this.generatedInfo;
    }

    public IBuilderTag getRootTag() {
        return this.rootTag;
    }

    public IBuilderTag tagFromName(String name) {
        return this.tagsFromName.get(name);
    }

    public IBuilderTag includingTag(int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return this.rootTag.searchTagWithSimpleIndex(beginIndex, 0);
        }
        if (beginIndex < endIndex) {
            return this.rootTag.searchTagBetweenIndexes(beginIndex, endIndex, 0);
        }
        return null;
    }

    public void removeTag(String tagName) {
        IBuilderTag tagToRemove = this.tagFromName(tagName);
        if (tagToRemove != null) {
            this.removeTag(tagToRemove);
        }
    }

    public CharSequence getText() {
        return this.text;
    }

    public String getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public Iterator<String> propertyNames() {
        return this.properties != null ? this.properties.keySet().iterator() : Iterators.emptyIterator();
    }

    public List<IMicroPattern> getMicroPatternsList() {
        return this.allMicroPatterns;
    }

    public void setMicroPatternsList(List<IMicroPattern> microPatterns) {
        this.allMicroPatterns = new ArrayList<IMicroPattern>(microPatterns.size() + 10);
        this.allMicroPatterns.addAll(microPatterns);
    }

    protected void shiftMicroPatterns(int startIndex, int difference) {
        if (difference == 0) {
            return;
        }
        if (this.allMicroPatterns != null) {
            int i = 0;
            while (i < this.allMicroPatterns.size()) {
                IMicroPattern mp = this.allMicroPatterns.get(i);
                if (mp.getLocation().getBeginIndex() >= startIndex) {
                    mp.getLocation().shift(difference);
                } else if (mp.getLocation().getEndIndex() > startIndex) {
                    mp.getLocation().shiftEnd(difference);
                }
                ++i;
            }
        }
    }

    public void removeMicroPatternFromList(IMicroPattern microPattern) {
        if (this.allMicroPatterns != null) {
            this.allMicroPatterns.remove(microPattern);
        }
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(name) && this.properties.get(name).equals(value)) {
            return;
        }
        this.share = false;
        this.properties.put(name, value);
    }

    public void removeTag(IBuilderTag tag) {
        if (tag instanceof BuilderTag) {
            BuilderTag tagToRemove = (BuilderTag)tag;
            tagToRemove.parent.removeSon(tagToRemove);
            this.unReferenceTag(tagToRemove);
        }
    }

    public IBuilderTree removeTagAndText(IBuilderTag tag) {
        if (tag.firstSon() == null) {
            return this.removeTreeAndText(tag);
        }
        if (tag instanceof BuilderTag) {
            StringBuilder newText = new StringBuilder();
            BuilderTag tagToRemove = (BuilderTag)tag;
            BuilderTag firstTag = tagToRemove.firstSon;
            BuilderTag lastTag = tagToRemove.lastSon;
            BuilderTag currentTag = firstTag;
            while (currentTag != lastTag) {
                newText.append(currentTag.getTextBefore());
                currentTag.setTextBefore("");
                currentTag = currentTag.nextTag;
            }
            newText.append(currentTag.getTextBefore());
            currentTag.setTextBefore("");
            newText.append(currentTag.getTextAfter());
            currentTag.setTextAfter("");
            BuilderTree bt = new BuilderTree();
            bt.setText(newText);
            this.removeTag(tagToRemove);
            bt.setRootTag(tagToRemove);
            this.share = false;
            return bt;
        }
        return null;
    }

    public void removeTree(IBuilderTag rootTreeTag) {
        if (rootTreeTag instanceof BuilderTag) {
            BuilderTag tagToRemove = (BuilderTag)rootTreeTag;
            tagToRemove.parent.removeSonTree(tagToRemove);
            this.share = false;
        }
    }

    public IBuilderTree removeTreeAndText(IBuilderTag rootTreeTag) {
        BuilderTree bt = null;
        if (rootTreeTag instanceof BuilderTag) {
            bt = new BuilderTree();
            int beginIndex = rootTreeTag.getBeginIndex();
            int endIndex = rootTreeTag.getEndIndex();
            BuilderTag tagToRemove = (BuilderTag)rootTreeTag;
            BuilderTag parentTag = tagToRemove.parent;
            BuilderTag nextTag = tagToRemove.nextTag;
            bt.setRootTag(tagToRemove);
            bt.setText(new StringBuilder(this.getText().subSequence(beginIndex, endIndex)));
            parentTag.removeSonTree(tagToRemove);
            this.text.delete(beginIndex, endIndex);
            int difference = beginIndex - endIndex;
            if (nextTag != null) {
                nextTag.relativeBeginIndex += difference;
                nextTag.modifyBrothersIndexesAndPropagateToParent(difference);
            } else {
                parentTag.tagLength += difference;
                parentTag.modifyBrothersIndexesAndPropagateToParent(difference);
            }
            this.share = false;
            this.shiftMicroPatterns(beginIndex, difference);
        }
        return bt;
    }

    protected BuilderTag searchTagBetweenIndexes(int beginIndex, int endIndex) {
        if (this.rootTag.firstSon == null) {
            return this.rootTag;
        }
        BuilderTag currentTag = this.rootTag.firstSon;
        int currentIndex = 0;
        BuilderTag resultTag = null;
        while (resultTag == null) {
            if ((currentIndex += currentTag.relativeBeginIndex) < beginIndex) {
                if ((currentIndex += currentTag.tagLength) < beginIndex && currentTag.nextTag != null) {
                    currentTag = currentTag.nextTag;
                }
                if (currentIndex + currentTag.tagLength >= endIndex) {
                    if (currentTag.firstSon != null) {
                        currentTag = currentTag.firstSon;
                        continue;
                    }
                    resultTag = currentTag;
                    continue;
                }
                do {
                    currentTag = currentTag.parent;
                } while ((currentIndex -= currentTag.relativeBeginIndex) + currentTag.tagLength <= endIndex);
                resultTag = currentTag;
                continue;
            }
            if (currentIndex == beginIndex) {
                if (beginIndex != endIndex) continue;
                resultTag = currentTag.parent;
                continue;
            }
            if (currentTag.nextTag == null) continue;
            currentTag = currentTag.nextTag;
        }
        return resultTag;
    }

    protected BuilderTag instanciateBuilderTag(int relativeBeginIndex, int tagLength, String tagName) {
        BuilderTag result = new BuilderTag(this);
        result.relativeBeginIndex = relativeBeginIndex;
        result.tagLength = tagLength;
        result.name = tagName;
        this.referenceTag(result);
        return result;
    }

    protected void referenceTag(BuilderTag tagToReference) {
        this.tagsFromName.put(tagToReference.getName(), tagToReference);
    }

    protected void unReferenceTag(BuilderTag tag) {
        this.tagsFromName.remove(tag.getName());
        this.share = false;
    }

    protected void unReferenceTagAndChildren(BuilderTag tag) {
        this.tagsFromName.remove(tag.getName());
        BuilderTag current = tag.firstSon;
        while (current != null) {
            this.unReferenceTagAndChildren(current);
            current = current.nextTag;
        }
        this.share = false;
    }

    protected void initialize(IGeneratedInfo generatedInfo) {
        this.visit(generatedInfo);
        this.rootTag = this.visit(generatedInfo.getRootTag(), null);
        this.text = new PatchCharSequence(generatedInfo.getText());
        this.generatedInfo = generatedInfo;
        this.share = true;
    }

    public IGeneratedInfo toGeneratedInfo() {
        GenInfoFactory genInfofactory = new GenInfoFactory();
        Iterator<String> names = this.propertyNames();
        while (names.hasNext()) {
            String name = names.next();
            if (name == null) continue;
            genInfofactory.setProperty(name, this.getProperty(name));
        }
        this.convertTag(this.rootTag, genInfofactory);
        this.share = true;
        return genInfofactory.createGeneratedInfo();
    }

    protected void convertTag(IBuilderTag tag, IGeneratedInfoFactory factory) {
        factory.beginTag(tag.getName());
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (name == null) continue;
            factory.setProperty(name, tag.getProperty(name));
        }
        IBuilderTag son = tag.firstSon();
        int previousIndex = tag.getBeginIndex();
        while (son != null) {
            if (previousIndex < son.getBeginIndex()) {
                factory.appendText(this.text.subSequence(previousIndex, son.getBeginIndex()));
            }
            this.convertTag(son, factory);
            previousIndex = son.getEndIndex();
            son = son.nextTag();
        }
        factory.appendText(this.text.subSequence(previousIndex, tag.getEndIndex()));
        factory.endTag();
    }

    protected void visit(IGeneratedInfo genInfo) {
        Iterator its = genInfo.propertyNames();
        while (its.hasNext()) {
            String name = (String)its.next();
            this.setProperty(name, genInfo.getProperty(name));
        }
    }

    protected BuilderTag visit(IGeneratedTag tag, BuilderTag tagAtBeginning) {
        BuilderTag currentTag = this.instanciateFrom(tag);
        currentTag.parent = tagAtBeginning;
        if (tagAtBeginning != null) {
            if (tagAtBeginning.firstSon != null) {
                tagAtBeginning.lastSon.nextTag = currentTag;
                currentTag.previousTag = tagAtBeginning.lastSon;
                tagAtBeginning.lastSon = currentTag;
            } else {
                tagAtBeginning.firstSon = currentTag;
                tagAtBeginning.lastSon = currentTag;
            }
        }
        Iterator it = tag.sons();
        while (it.hasNext()) {
            IGeneratedTag childTag = (IGeneratedTag)it.next();
            this.visit(childTag, currentTag);
        }
        if (tagAtBeginning == null) {
            return currentTag;
        }
        return tagAtBeginning;
    }

    protected BuilderTag instanciateFrom(IGeneratedTag tag) {
        BuilderTag result = this.instanciateBuilderTag(tag.getParent() != null ? tag.getBeginIndex() - tag.getParent().getBeginIndex() : tag.getBeginIndex(), tag.getEndIndex() - tag.getBeginIndex(), tag.getName());
        Iterator its = tag.propertyNames();
        while (its.hasNext()) {
            String name = (String)its.next();
            result.setProperty(name, tag.getProperty(name));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<GeneratedInfo ignoreCase=\"true\" freeFormatting=\"true\"><Text>");
        sb.append(this.getRootTag().toString());
        sb.append("</Text></GeneratedInfo>");
        return sb.toString();
    }

    protected void setMicroPatternGenearationProcess(boolean isInMicroPatternGenerationProcess) {
        this.isInMPGenContext = isInMicroPatternGenerationProcess;
    }
}

