/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.impl.GenInfoBuilder;
import com.ibm.pdp.engine.turbo.impl.GenTag;
import com.ibm.pdp.engine.turbo.properties.PropertiesIgnoreCase;
import com.ibm.pdp.util.Util;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GenInfo
extends PropertiesIgnoreCase
implements IGeneratedInfo {
    protected CharSequence text;
    protected GenTag rootTag;
    protected GenInfoBuilder builder;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected GenInfo() {
        this.text = new StringBuilder();
    }

    protected GenInfo(IGeneratedInfo infoToCopy) {
        this.copyPropertiesFrom(infoToCopy);
        this.text = infoToCopy.getText();
        this.rootTag = new GenTag(this, null, infoToCopy.getRootTag());
    }

    protected void copyPropertiesFrom(IGeneratedInfo info) {
        Iterator propertyNames = info.propertyNames();
        while (propertyNames.hasNext()) {
            String name = (String)propertyNames.next();
            this.setProperty(name, info.getProperty(name));
        }
    }

    public IGeneratedTag getRootTag() {
        return this.rootTag;
    }

    public CharSequence getText() {
        return this.text;
    }

    protected void appendText(CharSequence newText) {
        ((StringBuilder)this.text).append(newText);
    }

    protected void appendTextInterval(int beginIdx, int endIdx, CharSequence newText) {
        ((StringBuilder)this.text).append(newText, beginIdx, endIdx);
    }

    protected void close() {
        this.text = this.text.toString();
    }

    public IGenInfoBuilder toGeneratedInfoBuilder() {
        if (this.builder == null) {
            this.builder = new GenInfoBuilder(this);
        }
        return this.builder;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter(2 * this.getText().length());
        try {
            XMLStreamWriter stream = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            if (this.rootTag != null) {
                this.writeTag(this.rootTag, stream);
            }
            stream.flush();
        }
        catch (Exception e) {
            throw Util.rethrow((Throwable)e);
        }
        return writer.toString();
    }

    protected void writeTag(IGeneratedTag tag, XMLStreamWriter stream) throws XMLStreamException {
        stream.writeStartElement(tag.getName());
        Iterator names = tag.propertyNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            stream.writeAttribute(name, tag.getProperty(name));
        }
        int previousIdx = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            stream.writeCharacters(this.text.subSequence(previousIdx, son.getBeginIndex()).toString());
            this.writeTag(son, stream);
            previousIdx = son.getEndIndex();
        }
        stream.writeCharacters(this.text.subSequence(previousIdx, tag.getEndIndex()).toString());
        stream.writeEndElement();
    }
}

