/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.ITextSegment;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.TextNatureCursor;
import com.ibm.pdp.engine.turbo.core.TextPropertyCursor;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.impl.TextSegment;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DetailedTextSegmentIterator
implements Iterator<ITextSegment> {
    protected UserChangeSet changes;
    protected TextNatureCursor natures;
    protected TextPropertyCursor msp;
    protected TextSegment nextOne;
    protected TextSegment lastOne;
    protected static final String mspProperty = "msp";
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected DetailedTextSegmentIterator() {
    }

    protected DetailedTextSegmentIterator(TextProcessor processor) {
        this.changes = processor.getChangeSet();
        IMatcher matcher = processor.getMatcher();
        this.natures = new TextNatureCursor(this.changes);
        this.natures.setMatcher(matcher);
        this.msp = new TextPropertyCursor(this.changes);
        this.msp.setMatcher(matcher);
        this.msp.setScannedProperty(mspProperty);
    }

    protected DetailedTextSegmentIterator(TextProcessor processor, int fromIdx, int toIdx) {
        this.changes = processor.getChangeSet();
        IMatcher matcher = processor.getMatcher();
        this.natures = new TextNatureCursor(this.changes, fromIdx, toIdx);
        this.natures.setMatcher(matcher);
        this.msp = new TextPropertyCursor(this.changes, fromIdx, toIdx);
        this.msp.setMatcher(matcher);
        this.msp.setScannedProperty(mspProperty);
    }

    @Override
    public boolean hasNext() {
        return this.nextOne != null || this.findNextOne();
    }

    @Override
    public ITextSegment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("ITextProcessor.segments");
        }
        this.lastOne = this.nextOne;
        this.nextOne = null;
        return this.lastOne;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TextSegmentIterator.remove");
    }

    /*
     * Unable to fully structure code
     */
    protected boolean findNextOne() {
        if (this.lastOne != null) {
            beginIdx = this.lastOne.actualEndIdx;
            genBeginIdx = this.lastOne.referenceEndIdx;
            if (this.natures.endIndex() <= beginIdx && !this.natures.searchNextTextPortion()) {
                return this.finish();
            }
            if (this.msp.hasFoundTextPortion() && this.msp.endIndex() <= beginIdx) {
                this.msp.searchNextTextPortion();
            }
        } else if (this.natures.searchNextTextPortion()) {
            this.msp.searchNextTextPortion();
            beginIdx = this.natures.beginIndex();
            genBeginIdx = this.natures.generatedBeginIndex();
        } else {
            return this.finish();
        }
        endIdx = this.natures.endIndex();
        genEndIdx = this.natures.generatedEndIndex();
        nature = this.natures.changeNature();
        if (!nature.isUserCode() && this.msp.hasFoundTextPortion()) ** GOTO lbl24
        return this.nextTextSegment(beginIdx, endIdx, this.status(nature), genBeginIdx, genEndIdx);
lbl-1000:
        // 1 sources

        {
            if (this.msp.searchNextTextPortion()) continue;
            return this.nextTextSegment(beginIdx, endIdx, this.status(nature), genBeginIdx, genEndIdx);
lbl24:
            // 2 sources

            ** while (this.msp.endIndex() <= beginIdx)
        }
lbl25:
        // 1 sources

        if (this.msp.beginIndex() >= endIdx) {
            return this.nextTextSegment(beginIdx, endIdx, this.status(nature), genBeginIdx, genEndIdx);
        }
        if (this.msp.beginIndex() > beginIdx) {
            return this.nextTextSegment(beginIdx, this.msp.beginIndex(), this.status(nature), genBeginIdx, this.msp.generatedBeginIndex());
        }
        if (this.msp.endIndex() < endIdx) {
            return this.nextTextSegment(beginIdx, this.msp.endIndex(), this.mspStatus(nature), genBeginIdx, this.msp.generatedEndIndex());
        }
        return this.nextTextSegment(beginIdx, endIdx, this.mspStatus(nature), genBeginIdx, genEndIdx);
    }

    protected boolean nextTextSegment(int beginIdx, int endIdx, int status, int genBeginIdx, int genEndIdx) {
        this.nextOne = this.newTextSegment(beginIdx, endIdx, status, genBeginIdx, genEndIdx);
        return true;
    }

    protected TextSegment newTextSegment(int beginIdx, int endIdx, int status, int genBeginIdx, int genEndIdx) {
        return new TextSegment(this.changes.getText(), beginIdx, endIdx, status, this.changes.generatedText(), genBeginIdx, genEndIdx);
    }

    protected boolean finish() {
        this.lastOne = null;
        return false;
    }

    protected int mspStatus(ChangeNature nature) {
        return this.status(nature) | 4;
    }

    protected int status(ChangeNature nature) {
        switch (nature) {
            case Unchanged: {
                return 1;
            }
            case Reformated: {
                return 3;
            }
            case Deleted: {
                return 40;
            }
            case Inserted: {
                return 24;
            }
        }
        return 8;
    }
}

