/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.impl;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.turbo.impl.GenInfoBuilder;
import com.ibm.pdp.engine.turbo.properties.PropertiesIgnoreCase;

public class BuilderTag
extends PropertiesIgnoreCase
implements IBuilderTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int relativeBeginIndex;
    protected int tagLength;
    protected String name;
    protected GenInfoBuilder genInfoBuilder;
    protected BuilderTag parent;
    protected BuilderTag firstSon;
    protected BuilderTag previousTag;
    protected BuilderTag nextTag;
    protected BuilderTag lastSon;

    public BuilderTag(GenInfoBuilder genInfoBuilder) {
        this.genInfoBuilder = genInfoBuilder;
    }

    public int getBeginIndex() {
        int beginIndex = this.relativeBeginIndex;
        BuilderTag tag = this.parent;
        while (tag != null) {
            beginIndex += tag.relativeBeginIndex;
            tag = tag.parent;
        }
        return beginIndex;
    }

    public int getRelativeBeginIndex() {
        return this.relativeBeginIndex;
    }

    public int getEndIndex() {
        return this.getBeginIndex() + this.tagLength;
    }

    public int getRelativeEndIndex() {
        return this.relativeBeginIndex + this.tagLength;
    }

    public int getLength() {
        return this.tagLength;
    }

    public String getName() {
        return this.name;
    }

    public BuilderTag getParent() {
        return this.parent;
    }

    public IBuilderTag previousTag() {
        return this.previousTag;
    }

    public IBuilderTag nextTag() {
        return this.nextTag;
    }

    public boolean hasSon() {
        return this.firstSon != null;
    }

    public IBuilderTag firstSon() {
        return this.firstSon;
    }

    public IBuilderTag lastSon() {
        return this.lastSon;
    }

    public IGenInfoBuilder getGenInfoBuilder() {
        return this.genInfoBuilder;
    }

    public CharSequence getText() {
        return this.genInfoBuilder.text.getTextInterval(this.getBeginIndex(), this.getEndIndex());
    }

    protected int findFirstDifference(CharSequence s1, CharSequence s2) {
        int length = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < length) {
            if (s1.charAt(i) != s2.charAt(i)) {
                int j = i;
                return j;
            }
            ++i;
        }
        return length;
    }

    public void setText(CharSequence newText) {
        if (this.hasSon()) {
            return;
        }
        int difference = newText.length() - this.tagLength;
        int firstDifference = this.findFirstDifference(this.genInfoBuilder.text.getTextInterval(this.getBeginIndex(), this.getEndIndex()), newText);
        this.genInfoBuilder.text.replace(this.getBeginIndex(), this.getEndIndex(), newText);
        this.tagLength = newText.length();
        this.modifyAllIndexes(this.getBeginIndex() + firstDifference, difference);
    }

    public void setTextAfter(CharSequence newText) {
        int[] res = this.getTextAfterIndexes();
        int firstDifference = this.findFirstDifference(this.genInfoBuilder.text.getTextInterval(res[0], res[1]), newText);
        int textAfterLength = res[1] - res[0];
        int difference = newText.length() - textAfterLength;
        this.genInfoBuilder.text.replace(res[0], res[1], newText);
        this.modifyAllIndexes(res[0] + firstDifference, difference);
    }

    public CharSequence getTextAfter() {
        int[] res = this.getTextAfterIndexes();
        return this.genInfoBuilder.text.getTextInterval(res[0], res[1]);
    }

    public void setTextBefore(CharSequence newText) {
        int[] res = this.getTextBeforeIndexes();
        int firstDifference = this.findFirstDifference(this.genInfoBuilder.text.getTextInterval(res[0], res[1]), newText);
        int textBeforeLength = res[1] - res[0];
        int difference = newText.length() - textBeforeLength;
        this.genInfoBuilder.text.replace(res[0], res[1], newText);
        if (this.previousTag != null) {
            this.previousTag.modifyAllIndexes(res[0] + firstDifference, difference);
        } else {
            this.relativeBeginIndex += difference;
            this.modifyAllIndexes(res[0] + firstDifference, difference);
        }
    }

    public CharSequence getTextBefore() {
        int[] res = this.getTextBeforeIndexes();
        return this.genInfoBuilder.text.getTextInterval(res[0], res[1]);
    }

    protected int[] getTextAfterIndexes() {
        int[] res = new int[]{-1, -1};
        res[0] = this.getEndIndex();
        res[1] = this.nextTag != null ? this.nextTag.getBeginIndex() : (this.parent != null ? this.parent.getEndIndex() : this.tagLength);
        return res;
    }

    protected int[] getTextBeforeIndexes() {
        int[] res = new int[]{-1, -1};
        res[0] = this.previousTag != null ? this.previousTag.getEndIndex() : (this.parent != null ? this.parent.getBeginIndex() : 0);
        res[1] = this.getBeginIndex();
        return res;
    }

    protected void modifyAllIndexes(int startingIndex, int difference) {
        this.modifyBrothersIndexesAndPropagateToParent(difference);
        this.genInfoBuilder.share = false;
        this.genInfoBuilder.shiftMicroPatterns(startingIndex, difference);
    }

    protected void modifyBrothersIndexesAndPropagateToParent(int difference) {
        if (difference == 0) {
            return;
        }
        BuilderTag currentTag = this.nextTag;
        while (currentTag != null) {
            currentTag.relativeBeginIndex += difference;
            currentTag = currentTag.nextTag;
        }
        if (this.parent != null) {
            this.parent.tagLength += difference;
            this.parent.modifyBrothersIndexesAndPropagateToParent(difference);
        }
    }

    private boolean canInsertTag(BuilderTag newTag, BuilderTag relativeTag) {
        int begRelative = relativeTag.getRelativeBeginIndex();
        int begNew = newTag.getRelativeBeginIndex();
        if (begNew == begRelative) {
            return newTag.tagLength != 0 || relativeTag.tagLength != 0;
        }
        return begNew < begRelative;
    }

    protected void insertSon(BuilderTag newSon) {
        if (this.firstSon == null) {
            this.firstSon = newSon;
            this.lastSon = newSon;
        } else {
            BuilderTag currentTag = this.firstSon;
            while (currentTag != null && !this.canInsertTag(newSon, currentTag)) {
                currentTag = currentTag.nextTag;
            }
            if (currentTag == null) {
                this.lastSon.nextTag = newSon;
                newSon.previousTag = this.lastSon;
                this.lastSon = newSon;
            } else {
                if (currentTag.previousTag != null) {
                    currentTag.previousTag.nextTag = newSon;
                    newSon.previousTag = currentTag.previousTag;
                } else {
                    currentTag.parent.firstSon = newSon;
                }
                newSon.nextTag = currentTag;
                currentTag.previousTag = newSon;
                BuilderTag tmpTag = null;
                while (currentTag != null && currentTag.getEndIndex() <= newSon.getEndIndex()) {
                    tmpTag = currentTag.nextTag;
                    this.moveTree(currentTag, newSon);
                    currentTag = tmpTag;
                }
                newSon.nextTag = currentTag;
                if (currentTag != null) {
                    currentTag.previousTag = newSon;
                }
            }
        }
        this.genInfoBuilder.share = false;
    }

    protected void insertSonAfter(BuilderTag newSon, BuilderTag currentTag) {
        if (currentTag.nextTag != null) {
            currentTag.nextTag.previousTag = newSon;
            newSon.nextTag = currentTag.nextTag;
        } else {
            currentTag.parent.lastSon = newSon;
        }
        newSon.previousTag = currentTag;
        currentTag.nextTag = newSon;
    }

    protected void insertSonBefore(BuilderTag newSon, BuilderTag currentTag) {
        if (currentTag.previousTag != null) {
            currentTag.previousTag.nextTag = newSon;
            newSon.previousTag = currentTag.previousTag;
        } else {
            currentTag.parent.firstSon = newSon;
        }
        newSon.nextTag = currentTag;
        currentTag.previousTag = newSon;
    }

    protected void moveTree(BuilderTag rootTag, BuilderTag newParent) {
        int beginIndexBefore = rootTag.getBeginIndex();
        this.disconnectTag(rootTag);
        rootTag.parent = newParent;
        newParent.insertSon(rootTag);
        rootTag.relativeBeginIndex = beginIndexBefore - newParent.getBeginIndex();
    }

    protected void removeSon(BuilderTag tagToRemove) {
        if (tagToRemove.parent == this) {
            if (tagToRemove.firstSon != null) {
                int tagToRemoveRelativeBeginIndex = tagToRemove.relativeBeginIndex;
                BuilderTag currentTag = tagToRemove.firstSon;
                if (this.firstSon == tagToRemove) {
                    this.firstSon = currentTag;
                } else if (tagToRemove.previousTag != null) {
                    tagToRemove.previousTag.nextTag = currentTag;
                    currentTag.previousTag = tagToRemove.previousTag;
                }
                currentTag.parent = this;
                currentTag.relativeBeginIndex += tagToRemoveRelativeBeginIndex;
                if (currentTag.nextTag != null) {
                    currentTag = currentTag.nextTag;
                    while (currentTag != tagToRemove.lastSon) {
                        currentTag.parent = this;
                        currentTag.relativeBeginIndex += tagToRemoveRelativeBeginIndex;
                        currentTag = currentTag.nextTag;
                    }
                    if (this.lastSon == tagToRemove) {
                        this.lastSon = currentTag;
                    } else if (tagToRemove.nextTag != null) {
                        tagToRemove.nextTag.previousTag = currentTag;
                        currentTag.nextTag = tagToRemove.nextTag;
                    }
                    currentTag.parent = this;
                    currentTag.relativeBeginIndex += tagToRemoveRelativeBeginIndex;
                } else {
                    if (this.lastSon == tagToRemove) {
                        this.lastSon = currentTag;
                    }
                    if (tagToRemove.nextTag != null) {
                        tagToRemove.nextTag.previousTag = currentTag;
                        currentTag.nextTag = tagToRemove.nextTag;
                    }
                }
            } else {
                this.disconnectTag(tagToRemove);
            }
            tagToRemove.parent = null;
            this.genInfoBuilder.share = false;
        }
    }

    private void disconnectTag(BuilderTag tagToRemove) {
        if (this.firstSon == tagToRemove) {
            this.firstSon = tagToRemove.nextTag;
        }
        if (this.lastSon == tagToRemove) {
            this.lastSon = tagToRemove.previousTag;
        }
        if (tagToRemove.previousTag != null) {
            tagToRemove.previousTag.nextTag = tagToRemove.nextTag;
        }
        if (tagToRemove.nextTag != null) {
            tagToRemove.nextTag.previousTag = tagToRemove.previousTag;
        }
        tagToRemove.previousTag = null;
        tagToRemove.nextTag = null;
        tagToRemove.parent = null;
    }

    protected void removeSonTree(BuilderTag tagToRemove) {
        if (tagToRemove.parent == this) {
            this.disconnectTag(tagToRemove);
            tagToRemove.parent = null;
            this.genInfoBuilder.unReferenceTagAndChildren(tagToRemove);
        }
    }

    protected BuilderTag searchTagBetweenIndexes(int beginIndex, int endIndex, int currentIndex) {
        int tagBeginIndex = currentIndex + this.relativeBeginIndex;
        int tagEndIndex = tagBeginIndex + this.tagLength;
        if (tagBeginIndex <= beginIndex && tagEndIndex >= endIndex) {
            BuilderTag currentTag = this.firstSon;
            BuilderTag result = null;
            while (currentTag != null) {
                result = currentTag.searchTagBetweenIndexes(beginIndex, endIndex, tagBeginIndex);
                if (result == null) {
                    currentTag = currentTag.nextTag;
                    continue;
                }
                return result;
            }
            if (currentTag == null) {
                return this;
            }
        }
        return null;
    }

    protected BuilderTag searchTagWithSimpleIndex(int index, int currentIndex) {
        int tagBeginIndex = currentIndex + this.relativeBeginIndex;
        int tagEndIndex = tagBeginIndex + this.tagLength;
        if (tagBeginIndex < index && tagEndIndex > index) {
            BuilderTag currentTag = this.firstSon;
            while (currentTag != null) {
                BuilderTag result = currentTag.searchTagWithSimpleIndex(index, tagBeginIndex);
                if (result != null) {
                    return result;
                }
                currentTag = currentTag.nextTag;
            }
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("<Tag name=\"");
        result.append(this.getName());
        result.append("\">");
        if (this.firstSon == null) {
            result.append(this.getText());
        } else {
            BuilderTag current = this.firstSon;
            while (current != null) {
                result.append(current.getTextBefore());
                result.append(current.toString());
                current = current.nextTag;
            }
            result.append(this.lastSon.getTextAfter());
        }
        result.append("</Tag name=\"");
        result.append(this.getName());
        result.append("\">");
        return result.toString();
    }
}

