/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.tree.LightEditTree;
import java.util.Iterator;
import java.util.Set;

public class UserSyntacticInfo
extends SyntacticInfo {
    protected UserChangeSet changeSet;
    protected IEditTree lightEditTree;
    protected Set<String> acceptedTagNames;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public UserSyntacticInfo(UserChangeSet userChangeSet) {
        this.changeSet = userChangeSet;
    }

    public UserSyntacticInfo(UserChangeSet userChangeSet, ITextAnalyzer textAnalyzer) {
        super(textAnalyzer);
        this.changeSet = userChangeSet;
    }

    public Set<String> getAcceptedTagNames() {
        return this.acceptedTagNames;
    }

    public void setAcceptedTagNames(Set<String> tagNames) {
        this.acceptedTagNames = tagNames;
    }

    @Override
    public boolean acceptTagName(String tagName) {
        if (this.changeSet.segmentFromTagName(tagName, 0) != null) {
            return false;
        }
        if (this.acceptedTagNames == null) {
            return true;
        }
        return this.acceptedTagNames.contains(tagName);
    }

    @Override
    protected boolean acceptMark(int markRank) {
        return super.acceptMark(markRank);
    }

    @Override
    public synchronized void setText(CharSequence newText) {
        this.lightEditTree = null;
        super.setText(newText);
    }

    @Override
    public void setTextAnalyzer(ITextAnalyzer newAnalyzer) {
        this.lightEditTree = null;
        super.setTextAnalyzer(newAnalyzer);
    }

    @Override
    public synchronized void declareBlankPortion(int beginIdx, int endIdx) {
        this.lightEditTree = null;
        super.declareBlankPortion(beginIdx, endIdx);
    }

    @Override
    public synchronized void declareDirtyPortion(int beginIdx, int endIdx) {
        this.lightEditTree = null;
        super.declareDirtyPortion(beginIdx, endIdx);
    }

    @Override
    public synchronized void clearAll() {
        this.lightEditTree = null;
        super.clearAll();
    }

    @Override
    public synchronized void textChanged(int index, int nbRemoved, int nbAdded) {
        this.lightEditTree = null;
        super.textChanged(index, nbRemoved, nbAdded);
    }

    @Override
    public IEditTree getEditTree() {
        if (this.lightEditTree == null) {
            this.lightEditTree = new LightEditTree(this.changeSet);
        }
        return this.lightEditTree;
    }

    protected static void testEditTree(IEditTree editTree) {
        UserSyntacticInfo.showNodes(0, editTree.rootNodes());
    }

    private static void showNodes(int indent, Iterator<ITextNode> nodes) {
        while (nodes.hasNext()) {
            ITextNode node = nodes.next();
            int i = 0;
            while (i < indent) {
                System.out.print(' ');
                ++i;
            }
            String status = "";
            switch (node.getTextStatus()) {
                case Deleted: {
                    status = "-";
                    break;
                }
                case Inserted: {
                    status = "+";
                    break;
                }
                case Modified: {
                    status = "*";
                    break;
                }
                case Reformated: {
                    status = "~";
                    break;
                }
                case Unchanged: {
                    status = "=";
                }
            }
            System.out.println(String.valueOf(status) + node.getLabel());
            UserSyntacticInfo.showNodes(indent + 4, node.sons());
            if (node.getTextStatus() != TextStatus.Deleted && node.getTextStatus() != TextStatus.Modified) continue;
            System.out.println("<<<");
            System.out.println(node.generatedText());
            System.out.println(">>>");
        }
    }
}

