/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.turbo.EngineFactory;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.util.RandomBuilder;
import java.util.Iterator;

public class UserChangeSetTest {
    protected static RandomBuilder random;
    protected static final IEngineFactory engine;
    protected static int checkCount;
    protected static final char[] alphabet;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        engine = new EngineFactory();
        alphabet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\"', '_', '-', '/', '.', ',', ';', ':', '+', '*', '!', '#', '%', '&', '?', '|', '~', '$', '<', '>', '=', '(', ')', '[', ']', '{', '}', ' '};
    }

    public static void main(String[] args) {
        long seed = System.currentTimeMillis();
        random = new RandomBuilder(seed);
        System.out.println("Start, seed=" + seed + "L");
        UserChangeSetTest.test();
        System.out.println("Stop");
    }

    protected static void test() {
        try {
            UserChangeSet changeSet = new UserChangeSet();
            IGeneratedInfo generatedInfo = UserChangeSetTest.makeGeneratedInfo(100);
            changeSet.setGeneratedInfo(generatedInfo);
            UserChangeSetTest.checkChange(changeSet);
        }
        catch (Throwable t) {
            System.out.println("Error after check #" + checkCount + ":");
            t.printStackTrace(System.out);
        }
    }

    protected static void checkChange(UserChangeSet changeSet) {
        int repeat = 0;
        while (repeat < 1000) {
            UserChangeSetTest.makeOneChange(changeSet);
            ++repeat;
        }
        repeat = 0;
        while (repeat < 1000) {
            UserChangeSetTest.makeTwoChanges(changeSet);
            ++repeat;
        }
        repeat = 0;
        while (repeat < 1000) {
            UserChangeSetTest.makeBigChange(changeSet);
            ++repeat;
        }
    }

    protected static void checkBlankSegments(UserChangeSet changeSet) {
        Segment first = changeSet.atomAt(0);
        Segment last = changeSet.atomAt(changeSet.nbOfAtomicSegments() - 1);
        UserChangeSetTest.check(first.isBlank());
        UserChangeSetTest.check(last.isBlank());
        Iterator<Segment> atoms = changeSet.segments(changeSet.newSegmentSelection(true, first, false, last, false, false));
        while (atoms.hasNext()) {
            Segment atom = atoms.next();
            UserChangeSetTest.check(!atom.isBlank());
        }
    }

    protected static void makeOneChange(UserChangeSet changeSet) {
        int rank = random.nextInt(changeSet.nbOfAtomicSegments());
        Segment segment = changeSet.atomAt(rank);
        CharSequence oldText = segment.getText();
        int action = random.nextInt(3);
        ChangeNature change = null;
        switch (action) {
            case 0: {
                UserChangeSetTest.touch(segment);
                change = ChangeNature.Unchanged;
                break;
            }
            case 1: {
                UserChangeSetTest.reformat(segment);
                change = ChangeNature.Reformated;
                break;
            }
            case 2: {
                UserChangeSetTest.modify(segment);
                change = ChangeNature.Modified;
            }
        }
        UserChangeSetTest.checkSingleChangeNature(segment, ChangeNature.Dirty);
        segment.setChangeNature(change);
        UserChangeSetTest.undirtyTouching(segment);
        UserChangeSetTest.checkSingleChangeNature(segment, change);
        if (change != ChangeNature.Unchanged) {
            segment.setText(oldText);
            UserChangeSetTest.undirtyTouching(segment);
        }
        segment.setChangeNature(ChangeNature.Unchanged);
        UserChangeSetTest.checkSingleChangeNature(segment, ChangeNature.Unchanged);
    }

    protected static void makeTwoChanges(UserChangeSet changeSet) {
        int rank1 = random.nextInt(changeSet.nbOfAtomicSegments());
        Segment segment1 = changeSet.atomAt(rank1);
        CharSequence oldText1 = segment1.getText();
        int action1 = random.nextInt(3);
        ChangeNature change1 = null;
        switch (action1) {
            case 0: {
                UserChangeSetTest.touch(segment1);
                change1 = ChangeNature.Unchanged;
                break;
            }
            case 1: {
                UserChangeSetTest.reformat(segment1);
                change1 = ChangeNature.Reformated;
                break;
            }
            case 2: {
                UserChangeSetTest.modify(segment1);
                change1 = ChangeNature.Modified;
            }
        }
        int rank2 = random.nextInt(changeSet.nbOfAtomicSegments());
        Segment segment2 = changeSet.atomAt(rank2);
        CharSequence oldText2 = segment2.getText();
        int action2 = random.nextInt(3);
        ChangeNature change2 = null;
        switch (action2) {
            case 0: {
                UserChangeSetTest.touch(segment2);
                change2 = ChangeNature.Unchanged;
                break;
            }
            case 1: {
                UserChangeSetTest.reformat(segment2);
                change2 = ChangeNature.Reformated;
                break;
            }
            case 2: {
                UserChangeSetTest.modify(segment2);
                change2 = ChangeNature.Modified;
            }
        }
        UserChangeSetTest.checkDoubleChangeNature(segment1, ChangeNature.Dirty, segment2, ChangeNature.Dirty);
        if (segment1 == segment2) {
            segment1.setChangeNature(action1 > action2 ? change1 : change2);
            UserChangeSetTest.undirtyTouching(segment1);
        } else {
            segment1.setChangeNature(change1);
            segment2.setChangeNature(change2);
            UserChangeSetTest.undirtyTouching(segment1);
            UserChangeSetTest.undirtyTouching(segment2);
        }
        UserChangeSetTest.checkDoubleChangeNature(segment1, change1, segment2, change2);
        if (segment1 == segment2) {
            segment1.setText(oldText1);
            UserChangeSetTest.undirtyTouching(segment1);
        } else {
            segment1.setText(oldText1);
            segment2.setText(oldText2);
            UserChangeSetTest.undirtyTouching(segment1);
            UserChangeSetTest.undirtyTouching(segment2);
        }
        segment1.setChangeNature(ChangeNature.Unchanged);
        segment2.setChangeNature(ChangeNature.Unchanged);
        UserChangeSetTest.checkDoubleChangeNature(segment1, ChangeNature.Unchanged, segment2, ChangeNature.Unchanged);
    }

    protected static void makeBigChange(UserChangeSet changeSet) {
        int changeLength = random.quantity(changeSet.length());
        int changeIdx = random.nextInt(changeSet.length() - changeLength);
        int newLength = random.quantity(changeSet.length());
        String newText = random.randomString(newLength, alphabet);
        CharSequence oldText = changeSet.getText().subSequence(changeIdx, changeIdx + changeLength);
        changeSet.replaceText(changeIdx, changeIdx + changeLength, newText);
        ChangeNature newNature = ChangeNature.values()[1 + random.nextInt(ChangeNature.values().length - 1)];
        int minLength = Math.min(changeLength, newLength);
        int sameBeginLength = 0;
        while (sameBeginLength < minLength && newText.charAt(sameBeginLength) == oldText.charAt(sameBeginLength)) {
            ++sameBeginLength;
        }
        if (changeLength == newLength && sameBeginLength == changeLength) {
            UserChangeSetTest.check(changeSet.getChangeNature() == ChangeNature.Unchanged);
            return;
        }
        int sameEndLength = 0;
        while (sameEndLength < minLength && newText.charAt(newLength - sameEndLength - 1) == oldText.charAt(changeLength - sameEndLength - 1)) {
            ++sameEndLength;
        }
        int firstChangeIdx = changeIdx + sameBeginLength;
        int lastChangeIdx = changeIdx + newLength - sameEndLength;
        int previousRank = -1;
        int maxIdx = 0;
        Iterator<Segment> changedSegments = changeSet.changedAtomicSegments();
        while (changedSegments.hasNext()) {
            Segment segment = changedSegments.next();
            int rank = segment.minRank();
            if (previousRank != -1) {
                UserChangeSetTest.check(rank == previousRank + 1);
            } else {
                UserChangeSetTest.check(segment.beginIndex() <= firstChangeIdx);
            }
            previousRank = rank;
            maxIdx = segment.endIndex();
            UserChangeSetTest.check(segment.getChangeNature() == ChangeNature.Dirty);
            segment.setChangeNature(newNature);
        }
        UserChangeSetTest.check(maxIdx >= lastChangeIdx);
        UserChangeSetTest.check(changeSet.getChangeNature().changeLevel() == newNature.changeLevel());
        changeSet.restoreGeneratedText(changeIdx, changeIdx + newLength);
        UserChangeSetTest.check(changeSet.getText().subSequence(changeIdx, changeIdx + changeLength).equals(oldText));
        if (changeSet.atomAt(0).getChangeNature() != ChangeNature.Unchanged) {
            changeSet.atomAt(0).setChangeNature(ChangeNature.Unchanged);
        }
        if (changeSet.atomAt(changeSet.nbOfAtomicSegments() - 1).getChangeNature() != ChangeNature.Unchanged) {
            changeSet.atomAt(changeSet.nbOfAtomicSegments() - 1).setChangeNature(ChangeNature.Unchanged);
        }
        UserChangeSetTest.check(changeSet.getChangeNature() == ChangeNature.Unchanged);
    }

    protected static void undirtyTouching(Segment dirtySegment) {
        Segment previous = dirtySegment.previousAtom();
        while (previous != null && previous.getChangeNature() == ChangeNature.Dirty) {
            previous.setChangeNature(ChangeNature.Unchanged);
            previous = previous.previousAtom();
        }
        Segment next = dirtySegment.nextAtom();
        while (next != null && next.getChangeNature() == ChangeNature.Dirty) {
            next.setChangeNature(ChangeNature.Unchanged);
            next = next.nextAtom();
        }
    }

    protected static void touch(Segment atom) {
        CharSequence oldText = atom.getText();
        atom.setText("Other text");
        atom.setText(oldText);
    }

    protected static void reformat(Segment atom) {
        CharSequence oldText = atom.getText();
        StringBuilder newText = new StringBuilder(oldText.length());
        int i = 0;
        while (i < oldText.length()) {
            char c = oldText.charAt(i);
            if (c == ' ') {
                newText.append("  ");
            } else {
                newText.append(c);
            }
            ++i;
        }
        newText.append(' ');
        atom.setText(newText.toString());
    }

    protected static void modify(Segment atom) {
        atom.setText("Modified text");
    }

    protected static void checkSingleChangeNature(Segment segment, ChangeNature expectedNature) {
        UserChangeSetTest.check(segment.getTreeChangeNature() == expectedNature);
        Segment ancestor = segment.parent();
        if (ancestor != null) {
            UserChangeSetTest.check(ancestor.getTreeChangeNature() == expectedNature);
            if (segment.isPart()) {
                UserChangeSetTest.check(ancestor.getChangeNature() == expectedNature);
                UserChangeSetTest.check(ancestor.getSubtreesChangeNature() == ChangeNature.Unchanged);
            } else {
                UserChangeSetTest.check(ancestor.getSubtreesChangeNature() == expectedNature);
            }
            while ((ancestor = ancestor.parent()) != null) {
                UserChangeSetTest.check(ancestor.getTreeChangeNature() == expectedNature);
            }
        }
        UserChangeSetTest.check(segment.getChangeSet().getChangeNature() == expectedNature);
    }

    protected static void checkDoubleChangeNature(Segment segment1, ChangeNature expectedNature1, Segment segment2, ChangeNature expectedNature2) {
        boolean segment1Stronger;
        boolean bl = segment1Stronger = expectedNature1.ordinal() > expectedNature2.ordinal();
        if (segment1 == segment2) {
            UserChangeSetTest.checkSingleChangeNature(segment1, segment1Stronger ? expectedNature1 : expectedNature2);
            return;
        }
        UserChangeSetTest.check(segment1.getChangeNature() == expectedNature1);
        UserChangeSetTest.check(segment2.getChangeNature() == expectedNature2);
        boolean part1 = segment1.isPart();
        while (segment1.generatedLevel() > segment2.generatedLevel()) {
            segment1 = segment1.parent();
            if (part1) {
                UserChangeSetTest.check(segment1.getChangeNature() == expectedNature1);
                UserChangeSetTest.check(segment1.getSubtreesChangeNature() == ChangeNature.Unchanged);
                part1 = false;
                continue;
            }
            UserChangeSetTest.check(segment1.getSubtreesChangeNature() == expectedNature1);
        }
        boolean part2 = segment2.isPart();
        while (segment2.generatedLevel() > segment1.generatedLevel()) {
            segment2 = segment2.parent();
            if (part2) {
                UserChangeSetTest.check(segment2.getChangeNature() == expectedNature2);
                UserChangeSetTest.check(segment2.getSubtreesChangeNature() == ChangeNature.Unchanged);
                part2 = false;
                continue;
            }
            UserChangeSetTest.check(segment2.getSubtreesChangeNature() == expectedNature2);
        }
        segment1 = segment1.parent();
        segment2 = segment2.parent();
        while (segment1 != null && segment2 != null && segment1 != segment2) {
            if (part1) {
                UserChangeSetTest.check(segment1.getChangeNature() == expectedNature1);
                UserChangeSetTest.check(segment1.getSubtreesChangeNature() == ChangeNature.Unchanged);
                part1 = false;
            } else {
                UserChangeSetTest.check(segment1.getSubtreesChangeNature() == expectedNature1);
            }
            if (part2) {
                UserChangeSetTest.check(segment2.getChangeNature() == expectedNature2);
                UserChangeSetTest.check(segment2.getSubtreesChangeNature() == ChangeNature.Unchanged);
                part2 = false;
            } else {
                UserChangeSetTest.check(segment2.getSubtreesChangeNature() == expectedNature2);
            }
            segment1 = segment1.parent();
            segment2 = segment2.parent();
        }
        if (segment1 != segment2) {
            if (segment1 == null) {
                if (segment1Stronger) {
                    UserChangeSetTest.check(segment2.getChangeSet().getChangeNature() == expectedNature1);
                } else {
                    UserChangeSetTest.checkSingleChangeNature(segment2, expectedNature2);
                }
            } else if (segment2 == null) {
                if (segment1Stronger) {
                    UserChangeSetTest.checkSingleChangeNature(segment1, expectedNature1);
                } else {
                    UserChangeSetTest.check(segment1.getChangeSet().getChangeNature() == expectedNature2);
                }
            }
        } else if (segment1 != null) {
            UserChangeSetTest.checkSingleChangeNature(segment1, segment1Stronger ? expectedNature1 : expectedNature2);
        }
    }

    protected static void check(boolean condition) {
        ++checkCount;
        if (!condition) {
            throw new RuntimeException("Wrong check #" + checkCount);
        }
    }

    protected static IGeneratedInfo makeGeneratedInfo(int complexity) {
        IGeneratedInfoFactory factory = engine.newGeneratedInfoFactory();
        factory.beginTag("T0");
        UserChangeSetTest.makeSubTags(factory, 1, complexity, 0);
        factory.endTag();
        return factory.createGeneratedInfo();
    }

    protected static int makeSubTags(IGeneratedInfoFactory factory, int level, int complexity, int tagCount) {
        String enclosingTag = "T" + tagCount;
        if (complexity == 0) {
            UserChangeSetTest.appendText(factory, level, enclosingTag, enclosingTag, enclosingTag);
            return tagCount;
        }
        String fromTag = enclosingTag;
        String toTag = "T" + ++tagCount;
        UserChangeSetTest.appendText(factory, level, enclosingTag, fromTag, toTag);
        int t = 0;
        while (t < complexity - 1) {
            factory.beginTag(toTag);
            tagCount = UserChangeSetTest.makeSubTags(factory, level + 1, complexity / 10, tagCount);
            factory.endTag();
            fromTag = toTag;
            toTag = "T" + ++tagCount;
            UserChangeSetTest.appendText(factory, level, enclosingTag, fromTag, toTag);
            ++t;
        }
        factory.beginTag(toTag);
        tagCount = UserChangeSetTest.makeSubTags(factory, level + 1, complexity / 10, tagCount);
        factory.endTag();
        UserChangeSetTest.appendText(factory, level, enclosingTag, toTag, enclosingTag);
        return tagCount;
    }

    protected static void appendText(IGeneratedInfoFactory factory, int level, String enclosingTag, String fromTag, String toTag) {
        boolean fromEqualsTo = fromTag.equals(toTag);
        if (enclosingTag.equals(fromTag)) {
            if (fromEqualsTo) {
                factory.appendText((CharSequence)"[Tag ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)"]");
            } else {
                factory.appendText((CharSequence)"[First part of ");
                factory.appendText((CharSequence)enclosingTag);
                factory.appendText((CharSequence)" before ");
                factory.appendText((CharSequence)toTag);
                factory.appendText((CharSequence)"\n");
                UserChangeSetTest.indent(factory, level);
            }
        } else if (enclosingTag.equals(toTag)) {
            factory.appendText((CharSequence)"\n");
            UserChangeSetTest.indent(factory, level);
            factory.appendText((CharSequence)"Last part of ");
            factory.appendText((CharSequence)enclosingTag);
            factory.appendText((CharSequence)" after ");
            factory.appendText((CharSequence)fromTag);
            factory.appendText((CharSequence)"]");
        } else {
            factory.appendText((CharSequence)"\n");
            UserChangeSetTest.indent(factory, level);
            factory.appendText((CharSequence)"Middle part of ");
            factory.appendText((CharSequence)enclosingTag);
            factory.appendText((CharSequence)" between ");
            factory.appendText((CharSequence)fromTag);
            factory.appendText((CharSequence)" and ");
            factory.appendText((CharSequence)toTag);
            factory.appendText((CharSequence)"\n");
            UserChangeSetTest.indent(factory, level);
        }
    }

    protected static void indent(IGeneratedInfoFactory factory, int level) {
        int i = 0;
        while (i < level) {
            factory.appendText((CharSequence)"    ");
            ++i;
        }
    }
}

