/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.extension.DefaultTextPartitioner;
import com.ibm.pdp.engine.extension.IEditTreeExtension;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.turbo.core.AtomicPartSegment;
import com.ibm.pdp.engine.turbo.core.AtomicSegment;
import com.ibm.pdp.engine.turbo.core.AtomicSegmentIterator;
import com.ibm.pdp.engine.turbo.core.AtomicTagSegment;
import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.FilteredAtomicSegmentIterator;
import com.ibm.pdp.engine.turbo.core.FilteredSegmentIterator;
import com.ibm.pdp.engine.turbo.core.HierarchicSegment;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.IncrementalTextPartition;
import com.ibm.pdp.engine.turbo.core.PatchCharSequence;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;
import com.ibm.pdp.engine.turbo.core.SegmentIterator;
import com.ibm.pdp.engine.turbo.core.SegmentSelectionParameter;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticPartSegment;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.TopSegment;
import com.ibm.pdp.engine.turbo.core.UserSyntacticInfo;
import com.ibm.pdp.engine.turbo.core.VoidTextPartitioner;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.engine.turbo.impl.TextProcessor;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.util.Interval;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.containers.ArraySortedSet;
import com.ibm.pdp.util.containers.EditBuffer;
import com.ibm.pdp.util.containers.ListSortedSet;
import com.ibm.pdp.util.sort.AbstractRangeComparator;
import com.ibm.pdp.util.sort.RangeComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UserChangeSet {
    protected TextProcessor processor;
    protected IGeneratedInfo generatedInfo;
    protected ListSortedSet<AtomicSegment> atomSet;
    protected Object[] atomArray;
    protected int nbAtom;
    protected int nbLevel;
    protected TopSegment topSegment;
    protected Segment[] rootSegments;
    protected Map<String, Segment> tagNameToSegment;
    protected Map<String, Segment> syntacticTagNameToSegment;
    protected TagProperties generatedProperties;
    protected Dictionary dictionary;
    protected ITextPartition generatedPartition;
    protected ITextPartition partition;
    protected int gapBeginRank;
    protected int indexGap;
    protected int status;
    protected int changesCount;
    protected UserSyntacticInfo syntacticInfo;
    protected PatchCharSequence text;
    protected boolean silent;
    protected SegmentSelectionParameter emptySelectionParameter;
    protected SegmentSelectionParameter changedAtomsSelectionParameter;
    protected SegmentSelectionParameter changedSegmentsSelectionParameter;
    protected static SegmentFilter changedSegmentFilter;
    protected static SegmentFilter changedAtomSegmentFilter;
    protected static SegmentFilter modifiedSegmentFilter;
    protected static SegmentFilter dirtySegmentFilter;
    protected static Comparator<AtomicSegment> atomicSegmentComparator;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public UserChangeSet() {
        this.topSegment = this.newTopSegment();
        this.text = new PatchCharSequence();
    }

    public UserChangeSet(TextProcessor textProcessor) {
        this.processor = textProcessor;
        this.topSegment = this.newTopSegment();
        this.text = new PatchCharSequence();
    }

    public UserChangeSet(TextProcessor textProcessor, IGeneratedInfo initialGenInfo) {
        this.processor = textProcessor;
        this.topSegment = this.newTopSegment();
        this.text = new PatchCharSequence();
        this.setGeneratedInfo(initialGenInfo);
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean newSilent) {
        this.silent = newSilent;
    }

    public TextProcessor getTextProcessor() {
        return this.processor;
    }

    public void setTextProcessor(TextProcessor newProcessor) {
        this.processor = newProcessor;
    }

    protected ITextPartitioner newTextPartitioner() {
        if (this.generatedInfo == null) {
            return new VoidTextPartitioner();
        }
        return this.processor != null ? this.processor.newTextPartitioner() : new DefaultTextPartitioner();
    }

    public Dictionary getDictionary() {
        if (this.dictionary == null) {
            this.dictionary = this.newDictionary();
        }
        return this.dictionary;
    }

    protected Dictionary newDictionary() {
        return new Dictionary();
    }

    public void setDictionary(Dictionary newDictionary) {
        this.dictionary = newDictionary;
    }

    public IGeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    public void setGeneratedInfo(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.clearSegments();
            this.clearGeneratedText();
        } else {
            this.initSegments(newGeneratedInfo);
            this.setGeneratedText(newGeneratedInfo.getText());
        }
    }

    public void setGeneratedInfoKeepActualText(IGeneratedInfo newGeneratedInfo) {
        if (newGeneratedInfo == null) {
            this.clearSegments();
            this.clearGeneratedText();
        } else {
            this.initSegments(newGeneratedInfo);
            this.setGeneratedTextKeepActualText(newGeneratedInfo.getText());
        }
    }

    public TagProperties getGeneratedProperties() {
        if (this.generatedProperties == null) {
            this.generatedProperties = this.newGeneratedProperties();
        }
        return this.generatedProperties;
    }

    protected void clearGeneratedText() {
        if (this.generatedPartition == null) {
            return;
        }
        if (this.partition != this.generatedPartition) {
            this.clearHiddenGeneratedText();
            return;
        }
        this.text.setText("");
        if (this.isActive()) {
            CharSequence oldText = this.partition.getText();
            this.generatedPartition = null;
            this.partition = null;
            this.fireEvent(oldText, "", 0);
        } else {
            this.generatedPartition = null;
            this.partition = null;
        }
    }

    protected void clearHiddenGeneratedText() {
        this.generatedPartition = null;
        if (this.isActive()) {
            CharSequence currentText = this.partition.getText();
            this.fireEvent(currentText, currentText, 0);
        }
    }

    protected void setGeneratedText(CharSequence newGeneratedText) {
        if (this.generatedPartition == null) {
            this.generatedPartition = this.newGeneratedTextPartition();
        }
        if (this.partition != this.generatedPartition) {
            if (this.partition != null) {
                this.setHiddenGeneratedText(newGeneratedText);
                return;
            }
            this.partition = this.generatedPartition;
        }
        this.text.setText(newGeneratedText);
        if (this.isActive()) {
            CharSequence oldText = this.generatedPartition.getText();
            this.generatedPartition.setText(newGeneratedText);
            this.fireEvent(oldText, newGeneratedText, 0);
        } else {
            this.generatedPartition.setText(newGeneratedText);
        }
    }

    protected void setGeneratedTextKeepActualText(CharSequence newGeneratedText) {
        if (this.generatedPartition == null) {
            this.generatedPartition = this.newGeneratedTextPartition();
        }
        if (this.partition == null || this.partition == this.generatedPartition) {
            this.partition = this.newActualTextPartition();
        }
        this.setHiddenGeneratedText(newGeneratedText);
    }

    protected void setHiddenGeneratedText(CharSequence newGeneratedText) {
        this.generatedPartition.setText(newGeneratedText);
        this.touchSegmentsNoLengthVariation(0, this.nbAtom);
    }

    protected ITextPartition newGeneratedTextPartition() {
        return new BasicTextPartition(this.getDictionary(), this.newTextPartitioner());
    }

    protected void clearSegments() {
        this.generatedInfo = null;
        this.generatedProperties = null;
        this.atomSet = null;
        this.atomArray = null;
        this.nbAtom = 0;
        this.nbLevel = 0;
        this.rootSegments = null;
        this.tagNameToSegment = null;
        this.clearIndexGap();
        this.changesCount = 0;
        this.changedAtomsSelectionParameter = null;
        this.changedSegmentsSelectionParameter = null;
        this.emptySelectionParameter = null;
    }

    protected void initSegments(IGeneratedInfo newGeneratedInfo) {
        this.generatedInfo = newGeneratedInfo;
        this.generatedProperties = null;
        GetArraySortedSet<AtomicSegment> atoms = new GetArraySortedSet<AtomicSegment>(this.getAtomicSegmentComparator());
        this.atomSet = atoms;
        this.atomArray = null;
        this.nbAtom = 0;
        this.nbLevel = 0;
        this.rootSegments = null;
        this.topSegment.subSegments = null;
        this.tagNameToSegment = this.newNameToSegmentMap();
        this.makeSegments();
        atoms.compact();
        this.atomArray = atoms.getArray();
        this.clearIndexGap();
        this.changesCount = 0;
        this.changedAtomsSelectionParameter = null;
        this.changedSegmentsSelectionParameter = null;
        this.emptySelectionParameter = null;
    }

    protected void makeSegments() {
        IGeneratedTag rootTag = this.generatedInfo.getRootTag();
        Segment rootSegment = this.makeSegmentsForTag(null, null, rootTag);
        AtomicPartSegment lastPart = this.newAtomicPartSegment(null, rootSegment, null);
        lastPart.rank = this.nbAtom++;
        this.atomSet.asList().add(lastPart);
    }

    protected Segment makeSegmentsForTag(HierarchicSegment parent, Segment previous, IGeneratedTag tag) {
        if (tag.nbOfSons() == 0) {
            return this.makeSegmentsForAtomicTag(parent, previous, tag);
        }
        HierarchicSegment tagSegment = this.newHierarchicSegment(parent, tag);
        AtomicPartSegment previousPart = this.newAtomicPartSegment(parent, previous, tagSegment);
        previousPart.rank = this.nbAtom++;
        this.atomSet.asList().add(previousPart);
        tagSegment.minRank = this.nbAtom;
        this.tagNameToSegment.put(tag.getName(), tagSegment);
        this.makeSegmentsForSonTags(tagSegment, tag.sons());
        tagSegment.maxRank = this.nbAtom - 1;
        return tagSegment;
    }

    protected void makeSegmentsForSonTags(HierarchicSegment parent, Iterator<IGeneratedTag> sonTags) {
        Segment previous = parent;
        while (sonTags.hasNext()) {
            IGeneratedTag nextSonTag = sonTags.next();
            previous = this.makeSegmentsForTag(parent, previous, nextSonTag);
        }
        AtomicPartSegment lastPart = this.newAtomicPartSegment(parent, previous, parent);
        lastPart.rank = this.nbAtom++;
        this.atomSet.asList().add(lastPart);
    }

    protected AtomicTagSegment makeSegmentsForAtomicTag(HierarchicSegment parent, Segment previous, IGeneratedTag tag) {
        AtomicTagSegment taggedAtom = this.newAtomicTagSegment(parent, tag);
        AtomicPartSegment previousPart = this.newAtomicPartSegment(parent, previous, taggedAtom);
        previousPart.rank = this.nbAtom++;
        this.atomSet.asList().add(previousPart);
        taggedAtom.rank = this.nbAtom++;
        this.atomSet.asList().add(taggedAtom);
        this.tagNameToSegment.put(tag.getName(), taggedAtom);
        return taggedAtom;
    }

    public int length() {
        return this.partition != null ? this.partition.getTextLength() : 0;
    }

    public CharSequence getText() {
        return this.partition != null ? this.partition.getText() : "";
    }

    public void setText(CharSequence newText) {
        this.setText(newText, true);
    }

    public void setText(CharSequence newText, boolean fireEvent) {
        if (this.generatedInfo != null) {
            CharSequence oldText = this.partition.getText();
            int oldLength = oldText.length();
            int newLength = newText.length();
            int commonEndLength = this.commonEndLength(oldText, newText);
            if (oldLength == newLength && commonEndLength == oldLength) {
                return;
            }
            this.touchAllSegments(oldLength - commonEndLength, newLength - commonEndLength);
        }
        this.setActualText(newText, fireEvent);
    }

    protected void touchAllSegments(int oldCommonTailIdx, int newCommonTailIdx) {
        if (oldCommonTailIdx == newCommonTailIdx) {
            this.touchSegmentsNoLengthVariation(0, this.nbAtom);
        } else if (this.indexGap == 0) {
            this.touchAllSegmentsNoGap(oldCommonTailIdx, newCommonTailIdx);
        } else {
            this.touchAllSegmentsMoveGap(oldCommonTailIdx, newCommonTailIdx);
        }
    }

    protected void touchAllSegmentsNoGap(int oldCommonTailIdx, int newCommonTailIdx) {
        Object[] atoms = this.atomArray;
        ((AtomicSegment)atoms[0]).touch(true);
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        int rank = 1;
        while (rank < this.nbAtom) {
            AtomicSegment atom = (AtomicSegment)atoms[rank];
            int idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
            ++rank;
        }
    }

    protected void touchAllSegmentsMoveGap(int oldCommonTailIdx, int newCommonTailIdx) {
        int idx;
        int gap = this.indexGap;
        int gapRank = this.gapBeginRank;
        AtomicSegment atom = this.getAtomAt(0);
        atom.touch(true);
        if (gapRank == 0) {
            atom.beginIdx += gap;
        }
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        int atomRank = 1;
        while (atomRank < gapRank) {
            atom = this.getAtomAt(atomRank++);
            idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
        }
        while (atomRank < this.nbAtom) {
            atom = this.getAtomAt(atomRank++);
            idx = atom.beginIdx + gap;
            atom.beginIdx = idx >= oldCommonTailIdx ? idx + lengthVariation : (idx > newCommonTailIdx ? newCommonTailIdx : idx);
            atom.touch(true);
        }
        this.clearIndexGap();
    }

    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        this.replaceText(beginIdx, endIdx, newText, true, true);
    }

    protected void replaceText(int beginIdx, int endIdx, CharSequence newText, boolean fireEvent, boolean expandDirtyInterval) {
        if (beginIdx == 0 && endIdx == this.length()) {
            this.setText(newText, fireEvent);
            return;
        }
        if (this.generatedInfo != null) {
            boolean changed;
            boolean bl = changed = beginIdx == endIdx ? this.insertText(beginIdx, newText, expandDirtyInterval) : this.replaceTextInterval(beginIdx, endIdx, newText, expandDirtyInterval);
            if (!changed) {
                return;
            }
        }
        this.replaceActualText(beginIdx, endIdx, newText, fireEvent);
    }

    protected boolean insertText(int idx, CharSequence newText, boolean expandDirty) {
        int newLength = newText.length();
        if (newLength == 0) {
            return false;
        }
        ListSortedSet subSet = this.atomSet.subSet(this.newTouchRangeComparator(idx, idx));
        int beginRank = ((AtomicSegment)subSet.first()).rank;
        int endRank = 1 + ((AtomicSegment)subSet.last()).rank;
        this.touchSegments(beginRank, endRank, idx, idx + newLength, expandDirty);
        return true;
    }

    protected boolean replaceTextInterval(int beginIdx, int endIdx, CharSequence newText, boolean expandDirty) {
        CharSequence oldText = this.partition.getTextInterval(beginIdx, endIdx);
        int commonEndLength = this.commonEndLength(oldText, newText);
        int oldLength = endIdx - beginIdx;
        int newLength = newText.length();
        if (oldLength == newLength && commonEndLength == oldLength) {
            return false;
        }
        ListSortedSet subSet = this.atomSet.subSet(this.newTouchRangeComparator(beginIdx, endIdx));
        int beginRank = ((AtomicSegment)subSet.first()).rank;
        int endRank = 1 + ((AtomicSegment)subSet.last()).rank;
        this.touchSegments(beginRank, endRank, endIdx - commonEndLength, beginIdx + newLength - commonEndLength, expandDirty);
        return true;
    }

    protected void setActualText(CharSequence newText, boolean fireEvent) {
        if (this.partition == this.generatedPartition) {
            this.partition = this.newActualTextPartition();
        }
        if (fireEvent && this.isActive()) {
            CharSequence oldText = this.partition.getText();
            this.partition.setText(newText);
            this.updateSyntacticInfo(0, oldText.length(), newText.length());
            this.fireEvent(oldText, newText, 0);
            return;
        }
        int oldLength = this.partition.getTextLength();
        this.partition.setText(newText);
        this.updateSyntacticInfo(0, oldLength, newText.length());
    }

    protected void replaceActualText(int beginIdx, int endIdx, CharSequence newText, boolean fireEvent) {
        if (this.partition == this.generatedPartition) {
            this.partition = this.newActualTextPartition();
        }
        if (fireEvent && this.isActive()) {
            CharSequence oldText = this.partition.getTextInterval(beginIdx, endIdx);
            this.partition.replaceText(beginIdx, endIdx, newText);
            this.updateSyntacticInfo(beginIdx, endIdx - beginIdx, newText.length());
            this.fireEvent(oldText, newText, beginIdx);
            return;
        }
        this.partition.replaceText(beginIdx, endIdx, newText);
        this.updateSyntacticInfo(beginIdx, endIdx - beginIdx, newText.length());
    }

    protected boolean isActive() {
        return !this.silent && this.processor != null && this.processor.hasListener() && this.processor.getChangeSet() == this;
    }

    protected void fireEvent(CharSequence oldText, CharSequence newText, int index) {
        this.processor.fireTextChange(oldText != null ? oldText : "", newText, index);
    }

    protected ITextPartition newActualTextPartition() {
        return new IncrementalTextPartition(this.getDictionary(), this.newTextPartitioner(), this.text);
    }

    public ITextPartition textPartition() {
        return this.partition;
    }

    public SyntacticInfo getSyntacticInfo() {
        ITextAnalyzer textAnalyzer;
        if (this.syntacticInfo == null && (textAnalyzer = this.getTextAnalyzer()) != null) {
            this.syntacticInfo = new UserSyntacticInfo(this, textAnalyzer);
            this.syntacticInfo.setText(this.text);
        }
        return this.syntacticInfo;
    }

    protected void updateSyntacticInfo(int index, int nbRemoved, int nbAdded) {
        if (this.syntacticInfo != null) {
            this.syntacticInfo.textChanged(index, nbRemoved, nbAdded);
        }
    }

    protected void declareNewChangeLevel(int beginIdx, int endIdx, int changeLevel) {
        SyntacticInfo si = this.getSyntacticInfo();
        if (si != null) {
            if (changeLevel < 2) {
                si.declareBlankPortion(beginIdx, endIdx);
            } else if (changeLevel == 2) {
                si.declareDirtyPortion(beginIdx, endIdx);
            }
        }
    }

    protected void clearSyntacticInfo() {
        if (this.syntacticInfo != null) {
            this.syntacticInfo.clearAll();
        }
    }

    protected ITextAnalyzer getTextAnalyzer() {
        if (this.processor == null || this.processor.getChangeSet() != this) {
            return null;
        }
        IEditTreeExtension editTreeExt = this.processor.getEditTreeExtension();
        return editTreeExt != null ? editTreeExt.newTextAnalyzer() : null;
    }

    public int generatedLength() {
        return this.generatedInfo != null ? this.generatedInfo.getText().length() : 0;
    }

    public CharSequence generatedText() {
        return this.generatedInfo != null ? this.generatedInfo.getText() : "";
    }

    public ITextPartition generatedTextPartition() {
        return this.generatedPartition;
    }

    public Segment topSegment() {
        return this.topSegment;
    }

    public void refreshSyntacticSegments() {
        this.topSegment.touchSubSegments();
        Segment[] segmentArray = this.rootSegments();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            this.refreshSyntacticSegments(segment);
            ++n2;
        }
    }

    protected void refreshSyntacticSegments(Segment segment) {
        segment.enclosing = segment.parent == null ? this.topSegment() : segment.parent;
        segment.touchSubSegments();
        if (!segment.isAtomic()) {
            Segment[] segmentArray = segment.sons();
            int n = segmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Segment son = segmentArray[n2];
                this.refreshSyntacticSegments(son);
                ++n2;
            }
        }
    }

    public int nbOfLevels() {
        return this.nbLevel;
    }

    public int nbOfRootSegments() {
        return this.generatedInfo != null ? 3 : 0;
    }

    public Segment[] rootSegments() {
        if (this.rootSegments == null) {
            this.rootSegments = this.generatedInfo != null ? this.findRootSegments() : Segment.EMPTY_SEGMENT_ARRAY;
        }
        return this.rootSegments;
    }

    public int nbOfAtomicSegments() {
        return this.nbAtom;
    }

    public Segment firstAtom() {
        return (Segment)this.atomArray[0];
    }

    public Segment atomAt(int rank) {
        return (Segment)this.atomArray[rank];
    }

    public Segment lastAtom() {
        return (Segment)this.atomArray[this.nbAtom - 1];
    }

    protected AtomicSegment getAtomAt(int rank) {
        return (AtomicSegment)this.atomArray[rank];
    }

    protected void setAtomAt(int rank, AtomicSegment atom) {
        this.atomArray[rank] = atom;
    }

    protected Segment[] findRootSegments() {
        Iterator<Segment> rootIter = this.newSegmentIterator(false, null, true, null, true, false, this.singleLevelSegmentFilter(0));
        Segment[] roots = new Segment[3];
        int i = 0;
        while (i < 3) {
            roots[i] = rootIter.next();
            ++i;
        }
        return roots;
    }

    public Segment segmentFromTagName(String tagName, int shift) {
        Segment segment;
        Segment segment2 = segment = this.tagNameToSegment != null ? this.tagNameToSegment.get(tagName) : null;
        if (shift == 0 || segment == null) {
            return segment;
        }
        return this.getAtomAt((shift > 0 ? segment.maxRank() : segment.minRank()) + shift);
    }

    public Segment findSegmentFromTagName(String tagName, int shift) {
        Segment segment;
        Segment segment2 = segment = this.tagNameToSegment != null ? this.tagNameToSegment.get(tagName) : null;
        if (segment != null) {
            if (shift == 0) {
                return segment;
            }
            return this.getAtomAt((shift > 0 ? segment.maxRank() : segment.minRank()) + shift);
        }
        Segment segment3 = segment = this.syntacticTagNameToSegment != null ? this.syntacticTagNameToSegment.get(tagName) : null;
        if (shift == 0 || segment == null) {
            return segment;
        }
        Segment[] siblings = segment.enclosingSegment().subSegments();
        int i = 1;
        while (i < siblings.length) {
            if (siblings[i] == segment) {
                return siblings[i + shift];
            }
            i += 2;
        }
        return null;
    }

    public Iterator<Segment> segments(SegmentSelectionParameter parameter) {
        if (parameter == null) {
            return this.newSegmentIterator(false, null, true, null, true, false, null);
        }
        if (parameter == this.emptySelectionParameter || parameter.isEmptySelection()) {
            return this.emptySegmentIterator();
        }
        if (parameter.changeSet != this) {
            throw new RuntimeException("Segment selection parameter not compatible with this change set.");
        }
        return this.newSegmentIterator(parameter.atomic, parameter.start, parameter.startIncluded, parameter.stop, parameter.stopIncluded, parameter.reverseOrder, parameter.filter);
    }

    public int atomsTouching(int beginIdx, int endIdx, Interval atomRanks) {
        ObjectTouchRangeComparator cmp = new ObjectTouchRangeComparator(beginIdx, endIdx);
        EditBuffer.binarySearchInterval((Object[])this.atomArray, (int)this.nbAtom, (int)this.nbAtom, (Interval)atomRanks, (RangeComparator)cmp);
        return atomRanks.length();
    }

    public ChangeNature getChangeNature() {
        if (this.generatedInfo == null) {
            return this.length() > 0 ? ChangeNature.Replaced : ChangeNature.Unchanged;
        }
        return Segment.changeNatureFromStatus(this.status);
    }

    protected void updateRootSegmentStatus(int oldRootStatus, int newRootStatus) {
        int newRootChangeLevel;
        int oldRootChangeLevel = Segment.changeLevel(oldRootStatus);
        if (oldRootChangeLevel == (newRootChangeLevel = Segment.changeLevel(newRootStatus))) {
            return;
        }
        int changeLevel = Segment.changeLevel(this.status);
        if (newRootChangeLevel == changeLevel) {
            ++this.changesCount;
        } else if (newRootChangeLevel > changeLevel) {
            this.status = newRootChangeLevel;
            this.changesCount = 1;
        } else if (oldRootChangeLevel == changeLevel && --this.changesCount == 0) {
            this.recomputeStatus();
        }
    }

    protected void recomputeStatus() {
        int maxLevel = 0;
        int count = 0;
        Segment[] segmentArray = this.rootSegments();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Segment root = segmentArray[n2];
            int sonChangeLevel = Segment.changeLevel(root.getTreeStatus());
            if (sonChangeLevel > maxLevel) {
                maxLevel = sonChangeLevel;
                count = 1;
            } else if (sonChangeLevel == maxLevel) {
                ++count;
            }
            ++n2;
        }
        this.status = maxLevel;
        if (maxLevel != 0) {
            this.changesCount = count;
            return;
        }
        this.changesCount = 0;
        this.partition = this.generatedPartition;
        this.clearSyntacticInfo();
    }

    public Iterator<Segment> changedSegments() {
        return this.segments(this.changedSegmentsSelectionParameter());
    }

    public Iterator<Segment> changedAtomicSegments() {
        return this.segments(this.changedAtomsSelectionParameter());
    }

    protected SegmentSelectionParameter emptySelectionParameter() {
        if (this.emptySelectionParameter == null) {
            this.emptySelectionParameter = this.newSegmentSelection(true, null, true, null, true, false);
        }
        return this.emptySelectionParameter;
    }

    public SegmentSelectionParameter newSegmentSelection(boolean atomic, Segment start, boolean startIncluded, Segment stop, boolean stopIncluded, boolean reverseOrder) {
        if (start == null) {
            start = this.getAtomAt(reverseOrder ? this.nbAtom - 1 : 0);
            startIncluded = true;
            if (!atomic) {
                start = start.root();
            }
        }
        if (stop == null) {
            stop = this.getAtomAt(reverseOrder ? 0 : this.nbAtom - 1);
            stopIncluded = true;
        }
        return new SegmentSelectionParameter(this, atomic, start, startIncluded, stop, stopIncluded, reverseOrder);
    }

    protected SegmentSelectionParameter changedAtomsSelectionParameter() {
        if (this.changedAtomsSelectionParameter == null) {
            this.changedAtomsSelectionParameter = this.newSegmentSelection(true, null, true, null, true, false);
            this.changedAtomsSelectionParameter.setFilter(this.changedSegmentFilter());
        }
        return this.changedAtomsSelectionParameter;
    }

    protected SegmentSelectionParameter changedSegmentsSelectionParameter() {
        if (this.changedSegmentsSelectionParameter == null) {
            this.changedSegmentsSelectionParameter = this.newSegmentSelection(false, null, true, null, true, false);
            this.changedSegmentsSelectionParameter.setFilter(this.changedSegmentFilter());
        }
        return this.changedSegmentsSelectionParameter;
    }

    public SegmentSelectionParameter newSubtreeSelection(boolean atomic, Segment ancestor, boolean included, boolean reverseOrder) {
        boolean startIncluded;
        Segment stop;
        Segment start;
        if (reverseOrder) {
            start = atomic ? ancestor.lastAtom() : ancestor;
            stop = ancestor.firstAtom();
        } else {
            start = atomic ? ancestor.firstAtom() : ancestor;
            stop = ancestor.lastAtom();
        }
        boolean bl = startIncluded = included || start != ancestor;
        if (!startIncluded && start == stop) {
            return this.emptySelectionParameter();
        }
        return this.newSegmentSelection(atomic, start, startIncluded, stop, true, reverseOrder);
    }

    public SegmentSelectionParameter newRangeSelection(boolean atomic, RangeComparator<Segment> cmp, boolean reverseOrder) {
        Segment stop;
        Segment start;
        ListSortedSet subSet = this.atomSet.subSet(cmp);
        if (subSet.isEmpty()) {
            return this.emptySelectionParameter();
        }
        if (reverseOrder) {
            start = atomic ? (Segment)subSet.last() : ((AtomicSegment)subSet.last()).root();
            stop = (Segment)subSet.first();
        } else {
            start = atomic ? (Segment)subSet.first() : ((AtomicSegment)subSet.first()).root();
            stop = (Segment)subSet.last();
        }
        return this.newSegmentSelection(atomic, start, true, stop, true, reverseOrder);
    }

    public SegmentSelectionParameter newIntervalSelection(boolean atomic, int beginIndex, int endIndex, boolean reverseOrder) {
        return this.newRangeSelection(atomic, this.newTouchRangeComparator(beginIndex, endIndex), reverseOrder);
    }

    protected Iterator<Segment> emptySegmentIterator() {
        return Iterators.emptyIterator();
    }

    protected Iterator<Segment> newSegmentIterator(boolean atomic, Segment start, boolean startIncluded, Segment stop, boolean stopIncluded, boolean reverseOrder, SegmentFilter filter) {
        return filter == null ? (atomic ? new AtomicSegmentIterator(this.atomArray, start, startIncluded, stop, stopIncluded, reverseOrder) : new SegmentIterator(this.atomArray, start, startIncluded, stop, stopIncluded, reverseOrder)) : (atomic ? new FilteredAtomicSegmentIterator(this.atomArray, start, startIncluded, stop, stopIncluded, reverseOrder, filter) : new FilteredSegmentIterator(this.atomArray, start, startIncluded, stop, stopIncluded, reverseOrder, filter));
    }

    public SegmentFilter changedSegmentFilter() {
        if (changedSegmentFilter == null) {
            changedSegmentFilter = new ChangedSegmentFilter();
        }
        return changedSegmentFilter;
    }

    public SegmentFilter changedAtomicSegmentFilter() {
        if (changedAtomSegmentFilter == null) {
            changedAtomSegmentFilter = new ChangedAtomSegmentFilter();
        }
        return changedAtomSegmentFilter;
    }

    public SegmentFilter modifiedSegmentFilter() {
        if (modifiedSegmentFilter == null) {
            modifiedSegmentFilter = new ModifiedSegmentFilter();
        }
        return modifiedSegmentFilter;
    }

    public SegmentFilter dirtyAtomicSegmentFilter() {
        return this.dirtySegmentFilter();
    }

    public SegmentFilter dirtySegmentFilter() {
        if (dirtySegmentFilter == null) {
            dirtySegmentFilter = new DirtySegmentFilter();
        }
        return dirtySegmentFilter;
    }

    public SegmentFilter singleLevelSegmentFilter(final int level) {
        return new SegmentFilter(){

            @Override
            public boolean skip(Segment segment) {
                return segment.generatedLevel() != level;
            }

            @Override
            public boolean skipSons(Segment segment) {
                return segment.generatedLevel() >= level;
            }
        };
    }

    public SegmentFilter levelLowerOrEqualSegmentFilter(final int level) {
        return new SegmentFilter(){

            @Override
            public boolean skip(Segment segment) {
                return segment.generatedLevel() > level;
            }

            @Override
            public boolean skipSons(Segment segment) {
                return segment.generatedLevel() >= level;
            }
        };
    }

    public SegmentFilter sonsOnlySegmentFilter(final Segment parent) {
        return new SegmentFilter(){

            @Override
            public boolean skip(Segment segment) {
                return segment.parent != parent;
            }

            @Override
            public boolean skipSons(Segment segment) {
                return segment != parent && !segment.isAncestorOf(parent);
            }
        };
    }

    protected int commonEndLength(CharSequence leftText, CharSequence rightText) {
        int leftLength = leftText.length() - 1;
        int rightLength = rightText.length() - 1;
        int commonEndCount = 0;
        int max = Math.min(leftLength, rightLength);
        while (commonEndCount <= max && leftText.charAt(leftLength - commonEndCount) == rightText.charAt(rightLength - commonEndCount)) {
            ++commonEndCount;
        }
        return commonEndCount;
    }

    protected void replaceText(AtomicSegment atom, CharSequence newText) {
        int endIdx;
        int beginIdx = this.beginIndex(atom);
        CharSequence oldText = this.partition.getTextInterval(beginIdx, endIdx = this.endIndex(atom));
        if (Strings.sameCharSequences((CharSequence)oldText, (CharSequence)newText)) {
            return;
        }
        this.touch(atom, newText.length() - endIdx + beginIdx);
        this.replaceActualText(beginIdx, endIdx, newText, true);
    }

    protected void touch(AtomicSegment atom, int lengthVariation) {
        atom.touch(true);
        int rank = atom.rank;
        if (lengthVariation != 0 && (rank != this.nbAtom - 1 || rank == this.gapBeginRank)) {
            this.moveGapBeginRank(rank + 1);
            this.incrementIndexGap(lengthVariation);
        }
        this.expandDirtyInterval(rank, rank, lengthVariation);
    }

    protected void replaceTextOfAtoms(int minRank, int maxRank, CharSequence newText) {
        if (minRank == maxRank) {
            this.replaceText(this.getAtomAt(minRank), newText);
            return;
        }
        if (minRank == 0 && maxRank == this.nbAtom - 1) {
            this.setText(newText);
            return;
        }
        int beginIdx = this.beginIndexOfAtom(minRank);
        int endIdx = this.endIndexOfAtom(maxRank);
        CharSequence oldText = this.partition.getTextInterval(beginIdx, endIdx);
        int commonEndLength = this.commonEndLength(oldText, newText);
        int oldLength = endIdx - beginIdx;
        int newLength = newText.length();
        if (oldLength == newLength && commonEndLength == oldLength) {
            return;
        }
        this.touchSegments(minRank, maxRank + 1, endIdx - commonEndLength, beginIdx + newLength - commonEndLength, true);
        this.replaceActualText(beginIdx, endIdx, newText, true);
    }

    protected void touchSegments(int beginRank, int endRank, int oldCommonTailIdx, int newCommonTailIdx, boolean expandDirtyInterval) {
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        if (lengthVariation == 0) {
            this.touchSegmentsNoLengthVariation(beginRank, endRank);
        } else if (this.indexGap == 0) {
            this.touchSegmentsNoGap(beginRank, endRank, oldCommonTailIdx, newCommonTailIdx);
        } else if (endRank == this.nbAtom && beginRank > this.gapBeginRank) {
            this.touchSegmentsKeepGap(beginRank, endRank, oldCommonTailIdx, newCommonTailIdx);
        } else {
            this.touchSegmentsMoveGap(beginRank, endRank, oldCommonTailIdx, newCommonTailIdx);
        }
        if (expandDirtyInterval) {
            this.expandDirtyInterval(beginRank, endRank, lengthVariation);
        }
    }

    protected void touchSegmentsNoLengthVariation(int beginRank, int endRank) {
        Object[] atoms = this.atomArray;
        while (beginRank < endRank) {
            ((AtomicSegment)atoms[beginRank++]).touch(true);
        }
    }

    protected void touchSegmentsNoGap(int beginRank, int endRank, int oldCommonTailIdx, int newCommonTailIdx) {
        Object[] atoms = this.atomArray;
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        ((AtomicSegment)atoms[beginRank]).touch(true);
        int atomRank = beginRank + 1;
        while (atomRank < endRank) {
            AtomicSegment atom = (AtomicSegment)atoms[atomRank];
            int idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
            ++atomRank;
        }
        this.setIndexGap(endRank, lengthVariation);
    }

    protected void touchSegmentsKeepGap(int beginRank, int endRank, int oldCommonTailIdx, int newCommonTailIdx) {
        int idx;
        Object[] atoms = this.atomArray;
        int atomRank = beginRank;
        AtomicSegment atom = (AtomicSegment)atoms[atomRank++];
        atom.touch(true);
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        int gapRank = this.gapBeginRank;
        while (atomRank < gapRank) {
            atom = (AtomicSegment)atoms[atomRank++];
            idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
        }
        oldCommonTailIdx -= this.indexGap;
        newCommonTailIdx -= this.indexGap;
        while (atomRank < endRank) {
            atom = (AtomicSegment)atoms[atomRank++];
            idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
        }
    }

    protected void touchSegmentsMoveGap(int beginRank, int endRank, int oldCommonTailIdx, int newCommonTailIdx) {
        int idx;
        int gapRank = this.gapBeginRank;
        if (gapRank < beginRank) {
            gapRank = beginRank;
            this.moveGapBeginRank(gapRank);
        } else if (gapRank > endRank) {
            gapRank = endRank;
            this.moveGapBeginRank(gapRank);
        }
        Object[] atoms = this.atomArray;
        int atomRank = beginRank;
        AtomicSegment atom = (AtomicSegment)atoms[atomRank++];
        atom.touch(true);
        int gap = this.indexGap;
        if (gapRank == beginRank) {
            atom.beginIdx += gap;
        }
        int lengthVariation = newCommonTailIdx - oldCommonTailIdx;
        while (atomRank < gapRank) {
            atom = (AtomicSegment)atoms[atomRank++];
            idx = atom.beginIdx;
            if (idx >= oldCommonTailIdx) {
                atom.beginIdx = idx + lengthVariation;
            } else if (idx > newCommonTailIdx) {
                atom.beginIdx = newCommonTailIdx;
            }
            atom.touch(true);
        }
        while (atomRank < endRank) {
            atom = (AtomicSegment)atoms[atomRank++];
            idx = atom.beginIdx + gap;
            atom.beginIdx = idx >= oldCommonTailIdx ? idx + lengthVariation : (idx > newCommonTailIdx ? newCommonTailIdx : idx);
            atom.touch(true);
        }
        this.setIndexGap(endRank, gap + lengthVariation);
    }

    protected void expandDirtyInterval(int beginRank, int endRank, int lengthVariation) {
        int status;
        AtomicSegment atom;
        int rank = beginRank - 1;
        while (rank >= 0) {
            atom = this.getAtomAt(rank);
            status = atom.getSegmentStatus();
            if (status == 6) break;
            if (!(status >= 2 || atom.isGeneratedBlank() || status != 0 && this.isReformatedAtEnd(atom))) {
                atom.touch(true);
                break;
            }
            atom.touch(true);
            --rank;
        }
        rank = endRank;
        while (rank < this.nbAtom) {
            atom = this.getAtomAt(rank);
            status = atom.getSegmentStatus();
            if (status == 6) break;
            if (!(status >= 2 || atom.isGeneratedBlank() || status != 0 && this.isReformatedAtBegin(atom, lengthVariation))) {
                atom.touch(true);
                break;
            }
            atom.touch(true);
            ++rank;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isReformatedAtEnd(AtomicSegment atom) {
        lastWordRank = this.partition.wordRankFromIndex(endIdx = atom.endIndex());
        lastWordEndIdx = lastWordRank < 0 ? this.partition.wordEndIndex(~lastWordRank - 1) : (this.partition.wordBeginIndex(lastWordRank) == endIdx ? this.partition.wordEndIndex(lastWordRank - 1) : endIdx);
        if (endIdx - lastWordEndIdx == (genEndIdx = atom.generatedEndIndex()) - (lastGenWordEndIdx = (lastGenWordRank = this.generatedPartition.wordRankFromIndex(genEndIdx)) < 0 ? this.generatedPartition.wordEndIndex(~lastGenWordRank - 1) : (this.generatedPartition.wordBeginIndex(lastGenWordRank) == genEndIdx ? this.generatedPartition.wordEndIndex(lastGenWordRank - 1) : genEndIdx))) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (this.partition.charAt(lastWordEndIdx++) == this.generatedPartition.charAt(lastGenWordEndIdx++)) continue;
            return true;
lbl7:
            // 2 sources

            ** while (lastWordEndIdx < endIdx)
        }
lbl8:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isReformatedAtBegin(AtomicSegment atom, int lengthVariation) {
        beginIdx = atom.beginIndex() - lengthVariation;
        firstWordRank = this.partition.wordRankFromIndex(beginIdx);
        firstWordBeginIdx = firstWordRank < 0 ? this.partition.wordBeginIndex(~firstWordRank) : beginIdx;
        genBeginIdx = atom.generatedBeginIndex();
        firstGenWordRank = this.generatedPartition.wordRankFromIndex(genBeginIdx);
        v0 = firstGenWordBeginIdx = firstGenWordRank < 0 ? this.generatedPartition.wordBeginIndex(~firstGenWordRank) : genBeginIdx;
        if (firstWordBeginIdx - beginIdx == firstGenWordBeginIdx - genBeginIdx) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            if (this.partition.charAt(beginIdx++) == this.generatedPartition.charAt(genBeginIdx++)) continue;
            return true;
lbl11:
            // 2 sources

            ** while (beginIdx < firstWordBeginIdx)
        }
lbl12:
        // 1 sources

        return false;
    }

    protected void clearIndexGap() {
        this.gapBeginRank = this.nbAtom;
        this.indexGap = 0;
    }

    protected void setIndexGap(int newGapBeginRank, int newIndexGap) {
        if (newGapBeginRank == this.nbAtom || newIndexGap == 0) {
            this.gapBeginRank = this.nbAtom;
            this.indexGap = 0;
        } else {
            this.gapBeginRank = newGapBeginRank;
            this.indexGap = newIndexGap;
        }
    }

    protected void incrementIndexGap(int increment) {
        this.setIndexGap(this.gapBeginRank, this.indexGap + increment);
    }

    protected void moveGapBeginRank(int newGapBeginRank) {
        int gap = this.indexGap;
        if (gap != 0) {
            Object[] atoms = this.atomArray;
            int rank = this.gapBeginRank;
            while (rank < newGapBeginRank) {
                ((AtomicSegment)atoms[rank++]).beginIdx += gap;
            }
            while (rank > newGapBeginRank) {
                ((AtomicSegment)atoms[--rank]).beginIdx -= gap;
            }
        }
        this.gapBeginRank = newGapBeginRank;
    }

    public boolean restoreGeneratedText() {
        if (this.status == 0) {
            return false;
        }
        return this.restoreGeneratedTextInto((AtomicSegment)this.atomSet.first(), (AtomicSegment)this.atomSet.last());
    }

    public boolean restoreGeneratedText(int beginIdx, int endIdx) {
        if (this.status == 0) {
            return false;
        }
        if (beginIdx == 0 && endIdx == this.length()) {
            return this.restoreGeneratedTextInto((AtomicSegment)this.atomSet.first(), (AtomicSegment)this.atomSet.last());
        }
        return this.restoreGeneratedTextInInterval(beginIdx, endIdx);
    }

    protected boolean restoreGeneratedTextAt(int idx) {
        ListSortedSet atoms = this.atomSet.subSet(this.newTouchRangeComparator(idx, idx));
        return this.restoreAtomGeneratedText(((AtomicSegment)atoms.first()).rank, ((AtomicSegment)atoms.last()).rank);
    }

    protected boolean restoreGeneratedTextInInterval(int beginIdx, int endIdx) {
        ListSortedSet atoms = this.atomSet.subSet(this.newTouchRangeComparator(beginIdx, endIdx));
        Iterator iter = atoms.iterator();
        AtomicSegment firstAtom = null;
        AtomicSegment lastAtom = null;
        AtomicSegment firstDetailAtom = null;
        AtomicSegment secondDetailAtom = null;
        int startOfTextToReplace = -1;
        int startOfGeneratedText = -1;
        int endOfTextToReplace = -1;
        int endOfGeneratedText = -1;
        while (iter.hasNext()) {
            AtomicSegment atomicSegment = (AtomicSegment)iter.next();
            if (atomicSegment.getChangeNature() == ChangeNature.Deleted && atomicSegment.beginIndex() == atomicSegment.endIndex() && (atomicSegment.beginIndex() == beginIdx || atomicSegment.endIndex() == endIdx)) {
                if (atomicSegment.endIndex() == endIdx) {
                    if (firstAtom == null) {
                        firstAtom = atomicSegment;
                    }
                    lastAtom = atomicSegment;
                    break;
                }
                firstAtom = atomicSegment;
                lastAtom = atomicSegment;
                continue;
            }
            if (atomicSegment.beginIndex() >= beginIdx && atomicSegment.endIndex() <= endIdx) {
                if (firstAtom == null) {
                    firstAtom = atomicSegment;
                }
                lastAtom = atomicSegment;
                continue;
            }
            if (atomicSegment.isPart() && atomicSegment.getChangeNature() == ChangeNature.Reformated) {
                if (firstAtom == null) {
                    firstAtom = atomicSegment;
                }
                lastAtom = atomicSegment;
                continue;
            }
            IDetailedChanges details = atomicSegment.detailedChanges();
            if (details == null) continue;
            int nbOfDifferences = details.getNbOfDifferences();
            int startIndexOfModifications = 0;
            int endIndexOfModifications = 0;
            int startGeneratedIndexOfModifications = 0;
            int endGeneratedIndeOfModifications = 0;
            int nbOfDiferencesIncludedInTheInterval = 0;
            int i = 0;
            while (i < nbOfDifferences) {
                if (details.getModifiedBeginIndex(i) + atomicSegment.beginIndex() >= beginIdx && details.getModifiedEndIndex(i) + atomicSegment.beginIndex() <= endIdx) {
                    if (nbOfDiferencesIncludedInTheInterval == 0) {
                        startIndexOfModifications = details.getModifiedBeginIndex(i);
                        startGeneratedIndexOfModifications = details.getReferenceBeginIndex(i);
                    }
                    endIndexOfModifications = details.getModifiedEndIndex(i);
                    endGeneratedIndeOfModifications = details.getReferenceEndIndex(i);
                    ++nbOfDiferencesIncludedInTheInterval;
                }
                ++i;
            }
            if (nbOfDiferencesIncludedInTheInterval == 0) continue;
            if (nbOfDiferencesIncludedInTheInterval == nbOfDifferences) {
                if (firstAtom == null) {
                    firstAtom = atomicSegment;
                }
                lastAtom = atomicSegment;
                continue;
            }
            if (firstDetailAtom == null) {
                firstDetailAtom = atomicSegment;
                startOfTextToReplace = atomicSegment.beginIndex() + startIndexOfModifications;
                startOfGeneratedText = atomicSegment.generatedBeginIndex() + startGeneratedIndexOfModifications;
            } else {
                secondDetailAtom = atomicSegment;
            }
            endOfTextToReplace = atomicSegment.beginIndex() + endIndexOfModifications;
            endOfGeneratedText = atomicSegment.generatedBeginIndex() + endGeneratedIndeOfModifications;
        }
        if (firstAtom != null) {
            if (startOfTextToReplace == -1) {
                startOfTextToReplace = firstAtom.beginIndex();
            } else if (firstAtom.beginIndex() < startOfTextToReplace) {
                startOfTextToReplace = firstAtom.beginIndex();
            }
            if (startOfGeneratedText == -1) {
                startOfGeneratedText = firstAtom.generatedBeginIndex();
            } else if (firstAtom.generatedBeginIndex() < startOfGeneratedText) {
                startOfGeneratedText = firstAtom.generatedBeginIndex();
            }
            if (endOfTextToReplace == -1) {
                endOfTextToReplace = lastAtom.endIndex();
            } else if (lastAtom.endIndex() > endOfTextToReplace) {
                endOfTextToReplace = lastAtom.endIndex();
            }
            if (endOfGeneratedText == -1) {
                endOfGeneratedText = lastAtom.generatedEndIndex();
            } else if (lastAtom.generatedEndIndex() > endOfGeneratedText) {
                endOfGeneratedText = lastAtom.generatedEndIndex();
            }
        }
        if (startOfTextToReplace == -1) {
            return false;
        }
        CharSequence newText = this.generatedText().subSequence(startOfGeneratedText, endOfGeneratedText);
        CharSequence oldText = this.getText().subSequence(startOfTextToReplace, endOfTextToReplace);
        this.replaceText(startOfTextToReplace, endOfTextToReplace, newText, false, false);
        if (firstAtom != null) {
            AtomicSegment as = firstAtom;
            as.detailedChanges = null;
            while (as != lastAtom) {
                as = (AtomicSegment)as.nextAtom();
                as.detailedChanges = null;
            }
        }
        if (firstDetailAtom != null) {
            firstDetailAtom.detailedChanges = null;
        }
        if (secondDetailAtom != null) {
            secondDetailAtom.detailedChanges = null;
        }
        this.fireEvent(oldText, newText, startOfTextToReplace);
        return true;
    }

    protected boolean restoreGeneratedTextInto(AtomicSegment firstAtom, AtomicSegment lastAtom) {
        if (firstAtom == lastAtom) {
            return this.restoreGeneratedText(firstAtom);
        }
        Iterator<Segment> atomsToRestore = this.newSegmentIterator(true, firstAtom, true, lastAtom, true, false, this.changedAtomicSegmentFilter());
        if (!atomsToRestore.hasNext()) {
            return false;
        }
        firstAtom = (AtomicSegment)atomsToRestore.next();
        if (firstAtom == lastAtom) {
            return this.restoreGeneratedText(firstAtom);
        }
        atomsToRestore = this.newSegmentIterator(true, lastAtom, true, firstAtom, false, true, this.changedAtomicSegmentFilter());
        if (!atomsToRestore.hasNext()) {
            return this.restoreGeneratedText(firstAtom);
        }
        lastAtom = (AtomicSegment)atomsToRestore.next();
        return this.restoreAtomGeneratedText(firstAtom.rank, lastAtom.rank);
    }

    protected boolean restoreGeneratedText(AtomicSegment atom) {
        int newEndIdx;
        if (!atom.changeStatus(0)) {
            return false;
        }
        int nextRank = atom.rank + 1;
        int beginIdx = this.beginIndex(atom);
        int endIdx = this.endIndex(atom);
        CharSequence generatedText = atom.generatedText();
        if (nextRank != this.nbAtom && (newEndIdx = beginIdx + generatedText.length()) != endIdx) {
            this.moveGapBeginRank(nextRank);
            this.setIndexGap(nextRank, this.indexGap + newEndIdx - endIdx);
        }
        if (this.isActive()) {
            CharSequence oldText = this.text.getTextInterval(beginIdx, endIdx);
            if (this.status != 0) {
                this.partition.replaceText(beginIdx, endIdx, generatedText);
            } else {
                this.text.setText(this.generatedInfo.getText());
            }
            this.fireEvent(oldText, generatedText, beginIdx);
        } else if (this.status != 0) {
            this.partition.replaceText(beginIdx, endIdx, generatedText);
        } else {
            this.text.setText(this.generatedInfo.getText());
        }
        this.declareNewChangeLevel(beginIdx, endIdx, 0);
        return true;
    }

    protected boolean restoreAtomGeneratedText(int minRank, int maxRank) {
        if (minRank == maxRank) {
            return this.restoreGeneratedText(this.getAtomAt(minRank));
        }
        Object[] atoms = this.atomArray;
        int endRank = maxRank + 1;
        if (this.indexGap != 0) {
            if (this.gapBeginRank < minRank) {
                this.moveGapBeginRank(minRank);
            } else if (this.gapBeginRank > endRank) {
                this.moveGapBeginRank(endRank);
            }
        }
        AtomicSegment firstAtom = this.getAtomAt(minRank);
        AtomicSegment lastAtom = this.getAtomAt(maxRank);
        int beginIdx = firstAtom.beginIndex();
        int endIdx = lastAtom.endIndex();
        int idx = beginIdx;
        boolean restored = false;
        int rank = minRank;
        while (rank < endRank) {
            AtomicSegment atom = (AtomicSegment)atoms[rank];
            atom.beginIdx = idx;
            idx += atom.generatedLength();
            if (atom.changeStatus(0)) {
                restored = true;
            }
            ++rank;
        }
        this.setIndexGap(endRank, this.indexGap + idx - endIdx);
        if (this.isActive()) {
            CharSequence oldText = this.text.getTextInterval(beginIdx, endIdx);
            CharSequence newText = this.generatedPartition.getTextInterval(firstAtom.generatedBeginIndex(), lastAtom.generatedEndIndex());
            if (this.status != 0) {
                this.partition.replaceText(beginIdx, endIdx, newText);
            } else {
                this.text.setText(this.generatedInfo.getText());
            }
            this.fireEvent(oldText, newText, beginIdx);
        } else if (this.status != 0) {
            this.partition.replaceText(beginIdx, endIdx, this.generatedPartition.getTextInterval(firstAtom.generatedBeginIndex(), lastAtom.generatedEndIndex()));
        } else {
            this.text.setText(this.generatedInfo.getText());
        }
        this.declareNewChangeLevel(beginIdx, endIdx, 0);
        return restored;
    }

    protected TopSegment newTopSegment() {
        return new TopSegment(this);
    }

    protected HierarchicSegment newHierarchicSegment(HierarchicSegment parent, IGeneratedTag tag) {
        return new HierarchicSegment(this, parent, tag);
    }

    protected AtomicTagSegment newAtomicTagSegment(HierarchicSegment parent, IGeneratedTag tag) {
        return new AtomicTagSegment(this, parent, tag);
    }

    protected AtomicPartSegment newAtomicPartSegment(HierarchicSegment parent, Segment from, Segment to) {
        return new AtomicPartSegment(this, parent, from, to);
    }

    protected SyntacticTagSegment newSyntacticTagSegment(Segment parent, Segment enclosing, SyntacticTag syntacticTag, int minAtomRank, int maxAtomRank) {
        SyntacticTagSegment segment = new SyntacticTagSegment(this, parent, enclosing, syntacticTag, minAtomRank, maxAtomRank);
        if (this.syntacticTagNameToSegment == null) {
            this.syntacticTagNameToSegment = new HashMap<String, Segment>();
        }
        this.syntacticTagNameToSegment.put(syntacticTag.getName(), segment);
        return segment;
    }

    protected SyntacticPartSegment newSyntacticPartSegment(Segment parent, Segment enclosing, Segment from, Segment to, int atomRank) {
        return new SyntacticPartSegment(this, parent, enclosing, from, to, atomRank);
    }

    protected Comparator<AtomicSegment> getAtomicSegmentComparator() {
        if (atomicSegmentComparator == null) {
            atomicSegmentComparator = this.newAtomicSegmentComparator();
        }
        return atomicSegmentComparator;
    }

    protected Comparator<AtomicSegment> newAtomicSegmentComparator() {
        return new AtomicSegmentComparator();
    }

    protected Map<String, Segment> newNameToSegmentMap() {
        return new HashMap<String, Segment>();
    }

    protected TagProperties newGeneratedProperties() {
        return this.generatedInfo != null ? new TagProperties((Segment)this.topSegment, this.generatedInfo) : new TagProperties(this.topSegment);
    }

    public RangeComparator<Segment> newTouchRangeComparator(int beginIdx, int endIdx) {
        return new TouchRangeComparator(beginIdx, endIdx);
    }

    public RangeComparator<Segment> newIntersectRangeComparator(int beginIdx, int endIdx) {
        return new IntersectRangeComparator(beginIdx, endIdx);
    }

    public RangeComparator<Segment> newIncludeRangeComparator(int beginIdx, int endIdx) {
        return new IncludeRangeComparator(beginIdx, endIdx);
    }

    protected int beginIndex(AtomicSegment atom) {
        return atom.rank < this.gapBeginRank ? atom.beginIdx : atom.beginIdx + this.indexGap;
    }

    protected void changeBeginIndex(AtomicSegment atom, int newBeginIdx) {
        atom.beginIdx = atom.rank < this.gapBeginRank ? newBeginIdx : newBeginIdx - this.indexGap;
    }

    protected int beginIndexOfAtom(int atomRank) {
        AtomicSegment atom = this.getAtomAt(atomRank);
        return atomRank < this.gapBeginRank ? atom.beginIdx : atom.beginIdx + this.indexGap;
    }

    protected int endIndex(AtomicSegment atom) {
        int atomRank = atom.rank + 1;
        return atomRank == this.nbAtom ? this.length() : this.beginIndexOfAtom(atomRank);
    }

    protected int endIndexOfAtom(int atomRank) {
        return ++atomRank == this.nbAtom ? this.length() : this.beginIndexOfAtom(atomRank);
    }

    protected int length(AtomicSegment atom) {
        int nextRank = atom.rank + 1;
        if (nextRank == this.nbAtom) {
            return this.length() - this.beginIndex(atom);
        }
        int nextIdx = this.getAtomAt((int)nextRank).beginIdx;
        return nextRank == this.gapBeginRank ? nextIdx + this.indexGap - atom.beginIdx : nextIdx - atom.beginIdx;
    }

    protected boolean blankInterval(int beginIdx, int endIdx) {
        if (beginIdx >= endIdx) {
            return true;
        }
        int wordRank = this.partition.wordRankFromIndex(beginIdx);
        return wordRank < 0 && (--endIdx == beginIdx || this.partition.wordRankFromIndex(endIdx) == wordRank);
    }

    protected boolean blankGeneratedInterval(int beginIdx, int endIdx) {
        if (beginIdx >= endIdx) {
            return true;
        }
        int wordRank = this.generatedPartition.wordRankFromIndex(beginIdx);
        return wordRank < 0 && (--endIdx == beginIdx || this.generatedPartition.wordRankFromIndex(endIdx) == wordRank);
    }

    public IGeneratedInfo exportAsGeneratedInfo(IGeneratedInfoFactory factory, String rootTagName) {
        Segment top = this.topSegment();
        this.copyProperties(top, factory);
        factory.beginTag(rootTagName);
        if (top.isLeaf()) {
            factory.appendText(top.getText());
        } else {
            this.exportSubSegments(top.subSegments(), factory, false);
        }
        factory.endTag();
        return factory.createGeneratedInfo();
    }

    public IGeneratedInfo exportAsGeneratedInfo(IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        Segment top = this.topSegment();
        this.copyProperties(top, factory);
        if (top.isLeaf()) {
            if (tagSpecificCode) {
                factory.beginTag("Untagged#1");
                factory.setProperty("SpecificTag", "True");
                factory.setProperty("GeneratedText", "");
            } else {
                factory.beginTag("Untagged");
            }
            factory.appendText(top.getText());
            factory.endTag();
            return factory.createGeneratedInfo();
        }
        String rootTagName = this.getGeneratedInfo().getRootTag().getName();
        factory.beginTag(rootTagName);
        this.exportTopSegments(rootTagName, top.subSegments(), factory, tagSpecificCode);
        factory.endTag();
        return factory.createGeneratedInfo();
    }

    protected void copyProperties(Segment segment, IGeneratedInfoFactory factory) {
        if (segment.isSyntactic()) {
            this.copyOwnProperties(segment.getTagProperties(), factory);
        } else {
            this.copyPropertiesGeneratedSegment(segment, factory);
        }
    }

    protected void copyOwnProperties(TagProperties properties, IGeneratedInfoFactory factory) {
        Iterator<String> names = properties.ownPropertyNames();
        while (names.hasNext()) {
            String name = names.next();
            factory.setProperty(name, properties.getProperty(name));
        }
    }

    protected void copyPropertiesGeneratedSegment(Segment segment, IGeneratedInfoFactory factory) {
        TagProperties properties = segment.getTagProperties();
        SyntacticTag syntacticTag = this.fetchSyntacticTag(segment);
        if (properties == null) {
            if (syntacticTag == null) {
                return;
            }
            this.copySyntacticProperties(syntacticTag, factory);
            return;
        }
        if (syntacticTag == null) {
            this.copyOwnProperties(properties, factory);
            return;
        }
        this.copyMergeProperties(properties, syntacticTag, factory);
    }

    protected SyntacticTag fetchSyntacticTag(Segment segment) {
        if (!segment.isTagged() || segment.isSyntactic()) {
            return null;
        }
        SyntacticInfo syntacticInfo = this.getSyntacticInfo();
        if (syntacticInfo == null) {
            return null;
        }
        return syntacticInfo.unfilteredTagFromName(segment.enclosingTagName());
    }

    protected void copySyntacticProperties(SyntacticTag syntacticTag, IGeneratedInfoFactory factory) {
        Iterator<String> names = syntacticTag.propertyNames();
        while (names.hasNext()) {
            String name = names.next();
            factory.setProperty("+" + name, syntacticTag.getProperty(name));
        }
    }

    protected void copyMergeProperties(TagProperties properties, SyntacticTag syntacticTag, IGeneratedInfoFactory factory) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        Iterator<String> generatedNames = properties.ownPropertyNames();
        while (generatedNames.hasNext()) {
            String name = generatedNames.next();
            mergedProperties.put(name, properties.getProperty(name));
        }
        Iterator<String> syntacticNames = syntacticTag.propertyNames();
        while (syntacticNames.hasNext()) {
            String name = syntacticNames.next();
            mergedProperties.put("+" + name, syntacticTag.getProperty(name));
        }
        for (Map.Entry entry : mergedProperties.entrySet()) {
            factory.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void exportTopSegments0(String rootTagName, Segment[] subSegments, IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        int specificCount = 0;
        Segment[] segmentArray = subSegments;
        int n = subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (segment.isTagged()) {
                this.copyProperties(segment, factory);
                if (segment.isLeaf()) {
                    specificCount = this.exportLeafSegment(specificCount, segment, factory, tagSpecificCode);
                } else {
                    Segment[] segmentArray2 = segment.subSegments();
                    int n3 = segmentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Segment subSegment = segmentArray2[n4];
                        if (subSegment.isTagged()) {
                            this.exportTaggedSegment(subSegment, factory, tagSpecificCode);
                        } else {
                            specificCount = this.exportLeafSegment(specificCount, subSegment, factory, tagSpecificCode);
                        }
                        ++n4;
                    }
                }
            } else {
                specificCount = this.exportLeafSegment(specificCount, segment, factory, tagSpecificCode);
            }
            ++n2;
        }
    }

    protected void exportTopSegments(String rootTagName, Segment[] subSegments, IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        int specificCount = 0;
        Segment[] segmentArray = subSegments;
        int n = subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (segment.isTagged()) {
                if (segment.enclosingTagName().equals(rootTagName)) {
                    this.copyProperties(segment, factory);
                    if (segment.isLeaf()) {
                        specificCount = this.exportLeafSegment(specificCount, segment, factory, tagSpecificCode);
                    } else {
                        Segment[] segmentArray2 = segment.subSegments();
                        int n3 = segmentArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Segment subSegment = segmentArray2[n4];
                            if (subSegment.isTagged()) {
                                this.exportTaggedSegment(subSegment, factory, tagSpecificCode);
                            } else {
                                specificCount = this.exportLeafSegment(specificCount, subSegment, factory, tagSpecificCode);
                            }
                            ++n4;
                        }
                    }
                } else {
                    this.exportTaggedSegment(segment, factory, tagSpecificCode);
                }
            } else {
                specificCount = this.exportLeafSegment(specificCount, segment, factory, tagSpecificCode);
            }
            ++n2;
        }
    }

    protected void exportTaggedSegment(Segment segment, IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        factory.beginTag(segment.enclosingTagName());
        this.copyProperties(segment, factory);
        if (segment.isLeaf()) {
            this.exportLeafSegment(0, segment, factory, tagSpecificCode);
        } else {
            this.exportSubSegments(segment.subSegments(), factory, tagSpecificCode);
        }
        if (segment.getChangeSet().getSyntacticInfo() != null && segment.getTagProperties().getProperty("ForceParseSyntacticTag") != null) {
            segment.getChangeSet().getSyntacticInfo().declareDirtyPortion(segment.beginIndex(), segment.endIndex());
        }
        factory.endTag();
    }

    protected void exportSubSegments(Segment[] subSegments, IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        int specificCount = 0;
        Segment[] segmentArray = subSegments;
        int n = subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            if (segment.isTagged()) {
                this.exportTaggedSegment(segment, factory, tagSpecificCode);
            } else {
                specificCount = this.exportLeafSegment(specificCount, segment, factory, tagSpecificCode);
            }
            ++n2;
        }
    }

    protected int exportLeafSegment(int specificCount, Segment segment, IGeneratedInfoFactory factory, boolean tagSpecificCode) {
        CharSequence text = segment.getText();
        if (!tagSpecificCode || segment.getChangeNature() == ChangeNature.Unchanged) {
            factory.appendText(text);
            return specificCount;
        }
        CharSequence generatedText = segment.generatedText();
        String enclosingTagName = segment.enclosingTagName();
        enclosingTagName = enclosingTagName == null || enclosingTagName.length() == 0 ? "Untagged#" : String.valueOf(enclosingTagName) + "#";
        IDetailedChanges details = segment.detailedChanges();
        if (details == null || details.getNbOfDifferences() == 0) {
            factory.beginTag(String.valueOf(enclosingTagName) + ++specificCount);
            factory.setProperty("SpecificTag", "True");
            factory.setProperty("GeneratedText", generatedText.toString());
            factory.setProperty("ChangeNature", segment.getChangeNature().name());
            factory.appendText(text);
            factory.endTag();
            return specificCount;
        }
        int previousIdx = 0;
        int d = 0;
        while (d < details.getNbOfDifferences()) {
            int beginIdx = details.getModifiedBeginIndex(d);
            int endIdx = details.getModifiedEndIndex(d);
            if (beginIdx > previousIdx) {
                factory.appendText(text.subSequence(previousIdx, beginIdx));
            }
            factory.beginTag(String.valueOf(enclosingTagName) + ++specificCount);
            factory.setProperty("SpecificTag", "True");
            factory.setProperty("ChangeNature", details.getChangeNature(d).name());
            int generatedBeginIdx = details.getReferenceBeginIndex(d);
            int generatedEndIdx = details.getReferenceEndIndex(d);
            factory.setProperty("GeneratedText", generatedText.subSequence(generatedBeginIdx, generatedEndIdx).toString());
            factory.appendText(text.subSequence(beginIdx, endIdx));
            factory.endTag();
            previousIdx = endIdx;
            ++d;
        }
        if (previousIdx < segment.length()) {
            factory.appendText((CharSequence)text.subSequence(previousIdx, segment.length()).toString());
        }
        return specificCount;
    }

    public String toString() {
        GenInfoFactory factory = new GenInfoFactory();
        IGeneratedInfo genInfo = this.exportAsGeneratedInfo((IGeneratedInfoFactory)factory, true);
        return genInfo.toString();
    }

    protected static class AtomicSegmentComparator
    implements Comparator<AtomicSegment> {
        @Override
        public int compare(AtomicSegment left, AtomicSegment right) {
            return left.rank - right.rank;
        }
    }

    protected static class ChangedAtomSegmentFilter
    implements SegmentFilter {
        protected ChangedAtomSegmentFilter() {
        }

        @Override
        public boolean skip(Segment segment) {
            return segment.getTreeStatus() == 0;
        }

        @Override
        public boolean skipSons(Segment segment) {
            return segment.getTreeStatus() == 0;
        }
    }

    protected static class ChangedSegmentFilter
    implements SegmentFilter {
        protected ChangedSegmentFilter() {
        }

        @Override
        public boolean skip(Segment segment) {
            int status = segment.getSegmentStatus();
            return status == 0 || !segment.isAtomic() && (status <= 2 || status == 6);
        }

        @Override
        public boolean skipSons(Segment segment) {
            int status = segment.getSegmentStatus();
            return status > 2 && status < 6 || segment.getTreeStatus() == 0;
        }
    }

    protected static class DirtySegmentFilter
    implements SegmentFilter {
        protected DirtySegmentFilter() {
        }

        @Override
        public boolean skip(Segment segment) {
            return segment.getChangeNature() != ChangeNature.Dirty;
        }

        @Override
        public boolean skipSons(Segment segment) {
            return segment.getTreeChangeNature() != ChangeNature.Dirty;
        }
    }

    protected static class GeneratedIncludeRangeComparator
    extends IncludeRangeComparator {
        protected GeneratedIncludeRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        public int compareWithRange(AtomicSegment atom) {
            return this.compareRangeWithInterval(atom.generatedBeginIndex(), atom.generatedEndIndex());
        }
    }

    protected static class GeneratedIntersectRangeComparator
    extends IntersectRangeComparator {
        protected GeneratedIntersectRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        public int compareWithRange(AtomicSegment atom) {
            return this.compareRangeWithInterval(atom.generatedBeginIndex(), atom.generatedEndIndex());
        }
    }

    protected static class GeneratedTouchRangeComparator
    extends TouchRangeComparator {
        protected GeneratedTouchRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        public int compareWithRange(AtomicSegment atom) {
            return this.compareRangeWithInterval(atom.generatedBeginIndex(), atom.generatedEndIndex());
        }
    }

    protected static class GetArraySortedSet<E>
    extends ArraySortedSet<E> {
        private static final long serialVersionUID = 1L;

        protected GetArraySortedSet() {
        }

        protected GetArraySortedSet(Comparator<? super E> cmp) {
            super(cmp);
        }

        protected GetArraySortedSet(int initialCapacity, Comparator<? super E> cmp) {
            super(initialCapacity, cmp);
        }

        protected E[] getArray() {
            return this.array;
        }
    }

    protected static class IncludeRangeComparator
    extends IndexRangeComparator {
        protected IncludeRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        @Override
        protected int compareRangeWithInterval(int start, int stop) {
            return this.beginIdx >= 0 && start < this.beginIdx ? -1 : (this.endIdx >= 0 && stop > this.endIdx ? 1 : 0);
        }
    }

    protected static abstract class IndexRangeComparator
    extends AbstractRangeComparator<Segment> {
        protected int beginIdx;
        protected int endIdx;

        protected IndexRangeComparator() {
            this(-1, -1);
        }

        protected IndexRangeComparator(int beginIndex, int endIndex) {
            this.beginIdx = beginIndex;
            this.endIdx = endIndex;
        }

        public boolean isLeftLimited() {
            return this.beginIdx >= 0;
        }

        public boolean isRightLimited() {
            return this.endIdx >= 0;
        }

        public int compareWithRange(Segment atom) {
            return this.compareRangeWithInterval(atom.beginIndex(), atom.endIndex());
        }

        protected abstract int compareRangeWithInterval(int var1, int var2);
    }

    protected static class IntersectRangeComparator
    extends IndexRangeComparator {
        protected IntersectRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        @Override
        protected int compareRangeWithInterval(int start, int stop) {
            return this.beginIdx >= 0 && stop <= this.beginIdx ? -1 : (this.endIdx >= 0 && start >= this.endIdx ? 1 : 0);
        }
    }

    protected static class ModifiedSegmentFilter
    implements SegmentFilter {
        protected ModifiedSegmentFilter() {
        }

        @Override
        public boolean skip(Segment segment) {
            int status = segment.getSegmentStatus();
            return status < 2 || !segment.isAtomic() && (status == 2 || status == 6);
        }

        @Override
        public boolean skipSons(Segment segment) {
            int status = segment.getSegmentStatus();
            return status > 2 && status < 6 || segment.getTreeStatus() < 2;
        }
    }

    protected static abstract class ObjectIndexRangeComparator
    extends AbstractRangeComparator<Object> {
        protected int beginIdx;
        protected int endIdx;

        protected ObjectIndexRangeComparator() {
            this(-1, -1);
        }

        protected ObjectIndexRangeComparator(int beginIndex, int endIndex) {
            this.beginIdx = beginIndex;
            this.endIdx = endIndex;
        }

        public boolean isLeftLimited() {
            return this.beginIdx >= 0;
        }

        public boolean isRightLimited() {
            return this.endIdx >= 0;
        }

        public int compareWithRange(Object atomObject) {
            AtomicSegment atom = (AtomicSegment)atomObject;
            return this.compareRangeWithInterval(atom.beginIndex(), atom.endIndex());
        }

        protected abstract int compareRangeWithInterval(int var1, int var2);
    }

    protected static class ObjectTouchRangeComparator
    extends ObjectIndexRangeComparator {
        protected ObjectTouchRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        @Override
        protected int compareRangeWithInterval(int start, int stop) {
            return this.beginIdx >= 0 && stop < this.beginIdx ? -1 : (this.endIdx >= 0 && start > this.endIdx ? 1 : 0);
        }
    }

    protected static class TouchRangeComparator
    extends IndexRangeComparator {
        protected TouchRangeComparator(int beginIndex, int endIndex) {
            super(beginIndex, endIndex);
        }

        @Override
        protected int compareRangeWithInterval(int start, int stop) {
            return this.beginIdx >= 0 && stop < this.beginIdx ? -1 : (this.endIdx >= 0 && start > this.endIdx ? 1 : 0);
        }
    }
}

