/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticPartSegment;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.SyntacticTagSegment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TopSegment
extends Segment {
    protected Segment[] subSegments;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TopSegment(UserChangeSet userChangeSet) {
        super(userChangeSet);
    }

    @Override
    public TagProperties getTagProperties() {
        return this.changeSet.getGeneratedProperties();
    }

    @Override
    public int generatedLevel() {
        return -1;
    }

    @Override
    public Segment parent() {
        return null;
    }

    @Override
    public Segment root() {
        return null;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public boolean isPart() {
        return true;
    }

    @Override
    public boolean isFirstPart() {
        return true;
    }

    @Override
    public boolean isMiddlePart() {
        return false;
    }

    @Override
    public boolean isLastPart() {
        return true;
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return null;
    }

    @Override
    public IGeneratedTag fromTag() {
        return null;
    }

    @Override
    public IGeneratedTag toTag() {
        return null;
    }

    @Override
    public Segment previousBrother() {
        return null;
    }

    @Override
    public Segment nextBrother() {
        return null;
    }

    @Override
    public Segment previousAtom() {
        return null;
    }

    @Override
    public Segment nextAtom() {
        return null;
    }

    @Override
    public int minRank() {
        return this.changeSet.generatedInfo != null ? 0 : -1;
    }

    @Override
    public int maxRank() {
        return this.changeSet.generatedInfo != null ? this.changeSet.nbAtom - 1 : -1;
    }

    @Override
    public int beginIndex() {
        return 0;
    }

    @Override
    public int endIndex() {
        return this.changeSet.length();
    }

    @Override
    public void setBeginIndex(int newBeginIndex) {
    }

    @Override
    public int length() {
        return this.changeSet.length();
    }

    @Override
    public boolean isBlank() {
        return this.changeSet.blankInterval(0, this.changeSet.length());
    }

    @Override
    public CharSequence getText() {
        return this.changeSet.getText();
    }

    @Override
    public void setText(CharSequence newText) {
        this.changeSet.setText(newText);
    }

    @Override
    public int generatedBeginIndex() {
        return 0;
    }

    @Override
    public int generatedEndIndex() {
        return this.changeSet.generatedLength();
    }

    @Override
    public int generatedLength() {
        return this.changeSet.generatedLength();
    }

    @Override
    public boolean isGeneratedBlank() {
        return this.changeSet.blankGeneratedInterval(0, this.changeSet.generatedLength());
    }

    @Override
    public CharSequence generatedText() {
        return this.changeSet.generatedText();
    }

    @Override
    public ChangeNature getChangeNature() {
        return this.changeSet.getChangeNature();
    }

    @Override
    public void setChangeNature(ChangeNature newChangeNature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChangeNature getSubtreesChangeNature() {
        IGeneratedInfo genInfo = this.changeSet.generatedInfo;
        return genInfo != null ? this.changeSet.segmentFromTagName(genInfo.getRootTag().getName(), 0).getChangeNature() : ChangeNature.Unchanged;
    }

    @Override
    public ChangeNature getTreeChangeNature() {
        return this.getChangeNature();
    }

    @Override
    protected int getSegmentStatus() {
        if (this.changeSet.generatedInfo == null) {
            return this.length() > 0 ? 5 : 0;
        }
        return this.changeSet.status;
    }

    @Override
    protected int getTreeStatus() {
        return this.getSegmentStatus();
    }

    @Override
    public Segment supersedingSegment() {
        return this;
    }

    @Override
    public boolean restoreGeneratedText() {
        return this.changeSet.restoreGeneratedText();
    }

    @Override
    public ITextNode getTextNode() {
        return this.node;
    }

    @Override
    public void setTextNode(ITextNode newNode) {
        this.node = newNode;
    }

    @Override
    public IDetailedChanges detailedChanges() {
        return null;
    }

    @Override
    public void setDetailedChanges(IDetailedChanges newDetails) {
        throw new UnsupportedOperationException("TopSegment.setDetailedChanges");
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String fromTagName() {
        return null;
    }

    @Override
    public String toTagName() {
        return null;
    }

    @Override
    public String enclosingTagName() {
        return null;
    }

    @Override
    public int nbOfSons() {
        return this.changeSet.generatedInfo != null ? 3 : 0;
    }

    @Override
    public int nbOfTaggedSons() {
        return this.changeSet.generatedInfo != null ? 1 : 0;
    }

    @Override
    public Segment[] sons() {
        return this.changeSet.rootSegments();
    }

    @Override
    public boolean isAncestorOf(Segment segment) {
        return true;
    }

    @Override
    public Segment firstAtom() {
        return this.changeSet.atomAt(0);
    }

    @Override
    public Segment lastAtom() {
        return this.changeSet.atomAt(this.changeSet.nbAtom - 1);
    }

    @Override
    public Segment enclosingSegment() {
        return null;
    }

    @Override
    public boolean isSyntactic() {
        return true;
    }

    @Override
    public boolean isTop() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments.length == 0;
    }

    @Override
    public Segment[] subSegments() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments;
    }

    protected Segment[] buildSubSegments() {
        if (this.changeSet.generatedInfo == null) {
            return this.buildPureSyntacticSubSegments();
        }
        Segment[] sons = this.changeSet.rootSegments();
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return sons;
        }
        int startSonRank = 0;
        int minSonRank = 0;
        Iterator<SyntacticTag> subtags = si.rootTags();
        ArrayList<Segment> subSegmentsList = null;
        while (subtags.hasNext()) {
            SyntacticTag tag = subtags.next();
            if (!tag.isToInsertInEditTree()) continue;
            Segment son = sons[minSonRank];
            int tagBeginIdx = tag.beginIndex();
            while (son.endIndex() < tagBeginIdx) {
                son = sons[++minSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagBeginIdx) continue;
                son = sons[++minSonRank];
            }
            int maxSonRank = minSonRank;
            int tagEndIdx = tag.endIndex();
            while (son.endIndex() < tagEndIdx) {
                son = sons[++maxSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagEndIdx) {
                    minSonRank = maxSonRank;
                    continue;
                }
                ++maxSonRank;
            }
            if (subSegmentsList == null) {
                subSegmentsList = new ArrayList<Segment>();
            }
            this.addSubSegments(sons, startSonRank, minSonRank, maxSonRank, tag, subSegmentsList);
            startSonRank = minSonRank = maxSonRank;
        }
        if (subSegmentsList == null) {
            return sons;
        }
        this.completeSubSegments(sons, startSonRank, subSegmentsList);
        Segment[] subSegments = new Segment[subSegmentsList.size()];
        subSegmentsList.toArray(subSegments);
        return subSegments;
    }

    protected void addSubSegments(Segment[] sons, int startSonRank, int minSonRank, int maxSonRank, SyntacticTag tag, List<Segment> subSegmentsList) {
        TopSegment previous;
        int tagMinRank = sons[minSonRank].minRank();
        int tagMaxRank = sons[maxSonRank].maxRank();
        SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(null, this, tag, tagMinRank, tagMaxRank);
        Segment segment = previous = subSegmentsList.isEmpty() ? this : subSegmentsList.get(subSegmentsList.size() - 1);
        if (startSonRank == minSonRank) {
            SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(null, this, previous, tagSegment, tagMinRank);
            subSegmentsList.add(part);
            subSegmentsList.add(tagSegment);
            return;
        }
        if (previous != this) {
            int rank1 = sons[startSonRank].minRank();
            SyntacticPartSegment part1 = this.changeSet.newSyntacticPartSegment(null, this, previous, sons[++startSonRank], rank1);
            subSegmentsList.add(part1);
        }
        do {
            subSegmentsList.add(sons[startSonRank]);
        } while (++startSonRank < minSonRank);
        SyntacticPartSegment part2 = this.changeSet.newSyntacticPartSegment(null, this, sons[minSonRank - 1], tagSegment, tagMinRank);
        subSegmentsList.add(part2);
        subSegmentsList.add(tagSegment);
    }

    protected void completeSubSegments(Segment[] sons, int startSonRank, List<Segment> subSegmentsList) {
        int startRank = sons[startSonRank].minRank();
        Segment previous = subSegmentsList.get(subSegmentsList.size() - 1);
        int maxSonRank = sons.length - 1;
        if (startSonRank == maxSonRank) {
            SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(null, this, previous, this, startRank);
            subSegmentsList.add(part);
            return;
        }
        SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(null, this, previous, sons[++startSonRank], startRank);
        subSegmentsList.add(part);
        do {
            subSegmentsList.add(sons[startSonRank]);
        } while (++startSonRank <= maxSonRank);
    }

    protected Segment[] buildPureSyntacticSubSegments() {
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        int nbOfSubTags = 0;
        Iterator<SyntacticTag> subtags = si.rootTags();
        while (subtags.hasNext()) {
            SyntacticTag tag = subtags.next();
            if (!tag.isToInsertInEditTree()) continue;
            ++nbOfSubTags;
        }
        if (nbOfSubTags == 0) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        Segment[] subSegments = new Segment[1 + (nbOfSubTags << 1)];
        int count = 0;
        Segment previous = this;
        subtags = si.rootTags();
        while (subtags.hasNext()) {
            SyntacticTag tag = subtags.next();
            if (!tag.isToInsertInEditTree()) continue;
            SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(null, this, tag, -1, -1);
            subSegments[count++] = this.changeSet.newSyntacticPartSegment(null, this, previous, tagSegment, -1);
            subSegments[count++] = tagSegment;
            previous = tagSegment;
        }
        subSegments[count] = this.changeSet.newSyntacticPartSegment(null, this, previous, this, -1);
        return subSegments;
    }

    @Override
    protected boolean dirtySubSegments() {
        return this.subSegments == null;
    }

    @Override
    protected void touchSubSegments() {
        if (this.subSegments == null) {
            return;
        }
        Segment[] segmentArray = this.subSegments;
        int n = this.subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment subSegment = segmentArray[n2];
            if (subSegment.isSyntactic() && subSegment.isTagged()) {
                this.changeSet.syntacticTagNameToSegment.remove(subSegment.enclosingTagName());
                subSegment.touchSubSegments();
            }
            ++n2;
        }
        this.subSegments = null;
    }
}

