/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.TextCursor;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;

public class TextPropertyCursor
extends TextCursor {
    protected String scannedProperty;
    protected String value;
    protected Segment nextSegment;
    protected String nextValue;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextPropertyCursor(UserChangeSet userChangeSet) {
        super(userChangeSet);
    }

    public TextPropertyCursor(UserChangeSet userChangeSet, Segment firstSegmentToBrowse, Segment lastSegmentToBrowse) {
        super(userChangeSet, firstSegmentToBrowse, lastSegmentToBrowse);
    }

    public TextPropertyCursor(UserChangeSet userChangeSet, int beginIndex, int endIndex) {
        super(userChangeSet, beginIndex, endIndex);
    }

    public String getScannedProperty() {
        return this.scannedProperty;
    }

    public void setScannedProperty(String propertyName) {
        this.scannedProperty = propertyName;
    }

    @Override
    protected boolean search() {
        if (this.nextSegment == null && !this.findNextSegment()) {
            return this.finish();
        }
        int begin = this.nextSegment.beginIndex();
        int end = this.nextSegment.endIndex();
        int generatedBegin = this.nextSegment.generatedBeginIndex();
        int generatedEnd = this.nextSegment.generatedEndIndex();
        Segment min = this.nextSegment;
        Segment max = this.nextSegment;
        String propertyValue = this.nextValue;
        this.nextSegment = null;
        this.nextValue = null;
        while (this.segments.hasNext()) {
            Segment newSegment = (Segment)this.segments.next();
            String newPropertyValue = newSegment.getTagProperties().getProperty(this.scannedProperty);
            if (newPropertyValue == null) break;
            if (!newPropertyValue.equals(propertyValue)) {
                this.nextSegment = newSegment;
                this.nextValue = newPropertyValue;
                break;
            }
            end = newSegment.endIndex();
            generatedEnd = newSegment.generatedEndIndex();
            max = newSegment;
        }
        return this.interval(propertyValue, begin, end, generatedBegin, generatedEnd, min, max);
    }

    protected boolean findNextSegment() {
        if (this.segments == null) {
            this.initializeSearch();
        }
        while (this.segments.hasNext()) {
            Segment newSegment = (Segment)this.segments.next();
            String newValue = newSegment.getTagProperties().getProperty(this.scannedProperty);
            if (newValue == null) continue;
            this.nextSegment = newSegment;
            this.nextValue = newValue;
            return true;
        }
        return false;
    }

    protected boolean interval(String propertyValue, int b, int e, int gb, int ge, Segment min, Segment max) {
        this.value = propertyValue;
        this.beginIdx = b;
        this.endIdx = e;
        this.generatedBeginIdx = gb;
        this.generatedEndIdx = ge;
        this.minSegment = min;
        this.maxSegment = max;
        return true;
    }

    @Override
    protected boolean finish() {
        this.value = null;
        this.nextSegment = null;
        this.nextValue = null;
        return super.finish();
    }

    @Override
    protected boolean accept() {
        return this.value != null;
    }

    @Override
    public IGeneratedTag tag() {
        return null;
    }

    @Override
    public ChangeNature changeNature() {
        return null;
    }

    @Override
    public String getProperty(String name) {
        return name.equalsIgnoreCase(this.scannedProperty) ? this.value : null;
    }

    @Override
    public void rewind() {
        this.nextSegment = null;
        this.nextValue = null;
        super.rewind();
    }
}

