/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.TextCursor;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import java.util.Set;

public class TextPropertiesCursor
extends TextCursor {
    protected Set<String> scannedProperties;
    protected String[] names;
    protected String[] values;
    protected Segment nextSegment;
    protected String[] nextValues;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextPropertiesCursor(UserChangeSet userChangeSet) {
        super(userChangeSet);
    }

    public TextPropertiesCursor(UserChangeSet userChangeSet, Segment firstSegmentToBrowse, Segment lastSegmentToBrowse) {
        super(userChangeSet, firstSegmentToBrowse, lastSegmentToBrowse);
    }

    public TextPropertiesCursor(UserChangeSet userChangeSet, int beginIndex, int endIndex) {
        super(userChangeSet, beginIndex, endIndex);
    }

    public Set<String> getScannedProperties() {
        return this.scannedProperties;
    }

    public void setScannedProperties(Set<String> propertyNames) {
        this.scannedProperties = propertyNames;
    }

    @Override
    protected boolean search() {
        if (this.nextSegment == null && !this.findNextSegment()) {
            return this.finish();
        }
        int begin = this.nextSegment.beginIndex();
        int end = this.nextSegment.endIndex();
        int generatedBegin = this.nextSegment.generatedBeginIndex();
        int generatedEnd = this.nextSegment.generatedEndIndex();
        Segment min = this.nextSegment;
        Segment max = this.nextSegment;
        this.values = this.nextValues();
        this.nextSegment = null;
        while (this.segments.hasNext()) {
            Segment segment = (Segment)this.segments.next();
            int propertiesMatching = this.matchProperties(segment);
            if (propertiesMatching < 2) {
                if (propertiesMatching != 1) break;
                this.nextSegment = segment;
                break;
            }
            end = segment.endIndex();
            generatedEnd = segment.generatedEndIndex();
            max = segment;
        }
        return this.interval(begin, end, generatedBegin, generatedEnd, min, max);
    }

    protected boolean findNextSegment() {
        if (this.segments == null) {
            this.initializeSearch();
            this.initializeValues();
        }
        while (this.segments.hasNext()) {
            Segment newSegment = (Segment)this.segments.next();
            TagProperties properties = newSegment.getTagProperties();
            boolean foundNotNull = false;
            int i = 0;
            while (i < this.names.length) {
                this.nextValues[i] = properties.getProperty(this.names[i]);
                if (this.nextValues[i] != null) {
                    foundNotNull = true;
                }
                ++i;
            }
            if (!foundNotNull) continue;
            this.nextSegment = newSegment;
            return true;
        }
        return false;
    }

    protected void initializeValues() {
        int nbProperties = this.scannedProperties.size();
        this.names = new String[nbProperties];
        this.scannedProperties.toArray(this.names);
        this.values = new String[nbProperties];
        this.nextValues = new String[nbProperties];
    }

    protected String[] nextValues() {
        String[] newValues = this.nextValues;
        this.nextValues = this.values;
        return newValues;
    }

    protected int matchProperties(Segment newSegment) {
        boolean foundNotNull = false;
        boolean perfectMatch = true;
        TagProperties properties = newSegment.getTagProperties();
        int nbProperties = this.names.length;
        int i = 0;
        while (i < nbProperties) {
            String newValue = properties.getProperty(this.names[i]);
            if (newValue != null) {
                foundNotNull = true;
                if (!newValue.equals(this.values[i])) {
                    perfectMatch = false;
                }
            } else if (this.values[i] != null) {
                perfectMatch = false;
            }
            this.nextValues[i] = newValue;
            ++i;
        }
        return perfectMatch ? 2 : (foundNotNull ? 1 : 0);
    }

    protected boolean interval(int b, int e, int gb, int ge, Segment min, Segment max) {
        this.beginIdx = b;
        this.endIdx = e;
        this.generatedBeginIdx = gb;
        this.generatedEndIdx = ge;
        this.minSegment = min;
        this.maxSegment = max;
        return true;
    }

    @Override
    protected boolean finish() {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = null;
            ++i;
        }
        this.nextSegment = null;
        this.nextValues = null;
        return super.finish();
    }

    @Override
    public IGeneratedTag tag() {
        return null;
    }

    @Override
    public ChangeNature changeNature() {
        return null;
    }

    @Override
    public String getProperty(String name) {
        int nbValues = this.names.length;
        int i = 0;
        while (i < nbValues) {
            if (name.equals(this.names[i])) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void rewind() {
        this.nextSegment = null;
        super.rewind();
    }
}

