/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;

public class TextPartitionTranslator {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static int translateIndex(int index, ITextPartition from, ITextPartition to) {
        if (from instanceof ISubTextPartition) {
            if (to instanceof ISubTextPartition) {
                return TextPartitionTranslator.translateIndexSubSub(index, (ISubTextPartition)from, (ISubTextPartition)to);
            }
            return TextPartitionTranslator.translateIndexSubMain(index, (ISubTextPartition)from, to);
        }
        if (to instanceof ISubTextPartition) {
            return TextPartitionTranslator.translateIndexMainSub(index, from, (ISubTextPartition)to);
        }
        TextPartitionTranslator.checkSamePartition(from, to);
        return index;
    }

    protected static int translateIndexSubSub(int index, ISubTextPartition from, ISubTextPartition to) {
        TextPartitionTranslator.checkSamePartition(from.getMainPartition(), to.getMainPartition());
        return index + from.getBeginIndex() - to.getBeginIndex();
    }

    protected static int translateIndexSubMain(int index, ISubTextPartition from, ITextPartition to) {
        TextPartitionTranslator.checkSamePartition(from.getMainPartition(), to);
        return index + from.getBeginIndex();
    }

    protected static int translateIndexMainSub(int index, ITextPartition from, ISubTextPartition to) {
        TextPartitionTranslator.checkSamePartition(from, to.getMainPartition());
        return index - to.getBeginIndex();
    }

    public static int translateWordRank(int wordRank, ITextPartition from, ITextPartition to) {
        if (from instanceof ISubTextPartition) {
            if (to instanceof ISubTextPartition) {
                return TextPartitionTranslator.translateWordRankSubSub(wordRank, (ISubTextPartition)from, (ISubTextPartition)to);
            }
            return TextPartitionTranslator.translateWordRankSubMain(wordRank, (ISubTextPartition)from, to);
        }
        if (to instanceof ISubTextPartition) {
            return TextPartitionTranslator.translateWordRankMainSub(wordRank, from, (ISubTextPartition)to);
        }
        TextPartitionTranslator.checkSamePartition(from, to);
        return wordRank;
    }

    protected static int translateWordRankSubSub(int wordRank, ISubTextPartition from, ISubTextPartition to) {
        TextPartitionTranslator.checkSamePartition(from.getMainPartition(), to.getMainPartition());
        return wordRank + from.getBeginWordRank() - to.getBeginWordRank();
    }

    protected static int translateWordRankSubMain(int wordRank, ISubTextPartition from, ITextPartition to) {
        TextPartitionTranslator.checkSamePartition(from.getMainPartition(), to);
        return wordRank + from.getBeginWordRank();
    }

    protected static int translateWordRankMainSub(int wordRank, ITextPartition from, ISubTextPartition to) {
        TextPartitionTranslator.checkSamePartition(from, to.getMainPartition());
        return wordRank - to.getBeginWordRank();
    }

    protected static void checkSamePartition(ITextPartition left, ITextPartition right) {
        if (left != right) {
            throw new RuntimeException("Incompatible partitions");
        }
    }
}

