/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.FilteredAtomicSegmentIterator;
import com.ibm.pdp.engine.turbo.core.FilteredSegmentIterator;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.TextCursor;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.util.EnumSet;
import java.util.Iterator;

public class TextNatureCursor
extends TextCursor {
    public static final EnumSet<ChangeNature> UnchangedCodeNature = EnumSet.of(ChangeNature.Unchanged);
    public static final EnumSet<ChangeNature> ReformatedCodeNature = EnumSet.of(ChangeNature.Reformated);
    public static final EnumSet<ChangeNature> ModifiedCodeNature = EnumSet.of(ChangeNature.Modified);
    public static final EnumSet<ChangeNature> DeletedCodeNature = EnumSet.of(ChangeNature.Deleted);
    public static final EnumSet<ChangeNature> InsertedCodeNature = EnumSet.of(ChangeNature.Inserted);
    public static final EnumSet<ChangeNature> ReplacedCodeNature = EnumSet.of(ChangeNature.Replaced);
    public static final EnumSet<ChangeNature> DirtyCodeNature = EnumSet.of(ChangeNature.Dirty);
    public static final EnumSet<ChangeNature> GeneratedCodeNature = EnumSet.of(ChangeNature.Unchanged, ChangeNature.Reformated);
    public static final EnumSet<ChangeNature> UserCodeNature = EnumSet.complementOf(GeneratedCodeNature);
    public static final EnumSet<ChangeNature> NonDirtyCodeNature = EnumSet.complementOf(DirtyCodeNature);
    public static final EnumSet<ChangeNature> AnyCodeNature = EnumSet.allOf(ChangeNature.class);
    protected EnumSet<ChangeNature> acceptedChangeNatures;
    protected int minChangeNature;
    protected Segment nextSegment;
    protected int detailedChangeRank;
    protected ChangeNature nature;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextNatureCursor(UserChangeSet userChangeSet) {
        super(userChangeSet);
    }

    public TextNatureCursor(UserChangeSet userChangeSet, Segment firstSegmentToBrowse, Segment lastSegmentToBrowse) {
        super(userChangeSet, firstSegmentToBrowse, lastSegmentToBrowse);
    }

    public TextNatureCursor(UserChangeSet userChangeSet, int beginIndex, int endIndex) {
        super(userChangeSet, beginIndex, endIndex);
    }

    public EnumSet<ChangeNature> getAcceptedChangeNatures() {
        return this.acceptedChangeNatures != null ? this.acceptedChangeNatures : AnyCodeNature;
    }

    public void setAcceptedChangeNatures(EnumSet<ChangeNature> natures) {
        if (this.isSearchStarted()) {
            throw new RuntimeException("Forbidden to change search criteria during search");
        }
        this.acceptedChangeNatures = natures != AnyCodeNature ? natures : null;
    }

    @Override
    protected boolean accept() {
        return this.acceptedChangeNatures == null || this.nature.ordinal() >= this.minChangeNature && this.acceptedChangeNatures.contains((Object)this.nature);
    }

    @Override
    protected boolean search() {
        if (this.nextSegment == null) {
            if (this.segments == null) {
                this.initializeSearch();
            }
            if (!this.segments.hasNext()) {
                int maxIdx = this.lastSegment.endIndex();
                if (this.endIdx >= maxIdx || this.minChangeNature != 0) {
                    return this.finish();
                }
                return this.unchangedInterval(this.endIdx, maxIdx, this.generatedEndIdx, this.lastSegment.generatedEndIndex());
            }
            this.nextSegment = (Segment)this.segments.next();
        }
        ChangeNature n = this.computeChangeNature(this.nextSegment);
        if (this.searchNextDetailedChange(this.nextSegment)) {
            return true;
        }
        int nextIdx = this.nextSegment.beginIndex();
        if (nextIdx > this.endIdx && this.minChangeNature == 0) {
            return this.unchangedInterval(this.endIdx, nextIdx, this.generatedEndIdx, this.nextSegment.generatedBeginIndex());
        }
        int begin = nextIdx;
        int end = this.nextSegment.endIndex();
        int generatedBegin = this.nextSegment.generatedBeginIndex();
        int generatedEnd = this.nextSegment.generatedEndIndex();
        Segment min = this.nextSegment;
        Segment max = this.nextSegment;
        this.nextSegment = null;
        while (this.segments.hasNext()) {
            Segment segment = (Segment)this.segments.next();
            if (segment.beginIndex() != end || this.computeChangeNature(segment) != n) {
                this.nextSegment = segment;
                break;
            }
            end = segment.endIndex();
            generatedEnd = segment.generatedEndIndex();
            max = segment;
        }
        return this.interval(n, begin, end, generatedBegin, generatedEnd, min, max);
    }

    protected boolean interval(ChangeNature n, int b, int e, int gb, int ge, Segment min, Segment max) {
        this.nature = n;
        this.beginIdx = b;
        this.endIdx = e;
        this.generatedBeginIdx = gb;
        this.generatedEndIdx = ge;
        this.minSegment = min;
        this.maxSegment = max;
        return true;
    }

    protected boolean unchangedInterval(int b, int e, int gb, int ge) {
        this.nature = ChangeNature.Unchanged;
        this.beginIdx = b;
        this.endIdx = e;
        this.generatedBeginIdx = gb;
        this.generatedEndIdx = ge;
        Segment segment = this.maxSegment != null ? (this.maxSegment.endIndex() > b ? this.maxSegment : this.maxSegment.nextAtom()) : (this.minSegment = this.firstSegment.firstAtom());
        this.maxSegment = this.nextSegment != null ? (this.nextSegment.beginIndex() < e ? this.nextSegment : this.nextSegment.previousAtom()) : this.lastSegment.lastAtom();
        return true;
    }

    @Override
    protected boolean finish() {
        this.nature = null;
        this.nextSegment = null;
        this.detailedChangeRank = 0;
        return super.finish();
    }

    protected boolean searchNextDetailedChange(Segment segment) {
        IDetailedChanges details = segment.detailedChanges();
        if (details == null) {
            this.detailedChangeRank = 0;
            return false;
        }
        int diffRank = this.detailedChangeRank;
        int nbOfChanges = details.getNbOfDifferences();
        if (diffRank >= nbOfChanges) {
            this.detailedChangeRank = 0;
            return false;
        }
        int shift = segment.beginIndex();
        int genShift = segment.generatedBeginIndex();
        ChangeNature changeNature = details.getChangeNature(diffRank);
        int nextIdx = shift + details.getModifiedBeginIndex(diffRank);
        int nextGenIdx = genShift + details.getReferenceBeginIndex(diffRank);
        if (nextIdx > this.endIdx && this.minChangeNature == 0) {
            return this.unchangedInterval(this.endIdx, nextIdx, this.generatedEndIdx, nextGenIdx);
        }
        int nextEndIdx = shift + details.getModifiedEndIndex(diffRank);
        int nextGenEndIdx = genShift + details.getReferenceEndIndex(diffRank);
        this.interval(changeNature, nextIdx, nextEndIdx, nextGenIdx, nextGenEndIdx, segment, segment);
        if (++this.detailedChangeRank >= nbOfChanges) {
            this.detailedChangeRank = 0;
            this.nextSegment = null;
        }
        return true;
    }

    protected static ChangeNature differenceToChangeNature(DifferenceNature differenceNature) {
        switch (differenceNature) {
            case Deletion: {
                return ChangeNature.Deleted;
            }
            case Insertion: {
                return ChangeNature.Inserted;
            }
            case Replacement: {
                return ChangeNature.Replaced;
            }
        }
        return ChangeNature.Unchanged;
    }

    protected ChangeNature computeChangeNature(Segment s) {
        ChangeNature n = s.getChangeNature();
        if (n != ChangeNature.Dirty || this.matcher == null) {
            return n;
        }
        this.matcher.match(s);
        return s.getChangeNature();
    }

    @Override
    public IGeneratedTag tag() {
        return null;
    }

    @Override
    public ChangeNature changeNature() {
        return this.nature;
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public void rewind() {
        this.nextSegment = null;
        this.detailedChangeRank = 0;
        this.nature = null;
        super.rewind();
    }

    @Override
    protected Iterator<Segment> newSegmentIterator() {
        this.minChangeNature = this.computeMinChangeNature();
        if (this.minChangeNature < 0) {
            return Iterators.emptyIterator();
        }
        if (this.minChangeNature < 2) {
            return this.changedSegments();
        }
        if (this.minChangeNature < 6) {
            return this.modifiedSegments();
        }
        return this.dirtySegments();
    }

    protected int computeMinChangeNature() {
        if (this.acceptedChangeNatures == null) {
            return 0;
        }
        Iterator natures = this.acceptedChangeNatures.iterator();
        return natures.hasNext() ? ((ChangeNature)((Object)natures.next())).ordinal() : -1;
    }

    protected Iterator<Segment> changedSegments() {
        return new FilteredSegmentIterator(this.changeSet.atomArray, this.firstSegment, true, this.lastSegment, true, false, this.changeSet.changedSegmentFilter());
    }

    protected Iterator<Segment> modifiedSegments() {
        return new FilteredSegmentIterator(this.changeSet.atomArray, this.firstSegment, true, this.lastSegment, true, false, this.changeSet.modifiedSegmentFilter());
    }

    protected Iterator<Segment> dirtySegments() {
        return new FilteredAtomicSegmentIterator(this.changeSet.atomArray, this.firstSegment, true, this.lastSegment, true, false, this.changeSet.dirtySegmentFilter());
    }
}

