/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.AtomicSegmentIterator;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.match.IMatcher;
import java.util.Iterator;

public class TextCursor {
    protected UserChangeSet changeSet;
    protected IMatcher matcher;
    protected Segment firstSegment;
    protected Segment lastSegment;
    protected int startIdx;
    protected int stopIdx;
    protected Iterator<Segment> segments;
    protected Segment minSegment;
    protected Segment maxSegment;
    protected int beginIdx;
    protected int endIdx;
    protected int generatedBeginIdx;
    protected int generatedEndIdx;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public TextCursor(UserChangeSet userChangeSet) {
        this.changeSet = userChangeSet;
        this.firstSegment = userChangeSet.rootSegments()[0];
        this.lastSegment = userChangeSet.lastAtom();
        this.startIdx = 0;
        this.stopIdx = userChangeSet.length();
    }

    public TextCursor(UserChangeSet userChangeSet, Segment firstSegmentToBrowse, Segment lastSegmentToBrowse) {
        this.changeSet = userChangeSet;
        this.firstSegment = firstSegmentToBrowse;
        this.lastSegment = lastSegmentToBrowse;
        this.stopIdx = -1;
        this.startIdx = -1;
    }

    public TextCursor(UserChangeSet userChangeSet, int beginIndex, int endIndex) {
        this.changeSet = userChangeSet;
        this.lastSegment = null;
        this.firstSegment = null;
        this.startIdx = beginIndex;
        this.stopIdx = endIndex;
    }

    public IMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(IMatcher m) {
        this.matcher = m;
    }

    public Segment getFirstSegment() {
        if (this.firstSegment == null) {
            this.computeSegmentsFromIndexes(this.startIdx, this.stopIdx);
        }
        return this.firstSegment;
    }

    public Segment getLastSegment() {
        if (this.lastSegment == null) {
            this.computeSegmentsFromIndexes(this.startIdx, this.stopIdx);
        }
        return this.lastSegment;
    }

    public void setSegmentsToBrowse(Segment firstSegmentToBrowse, Segment lastSegmentToBrowse) {
        if (this.isSearchStarted()) {
            throw new RuntimeException("Forbidden to change search interval during search");
        }
        this.firstSegment = firstSegmentToBrowse != null ? firstSegmentToBrowse : this.changeSet.rootSegments()[0];
        this.lastSegment = lastSegmentToBrowse != null ? lastSegmentToBrowse : this.changeSet.lastAtom();
        this.stopIdx = -1;
        this.startIdx = -1;
    }

    public int getStartIndex() {
        if (this.startIdx == -1) {
            this.computeIndexesFromSegments(this.firstSegment, this.lastSegment);
        }
        return this.startIdx;
    }

    public int getStopIndex() {
        if (this.stopIdx == -1) {
            this.computeIndexesFromSegments(this.firstSegment, this.lastSegment);
        }
        return this.stopIdx;
    }

    public void setSearchInterval(int startIndex, int stopIndex) {
        if (this.isSearchStarted()) {
            throw new RuntimeException("Forbidden to change search interval during search");
        }
        this.startIdx = startIndex;
        this.stopIdx = stopIndex;
        this.lastSegment = null;
        this.firstSegment = null;
    }

    public boolean isSearchStarted() {
        return this.segments != null;
    }

    public boolean searchNextTextPortion() {
        while (this.search()) {
            if (this.isBeforeTargetInterval()) continue;
            if (this.isAfterTargetInterval()) {
                return this.finish();
            }
            if (!this.accept()) continue;
            return true;
        }
        return false;
    }

    protected boolean isBeforeTargetInterval() {
        return this.endIdx < this.startIdx || this.endIdx == this.startIdx && this.beginIdx < this.endIdx;
    }

    protected boolean isAfterTargetInterval() {
        return this.beginIdx > this.stopIdx || this.beginIdx == this.stopIdx && this.endIdx > this.beginIdx;
    }

    protected boolean accept() {
        return true;
    }

    protected boolean search() {
        if (this.segments == null) {
            this.initializeSearch();
        }
        if (!this.segments.hasNext()) {
            return this.finish();
        }
        Segment segment = this.segments.next();
        this.beginIdx = segment.beginIndex();
        this.endIdx = segment.endIndex();
        this.generatedBeginIdx = segment.generatedBeginIndex();
        this.generatedEndIdx = segment.generatedEndIndex();
        this.minSegment = this.maxSegment = segment;
        return true;
    }

    protected void initializeSearch() {
        this.initializeBounds();
        this.initializeTextPortion();
        this.segments = this.newSegmentIterator();
    }

    protected void initializeBounds() {
        if (this.startIdx == -1 || this.stopIdx == -1) {
            if (this.firstSegment == null) {
                this.firstSegment = this.changeSet.rootSegments()[0];
            }
            if (this.lastSegment == null) {
                this.lastSegment = this.changeSet.lastAtom();
            }
            this.computeIndexesFromSegments(this.firstSegment, this.lastSegment);
        } else if (this.firstSegment == null || this.lastSegment == null) {
            this.computeSegmentsFromIndexes(this.startIdx, this.stopIdx);
        }
    }

    protected void initializeTextPortion() {
        this.beginIdx = this.endIdx = this.firstSegment.beginIndex();
        this.generatedBeginIdx = this.generatedEndIdx = this.firstSegment.generatedBeginIndex();
    }

    protected boolean finish() {
        this.beginIdx = this.endIdx = this.lastSegment.endIndex();
        this.generatedBeginIdx = this.generatedEndIdx = this.lastSegment.generatedEndIndex();
        this.maxSegment = null;
        this.minSegment = null;
        return false;
    }

    public boolean hasFoundTextPortion() {
        return this.minSegment != null;
    }

    public IGeneratedTag tag() {
        return this.minSegment.enclosingTag();
    }

    public ChangeNature changeNature() {
        return this.minSegment.getChangeNature();
    }

    public String getProperty(String name) {
        return this.minSegment.getTagProperties().getProperty(name);
    }

    public int beginIndex() {
        return this.beginIdx;
    }

    public int endIndex() {
        return this.endIdx;
    }

    public int generatedBeginIndex() {
        return this.generatedBeginIdx;
    }

    public int generatedEndIndex() {
        return this.generatedEndIdx;
    }

    public Segment minSegment() {
        return this.minSegment;
    }

    public Segment maxSegment() {
        return this.maxSegment;
    }

    public void rewind() {
        this.segments = null;
        this.beginIdx = this.endIdx = this.firstSegment.beginIndex();
        this.generatedBeginIdx = this.generatedEndIdx = this.firstSegment.generatedBeginIndex();
        this.maxSegment = null;
        this.minSegment = null;
    }

    protected Iterator<Segment> newSegmentIterator() {
        return new AtomicSegmentIterator(this.changeSet.atomArray, this.firstSegment, true, this.lastSegment, true, false);
    }

    protected void computeIndexesFromSegments(Segment minSegment, Segment maxSegment) {
        if (this.matcher != null) {
            if (minSegment.getChangeNature() == ChangeNature.Dirty) {
                this.matcher.match(minSegment);
            }
            if (maxSegment != minSegment && maxSegment.getChangeNature() == ChangeNature.Dirty) {
                this.matcher.match(maxSegment);
            }
        }
        this.startIdx = minSegment.beginIndex();
        this.stopIdx = maxSegment.endIndex();
    }

    protected void computeSegmentsFromIndexes(int beginIndex, int endIndex) {
        if (this.matcher == null) {
            this.computeSegmentsFromIndexesNoMatch(beginIndex, endIndex);
        } else {
            this.computeSegmentsFromIndexesMatch(beginIndex, endIndex);
        }
    }

    protected void computeSegmentsFromIndexesNoMatch(int beginIndex, int endIndex) {
        int beginAtomRank = 0;
        int endAtomRank = this.changeSet.nbOfAtomicSegments();
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            Segment segment = this.changeSet.atomAt(middleAtomRank);
            if (segment.beginIndex() > endIndex) {
                endAtomRank = middleAtomRank;
                continue;
            }
            if (segment.endIndex() < beginIndex) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            beginAtomRank = this.leftAtomTouchingNoMatch(beginIndex, beginAtomRank, middleAtomRank + 1);
            endAtomRank = this.rightAtomTouchingNoMatch(endIndex, middleAtomRank, endAtomRank);
            this.firstSegment = this.changeSet.atomAt(beginAtomRank).supersedingSegment();
            this.lastSegment = this.changeSet.atomAt(endAtomRank - 1);
            return;
        }
    }

    protected int leftAtomTouchingNoMatch(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            if (this.changeSet.atomAt(middleAtomRank).endIndex() < index) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            endAtomRank = middleAtomRank;
        }
        return beginAtomRank;
    }

    protected int rightAtomTouchingNoMatch(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            if (this.changeSet.atomAt(middleAtomRank).beginIndex() > index) {
                endAtomRank = middleAtomRank;
                continue;
            }
            beginAtomRank = middleAtomRank + 1;
        }
        return beginAtomRank;
    }

    protected void computeSegmentsFromIndexesMatch(int beginIndex, int endIndex) {
        int beginAtomRank = 0;
        int endAtomRank = this.changeSet.nbOfAtomicSegments();
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            Segment segment = this.changeSet.atomAt(middleAtomRank);
            if (segment.getChangeNature() == ChangeNature.Dirty) {
                this.matcher.match(segment);
            }
            if (segment.beginIndex() > endIndex) {
                endAtomRank = middleAtomRank;
                continue;
            }
            if (segment.endIndex() < beginIndex) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            beginAtomRank = this.leftAtomTouchingMatch(beginIndex, beginAtomRank, middleAtomRank + 1);
            endAtomRank = this.rightAtomTouchingMatch(endIndex, middleAtomRank, endAtomRank);
            this.firstSegment = this.changeSet.atomAt(beginAtomRank).supersedingSegment();
            this.lastSegment = this.changeSet.atomAt(endAtomRank - 1);
            return;
        }
    }

    protected int leftAtomTouchingMatch(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            Segment segment = this.changeSet.atomAt(middleAtomRank);
            if (segment.getChangeNature() == ChangeNature.Dirty) {
                this.matcher.match(segment);
            }
            if (segment.endIndex() < index) {
                beginAtomRank = middleAtomRank + 1;
                continue;
            }
            endAtomRank = middleAtomRank;
        }
        return beginAtomRank;
    }

    protected int rightAtomTouchingMatch(int index, int beginAtomRank, int endAtomRank) {
        while (beginAtomRank < endAtomRank) {
            int middleAtomRank = beginAtomRank + endAtomRank >> 1;
            Segment segment = this.changeSet.atomAt(middleAtomRank);
            if (segment.getChangeNature() == ChangeNature.Dirty) {
                this.matcher.match(segment);
            }
            if (segment.beginIndex() > index) {
                endAtomRank = middleAtomRank;
                continue;
            }
            beginAtomRank = middleAtomRank + 1;
        }
        return beginAtomRank;
    }
}

