/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticPartSegment;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.util.Interval;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SyntacticTagSegment
extends Segment {
    protected TagProperties properties;
    protected SyntacticTag tag;
    protected int genBeginIdx;
    protected int genEndIdx;
    protected int minRank;
    protected int maxRank;
    protected Segment[] subSegments;
    protected int status;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected SyntacticTagSegment(UserChangeSet userChangeSet, Segment parentSegment, Segment enclosingSegment, SyntacticTag syntacticTag, int minAtomRank, int maxAtomRank) {
        super(userChangeSet, parentSegment);
        this.enclosing = enclosingSegment;
        this.tag = syntacticTag;
        this.minRank = minAtomRank;
        this.maxRank = maxAtomRank;
        this.genBeginIdx = -1;
        this.genEndIdx = -1;
        this.status = 6;
    }

    @Override
    public int generatedLevel() {
        return this.parent.generatedLevel();
    }

    @Override
    public TagProperties getTagProperties() {
        if (this.properties == null) {
            this.properties = this.newTagProperties();
        }
        return this.properties;
    }

    protected TagProperties newTagProperties() {
        return new TagProperties((Segment)this, this.tag);
    }

    @Override
    public boolean isSyntactic() {
        return true;
    }

    @Override
    public String enclosingTagName() {
        return this.tag.getName();
    }

    @Override
    public String fromTagName() {
        return this.tag.getName();
    }

    @Override
    public String toTagName() {
        return this.tag.getName();
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isFirstPart() {
        return false;
    }

    @Override
    public boolean isLastPart() {
        return false;
    }

    @Override
    public boolean isMiddlePart() {
        return false;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return true;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public Segment enclosingSegment() {
        return this.enclosing;
    }

    @Override
    public boolean isLeaf() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments.length == 0;
    }

    @Override
    public Segment[] subSegments() {
        if (this.subSegments == null) {
            this.subSegments = this.buildSubSegments();
        }
        return this.subSegments;
    }

    protected Segment[] buildSubSegments() {
        if (this.minRank == this.maxRank) {
            return this.buildSubSegmentsInAtom(this.minRank);
        }
        Segment[] sons = this.parent != null ? this.parent.sons() : this.changeSet.rootSegments();
        int startSonRank = this.sonRankFromAtomRank(this.minRank, sons, 0);
        int stopSonRank = this.sonRankFromAtomRank(this.maxRank, sons, startSonRank);
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return this.buildSubSegmentsNoSubTags(sons, startSonRank, stopSonRank);
        }
        int minSonRank = startSonRank;
        Iterator<SyntacticTag> subtags = si.subTags(this.tag);
        ArrayList<Segment> subSegmentsList = null;
        while (subtags.hasNext()) {
            SyntacticTag subtag = subtags.next();
            if (!subtag.isToInsertInEditTree()) continue;
            Segment son = sons[minSonRank];
            int tagBeginIdx = subtag.beginIndex();
            while (son.endIndex() < tagBeginIdx) {
                son = sons[++minSonRank];
            }
            while (son.endIndex() == tagBeginIdx) {
                int syntacticTagBeginRank;
                int maxRank = son.maxRank();
                Interval interval = new Interval(0, this.changeSet.nbAtom);
                int nbAtoms = this.changeSet.atomsTouching(tagBeginIdx + 1, tagBeginIdx + 1, interval);
                if (nbAtoms != 1 || maxRank >= (syntacticTagBeginRank = interval.begin)) break;
                son = sons[++minSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagBeginIdx) continue;
                son = sons[++minSonRank];
            }
            int maxSonRank = minSonRank;
            int tagEndIdx = subtag.endIndex();
            while (son.endIndex() < tagEndIdx) {
                son = sons[++maxSonRank];
            }
            if (son.isTagged()) {
                if (son.endIndex() != tagEndIdx) {
                    minSonRank = maxSonRank;
                    continue;
                }
                ++maxSonRank;
            }
            if (subSegmentsList == null) {
                subSegmentsList = new ArrayList<Segment>();
            }
            this.addSubSegments(sons, startSonRank, minSonRank, maxSonRank, subtag, subSegmentsList);
            startSonRank = minSonRank = maxSonRank;
        }
        if (subSegmentsList == null) {
            return this.buildSubSegmentsNoSubTags(sons, startSonRank, stopSonRank);
        }
        this.completeSubSegments(sons, startSonRank, stopSonRank, subSegmentsList);
        Segment[] subSegments = new Segment[subSegmentsList.size()];
        subSegmentsList.toArray(subSegments);
        return subSegments;
    }

    protected int sonRankFromAtomRank(int atomRank, Segment[] sons, int sonRank) {
        Segment atom = this.changeSet.atomAt(atomRank);
        while (sons[sonRank] != atom) {
            ++sonRank;
        }
        return sonRank;
    }

    protected void addSubSegments(Segment[] sons, int startSonRank, int minSonRank, int maxSonRank, SyntacticTag tag, List<Segment> subSegmentsList) {
        SyntacticTagSegment previous;
        int tagMinRank = sons[minSonRank].minRank();
        int tagMaxRank = sons[maxSonRank].maxRank();
        SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(this.parent, this, tag, tagMinRank, tagMaxRank);
        Segment segment = previous = subSegmentsList.isEmpty() ? this : subSegmentsList.get(subSegmentsList.size() - 1);
        if (startSonRank == minSonRank) {
            SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, tagSegment, tagMinRank);
            subSegmentsList.add(part);
            subSegmentsList.add(tagSegment);
            return;
        }
        int rank1 = sons[startSonRank].minRank();
        SyntacticPartSegment part1 = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, sons[++startSonRank], rank1);
        subSegmentsList.add(part1);
        do {
            Segment toAdd = sons[startSonRank];
            subSegmentsList.add(toAdd);
            toAdd.enclosing = this;
        } while (++startSonRank < minSonRank);
        SyntacticPartSegment part2 = this.changeSet.newSyntacticPartSegment(this.parent, this, sons[minSonRank - 1], tagSegment, tagMinRank);
        subSegmentsList.add(part2);
        subSegmentsList.add(tagSegment);
    }

    protected void completeSubSegments(Segment[] sons, int minSonRank, int maxSonRank, List<Segment> subSegmentsList) {
        int rank1 = sons[minSonRank].minRank();
        Segment previous = subSegmentsList.get(subSegmentsList.size() - 1);
        if (minSonRank == maxSonRank) {
            SyntacticPartSegment part = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, this, rank1);
            subSegmentsList.add(part);
            return;
        }
        SyntacticPartSegment part1 = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, sons[++minSonRank], rank1);
        subSegmentsList.add(part1);
        do {
            Segment toAdd = sons[minSonRank];
            subSegmentsList.add(toAdd);
            toAdd.enclosing = this;
        } while (++minSonRank < maxSonRank);
        int rank2 = sons[maxSonRank].maxRank();
        SyntacticPartSegment part2 = this.changeSet.newSyntacticPartSegment(this.parent, this, sons[maxSonRank - 1], this, rank2);
        subSegmentsList.add(part2);
    }

    protected Segment[] buildSubSegmentsInAtom(int rank) {
        SyntacticInfo si = this.changeSet.getSyntacticInfo();
        if (si == null) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        int nbOfSubTags = 0;
        Iterator<SyntacticTag> subtags = si.subTags(this.tag);
        while (subtags.hasNext()) {
            SyntacticTag subtag = subtags.next();
            if (!subtag.isToInsertInEditTree()) continue;
            ++nbOfSubTags;
        }
        if (nbOfSubTags == 0) {
            return Segment.EMPTY_SEGMENT_ARRAY;
        }
        Segment[] subSegments = new Segment[1 + (nbOfSubTags << 1)];
        int count = 0;
        SyntacticTagSegment previous = this;
        subtags = si.subTags(this.tag);
        while (subtags.hasNext()) {
            SyntacticTag tag = subtags.next();
            if (!tag.isToInsertInEditTree()) continue;
            SyntacticTagSegment tagSegment = this.changeSet.newSyntacticTagSegment(this.parent, this, tag, rank, rank);
            subSegments[count++] = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, tagSegment, rank);
            subSegments[count++] = tagSegment;
            previous = tagSegment;
        }
        subSegments[count] = this.changeSet.newSyntacticPartSegment(this.parent, this, previous, this, rank);
        return subSegments;
    }

    protected Segment[] buildSubSegmentsNoSubTags(Segment[] sons, int minSonRank, int maxSonRank) {
        Segment[] subSegments = new Segment[maxSonRank - minSonRank + 1];
        subSegments[0] = this.changeSet.newSyntacticPartSegment(this.parent, this, this, sons[minSonRank + 1], this.minRank);
        int count = 1;
        while (++minSonRank < maxSonRank) {
            Segment son = sons[minSonRank];
            subSegments[count++] = son;
            son.enclosing = this;
        }
        subSegments[count] = this.changeSet.newSyntacticPartSegment(this.parent, this, sons[maxSonRank - 1], this, this.maxRank);
        return subSegments;
    }

    @Override
    protected boolean dirtySubSegments() {
        return this.subSegments == null;
    }

    @Override
    protected void touchSubSegments() {
        if (this.subSegments == null) {
            return;
        }
        Segment parentSegment = this.parent != null ? this.parent : this.changeSet.topSegment;
        Segment[] segmentArray = this.subSegments;
        int n = this.subSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment subSegment = segmentArray[n2];
            if (subSegment.isSyntactic()) {
                if (subSegment.isTagged()) {
                    this.changeSet.syntacticTagNameToSegment.remove(subSegment.enclosingTagName());
                    subSegment.touchSubSegments();
                }
            } else {
                subSegment.enclosing = parentSegment;
            }
            ++n2;
        }
        this.subSegments = null;
    }

    @Override
    public int beginIndex() {
        return this.tag.beginIndex();
    }

    @Override
    public int endIndex() {
        return this.tag.endIndex();
    }

    @Override
    public IDetailedChanges detailedChanges() {
        return null;
    }

    @Override
    public void setDetailedChanges(IDetailedChanges newDetails) {
        throw new UnsupportedOperationException("SyntacticTagSegment.setDetailedChanges");
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return this.parent != null ? this.parent.enclosingTag() : null;
    }

    @Override
    public int generatedBeginIndex() {
        if (this.genBeginIdx < 0) {
            this.computeGeneratedIndexes();
        }
        return this.genBeginIdx;
    }

    @Override
    public int generatedEndIndex() {
        if (this.genEndIdx < 0) {
            this.computeGeneratedIndexes();
        }
        return this.genEndIdx;
    }

    @Override
    public int generatedLength() {
        if (this.genBeginIdx < 0) {
            this.computeGeneratedIndexes();
        }
        return this.genEndIdx - this.genBeginIdx;
    }

    @Override
    public CharSequence generatedText() {
        int genEndIdx;
        int genBeginIdx;
        if (this.genBeginIdx < 0 || this.genEndIdx < 0) {
            this.computeGeneratedIndexes();
        }
        if ((genBeginIdx = this.generatedBeginIndex()) >= (genEndIdx = this.generatedEndIndex())) {
            return "";
        }
        return this.changeSet.generatedText().subSequence(genBeginIdx, genEndIdx);
    }

    protected void computeGeneratedIndexes() {
        if (this.minRank != this.maxRank) {
            this.computeGeneratedBeginIndex(this.changeSet.atomAt(this.minRank));
            this.computeGeneratedEndIndex(this.changeSet.atomAt(this.maxRank));
        } else {
            this.computeGeneratedIndexesSingleSegment(this.changeSet.atomAt(this.minRank));
        }
    }

    protected void computeGeneratedBeginIndex(Segment atom) {
        switch (atom.getSegmentStatus()) {
            case 0: {
                this.computeGeneratedBeginIndexUnchangedSegment(atom);
                return;
            }
            case 1: {
                this.computeGeneratedBeginIndexReformatedSegment(atom);
                return;
            }
            case 2: {
                this.computeGeneratedBeginIndexModifiedSegment(atom);
                return;
            }
            case 3: {
                this.computeGeneratedBeginIndexDeletedSegment(atom);
                return;
            }
            case 4: {
                this.computeGeneratedBeginIndexInsertedSegment(atom);
                return;
            }
            case 5: 
            case 6: {
                this.computeGeneratedBeginIndexReplacedSegment(atom);
                return;
            }
        }
    }

    protected void computeGeneratedBeginIndexUnchangedSegment(Segment atom) {
        this.genBeginIdx = this.beginIndex() - atom.beginIndex() + atom.generatedBeginIndex();
    }

    protected void computeGeneratedBeginIndexReformatedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            return;
        }
        DiffCursor diffs = Strings.newDiffCursor((CharSequence)atom.generatedText(), (CharSequence)atom.getText());
        int idx = this.beginIndex() - atom.beginIndex();
        diffs.moveToModifiedIndex(idx);
        this.genBeginIdx = atom.generatedBeginIndex() + (idx == diffs.getModifiedBeginIndex() ? diffs.getReferenceBeginIndex() : diffs.getReferenceEndIndex());
    }

    protected void computeGeneratedBeginIndexModifiedSegment(Segment atom) {
        this.genBeginIdx = this.beginIndex() == atom.beginIndex() ? atom.generatedBeginIndex() : this.modifiedToGeneratedBeginIdx(this.beginIndex(), atom);
    }

    protected void computeGeneratedBeginIndexDeletedSegment(Segment atom) {
        this.genBeginIdx = this.beginIndex() == atom.beginIndex() ? atom.generatedBeginIndex() : atom.generatedEndIndex();
    }

    protected void computeGeneratedBeginIndexInsertedSegment(Segment atom) {
        this.genBeginIdx = this.beginIndex() == atom.beginIndex() ? atom.generatedBeginIndex() : atom.generatedEndIndex();
    }

    protected void computeGeneratedBeginIndexReplacedSegment(Segment atom) {
        this.genBeginIdx = this.beginIndex() == atom.beginIndex() ? atom.generatedBeginIndex() : atom.generatedEndIndex();
    }

    protected void computeGeneratedEndIndex(Segment atom) {
        switch (atom.getSegmentStatus()) {
            case 0: {
                this.computeGeneratedEndIndexUnchangedSegment(atom);
                return;
            }
            case 1: {
                this.computeGeneratedEndIndexReformatedSegment(atom);
                return;
            }
            case 2: {
                this.computeGeneratedEndIndexModifiedSegment(atom);
                return;
            }
            case 3: {
                this.computeGeneratedEndIndexDeletedSegment(atom);
                return;
            }
            case 4: {
                this.computeGeneratedEndIndexInsertedSegment(atom);
                return;
            }
            case 5: 
            case 6: {
                this.computeGeneratedEndIndexReplacedSegment(atom);
                return;
            }
        }
    }

    protected void computeGeneratedEndIndexUnchangedSegment(Segment atom) {
        this.genEndIdx = this.endIndex() - atom.beginIndex() + atom.generatedBeginIndex();
    }

    protected void computeGeneratedEndIndexReformatedSegment(Segment atom) {
        if (this.endIndex() == atom.endIndex()) {
            this.genEndIdx = atom.generatedEndIndex();
            return;
        }
        DiffCursor diffs = Strings.newDiffCursor((CharSequence)atom.generatedText(), (CharSequence)atom.getText());
        int idx = this.endIndex() - atom.beginIndex();
        diffs.moveToModifiedIndex(idx);
        this.genEndIdx = atom.generatedBeginIndex() + (idx == diffs.getModifiedEndIndex() ? diffs.getReferenceEndIndex() : diffs.getReferenceBeginIndex());
    }

    protected void computeGeneratedEndIndexModifiedSegment(Segment atom) {
        this.genEndIdx = this.endIndex() == atom.endIndex() ? atom.generatedEndIndex() : this.modifiedToGeneratedEndIdx(this.endIndex(), atom);
    }

    protected void computeGeneratedEndIndexDeletedSegment(Segment atom) {
        this.genEndIdx = this.endIndex() == atom.endIndex() ? atom.generatedEndIndex() : atom.generatedBeginIndex();
    }

    protected void computeGeneratedEndIndexInsertedSegment(Segment atom) {
        this.genEndIdx = this.endIndex() == atom.endIndex() ? atom.generatedEndIndex() : atom.generatedBeginIndex();
    }

    protected void computeGeneratedEndIndexReplacedSegment(Segment atom) {
        this.genEndIdx = this.endIndex() == atom.endIndex() ? atom.generatedEndIndex() : atom.generatedBeginIndex();
    }

    protected void computeGeneratedIndexesSingleSegment(Segment atom) {
        switch (atom.getSegmentStatus()) {
            case 0: {
                this.computeGeneratedIndexesUnchangedSegment(atom);
                return;
            }
            case 1: {
                this.computeGeneratedIndexesReformatedSegment(atom);
                return;
            }
            case 2: {
                this.computeGeneratedIndexesModifiedSegment(atom);
                return;
            }
            case 3: {
                this.computeGeneratedIndexesDeletedSegment(atom);
                return;
            }
            case 4: {
                this.computeGeneratedIndexesInsertedSegment(atom);
                return;
            }
            case 5: 
            case 6: {
                this.computeGeneratedIndexesReplacedSegment(atom);
                return;
            }
        }
    }

    protected void computeGeneratedIndexesUnchangedSegment(Segment atom) {
        this.genBeginIdx = atom.generatedBeginIndex() + this.beginIndex() - atom.beginIndex();
        this.genEndIdx = atom.generatedBeginIndex() + this.endIndex() - atom.beginIndex();
    }

    protected void computeGeneratedIndexesReformatedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex() && this.endIndex() == atom.endIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            this.genEndIdx = atom.generatedEndIndex();
        } else {
            Interval interval = new Interval(this.beginIndex() - atom.beginIndex(), this.endIndex() - atom.beginIndex());
            this.convertModifiedIntervalToReferenceInterval(interval, atom.generatedText(), atom.getText());
            this.genBeginIdx = atom.generatedBeginIndex() + interval.begin;
            this.genEndIdx = atom.generatedBeginIndex() + interval.end;
        }
    }

    protected void convertModifiedIntervalToReferenceInterval(Interval interval, CharSequence ref, CharSequence mod) {
        int modBeginIdx = interval.begin;
        int modEndIdx = interval.end;
        DiffCursor diffs = Strings.newDiffCursor((CharSequence)ref, (CharSequence)mod);
        diffs.moveToModifiedIndex(modBeginIdx);
        interval.begin = diffs.getReferenceEndIndex();
        diffs.moveToModifiedIndex(modEndIdx);
        interval.end = diffs.getReferenceBeginIndex();
        if (interval.begin > interval.end) {
            interval.end = interval.begin;
        }
    }

    protected void computeGeneratedIndexesModifiedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex() && this.endIndex() == atom.endIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            this.genEndIdx = atom.generatedEndIndex();
        } else {
            this.genBeginIdx = this.modifiedToGeneratedBeginIdx(this.beginIndex(), atom);
            this.genEndIdx = this.modifiedToGeneratedEndIdx(this.endIndex(), atom);
            if (this.genEndIdx < this.genBeginIdx) {
                this.genEndIdx = this.genBeginIdx;
            }
        }
    }

    protected int modifiedToGeneratedBeginIdx(int idx, Segment atom) {
        IDetailedChanges details = atom.detailedChanges();
        if (details == null) {
            return atom.generatedEndIndex();
        }
        idx -= atom.beginIndex();
        int nbDifferences = details.getNbOfDifferences();
        int diffRank = 0;
        while (diffRank < nbDifferences) {
            int modEndIdx = details.getModifiedEndIndex(diffRank);
            if (modEndIdx >= idx) {
                int modBeginIdx = details.getModifiedBeginIndex(diffRank);
                return atom.generatedBeginIndex() + (modBeginIdx < idx ? details.getReferenceEndIndex(diffRank) : details.getReferenceBeginIndex(diffRank) + idx - modBeginIdx);
            }
            ++diffRank;
        }
        return atom.generatedEndIndex() + idx - atom.length();
    }

    protected int modifiedToGeneratedEndIdx(int idx, Segment atom) {
        IDetailedChanges details = atom.detailedChanges();
        if (details == null) {
            return atom.generatedBeginIndex();
        }
        idx -= atom.beginIndex();
        int diffRank = details.getNbOfDifferences() - 1;
        while (diffRank >= 0) {
            int modBeginIdx = details.getModifiedBeginIndex(diffRank);
            if (modBeginIdx <= idx) {
                int modEndIdx = details.getModifiedEndIndex(diffRank);
                return atom.generatedBeginIndex() + (modEndIdx > idx ? details.getReferenceBeginIndex(diffRank) : details.getReferenceEndIndex(diffRank) + idx - modEndIdx);
            }
            --diffRank;
        }
        return atom.generatedBeginIndex() + idx;
    }

    protected void computeGeneratedIndexesDeletedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex() && this.endIndex() == atom.endIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            this.genEndIdx = atom.generatedEndIndex();
        } else {
            this.genBeginIdx = this.genEndIdx = atom.generatedEndIndex();
        }
    }

    protected void computeGeneratedIndexesInsertedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex() && this.endIndex() == atom.endIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            this.genEndIdx = atom.generatedEndIndex();
        } else {
            this.genBeginIdx = this.genEndIdx = atom.generatedEndIndex();
        }
    }

    protected void computeGeneratedIndexesReplacedSegment(Segment atom) {
        if (this.beginIndex() == atom.beginIndex() && this.endIndex() == atom.endIndex()) {
            this.genBeginIdx = atom.generatedBeginIndex();
            this.genEndIdx = atom.generatedEndIndex();
        } else {
            this.genBeginIdx = this.genEndIdx = atom.generatedEndIndex();
        }
    }

    @Override
    public ChangeNature getChangeNature() {
        return Segment.changeNatureFromStatus(this.getSegmentStatus());
    }

    @Override
    protected int getSegmentStatus() {
        if (this.status == 6) {
            this.status = this.computeStatus();
        }
        return this.status;
    }

    protected int computeStatus() {
        return 4;
    }

    @Override
    public ChangeNature getSubtreesChangeNature() {
        return Segment.changeNatureFromStatus(this.getSubtreesStatus());
    }

    protected int getSubtreesStatus() {
        if (this.minRank == this.maxRank) {
            return 0;
        }
        int maxChangeLevel = 0;
        Segment[] segmentArray = this.subSegments();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            int subSegmentChangeLevel;
            Segment subSegment = segmentArray[n2];
            if (!subSegment.isSyntactic() && (subSegmentChangeLevel = SyntacticTagSegment.changeLevel(subSegment.getSegmentStatus())) > maxChangeLevel) {
                maxChangeLevel = subSegmentChangeLevel;
            }
            ++n2;
        }
        return maxChangeLevel;
    }

    @Override
    public ChangeNature getTreeChangeNature() {
        return Segment.changeNatureFromStatus(this.getTreeStatus());
    }

    @Override
    protected int getTreeStatus() {
        return Math.max(this.getSegmentStatus(), this.getSubtreesStatus());
    }

    @Override
    public boolean restoreGeneratedText() {
        return this.changeSet.restoreGeneratedText(this.beginIndex(), this.endIndex());
    }

    @Override
    public int length() {
        return this.endIndex() - this.beginIndex();
    }

    @Override
    public int maxRank() {
        return this.maxRank;
    }

    @Override
    public int minRank() {
        return this.minRank;
    }

    @Override
    public boolean isAncestorOf(Segment segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Segment firstAtom() {
        return this.changeSet.atomAt(this.minRank);
    }

    @Override
    public Segment lastAtom() {
        return this.changeSet.atomAt(this.maxRank);
    }

    @Override
    public int nbOfSons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nbOfTaggedSons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Segment nextAtom() {
        return this.maxRank < this.changeSet.nbAtom - 1 ? this.changeSet.atomAt(this.maxRank + 1) : null;
    }

    @Override
    public Segment previousAtom() {
        return this.maxRank > 0 ? this.changeSet.atomAt(this.minRank - 1) : null;
    }

    @Override
    public Segment nextBrother() {
        return this.changeSet.atomAt(this.maxRank).nextBrother();
    }

    @Override
    public Segment previousBrother() {
        return this.changeSet.atomAt(this.minRank).previousBrother();
    }

    @Override
    public void setBeginIndex(int newBeginIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChangeNature(ChangeNature newChangeNature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(CharSequence newText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Segment[] sons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IGeneratedTag fromTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IGeneratedTag toTag() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("genBeginIndex:");
        sb.append(this.generatedBeginIndex());
        sb.append(" genEndIndex:");
        sb.append(this.generatedEndIndex());
        sb.append(this.generatedEndIndex() >= this.generatedBeginIndex() ? " OK" : " KO");
        sb.append("\n");
        sb.append("gen :");
        sb.append(this.generatedText());
        sb.append("\ntext:");
        if (this.beginIndex() == -1) {
            sb.append("Unknown");
        } else if (this.endIndex() == -1) {
            sb.append("next BeginIndex =-1");
        } else {
            sb.append(this.getText());
        }
        return String.valueOf(this.tag.getName()) + " [" + this.tag.beginIndex() + ", " + this.tag.endIndex() + "]" + sb.toString();
    }
}

