/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.core.SyntacticTagBegin;
import com.ibm.pdp.engine.turbo.core.SyntacticTagEnd;
import com.ibm.pdp.util.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyntacticTag {
    protected String name;
    protected SyntacticTagBegin beginMark;
    protected SyntacticTagEnd endMark;
    protected Map<String, String> properties;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SyntacticTag(String tagName) {
        this.name = tagName;
        this.properties = new HashMap<String, String>();
        this.properties.put("SyntacticTag", "true");
    }

    public String getName() {
        return this.name;
    }

    public Iterator<String> propertyNames() {
        if (this.properties == null) {
            return Iterators.emptyIterator();
        }
        return this.properties.keySet().iterator();
    }

    public String getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public int beginIndex() {
        return this.beginMark != null ? this.beginMark.index : -1;
    }

    public int endIndex() {
        return this.endMark != null ? this.endMark.index : -1;
    }

    public boolean isValid() {
        String invalid = this.getProperty("invalid");
        if (invalid != null && invalid.equalsIgnoreCase("true")) {
            return false;
        }
        return this.beginMark != null && this.endMark != null && this.beginMark.index >= 0 && this.endMark.index >= 0 && this.beginMark.index <= this.endMark.index;
    }

    public boolean isToInsertInEditTree() {
        if (this.properties == null) {
            return true;
        }
        String editTreeValue = this.properties.get("EditTree");
        return editTreeValue == null || !editTreeValue.equalsIgnoreCase("ignore");
    }

    public boolean isToReconcile() {
        if (this.properties == null) {
            return true;
        }
        String reconcileValue = this.properties.get("ReconcileMode");
        return reconcileValue == null || !reconcileValue.equalsIgnoreCase("ignore");
    }

    protected SyntacticTagBegin addBeginMark(int index) {
        SyntacticTagBegin lastMark = null;
        SyntacticTagBegin mark = this.beginMark;
        while (mark != null) {
            if (mark.index == index) {
                return null;
            }
            lastMark = mark;
            mark = mark.next;
        }
        SyntacticTagBegin newMark = new SyntacticTagBegin(this, index);
        if (lastMark != null) {
            lastMark.next = newMark;
        } else {
            this.beginMark = newMark;
        }
        return newMark;
    }

    protected SyntacticTagEnd addEndMark(int index) {
        SyntacticTagEnd lastMark = null;
        SyntacticTagEnd mark = this.endMark;
        while (mark != null) {
            if (mark.index == index) {
                return null;
            }
            lastMark = mark;
            mark = mark.next;
        }
        SyntacticTagEnd newMark = new SyntacticTagEnd(this, index);
        if (lastMark != null) {
            lastMark.next = newMark;
        } else {
            this.endMark = newMark;
        }
        return newMark;
    }

    protected boolean removeMark(SyntacticMark mark) {
        return mark.isBeginMark() ? this.removeBeginMark(mark) : this.removeEndMark(mark);
    }

    protected boolean removeBeginMark(SyntacticMark markToRemove) {
        SyntacticTagBegin mark = this.beginMark;
        if (mark == markToRemove) {
            this.beginMark = mark.next;
            return true;
        }
        SyntacticTagBegin previous = mark;
        mark = mark.next;
        while (mark != null) {
            if (mark == markToRemove) {
                previous.next = mark.next;
                return true;
            }
            previous = mark;
            mark = mark.next;
        }
        return false;
    }

    protected boolean removeEndMark(SyntacticMark markToRemove) {
        SyntacticTagEnd mark = this.endMark;
        if (mark == markToRemove) {
            this.endMark = mark.next;
            return true;
        }
        SyntacticTagEnd previous = mark;
        mark = mark.next;
        while (mark != null) {
            if (mark == markToRemove) {
                previous.next = mark.next;
                return true;
            }
            previous = mark;
            mark = mark.next;
        }
        return false;
    }

    protected void removeAllMarks() {
        this.beginMark = null;
        this.endMark = null;
    }

    public String toString() {
        return this.name;
    }
}

