/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.turbo.core.SyntacticInfo;
import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.core.SyntacticProblemEnd;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.util.Iterators;
import java.util.Iterator;

public class SyntacticProblemBegin
extends SyntacticMark
implements IProblem {
    protected SyntacticInfo info;
    protected SyntacticProblemEnd peer;
    protected String problemCode;
    protected boolean error;
    protected boolean warning;
    protected String message;
    protected String[] parameters;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SyntacticProblemBegin(SyntacticInfo syntacticInfo) {
        this.info = syntacticInfo;
    }

    public SyntacticProblemBegin(SyntacticInfo syntacticInfo, int initialIndex) {
        super(initialIndex);
        this.info = syntacticInfo;
    }

    @Override
    public SyntacticMark getPeer() {
        return this.peer;
    }

    public void setPeer(SyntacticProblemEnd newPeer) {
        this.peer = newPeer;
    }

    public void setProblem(IProblem problem) {
        this.problemCode = problem.code();
        this.error = problem.isError();
        this.warning = problem.isWarning();
        this.message = problem.message();
        this.parameters = problem.parameters();
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public boolean isBeginMark() {
        return true;
    }

    @Override
    public boolean isEndMark() {
        return false;
    }

    @Override
    public boolean isProblem() {
        return true;
    }

    @Override
    public boolean isTag() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.peer != null && this.peer.index >= this.index;
    }

    @Override
    public IProblem toProblem() {
        return this.isValid() ? this : null;
    }

    @Override
    public SyntacticTag toTag() {
        return null;
    }

    public String code() {
        return this.problemCode;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isWarning() {
        return !this.error;
    }

    public String message() {
        return this.message;
    }

    public String[] parameters() {
        return this.parameters;
    }

    public int beginIndex() {
        return this.index;
    }

    public int endIndex() {
        return this.peer.index;
    }

    public int length() {
        return this.peer.index - this.index;
    }

    public Iterator<IProblem.IQuickFixAction> actions() {
        return Iterators.emptyIterator();
    }

    public void remove() {
        if (this.peer != null) {
            this.info.deleteMark(this.peer);
        }
        this.info.deleteMark(this);
    }

    public String id() {
        return null;
    }
}

