/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.util.Ints;
import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.IntSequenceDifferencer;
import com.ibm.pdp.util.ints.IntSequence;

public class SyntacticPartSegment
extends Segment {
    protected Segment from;
    protected Segment to;
    protected int atomRank;
    protected int status;
    protected IDetailedChanges detailedChanges;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected SyntacticPartSegment(UserChangeSet userChangeSet, Segment parentSegment, Segment enclosingSegment, Segment fromSegment, Segment toSegment, int rank) {
        super(userChangeSet, parentSegment);
        this.enclosing = enclosingSegment;
        this.from = fromSegment;
        this.to = toSegment;
        this.atomRank = rank;
        this.status = 6;
    }

    @Override
    public TagProperties getTagProperties() {
        return this.enclosing.getTagProperties();
    }

    @Override
    public int generatedLevel() {
        return this.parent != null ? this.parent.generatedLevel() : -1;
    }

    @Override
    public Segment enclosingSegment() {
        return this.enclosing;
    }

    @Override
    public Segment[] subSegments() {
        return EMPTY_SEGMENT_ARRAY;
    }

    @Override
    protected boolean dirtySubSegments() {
        return false;
    }

    @Override
    protected void touchSubSegments() {
    }

    @Override
    public String enclosingTagName() {
        return this.enclosing.enclosingTagName();
    }

    @Override
    public String fromTagName() {
        return this.from.enclosingTagName();
    }

    @Override
    public String toTagName() {
        return this.to.enclosingTagName();
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public boolean isPart() {
        return true;
    }

    @Override
    public boolean isSyntactic() {
        return true;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isFirstPart() {
        return this.from == this.enclosing;
    }

    @Override
    public boolean isLastPart() {
        return this.to == this.enclosing;
    }

    @Override
    public boolean isMiddlePart() {
        return this.from != this.enclosing && this.to != this.enclosing;
    }

    @Override
    public int beginIndex() {
        return this.from == this.enclosing ? this.enclosing.beginIndex() : this.from.endIndex();
    }

    @Override
    public int endIndex() {
        return this.to == this.enclosing ? this.enclosing.endIndex() : this.to.beginIndex();
    }

    @Override
    public int length() {
        return this.endIndex() - this.beginIndex();
    }

    @Override
    public int generatedBeginIndex() {
        return this.from == this.enclosing ? this.enclosing.generatedBeginIndex() : this.from.generatedEndIndex();
    }

    @Override
    public int generatedEndIndex() {
        return this.to == this.enclosing ? this.enclosing.generatedEndIndex() : this.to.generatedBeginIndex();
    }

    @Override
    public int generatedLength() {
        return this.generatedEndIndex() - this.generatedBeginIndex();
    }

    @Override
    public CharSequence generatedText() {
        int genEndIdx;
        int genBeginIdx = this.generatedBeginIndex();
        if (genBeginIdx >= (genEndIdx = this.generatedEndIndex())) {
            return "";
        }
        return this.changeSet.generatedText().subSequence(genBeginIdx, genEndIdx);
    }

    @Override
    public ChangeNature getChangeNature() {
        return SyntacticPartSegment.changeNatureFromStatus(this.getSegmentStatus());
    }

    @Override
    public IDetailedChanges detailedChanges() {
        if (this.status == 6) {
            this.status = this.computeStatusAndDetails();
        }
        return this.detailedChanges;
    }

    @Override
    public void setDetailedChanges(IDetailedChanges newDetails) {
        this.detailedChanges = newDetails;
    }

    @Override
    public IGeneratedTag enclosingTag() {
        return this.parent != null ? this.parent.enclosingTag() : null;
    }

    @Override
    public IGeneratedTag fromTag() {
        return this.changeSet.atomAt(this.atomRank).fromTag();
    }

    @Override
    public IGeneratedTag toTag() {
        return this.changeSet.atomAt(this.atomRank).toTag();
    }

    @Override
    protected int getSegmentStatus() {
        if (this.status == 6) {
            this.status = this.computeStatusAndDetails();
        }
        return this.status;
    }

    protected int computeStatusAndDetails() {
        if (this.enclosing != this.parent || this.changeSet.generatedInfo == null) {
            return this.enclosing.getSegmentStatus();
        }
        ISubTextPartition modified = this.changeSet.partition.subTextPartition(this.beginIndex(), this.endIndex());
        ISubTextPartition reference = this.changeSet.generatedPartition.subTextPartition(this.generatedBeginIndex(), this.generatedEndIndex());
        int modifiedwordCount = modified.getWordsCount();
        int referenceWordCount = reference.getWordsCount();
        if (modifiedwordCount == 0) {
            if (referenceWordCount != 0) {
                return 3;
            }
            return Strings.sameCharSequences((CharSequence)modified.getText(), (CharSequence)reference.getText()) ? 0 : 1;
        }
        if (referenceWordCount == 0) {
            return 4;
        }
        IntSequenceDifferencer wordsDifferencer = Ints.newIntSequenceDifferencer((IntSequence)reference.getWords(), (IntSequence)modified.getWords());
        int nbDifferences = 0;
        int nbRemovedWords = 0;
        int nbAddedWords = 0;
        DiffCursor wordDiff = wordsDifferencer.newDiffCursor();
        while (wordDiff.searchNextDifference()) {
            nbRemovedWords += wordDiff.getReferenceEndIndex() - wordDiff.getReferenceBeginIndex();
            nbAddedWords += wordDiff.getModifiedEndIndex() - wordDiff.getModifiedBeginIndex();
            ++nbDifferences;
        }
        if (nbDifferences == 0) {
            return Strings.sameCharSequences((CharSequence)modified.getText(), (CharSequence)reference.getText()) ? 0 : 1;
        }
        if (SyntacticPartSegment.isReplacement(referenceWordCount, nbRemovedWords, nbAddedWords, nbDifferences)) {
            return 5;
        }
        int maxValue = Math.max(Math.max(modified.getTextLength(), reference.getTextLength()), nbDifferences);
        this.detailedChanges = SyntacticPartSegment.buildDetailedChanges(modified, reference, nbDifferences, maxValue, wordsDifferencer.newDiffCursor());
        return 2;
    }

    @Override
    public ChangeNature getSubtreesChangeNature() {
        return ChangeNature.Unchanged;
    }

    @Override
    public ChangeNature getTreeChangeNature() {
        return this.getChangeNature();
    }

    @Override
    protected int getTreeStatus() {
        return this.getSegmentStatus();
    }

    @Override
    public boolean restoreGeneratedText() {
        return this.changeSet.restoreGeneratedText(this.beginIndex(), this.endIndex());
    }

    @Override
    public int maxRank() {
        return this.atomRank;
    }

    @Override
    public int minRank() {
        return this.atomRank;
    }

    @Override
    public boolean isAncestorOf(Segment segment) {
        return false;
    }

    @Override
    public Segment firstAtom() {
        return this.changeSet.atomAt(this.atomRank);
    }

    @Override
    public Segment lastAtom() {
        return this.changeSet.atomAt(this.atomRank);
    }

    @Override
    public int nbOfSons() {
        return 0;
    }

    @Override
    public int nbOfTaggedSons() {
        return 0;
    }

    @Override
    public Segment[] sons() {
        return EMPTY_SEGMENT_ARRAY;
    }

    @Override
    public Segment nextAtom() {
        return this.atomRank < this.changeSet.nbAtom - 1 ? this.changeSet.getAtomAt(this.atomRank + 1) : null;
    }

    @Override
    public Segment previousAtom() {
        return this.atomRank > 0 ? this.changeSet.getAtomAt(this.atomRank - 1) : null;
    }

    @Override
    public Segment nextBrother() {
        return this.changeSet.atomAt(this.atomRank).nextBrother();
    }

    @Override
    public Segment previousBrother() {
        return this.changeSet.atomAt(this.atomRank).previousBrother();
    }

    @Override
    public void setBeginIndex(int newBeginIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChangeNature(ChangeNature newChangeNature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(CharSequence newText) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("genBeginIndex:");
        sb.append(this.generatedBeginIndex());
        sb.append(" genEndIndex:");
        sb.append(this.generatedEndIndex());
        sb.append(this.generatedEndIndex() >= this.generatedBeginIndex() ? " OK" : " KO");
        sb.append("\n");
        sb.append("gen :");
        sb.append(this.generatedText());
        sb.append("\ntext:");
        if (this.beginIndex() == -1) {
            sb.append("Unknown");
        } else if (this.endIndex() == -1) {
            sb.append("next BeginIndex =-1");
        } else {
            sb.append(this.getText());
        }
        return String.valueOf(this.enclosingTagName()) + "(" + this.fromTagName() + ".." + this.toTagName() + ") [" + this.beginIndex() + ", " + this.endIndex() + "]" + sb.toString();
    }
}

