/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IProblem;
import com.ibm.pdp.engine.extension.ITextAnalyzer;
import com.ibm.pdp.engine.extension.ITextScanner;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.engine.turbo.core.SyntacticMark;
import com.ibm.pdp.engine.turbo.core.SyntacticProblemBegin;
import com.ibm.pdp.engine.turbo.core.SyntacticProblemEnd;
import com.ibm.pdp.engine.turbo.core.SyntacticTag;
import com.ibm.pdp.engine.turbo.core.SyntacticTagBegin;
import com.ibm.pdp.engine.turbo.core.SyntacticTagEnd;
import com.ibm.pdp.util.Interval;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.containers.EditBuffer;
import com.ibm.pdp.util.containers.IntBuffer;
import com.ibm.pdp.util.iterators.FilterIterator;
import com.ibm.pdp.util.sort.AbstractRangeComparator;
import com.ibm.pdp.util.sort.RangeComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SyntacticInfo {
    protected ITextAnalyzer analyzer;
    protected Map<String, SyntacticTag> tagByName;
    protected int[] portions;
    protected int portionsHole;
    protected int portionsLength;
    protected int idxGap;
    protected int gapRank;
    protected SyntacticMark[] marks;
    protected int marksHole;
    protected int nbMarks;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SyntacticInfo() {
        this.portions = new int[4];
        this.marks = new SyntacticMark[4];
    }

    public SyntacticInfo(ITextAnalyzer textAnalyzer) {
        this.analyzer = textAnalyzer;
        this.portions = new int[4];
        this.marks = new SyntacticMark[4];
    }

    public ITextAnalyzer getTextAnalyzer() {
        return this.analyzer;
    }

    public void setTextAnalyzer(ITextAnalyzer newAnalyzer) {
        this.analyzer = newAnalyzer;
    }

    public void setText(CharSequence newText) {
        this.clearAll();
        this.analyzer.setText(newText);
    }

    public void textChanged(int index, int nbRemoved, int nbAdded) {
        int shiftBeginIdx = index + nbRemoved;
        this.declareBlankPortion(index, shiftBeginIdx);
        this.shiftIndexes(shiftBeginIdx, nbAdded - nbRemoved);
        this.analyzer.textChanged(index, nbRemoved, nbAdded);
    }

    protected void shiftIndexes(int index, int delta) {
        if (this.portionsLength > 0) {
            int dirtyRank = this.dirtyRankFromIndex(index);
            this.moveDirtyGapRank(dirtyRank >= 0 ? dirtyRank : ~dirtyRank);
            this.incrementIndexGap(delta);
        }
        if (this.nbMarks > 0) {
            Interval markRanks = new Interval(0, this.nbMarks);
            this.marksTouching(markRanks, index);
            int markRank = markRanks.begin;
            while (markRank < this.nbMarks) {
                this.incrementMarkIndex(markRank, delta);
                ++markRank;
            }
        }
    }

    protected void setIndexGap(int newDirtyGapRank, int newIdxGap) {
        if (newIdxGap == 0 || newDirtyGapRank == this.portionsLength) {
            this.gapRank = this.portionsLength;
            this.idxGap = 0;
        } else {
            this.gapRank = newDirtyGapRank;
            this.idxGap = newIdxGap;
        }
    }

    protected void incrementIndexGap(int increment) {
        this.setIndexGap(this.gapRank, this.idxGap + increment);
    }

    protected void moveDirtyGapRank(int newDirtyGapRank) {
        int gap = this.idxGap;
        if (gap != 0) {
            int rank = this.gapRank;
            if (rank < newDirtyGapRank) {
                do {
                    int bufferIdx;
                    int n = bufferIdx = IntBuffer.arrayIndex((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)rank++);
                    this.portions[n] = this.portions[n] + gap;
                } while (rank < newDirtyGapRank);
            } else if (rank > newDirtyGapRank) {
                do {
                    int bufferIdx;
                    int n = bufferIdx = IntBuffer.arrayIndex((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)(--rank));
                    this.portions[n] = this.portions[n] - gap;
                } while (rank > newDirtyGapRank);
            }
        }
        this.gapRank = newDirtyGapRank;
    }

    protected void clearIndexGap() {
        this.gapRank = this.portionsLength;
        this.idxGap = 0;
    }

    public Iterator<SyntacticMark> marks() {
        this.refreshMarks();
        if (this.nbMarks == 0) {
            return Iterators.emptyIterator();
        }
        return this.newMarksIter();
    }

    protected Iterator<SyntacticMark> newMarksIter() {
        return new MarksIter(this);
    }

    public Iterator<SyntacticMark> marks(int beginIndex, int endIndex) {
        this.refreshMarks();
        if (this.nbMarks == 0) {
            return Iterators.emptyIterator();
        }
        Interval markRanks = new Interval(0, this.nbMarks);
        if (this.marksTouching(markRanks, beginIndex, endIndex) == 0) {
            return Iterators.emptyIterator();
        }
        return this.newMarksIter(markRanks.begin, markRanks.end);
    }

    protected Iterator<SyntacticMark> newMarksIter(int beginRank, int endRank) {
        return new MarksIter(this, beginRank, endRank);
    }

    protected boolean acceptMark(int markRank) {
        return this.markAt(markRank).isValid();
    }

    public Iterator<SyntacticTag> unfilteredTags() {
        this.refreshMarks();
        if (this.tagByName == null) {
            return Iterators.emptyIterator();
        }
        Iterator<Map.Entry<String, SyntacticTag>> entries = this.tagByName.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SyntacticTag> entry = entries.next();
            SyntacticTag tag = entry.getValue();
            if (tag.beginMark != null || tag.endMark != null) continue;
            entries.remove();
        }
        return this.tagByName.values().iterator();
    }

    public Iterator<SyntacticTag> tags() {
        this.refreshMarks();
        if (this.nbMarks == 0) {
            return Iterators.emptyIterator();
        }
        return this.newTagsIter();
    }

    public Iterator<SyntacticTag> includedTags(int beginIndex, int endIndex) {
        this.refreshMarks();
        if (this.nbMarks == 0) {
            return Iterators.emptyIterator();
        }
        Interval markRanks = new Interval(0, this.nbMarks);
        if (this.marksTouching(markRanks, beginIndex, endIndex) == 0) {
            return Iterators.emptyIterator();
        }
        return this.newTagsIter(markRanks.begin, markRanks.end);
    }

    protected Iterator<SyntacticTag> newTagsIter() {
        return new TagsIter(this);
    }

    protected Iterator<SyntacticTag> newTagsIter(int beginRank, int endRank) {
        return new TagsIter(this, beginRank, endRank);
    }

    public Iterator<SyntacticTag> rootTags() {
        this.refreshMarks();
        if (this.nbMarks == 0) {
            return Iterators.emptyIterator();
        }
        return this.newRootTagsIter();
    }

    protected Iterator<SyntacticTag> newRootTagsIter() {
        return new SubTagsIter(this);
    }

    public Iterator<SyntacticTag> subTags(SyntacticTag parent) {
        this.refreshMarks();
        if (!parent.isValid()) {
            return Iterators.emptyIterator();
        }
        Interval markRanks = new Interval(0, this.nbMarks);
        this.marksTouching(markRanks, parent.beginIndex(), parent.endIndex());
        int beginRank = markRanks.begin;
        int endRank = markRanks.end;
        while (beginRank < endRank) {
            if (this.markAt(beginRank++) == parent.beginMark) break;
        }
        while (endRank > beginRank) {
            if (this.markAt(--endRank) == parent.endMark) break;
        }
        if (beginRank >= endRank) {
            return Iterators.emptyIterator();
        }
        return this.newSubTagsIter(beginRank, endRank);
    }

    public Iterator<SyntacticTag> subTags(int beginIdx, int endIdx) {
        this.refreshMarks();
        Interval markRanks = new Interval(0, this.nbMarks);
        this.marksTouching(markRanks, beginIdx, endIdx);
        int beginRank = markRanks.begin;
        int endRank = markRanks.end;
        if (beginRank >= endRank) {
            return Iterators.emptyIterator();
        }
        return this.newSubTagsIter(beginRank, endRank);
    }

    protected Iterator<SyntacticTag> newSubTagsIter(int beginRank, int endRank) {
        return new SubTagsIter(this, beginRank, endRank);
    }

    public SyntacticTag includingTag(int beginIndex, int endIndex) {
        this.refreshMarks();
        Interval markRanks = new Interval(0, this.nbMarks);
        this.marksTouching(markRanks, beginIndex, endIndex);
        int beginRank = markRanks.begin;
        int endRank = markRanks.end;
        while (beginRank < endRank && this.markAt((int)beginRank).index == beginIndex) {
            ++beginRank;
        }
        while (endRank > beginRank && this.markAt((int)(endRank - 1)).index == endIndex) {
            --endRank;
        }
        while (beginRank > 0 && endRank < this.nbMarks) {
            SyntacticMark mark = this.markAt(beginRank - 1);
            if (mark instanceof SyntacticTagBegin && (mark = mark.getPeer()) != null && mark.index >= endIndex) {
                return mark.toTag();
            }
            mark = this.markAt(endRank);
            if (mark instanceof SyntacticTagEnd && (mark = mark.getPeer()) != null && mark.index <= beginIndex) {
                return mark.toTag();
            }
            --beginRank;
            ++endRank;
        }
        return null;
    }

    public SyntacticTag includingTag(SyntacticTag subTag) {
        int endIndex;
        this.refreshMarks();
        if (!subTag.isValid()) {
            return null;
        }
        Interval markRanks = new Interval(0, this.nbMarks);
        int beginIndex = subTag.beginIndex();
        if (this.marksTouching(markRanks, beginIndex, endIndex = subTag.endIndex()) < 2) {
            return null;
        }
        int beginRank = markRanks.begin;
        int endRank = markRanks.end;
        SyntacticTagBegin subTagBegin = subTag.beginMark;
        SyntacticMark mark = this.markAt(beginRank);
        while (mark != subTagBegin) {
            if (mark.index > beginIndex || endRank - beginRank < 2) {
                return null;
            }
            mark = this.markAt(++beginRank);
        }
        SyntacticTagEnd subTagEnd = subTag.endMark;
        SyntacticMark mark2 = this.markAt(endRank - 1);
        while (mark2 != subTagEnd) {
            if (mark2.index < endIndex || endRank - beginRank < 2) {
                return null;
            }
            mark2 = this.markAt(--endRank - 1);
        }
        while (beginRank > 0 && endRank < this.nbMarks) {
            mark2 = this.markAt(beginRank - 1);
            if (mark2 instanceof SyntacticTagBegin && (mark2 = mark2.getPeer()) != null && mark2.index >= endIndex) {
                return mark2.toTag();
            }
            mark2 = this.markAt(endRank);
            if (mark2 instanceof SyntacticTagEnd && (mark2 = mark2.getPeer()) != null && mark2.index <= beginIndex) {
                return mark2.toTag();
            }
            --beginRank;
            ++endRank;
        }
        return null;
    }

    public Iterator<IProblem> problems() {
        this.refreshMarks();
        return new FilterIterator<SyntacticMark>(this.marks()){

            protected boolean accept(SyntacticMark candidate) {
                return candidate.isBeginMark() && candidate.isProblem();
            }
        };
    }

    public Iterator<IProblem> problems(int beginIndex, int endIndex) {
        this.refreshMarks();
        return new FilterIterator<SyntacticMark>(this.marks(beginIndex, endIndex)){

            protected boolean accept(SyntacticMark candidate) {
                return candidate.isBeginMark() && candidate.isProblem();
            }
        };
    }

    public SyntacticTag unfilteredTagFromName(String syntacticTagName) {
        this.refreshMarks();
        if (this.tagByName == null) {
            return null;
        }
        SyntacticTag tag = this.tagByName.get(syntacticTagName);
        if (tag == null) {
            return null;
        }
        if (tag.beginMark == null && tag.endMark == null) {
            this.tagByName.remove(syntacticTagName);
            return null;
        }
        return tag;
    }

    public SyntacticTag tagFromName(String syntacticTagName) {
        this.refreshMarks();
        if (this.tagByName == null) {
            return null;
        }
        SyntacticTag tag = this.tagByName.get(syntacticTagName);
        return tag != null && tag.isValid() ? tag : null;
    }

    protected void addMark(int markRank, SyntacticMark mark) {
        this.marks = (SyntacticMark[])EditBuffer.insert((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (int)markRank, (int)1);
        this.marks[markRank] = mark;
        this.marksHole = markRank + 1;
        ++this.nbMarks;
    }

    protected SyntacticMark markAt(int markRank) {
        return (SyntacticMark)EditBuffer.getElementAt((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (int)markRank);
    }

    protected int getMarkIndex(int markRank) {
        return this.markAt((int)markRank).index;
    }

    protected void setMarkIndex(int markRank, int newIndex) {
        this.markAt((int)markRank).index = newIndex;
    }

    protected void incrementMarkIndex(int markRank, int value) {
        this.markAt((int)markRank).index += value;
    }

    protected void deleteMark(SyntacticMark mark) {
        Interval ranks = new Interval(0, this.nbMarks);
        this.marksTouching(ranks, mark.index);
        int rank = ranks.begin;
        while (rank < ranks.end) {
            if (this.markAt(rank) == mark) {
                this.deleteMark(rank);
                return;
            }
            ++rank;
        }
        rank = 0;
        while (rank < this.nbMarks) {
            if (this.markAt(rank) == mark) {
                this.deleteMark(rank);
                return;
            }
            ++rank;
        }
    }

    protected void deleteMark(int markRank) {
        SyntacticMark mark = this.markAt(markRank);
        if (mark.isTag()) {
            SyntacticTag tag = mark.toTag();
            tag.removeMark(mark);
        }
        this.marks = (SyntacticMark[])EditBuffer.delete((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (int)markRank, (int)1);
        this.marksHole = markRank;
        --this.nbMarks;
    }

    protected int deleteMarks(int beginMarkRank, int endMarkRank) {
        int toDelete = endMarkRank - beginMarkRank;
        if (toDelete <= 0) {
            return 0;
        }
        Object[] m = this.marks;
        int hole = this.marksHole;
        int length = this.nbMarks;
        int rank = beginMarkRank;
        while (rank < endMarkRank) {
            SyntacticMark mark = this.markAt(rank);
            if (mark.isTag()) {
                SyntacticTag tag = mark.toTag();
                tag.removeMark(mark);
            }
            ++rank;
        }
        this.marks = (SyntacticMark[])EditBuffer.delete((Object[])m, (int)hole, (int)length, (int)beginMarkRank, (int)toDelete);
        this.marksHole = beginMarkRank;
        this.nbMarks = length - toDelete;
        return toDelete;
    }

    protected int deleteMarksTouching(int beginIdx, int endIdx) {
        Interval markRanks = new Interval(0, this.nbMarks);
        this.marksTouching(markRanks, beginIdx, endIdx);
        return this.deleteMarks(markRanks.begin, markRanks.end);
    }

    protected int deleteMarksIn(int beginIdx, int endIdx) {
        SyntacticMark mark;
        Interval markRanks = new Interval(0, this.nbMarks);
        this.marksTouching(markRanks, beginIdx, endIdx);
        if (markRanks.isEmpty()) {
            return 0;
        }
        int markRank = markRanks.end - 1;
        while (markRank >= markRanks.begin) {
            mark = this.markAt(markRank);
            if (mark.index() != endIdx) break;
            if (mark.isEndMark()) {
                this.deleteMark(markRank);
            }
            --markRanks.end;
            --markRank;
        }
        markRank = markRanks.begin;
        while (markRank < markRanks.end) {
            mark = this.markAt(markRank);
            if (mark.index() != beginIdx) break;
            if (mark.isBeginMark()) {
                this.deleteMark(markRank);
                --markRank;
                --markRanks.end;
            } else {
                ++markRanks.begin;
            }
            ++markRank;
        }
        return this.deleteMarks(markRanks.begin, markRanks.end);
    }

    protected int marksIn(Interval markRanks, int beginIdx, int endIdx) {
        return EditBuffer.binarySearchInterval((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (Interval)markRanks, this.newMarkInRangeCmp(beginIdx, endIdx));
    }

    protected int marksTouching(Interval markRanks, int index) {
        return EditBuffer.binarySearchInterval((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (Interval)markRanks, this.newMarkTouchingRangeCmp(index, index));
    }

    protected int marksTouching(Interval markRanks, int beginIdx, int endIdx) {
        return EditBuffer.binarySearchInterval((Object[])this.marks, (int)this.marksHole, (int)this.nbMarks, (Interval)markRanks, this.newMarkTouchingRangeCmp(beginIdx, endIdx));
    }

    protected RangeComparator<SyntacticMark> newMarkFromIndexRangeCmp(int index) {
        return new MarkFromIndexRangeCmp(index);
    }

    protected RangeComparator<SyntacticMark> newMarkTouchingRangeCmp(int beginIdx, int endIdx) {
        return new MarkTouchingRangeCmp(beginIdx, endIdx);
    }

    protected RangeComparator<SyntacticMark> newMarkInRangeCmp(int beginIdx, int endIdx) {
        return new MarkInRangeCmp(beginIdx, endIdx);
    }

    protected boolean isDirtyIndex(int index) {
        return index < 0 || this.dirtyPortionTouching(index) >= 0;
    }

    protected int dirtyPortionTouching(int index) {
        int beginRank = 0;
        int endRank = this.portionsLength;
        while (beginRank < endRank) {
            int middleRank = beginRank + endRank >> 1 & 0xFFFFFFFE;
            if (this.dirtyIndex(middleRank) > index) {
                endRank = middleRank;
                continue;
            }
            if (this.dirtyIndex(middleRank + 1) < index) {
                beginRank = middleRank + 2;
                continue;
            }
            return middleRank;
        }
        return ~beginRank;
    }

    protected int dirtyPortionBeginIndex(int dirtyRank) {
        return this.dirtyIndex(dirtyRank & 0xFFFFFFFE);
    }

    protected int dirtyPortionEndIndex(int dirtyRank) {
        return this.dirtyIndex(dirtyRank | 1);
    }

    protected int dirtyIndex(int dirtyRank) {
        int dirtyIndex = IntBuffer.getIntAt((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)dirtyRank);
        return dirtyRank >= this.gapRank ? dirtyIndex + this.idxGap : dirtyIndex;
    }

    protected void setDirtyPortion(int dirtyRank, int beginIdx, int endIdx) {
        if ((dirtyRank &= 0xFFFFFFFE) >= this.gapRank) {
            beginIdx -= this.idxGap;
            endIdx -= this.idxGap;
        } else if (dirtyRank + 1 == this.gapRank) {
            endIdx -= this.idxGap;
        }
        IntBuffer.setIntAt((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)dirtyRank, (int)beginIdx);
        IntBuffer.setIntAt((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)(dirtyRank + 1), (int)endIdx);
    }

    protected void insertDirtyPortion(int dirtyRank, int beginIdx, int endIdx) {
        if ((dirtyRank &= 0xFFFFFFFE) > this.gapRank) {
            beginIdx -= this.idxGap;
            endIdx -= this.idxGap;
        } else {
            this.gapRank += 2;
        }
        this.portions = IntBuffer.insert((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)dirtyRank, (int)2);
        this.portions[dirtyRank] = beginIdx;
        this.portions[dirtyRank + 1] = endIdx;
        this.portionsHole = dirtyRank + 2;
        this.portionsLength += 2;
    }

    protected void deleteDirtyPortion(int dirtyRank) {
        this.portions = IntBuffer.delete((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)(dirtyRank &= 0xFFFFFFFE), (int)2);
        this.portionsHole = dirtyRank;
        this.portionsLength -= 2;
        if (dirtyRank < this.gapRank) {
            this.gapRank -= dirtyRank + 1 == this.gapRank ? 1 : 2;
        }
    }

    protected void deleteDirtyPortions(int beginDirtyRank, int endDirtyRank) {
        int toDelete = endDirtyRank - beginDirtyRank;
        this.portions = IntBuffer.delete((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)beginDirtyRank, (int)toDelete);
        this.portionsHole = beginDirtyRank;
        this.portionsLength -= toDelete;
        if (endDirtyRank <= this.gapRank) {
            this.gapRank -= toDelete;
        } else if (beginDirtyRank < this.gapRank) {
            this.gapRank -= this.gapRank - beginDirtyRank;
        }
    }

    protected void deleteAllDirtyPortions() {
        this.portions = IntBuffer.delete((int[])this.portions, (int)this.portionsHole, (int)this.portionsLength, (int)0, (int)this.portionsLength);
        this.portionsLength = 0;
        this.portionsHole = 0;
        this.clearIndexGap();
    }

    public void declareDirtyPortion(int beginIdx, int endIdx) {
        this.addDirtyPortion(beginIdx, endIdx);
        if (this.nbMarks > 0) {
            this.deleteMarksIn(beginIdx, endIdx);
        }
    }

    protected void addDirtyPortion(int beginIdx, int endIdx) {
        if (this.portionsLength == 0) {
            this.insertDirtyPortion(0, beginIdx, endIdx);
            return;
        }
        Interval dirtyPortionRanks = new Interval(0, this.portionsLength);
        int nbDirtyPortion = this.dirtyPortionsTouching(dirtyPortionRanks, beginIdx, endIdx);
        int beginRank = dirtyPortionRanks.begin;
        if (nbDirtyPortion == 0) {
            this.insertDirtyPortion(beginRank, beginIdx, endIdx);
            return;
        }
        int endRank = dirtyPortionRanks.end;
        if (nbDirtyPortion > 1) {
            this.deleteDirtyPortions(beginRank + 2, endRank);
            endRank = beginRank + 2;
        }
        beginIdx = Math.min(this.dirtyIndex(beginRank), beginIdx);
        endIdx = Math.max(this.dirtyIndex(endRank - 1), endIdx);
        this.setDirtyPortion(beginRank, beginIdx, endIdx);
    }

    public void declareBlankPortion(int beginIdx, int endIdx) {
        if (beginIdx >= endIdx) {
            return;
        }
        if (this.portionsLength > 0) {
            this.addBlankPortion(beginIdx, endIdx);
        }
        if (this.nbMarks > 0) {
            this.deleteMarksIn(beginIdx, endIdx);
        }
    }

    protected void addBlankPortion(int beginIdx, int endIdx) {
        Interval dirtyPortionRanks = new Interval(0, this.portionsLength);
        int nbDirtyPortion = this.dirtyPortionsTouching(dirtyPortionRanks, beginIdx, endIdx);
        if (nbDirtyPortion == 0) {
            return;
        }
        int beginRank = dirtyPortionRanks.begin;
        int endRank = dirtyPortionRanks.end;
        int dirtyBeginIdx = this.dirtyIndex(beginRank);
        int dirtyEndIdx = this.dirtyIndex(endRank - 1);
        if (nbDirtyPortion == 1) {
            if (dirtyBeginIdx < beginIdx && dirtyEndIdx > endIdx) {
                this.setDirtyPortion(beginRank, dirtyBeginIdx, beginIdx);
                this.insertDirtyPortion(endRank, endIdx, dirtyEndIdx);
            } else if (dirtyBeginIdx < beginIdx) {
                this.setDirtyPortion(beginRank, dirtyBeginIdx, beginIdx);
            } else if (dirtyEndIdx > endIdx) {
                this.setDirtyPortion(beginRank, endIdx, dirtyEndIdx);
            } else {
                this.deleteDirtyPortion(beginRank);
            }
            return;
        }
        if (dirtyBeginIdx < beginIdx && dirtyEndIdx > endIdx) {
            this.setDirtyPortion(beginRank, dirtyBeginIdx, beginIdx);
            beginRank += 2;
            this.setDirtyPortion(endRank -= 2, endIdx, dirtyEndIdx);
        } else if (dirtyBeginIdx < beginIdx) {
            this.setDirtyPortion(beginRank, dirtyBeginIdx, beginIdx);
            beginRank += 2;
        } else if (dirtyEndIdx > endIdx) {
            this.setDirtyPortion(endRank -= 2, endIdx, dirtyEndIdx);
        }
        if (beginRank < endRank) {
            this.deleteDirtyPortions(beginRank, endRank);
        }
    }

    protected int dirtyPortionsTouching(Interval dirtyPortionRanks, int beginIdx, int endIdx) {
        int beginRank = dirtyPortionRanks.begin & 0xFFFFFFFE;
        int endRank = dirtyPortionRanks.end & 0xFFFFFFFE;
        while (beginRank < endRank) {
            int middleRank = beginRank + endRank >> 1 & 0xFFFFFFFE;
            int middleBeginIdx = this.dirtyIndex(middleRank);
            if (middleBeginIdx > endIdx) {
                endRank = middleRank;
                continue;
            }
            int middleEndIdx = this.dirtyIndex(middleRank + 1);
            if (middleEndIdx < beginIdx) {
                beginRank = middleRank + 2;
                continue;
            }
            beginRank = middleBeginIdx > beginIdx ? this.leftDirtyPortionTouching(beginIdx, beginRank, middleRank) & 0xFFFFFFFE : middleRank;
            int n = endRank = middleEndIdx < endIdx ? this.rightDirtyPortionTouching(endIdx, middleRank + 2, endRank) : middleRank + 2;
            if ((endRank & 1) == 0) break;
            ++endRank;
            break;
        }
        dirtyPortionRanks.begin = beginRank;
        dirtyPortionRanks.end = endRank;
        return (endRank - beginRank) / 2;
    }

    protected int leftDirtyPortionTouching(int index, int beginRank, int endRank) {
        while (beginRank < endRank) {
            int middleRank = beginRank + endRank >> 1;
            if (this.dirtyIndex(middleRank) < index) {
                beginRank = middleRank + 1;
                continue;
            }
            endRank = middleRank;
        }
        return beginRank;
    }

    protected int rightDirtyPortionTouching(int index, int beginRank, int endRank) {
        while (beginRank < endRank) {
            int middleRank = beginRank + endRank >> 1;
            if (this.dirtyIndex(middleRank) <= index) {
                beginRank = middleRank + 1;
                continue;
            }
            endRank = middleRank;
        }
        return beginRank;
    }

    protected void checkDirtyPortions() {
        if (this.portionsLength % 2 != 0) {
            throw new RuntimeException("dirtyPortionLength must be multiple of 2");
        }
        int previousIdx = 0;
        int i = 0;
        while (i < this.portionsLength) {
            int idx = this.dirtyIndex(i);
            if (idx < 0 || idx < previousIdx) {
                throw new RuntimeException("Wrong dirty index");
            }
            previousIdx = idx;
            ++i;
        }
    }

    public void clearAll() {
        if (this.tagByName != null) {
            this.tagByName.clear();
        }
        if (this.portionsLength > 0) {
            this.portions = IntBuffer.clear((int[])this.portions);
            this.portionsLength = 0;
            this.portionsHole = 0;
            this.clearIndexGap();
        }
        if (this.nbMarks > 0) {
            this.marks = (SyntacticMark[])EditBuffer.clear((Object[])this.marks);
            this.nbMarks = 0;
            this.marksHole = 0;
        }
    }

    protected int dirtyRankFromIndex(int index) {
        return this.dirtyRankFromIndex(index, 0, this.portionsLength);
    }

    protected int dirtyRankFromIndex(int index, int beginRank, int endRank) {
        while (beginRank < endRank) {
            int middleRank = beginRank + endRank >> 1;
            int middleIdx = this.dirtyIndex(middleRank);
            if (index < middleIdx) {
                endRank = middleRank;
                continue;
            }
            if (index > middleIdx) {
                beginRank = middleRank + 1;
                continue;
            }
            return middleRank;
        }
        return ~beginRank;
    }

    protected IEditTree getEditTree() {
        return null;
    }

    protected synchronized void refreshMarks() {
        int length = this.portionsLength;
        int rank = 0;
        while (rank < length) {
            this.refreshMarksInto(this.dirtyIndex(rank), this.dirtyIndex(rank + 1));
            rank += 2;
        }
        this.deleteAllDirtyPortions();
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshMarksInto(int beginIdx, int endIdx) {
        markRanks = new Interval(0, this.nbMarks);
        if (this.nbMarks > 0 && this.marksIn(markRanks, beginIdx, endIdx) > 0) {
            this.deleteMarks(markRanks.begin, markRanks.end);
            markRanks.end = markRanks.begin;
        }
        if ((scanner = this.newTextScanner(beginIdx, endIdx)) != null) ** GOTO lbl27
        return;
lbl-1000:
        // 1 sources

        {
            if (scanner.foundTag()) {
                tagName = scanner.getTagName();
                index = scanner.index();
                v0 = tag = this.tagByName != null ? this.tagByName.get(tagName) : null;
                if (tag == null) {
                    tag = this.addNewTag(markRanks, tagName, scanner.isBeginIndex(), index);
                } else {
                    this.addTagExtremity(markRanks, tag, scanner.isBeginIndex(), index);
                }
                if (this.acceptTagName(tagName)) {
                    tag.setProperty("invalid", "false");
                } else {
                    tag.setProperty("invalid", "true");
                }
                map = scanner.getTagProperties();
                if (map != null) {
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        tag.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            if (!scanner.foundProblem()) continue;
            this.addNewProblem(markRanks, scanner.getProblem());
lbl27:
            // 3 sources

            ** while (scanner.scan())
        }
lbl28:
        // 1 sources

    }

    public boolean acceptTagName(String tagName) {
        return true;
    }

    protected SyntacticTag createTag(String tagName) {
        SyntacticTag newTag = this.newSyntacticTag(tagName);
        if (this.tagByName == null) {
            this.tagByName = new HashMap<String, SyntacticTag>();
        }
        this.tagByName.put(tagName, newTag);
        return newTag;
    }

    protected SyntacticTag addNewTag(Interval markRanks, String tagName, boolean beginMark, int index) {
        SyntacticTag newTag = this.createTag(tagName);
        if (beginMark) {
            newTag.beginMark = this.newSyntacticTagBegin(newTag, index);
            this.addMarkInto(markRanks, newTag.beginMark);
        } else {
            newTag.endMark = this.newSyntacticTagEnd(newTag, index);
            this.addMarkInto(markRanks, newTag.endMark);
        }
        return newTag;
    }

    protected SyntacticTag newSyntacticTag(String tagName) {
        return new SyntacticTag(tagName);
    }

    protected SyntacticTagBegin newSyntacticTagBegin(SyntacticTag tag, int index) {
        return new SyntacticTagBegin(tag, index);
    }

    protected SyntacticTagEnd newSyntacticTagEnd(SyntacticTag tag, int index) {
        return new SyntacticTagEnd(tag, index);
    }

    protected void addTagExtremity(Interval markRanks, SyntacticTag tag, boolean tagBegin, int newIndex) {
        if (tagBegin) {
            this.addTagBeginMark(markRanks, tag, newIndex);
        } else {
            this.addTagEndMark(markRanks, tag, newIndex);
        }
    }

    protected void addTagBeginMark(Interval markRanks, SyntacticTag tag, int newBeginIndex) {
        SyntacticTagBegin newBeginMark = tag.addBeginMark(newBeginIndex);
        if (newBeginMark != null) {
            this.addMarkInto(markRanks, newBeginMark);
        }
    }

    protected void addTagEndMark(Interval markRanks, SyntacticTag tag, int newEndIndex) {
        SyntacticTagEnd newEndMark = tag.addEndMark(newEndIndex);
        if (newEndMark != null) {
            this.addMarkInto(markRanks, newEndMark);
        }
    }

    protected int findMarkRank(SyntacticMark mark) {
        Interval markRanks = new Interval(0, this.nbMarks);
        int endRank = markRanks.end;
        int rank = markRanks.begin;
        while (rank < endRank) {
            if (this.markAt(rank) == mark) {
                return rank;
            }
            ++rank;
        }
        return ~endRank;
    }

    protected void addMarkInto(Interval markRanks, SyntacticMark mark) {
        int diff;
        int beginRank = markRanks.begin;
        int endRank = markRanks.end;
        if (beginRank < endRank && mark.index < this.markAt((int)(endRank - 1)).index && (diff = this.marksTouching(markRanks, mark.index)) > 0) {
            int realBegin = markRanks.begin;
            if (realBegin == 0) {
                ++realBegin;
                --diff;
            }
            if (mark.isEndMark()) {
                SyntacticTag st = mark.toTag();
                int i = realBegin;
                while (i <= markRanks.end) {
                    SyntacticMark sm = this.marks[i - 1];
                    if (sm != null && sm.isBeginMark() && sm.toTag() == st) {
                        markRanks.end = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.addMark(markRanks.end, mark);
        markRanks.begin = beginRank;
        markRanks.end = endRank + 1;
    }

    protected void addNewProblem(Interval markRanks, IProblem newProblem) {
        SyntacticProblemBegin problemBegin = new SyntacticProblemBegin(this, newProblem.beginIndex());
        SyntacticProblemEnd problemEnd = new SyntacticProblemEnd(newProblem.endIndex());
        problemBegin.setPeer(problemEnd);
        problemEnd.setPeer(problemBegin);
        problemBegin.setProblem(newProblem);
        this.addMarkInto(markRanks, problemBegin);
        this.addMarkInto(markRanks, problemEnd);
    }

    protected ITextScanner newTextScanner(int beginIndex, int endIndex) {
        IEditTree editTree = this.getEditTree();
        if (editTree != null) {
            this.analyzer.setEditTree(editTree);
        }
        return this.analyzer.newScanner(beginIndex, endIndex);
    }

    protected static class MarkFromIndexRangeCmp
    extends AbstractRangeComparator<SyntacticMark> {
        protected int idx;

        protected MarkFromIndexRangeCmp(int index) {
            this.idx = index;
        }

        public int compareWithRange(SyntacticMark mark) {
            int markIdx = mark.index;
            return markIdx < this.idx ? -1 : (markIdx > this.idx ? 1 : 0);
        }
    }

    protected static class MarkInRangeCmp
    extends AbstractRangeComparator<SyntacticMark> {
        protected int beginIdx;
        protected int endIdx;

        protected MarkInRangeCmp(int beginIndex, int endIndex) {
            this.beginIdx = beginIndex;
            this.endIdx = endIndex;
        }

        public int compareWithRange(SyntacticMark mark) {
            int markIdx = mark.index;
            return markIdx < this.beginIdx ? -1 : (markIdx >= this.endIdx ? 1 : 0);
        }
    }

    protected static class MarkTouchingRangeCmp
    extends AbstractRangeComparator<SyntacticMark> {
        protected int beginIdx;
        protected int endIdx;

        protected MarkTouchingRangeCmp(int beginIndex, int endIndex) {
            this.beginIdx = beginIndex;
            this.endIdx = endIndex;
        }

        public int compareWithRange(SyntacticMark mark) {
            int markIdx = mark.index;
            return markIdx < this.beginIdx ? -1 : (markIdx > this.endIdx ? 1 : 0);
        }
    }

    protected static class MarksIter
    implements Iterator<SyntacticMark> {
        protected SyntacticInfo info;
        protected SyntacticMark nextMark;
        protected int nextMarkRank;
        protected int stopMarkRank;

        protected MarksIter(SyntacticInfo si) {
            this.info = si;
            this.nextMarkRank = 0;
            this.stopMarkRank = si.nbMarks;
        }

        protected MarksIter(SyntacticInfo si, int beginRank, int endRank) {
            this.info = si;
            this.nextMarkRank = beginRank;
            this.stopMarkRank = endRank;
        }

        @Override
        public boolean hasNext() {
            return this.nextMark != null || this.findNextMark();
        }

        @Override
        public SyntacticMark next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Syntactic marks iterator");
            }
            SyntacticMark toReturn = this.nextMark;
            this.nextMark = null;
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Syntactic marks iterator : remove");
        }

        protected boolean findNextMark() {
            int endRank = this.stopMarkRank;
            int rank = this.nextMarkRank;
            while (rank < endRank) {
                if (this.accept(rank)) {
                    this.nextMark = this.info.markAt(rank);
                    this.nextMarkRank = rank + 1;
                    return true;
                }
                ++rank;
            }
            return false;
        }

        protected boolean accept(int markRank) {
            return this.info.acceptMark(markRank);
        }
    }

    protected static class SubTagsIter
    extends TagsIter {
        protected SubTagsIter(SyntacticInfo syntacticInfo) {
            super(syntacticInfo);
        }

        protected SubTagsIter(SyntacticInfo syntacticInfo, int beginRank, int endRank) {
            super(syntacticInfo, beginRank, endRank);
        }

        @Override
        protected boolean findNextTag() {
            int endRank = this.stopMarkRank - 1;
            int rank = this.nextMarkRank;
            while (rank < endRank) {
                if (this.accept(rank)) {
                    SyntacticMark endMark = this.info.markAt(rank).getPeer();
                    while (++rank <= endRank) {
                        if (this.info.markAt(rank) != endMark) continue;
                        this.nextTag = endMark.toTag();
                        this.nextMarkRank = rank + 1;
                        return true;
                    }
                    this.nextMarkRank = rank;
                    return false;
                }
                ++rank;
            }
            return false;
        }
    }

    protected static class TagsIter
    implements Iterator<SyntacticTag> {
        protected SyntacticInfo info;
        protected SyntacticTag nextTag;
        protected int nextMarkRank;
        protected int stopMarkRank;
        protected int maxIdx;

        protected TagsIter(SyntacticInfo si) {
            this.info = si;
            this.nextMarkRank = 0;
            this.stopMarkRank = si.nbMarks;
            this.maxIdx = si.markAt((int)(si.nbMarks - 1)).index;
        }

        protected TagsIter(SyntacticInfo si, int beginRank, int endRank) {
            this.info = si;
            this.nextMarkRank = beginRank;
            this.stopMarkRank = endRank;
            this.maxIdx = si.markAt((int)(endRank - 1)).index;
        }

        @Override
        public boolean hasNext() {
            return this.nextTag != null || this.findNextTag();
        }

        @Override
        public SyntacticTag next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Sub tags iterator");
            }
            SyntacticTag toReturn = this.nextTag;
            this.nextTag = null;
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Syntactic tags iterator : remove");
        }

        protected boolean findNextTag() {
            int endRank = this.stopMarkRank - 1;
            int rank = this.nextMarkRank;
            while (rank < endRank) {
                if (this.accept(rank)) {
                    this.nextTag = this.info.markAt(rank).toTag();
                    this.nextMarkRank = rank + 1;
                    return true;
                }
                ++rank;
            }
            return false;
        }

        protected boolean accept(int markRank) {
            SyntacticMark mark = this.info.markAt(markRank);
            return mark instanceof SyntacticTagBegin && this.info.acceptMark(markRank) && mark.getPeer().index <= this.maxIdx;
        }
    }
}

