/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.BasicTextPartition;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.IncrementalTextPartition;
import com.ibm.pdp.util.ints.IntSequence;

public class SubTextPartition
implements ISubTextPartition {
    protected int beginIndex;
    protected int endIndex;
    protected ITextPartition textPartition;
    protected int beginWordRank;
    protected int endWordRank;
    protected int realBeginWordRank;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SubTextPartition(ITextPartition textPartition, int beginIndex, int endIndex) {
        int endWordIndex;
        int beginWordIndex;
        if (beginIndex < 0 || endIndex < 0) {
            throw new RuntimeException("SubTextPartition : beginIndex or enIndex < 0");
        }
        if (endIndex < beginIndex) {
            throw new RuntimeException("SubTextPartition : endIndex < beginIndex");
        }
        this.beginWordRank = textPartition.wordRankFromIndex(beginIndex);
        int n = this.realBeginWordRank = this.beginWordRank < 0 ? ~this.beginWordRank : this.beginWordRank;
        if (this.beginWordRank >= 0 && (beginWordIndex = textPartition.wordBeginIndex(this.beginWordRank)) != beginIndex) {
            throw new RuntimeException("SubTextPartition : beginIndex is in the middle of a word");
        }
        this.endWordRank = textPartition.wordRankFromIndex(endIndex);
        if (this.endWordRank >= 0 && (endWordIndex = textPartition.wordBeginIndex(this.endWordRank)) != endIndex) {
            throw new RuntimeException("SubTextPartition : endIndex is in the middle of a word");
        }
        this.textPartition = textPartition;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    @Override
    public ITextPartition getMainPartition() {
        return this.textPartition;
    }

    @Override
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getBeginWordRank() {
        return this.beginWordRank;
    }

    @Override
    public int getEndWordRank() {
        return this.endWordRank;
    }

    @Override
    public char charAt(int index) {
        return this.textPartition.charAt(index + this.beginIndex);
    }

    @Override
    public CharSequence getText() {
        return this.textPartition.getTextInterval(this.beginIndex, this.endIndex);
    }

    @Override
    public CharSequence getTextInterval(int beginIdx, int endIdx) {
        return this.textPartition.getTextInterval(beginIdx + this.beginIndex, endIdx + this.beginIndex);
    }

    @Override
    public int getTextLength() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public IntSequence getWords() {
        if (this.beginWordRank == this.endWordRank) {
            return IntSequence.empty;
        }
        int realEndWordRank = this.endWordRank < 0 ? ~this.endWordRank : this.endWordRank;
        return this.textPartition.getWordsInterval(this.realBeginWordRank, realEndWordRank);
    }

    @Override
    public int getWordsCount() {
        return this.getWords().length();
    }

    @Override
    public IntSequence getWordsInterval(int beginWordRank, int endWordRank) {
        int realEndWordRank = endWordRank < 0 ? ~endWordRank : endWordRank;
        return this.textPartition.getWordsInterval(beginWordRank + this.realBeginWordRank, realEndWordRank + this.realBeginWordRank);
    }

    @Override
    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
    }

    @Override
    public void setText(CharSequence newText) {
    }

    @Override
    public int spaceAfterWord(int wordRank) {
        if (wordRank == this.getWordsCount() - 1 && this.endWordRank < 0) {
            return this.textPartition.spaceBeforeWord(~this.endWordRank) - this.textPartition.wordBeginIndex(~this.endWordRank) + this.endIndex;
        }
        return this.textPartition.spaceAfterWord(wordRank + this.realBeginWordRank);
    }

    @Override
    public int spaceBeforeWord(int wordRank) {
        if (wordRank == 0) {
            return this.textPartition.wordBeginIndex(this.realBeginWordRank) - this.beginIndex;
        }
        if (wordRank == this.getWordsCount()) {
            int result = this.textPartition.spaceBeforeWord(wordRank + this.realBeginWordRank);
            return result - (this.textPartition.wordBeginIndex(wordRank + this.realBeginWordRank) - this.endIndex);
        }
        return this.textPartition.spaceBeforeWord(wordRank + this.realBeginWordRank);
    }

    @Override
    public int wordBeginIndex(int wordRank) {
        int wordCount = this.getWordsCount();
        if (wordRank > wordCount) {
            throw new RuntimeException("SubTextPartition:wordBeginIndex wordRank> wordCount");
        }
        if (wordRank == wordCount) {
            return this.getTextLength();
        }
        return this.textPartition.wordBeginIndex(wordRank + this.realBeginWordRank) - this.beginIndex;
    }

    @Override
    public int wordEndIndex(int wordRank) {
        int wordCount = this.getWordsCount();
        if (wordRank > wordCount) {
            throw new RuntimeException("SubTextPartition:wordBeginIndex wordRank> wordCount");
        }
        if (wordRank == -1) {
            return 0;
        }
        return this.textPartition.wordEndIndex(wordRank + this.realBeginWordRank) - this.beginIndex;
    }

    @Override
    public int wordIdAt(int wordRank) {
        return this.textPartition.wordIdAt(this.realBeginWordRank + wordRank);
    }

    @Override
    public int wordLength(int wordRank) {
        return this.textPartition.wordLength(wordRank + this.realBeginWordRank);
    }

    @Override
    public int wordRankFromIndex(int index) {
        int tmp = this.textPartition.wordRankFromIndex(index + this.beginIndex);
        if (tmp < 0) {
            tmp = ~tmp - this.realBeginWordRank;
            return ~tmp;
        }
        return tmp - this.realBeginWordRank;
    }

    public int convertToRootPartitionRank(int rank) {
        if (this.textPartition instanceof SubTextPartition) {
            return ((SubTextPartition)this.textPartition).convertToRootPartitionRank(rank + this.realBeginWordRank);
        }
        return rank + this.realBeginWordRank;
    }

    public int convertToRootPartitionIndex(int index) {
        if (this.textPartition instanceof SubTextPartition) {
            return ((SubTextPartition)this.textPartition).convertToRootPartitionIndex(index + this.beginIndex);
        }
        return index + this.beginIndex;
    }

    public int convertFromRootPartitionIndex(int index) {
        if (this.textPartition instanceof SubTextPartition) {
            return ((SubTextPartition)this.textPartition).convertFromRootPartitionIndex(index - this.beginIndex);
        }
        return index - this.beginIndex;
    }

    public Dictionary getDictionary() {
        ITextPartition rootTextPartition = this.textPartition;
        while (rootTextPartition instanceof SubTextPartition) {
            rootTextPartition = ((SubTextPartition)rootTextPartition).textPartition;
        }
        if (rootTextPartition instanceof BasicTextPartition) {
            return ((BasicTextPartition)rootTextPartition).getDictionary();
        }
        if (rootTextPartition instanceof IncrementalTextPartition) {
            return ((IncrementalTextPartition)rootTextPartition).getDictionary();
        }
        return null;
    }

    public String toString() {
        return this.getText().toString();
    }

    @Override
    public ISubTextPartition subTextPartition(int beginIdx, int endIdx) {
        return new SubTextPartition(this.textPartition, beginIdx, endIdx);
    }

    @Override
    public int minWordId() {
        return this.textPartition.minWordId();
    }

    @Override
    public int maxWordId() {
        return this.textPartition.maxWordId();
    }
}

