/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.Segment;
import com.ibm.pdp.engine.turbo.core.SegmentFilter;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;

public class SegmentSelectionParameter {
    protected UserChangeSet changeSet;
    protected boolean atomic;
    protected Segment start;
    protected boolean startIncluded;
    protected Segment stop;
    protected boolean stopIncluded;
    protected boolean reverseOrder;
    protected SegmentFilter filter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SegmentSelectionParameter() {
    }

    public SegmentSelectionParameter(UserChangeSet userChangeSet, boolean atomicInit, Segment startInit, boolean startIncludedInit, Segment stopInit, boolean stopIncludedInit, boolean reverseOrderInit) {
        if (startInit != null && startInit.changeSet != userChangeSet || stopInit != null && stopInit.changeSet != userChangeSet) {
            throw new RuntimeException("Start or stop segment do not belong to the right change set.");
        }
        this.changeSet = userChangeSet;
        this.atomic = atomicInit;
        this.start = startInit;
        this.startIncluded = startIncludedInit;
        this.stop = stopInit;
        this.stopIncluded = stopIncludedInit;
        this.reverseOrder = reverseOrderInit;
    }

    public boolean getAtomic() {
        return this.atomic;
    }

    public Segment getStart() {
        return this.start;
    }

    public void setStart(Segment newStart) {
        if (newStart != null && newStart.changeSet != this.changeSet) {
            throw new RuntimeException("Start segment do not belong to the right change set.");
        }
        this.start = newStart;
    }

    public boolean getStartIncluded() {
        return this.startIncluded;
    }

    public void setStartIncluded(boolean newStartIncluded) {
        this.startIncluded = newStartIncluded;
    }

    public Segment getStop() {
        return this.stop;
    }

    public void setStop(Segment newStop) {
        if (newStop != null && newStop.changeSet != this.changeSet) {
            throw new RuntimeException("Stop segment do not belong to the right change set.");
        }
        this.stop = newStop;
    }

    public boolean getStopIncluded() {
        return this.stopIncluded;
    }

    public void setStopIncluded(boolean newStopIncluded) {
        this.stopIncluded = newStopIncluded;
    }

    public boolean getReverseOrder() {
        return this.reverseOrder;
    }

    public SegmentFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SegmentFilter newFilter) {
        this.filter = newFilter;
    }

    public boolean isEmptySelection() {
        return this.isEmptyInterval();
    }

    protected boolean isEmptyInterval() {
        if (this.atomic) {
            return this.isEmptyAtomicInterval();
        }
        return this.stop.isAncestorOf(this.start) || this.start == this.stop && (!this.startIncluded || !this.stopIncluded);
    }

    protected boolean isEmptyAtomicInterval() {
        int leftRank;
        int rightRank;
        if (this.reverseOrder) {
            rightRank = this.startIncluded ? this.start.maxRank() : this.start.minRank() - 1;
            leftRank = this.stopIncluded ? this.stop.minRank() - 1 : this.stop.maxRank();
        } else {
            leftRank = this.startIncluded ? this.start.minRank() : this.start.maxRank() + 1;
            int n = rightRank = this.stopIncluded ? this.stop.maxRank() + 1 : this.stop.minRank();
        }
        return leftRank >= rightRank;
    }
}

