/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.Segment;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SegmentIterator
implements Iterator<Segment> {
    protected Object[] atom;
    protected Segment found;
    protected Segment lastReturned;
    protected int stopRank;
    protected int stopLevel;
    protected boolean reverse;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected SegmentIterator() {
    }

    protected SegmentIterator(Object[] atomArray, Segment startSegment, boolean includeStartSegment, Segment stopSegment, boolean includeStopSegment, boolean reverseOrder) {
        this.atom = atomArray;
        this.reverse = reverseOrder;
        if (startSegment == null) {
            startSegment = ((Segment)atomArray[reverseOrder ? atomArray.length - 1 : 0]).root();
            includeStartSegment = true;
        }
        if (includeStartSegment) {
            this.found = startSegment;
        } else {
            this.lastReturned = startSegment;
        }
        if (stopSegment == null) {
            stopSegment = (Segment)atomArray[reverseOrder ? 0 : atomArray.length - 1];
        } else if (!includeStopSegment) {
            stopSegment = this.previous(stopSegment);
        }
        this.stopRank = reverseOrder ? stopSegment.maxRank() : stopSegment.minRank();
        this.stopLevel = stopSegment.generatedLevel();
    }

    protected Segment previous(Segment segment) {
        return this.reverse ? this.previousBackward(segment) : this.previousForward(segment);
    }

    protected Segment previousForward(Segment segment) {
        Segment brother = segment.previousBrother();
        if (brother != null) {
            return (Segment)this.atom[brother.maxRank()];
        }
        segment = segment.parent;
        if (segment != null) {
            return segment;
        }
        return (Segment)this.atom[this.atom.length - 1];
    }

    protected Segment previousBackward(Segment segment) {
        Segment brother = segment.nextBrother();
        if (brother != null) {
            return (Segment)this.atom[brother.minRank()];
        }
        segment = segment.parent;
        if (segment != null) {
            return segment;
        }
        return (Segment)this.atom[0];
    }

    @Override
    public boolean hasNext() {
        return this.found != null || !(this.reverse ? !this.findBackward(this.lastReturned) : !this.findForward(this.lastReturned));
    }

    @Override
    public Segment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("SegmentIterator.next");
        }
        this.lastReturned = this.found;
        this.found = null;
        return this.lastReturned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("SegmentIterator.remove");
    }

    protected boolean findForward(Segment segment) {
        Segment candidate = this.forwardCandidate(segment);
        if (candidate == null) {
            this.found = null;
            return false;
        }
        this.found = this.nextToReturn(segment, candidate);
        return true;
    }

    protected Segment forwardCandidate(Segment segment) {
        int minRank = segment.minRank();
        return minRank < this.stopRank || minRank == this.stopRank && segment.generatedLevel() < this.stopLevel ? (Segment)this.atom[segment.isAtomic() ? minRank + 1 : minRank] : null;
    }

    protected boolean findBackward(Segment segment) {
        Segment candidate = this.backwardCandidate(segment);
        if (candidate == null) {
            this.found = null;
            return false;
        }
        this.found = this.nextToReturn(segment, candidate);
        return true;
    }

    protected Segment backwardCandidate(Segment segment) {
        int maxRank = segment.maxRank();
        return maxRank > this.stopRank || maxRank == this.stopRank && segment.generatedLevel() < this.stopLevel ? (Segment)this.atom[segment.isAtomic() ? maxRank - 1 : maxRank] : null;
    }

    protected Segment nextToReturn(Segment previous, Segment candidate) {
        int candidateParentLevel;
        int previousLevel = previous != null ? previous.generatedLevel() : -1;
        if (previousLevel > (candidateParentLevel = candidate.generatedLevel() - 1)) {
            do {
                previous = previous.parent;
            } while (--previousLevel > candidateParentLevel);
        } else if (previousLevel < candidateParentLevel) {
            do {
                candidate = candidate.parent;
            } while (--candidateParentLevel < previousLevel);
        }
        while (candidate.parent != previous) {
            candidate = candidate.parent;
            previous = previous.parent;
        }
        return candidate;
    }
}

