/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.TextStatus;
import com.ibm.pdp.engine.tree.ITextNode;
import com.ibm.pdp.engine.turbo.core.ChangeNature;
import com.ibm.pdp.engine.turbo.core.DetailedChangeBits16;
import com.ibm.pdp.engine.turbo.core.DetailedChangeBits32;
import com.ibm.pdp.engine.turbo.core.DetailedChangeBits7;
import com.ibm.pdp.engine.turbo.core.DetailedChanges2Bits3;
import com.ibm.pdp.engine.turbo.core.DetailedChanges3Bits2;
import com.ibm.pdp.engine.turbo.core.DetailedChangesBits16;
import com.ibm.pdp.engine.turbo.core.DetailedChangesBits32;
import com.ibm.pdp.engine.turbo.core.DetailedChangesBits4;
import com.ibm.pdp.engine.turbo.core.DetailedChangesBits8;
import com.ibm.pdp.engine.turbo.core.IDetailedChanges;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.UserChangeSet;
import com.ibm.pdp.engine.turbo.properties.TagProperties;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.diff.DifferenceNature;
import java.io.IOException;

public abstract class Segment {
    protected UserChangeSet changeSet;
    protected Segment parent;
    protected Segment enclosing;
    protected ITextNode node;
    protected static final int SEGMENT_STATUS_MASK = 7;
    protected static final ChangeNature[] natures = ChangeNature.values();
    protected static final int UNCHANGED = 0;
    protected static final int REFORMATED = 1;
    protected static final int MODIFIED = 2;
    protected static final int DELETED = 3;
    protected static final int INSERTED = 4;
    protected static final int REPLACED = 5;
    protected static final int DIRTY = 6;
    protected static final Segment[] EMPTY_SEGMENT_ARRAY = new Segment[0];
    protected static final DifferenceNature[] differenceNaturesFromDifference = DifferenceNature.values();
    protected static final ChangeNature[] naturesFromDifference = new ChangeNature[]{ChangeNature.Reformated, ChangeNature.Inserted, ChangeNature.Deleted, ChangeNature.Replaced};
    protected static final TextStatus[] textStatusFromDifference = new TextStatus[]{TextStatus.Reformated, TextStatus.Inserted, TextStatus.Deleted, TextStatus.Modified};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected Segment() {
    }

    protected Segment(UserChangeSet userChangeSet) {
        this.changeSet = userChangeSet;
    }

    protected Segment(UserChangeSet userChangeSet, Segment parentSegment) {
        this.changeSet = userChangeSet;
        this.parent = parentSegment;
    }

    public UserChangeSet getChangeSet() {
        return this.changeSet;
    }

    public abstract TagProperties getTagProperties();

    public abstract int generatedLevel();

    public Segment parent() {
        return this.parent;
    }

    public Segment root() {
        Segment root = this;
        Segment ancestor = this.parent;
        while (ancestor != null) {
            root = ancestor;
            ancestor = ancestor.parent;
        }
        return root;
    }

    public Segment top() {
        return this.changeSet.topSegment;
    }

    public abstract boolean isAtomic();

    public abstract boolean isTagged();

    public abstract boolean isPart();

    public abstract boolean isFirstPart();

    public abstract boolean isMiddlePart();

    public abstract boolean isLastPart();

    public abstract IGeneratedTag enclosingTag();

    public abstract IGeneratedTag fromTag();

    public abstract IGeneratedTag toTag();

    public abstract String fromTagName();

    public abstract String toTagName();

    public abstract String enclosingTagName();

    public abstract int nbOfSons();

    public abstract int nbOfTaggedSons();

    public abstract Segment[] sons();

    public abstract boolean isAncestorOf(Segment var1);

    public static Segment commonAncestorOf(Segment left, Segment right) {
        int levelDiff = right.generatedLevel() - left.generatedLevel();
        if (levelDiff > 0) {
            do {
                right = right.parent();
            } while (--levelDiff != 0);
        } else if (levelDiff < 0) {
            do {
                left = left.parent();
            } while (++levelDiff != 0);
        }
        while (left != right) {
            left = left.parent();
            right = right.parent();
        }
        return left;
    }

    public abstract Segment previousBrother();

    public abstract Segment nextBrother();

    public abstract Segment previousAtom();

    public abstract Segment nextAtom();

    public abstract Segment firstAtom();

    public abstract Segment lastAtom();

    public abstract boolean isSyntactic();

    public abstract boolean isTop();

    public abstract boolean isLeaf();

    public abstract Segment enclosingSegment();

    public abstract Segment[] subSegments();

    protected abstract boolean dirtySubSegments();

    protected abstract void touchSubSegments();

    public abstract int minRank();

    public abstract int maxRank();

    public abstract int beginIndex();

    public abstract int endIndex();

    public abstract void setBeginIndex(int var1);

    public abstract int length();

    public boolean isBlank() {
        return this.changeSet.blankInterval(this.beginIndex(), this.endIndex());
    }

    public CharSequence getText() {
        return this.changeSet.partition.getTextInterval(this.beginIndex(), this.endIndex());
    }

    public abstract void setText(CharSequence var1);

    public abstract int generatedBeginIndex();

    public abstract int generatedEndIndex();

    public abstract int generatedLength();

    public boolean isGeneratedBlank() {
        return this.changeSet.blankGeneratedInterval(this.generatedBeginIndex(), this.generatedEndIndex());
    }

    public abstract CharSequence generatedText();

    public abstract ChangeNature getChangeNature();

    public abstract void setChangeNature(ChangeNature var1);

    public abstract ChangeNature getSubtreesChangeNature();

    public abstract ChangeNature getTreeChangeNature();

    protected abstract int getSegmentStatus();

    protected abstract int getTreeStatus();

    protected void updateSubtreeStatus(int oldSubtreeStatus, int newSubtreeStatus) {
    }

    protected void updatePartStatus(int oldPartStatus, int newPartStatus) {
    }

    protected static int changeLevel(int changeStatus) {
        return changeStatus < 2 || changeStatus == 6 ? changeStatus : 2;
    }

    protected static ChangeNature changeNatureFromStatus(int status) {
        return natures[status];
    }

    public static DifferenceNature differenceNatureFromDifference(int difference) {
        return differenceNaturesFromDifference[difference];
    }

    public static ChangeNature changeNatureFromDifference(int difference) {
        return naturesFromDifference[difference];
    }

    public static TextStatus textStatusFromDifference(int difference) {
        return textStatusFromDifference[difference];
    }

    public Segment supersedingSegment() {
        Segment found = this;
        Segment candidate = this.parent;
        while (candidate != null && candidate.getChangeNature().isGlobalChange()) {
            found = candidate;
            candidate = candidate.parent;
        }
        return found;
    }

    public abstract boolean restoreGeneratedText();

    public ITextNode getTextNode() {
        return this.node;
    }

    public void setTextNode(ITextNode newNode) {
        this.node = newNode;
    }

    public abstract IDetailedChanges detailedChanges();

    public abstract void setDetailedChanges(IDetailedChanges var1);

    protected static boolean isReplacement(int initialCount, int nbRemoved, int nbAdded, int nbDifferences) {
        return false;
    }

    protected static IDetailedChanges buildDetailedChanges(ITextPartition modified, ITextPartition reference, int nbDifference, int maxValue, DiffCursor diff) {
        IDetailedChanges details = Segment.newDetailedChanges(nbDifference, maxValue);
        int diffCount = 0;
        while (diff.searchNextDifference()) {
            details.setDifferenceNature(diffCount, diff.getDifferenceNature());
            details.setReferenceBeginIndex(diffCount, reference.wordEndIndex(diff.getReferenceBeginIndex() - 1));
            details.setReferenceEndIndex(diffCount, reference.wordBeginIndex(diff.getReferenceEndIndex()));
            details.setModifiedBeginIndex(diffCount, modified.wordEndIndex(diff.getModifiedBeginIndex() - 1));
            details.setModifiedEndIndex(diffCount, modified.wordBeginIndex(diff.getModifiedEndIndex()));
            ++diffCount;
        }
        return details;
    }

    protected static IDetailedChanges newDetailedChanges(int nbDifference, int maxValue) {
        if (nbDifference == 1) {
            if (maxValue < 65536) {
                if (maxValue < 128) {
                    return new DetailedChangeBits7();
                }
                return new DetailedChangeBits16();
            }
            return new DetailedChangeBits32();
        }
        if (nbDifference == 2 && maxValue < 8) {
            return new DetailedChanges2Bits3();
        }
        if (nbDifference == 3 && maxValue < 4) {
            return new DetailedChanges3Bits2();
        }
        if (maxValue < 256) {
            if (maxValue < 16) {
                return new DetailedChangesBits4(nbDifference);
            }
            return new DetailedChangesBits8(nbDifference);
        }
        if (maxValue < 65536) {
            return new DetailedChangesBits16(nbDifference);
        }
        return new DetailedChangesBits32(nbDifference);
    }

    public int detailDiffRankAtIndex(int index) {
        IDetailedChanges details = this.detailedChanges();
        if (details == null) {
            return -1;
        }
        index -= this.beginIndex();
        int begin = 0;
        int end = details.getNbOfDifferences();
        while (begin < end) {
            int middle = begin + end >> 1;
            if (details.getModifiedBeginIndex(middle) > index) {
                end = middle;
                continue;
            }
            if (details.getModifiedEndIndex(middle) < index) {
                begin = middle + 1;
                continue;
            }
            return middle;
        }
        return ~begin;
    }

    public static void appendDetails(IDetailedChanges details, Appendable stream) {
        int diffCount = details.getNbOfDifferences();
        try {
            int diff = 0;
            while (diff < diffCount) {
                switch (details.getDifferenceNature(diff)) {
                    case Deletion: {
                        stream.append('-');
                        break;
                    }
                    case Insertion: {
                        stream.append('+');
                        break;
                    }
                    case Replacement: {
                        stream.append('*');
                    }
                }
                stream.append("R[").append(String.valueOf(details.getReferenceBeginIndex(diff)));
                stream.append(',').append(String.valueOf(details.getReferenceEndIndex(diff)));
                stream.append("] M[").append(String.valueOf(details.getModifiedBeginIndex(diff)));
                stream.append(',').append(String.valueOf(details.getModifiedEndIndex(diff))).append("]\n");
                ++diff;
            }
        }
        catch (IOException ioe) {
            throw Util.rethrow((Throwable)ioe);
        }
    }
}

