/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.turbo.core.PatchCharSequence;
import com.ibm.pdp.util.containers.CharBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.Random;

public class PatchCharSequenceTest {
    protected static final char[] alphabet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\"', '_', '-', '/', '.', ',', ';', ':', '+', '*', '!', '#', '%', '&', '?', '|', '~', '$', '<', '>', '=', '(', ')', '[', ']', '{', '}', ' '};
    protected static Random random = new Random();
    protected static final Formatter fmt = new Formatter(System.out);
    protected static final int alphabetSize = 90;
    protected static final int maxActionCode = 16;
    protected static final int maxAddLength = 10000;
    protected static int maxLength = 0;
    protected static int testCount = 0;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        long time;
        long seed = time = System.currentTimeMillis();
        fmt.format("Start test\n", new Object[0]);
        try {
            PatchCharSequenceTest.testWithSeed(seed);
        }
        catch (Throwable t) {
            fmt.format("\n!!!!!!!!!!!!!!!!\n", new Object[0]);
            StringWriter writer = new StringWriter(200);
            t.printStackTrace(new PrintWriter(writer));
            fmt.format("%s", writer.toString());
            fmt.format("\n!!!!!!!!!!!!!!!!\n", new Object[0]);
        }
        time = (System.currentTimeMillis() - time) / 1000L;
        fmt.format("Test stopped, %d tests performed in %d s, MaxLength=%d\n", testCount, time, maxLength);
    }

    public static void testRandomSeeds(int nbTest) {
        long rootSeed = System.currentTimeMillis();
        random = new Random(rootSeed);
        int l = 0;
        while (l < nbTest) {
            long seed = random.nextLong();
            PatchCharSequenceTest.testWithSeed(seed);
            ++l;
        }
    }

    protected static void testWithSeed(long seed) {
        fmt.format("############################# Seed=%d ##############################\n", seed);
        random.setSeed(seed);
        PatchCharSequenceTest.validityTests();
    }

    protected static void validityTests() {
        StringBuilder builder = new StringBuilder();
        PatchCharSequence buffer = new PatchCharSequence();
        int i = 0;
        while (i < 100000) {
            ++testCount;
            int action = PatchCharSequenceTest.randomActionCode();
            switch (action) {
                case 0: {
                    char c = PatchCharSequenceTest.randomChar(90);
                    builder.append(c);
                    buffer.append(c);
                    break;
                }
                case 1: {
                    String str = PatchCharSequenceTest.makeRandomString(1 + PatchCharSequenceTest.randomLength(10000), 90);
                    builder.append(str);
                    buffer.append(str);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    char c = PatchCharSequenceTest.randomChar(90);
                    int idx = random.nextInt(builder.length() + 1);
                    builder.insert(idx, c);
                    buffer.insert(idx, c);
                    break;
                }
                case 6: {
                    String str = PatchCharSequenceTest.makeRandomString(1 + PatchCharSequenceTest.randomLength(10000), 90);
                    int idx = random.nextInt(builder.length() + 1);
                    builder.insert(idx, str);
                    buffer.insert(idx, str);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    int length = builder.length();
                    if (length == 0) break;
                    int idx = random.nextInt(length);
                    builder.deleteCharAt(idx);
                    buffer.delete(idx);
                    break;
                }
                case 11: {
                    int length = builder.length();
                    if (length == 0) break;
                    int beginIdx = random.nextInt(length);
                    int endIdx = random.nextInt(1 + length);
                    if (endIdx < beginIdx) {
                        int tmp = endIdx;
                        endIdx = beginIdx;
                        beginIdx = tmp;
                    }
                    builder.delete(beginIdx, endIdx);
                    buffer.delete(beginIdx, endIdx);
                    break;
                }
                case 12: {
                    int tmp;
                    int length = builder.length();
                    if (length == 0) break;
                    String str = PatchCharSequenceTest.makeRandomString(1 + PatchCharSequenceTest.randomLength(10000), 90);
                    int fromIdx = random.nextInt(length);
                    int toIdx = random.nextInt(length + 1);
                    if (toIdx < fromIdx) {
                        tmp = toIdx;
                        toIdx = fromIdx;
                        fromIdx = tmp;
                    }
                    builder.replace(fromIdx, toIdx, str);
                    buffer.replace(fromIdx, toIdx, str);
                    break;
                }
                case 13: {
                    int length = builder.length();
                    if (length == 0) break;
                    char chr = PatchCharSequenceTest.randomChar(90);
                    int index = random.nextInt(length);
                    builder.setCharAt(index, chr);
                    buffer.replace(index, index + 1, chr);
                    break;
                }
                case 14: {
                    int tmp;
                    int length = builder.length();
                    if (length == 0) break;
                    char chr = PatchCharSequenceTest.randomChar(90);
                    int fromIdx = random.nextInt(length);
                    int toIdx = random.nextInt(length + 1);
                    if (toIdx < fromIdx) {
                        tmp = toIdx;
                        toIdx = fromIdx;
                        fromIdx = tmp;
                    }
                    builder.replace(fromIdx, toIdx, Character.toString(chr));
                    buffer.replace(fromIdx, toIdx, chr);
                    break;
                }
            }
            PatchCharSequenceTest.checkEquality(builder, buffer);
            ++i;
        }
    }

    protected static void checkEquality(StringBuilder builder, PatchCharSequence buffer) {
        int length = builder.length();
        if (length > maxLength) {
            maxLength = length;
        }
        if (buffer.length() != length) {
            throw new RuntimeException("Wrong length, Test #" + testCount);
        }
        int i = 0;
        while (i < length) {
            if (builder.charAt(i) != buffer.charAt(i)) {
                throw new RuntimeException("Wrong char at index " + i + ", Test #" + testCount);
            }
            ++i;
        }
    }

    protected static int randomActionCode() {
        return random.nextInt(16);
    }

    protected static void performanceTests() {
        int l = 0;
        while (l < 10) {
            fmt.format("Performance %d\n", l + 1);
            PatchCharSequenceTest.appendTest();
            PatchCharSequenceTest.readTest();
            PatchCharSequenceTest.randomInsertTest();
            PatchCharSequenceTest.middleInsertTest();
            PatchCharSequenceTest.beginInsertTest();
            PatchCharSequenceTest.randomReplaceTest();
            ++l;
        }
    }

    protected static void appendTest() {
        int nbLoop = 1000;
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < nbLoop) {
            int c = 0;
            while (c < 65535) {
                builder.append('X');
                ++c;
            }
            count1 += builder.length();
            builder.delete(0, builder.length());
            ++i;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        char[] buffer = new char[8];
        int length = 0;
        int i2 = 0;
        while (i2 < nbLoop) {
            int c = 0;
            while (c < 65535) {
                buffer = CharBuffer.append((char[])buffer, (int)length, (int)length, (int)1);
                buffer[length++] = 88;
                ++c;
            }
            count2 += length;
            buffer = CharBuffer.delete((char[])buffer, (int)length, (int)length, (int)0, (int)length);
            length = 0;
            ++i2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += length)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("Append StringBuilder=%d ms, CharBuffer=%d ms\n", time1, time2);
    }

    protected static void readTest() {
        int nbLoop = 1000;
        int length = 65535;
        StringBuilder builder = new StringBuilder(length);
        int c = 0;
        while (c < length) {
            builder.append(PatchCharSequenceTest.randomChar(90));
            ++c;
        }
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        int i = 0;
        while (i < nbLoop) {
            int c2 = 0;
            while (c2 < length) {
                count1 += builder.charAt(c2);
                ++c2;
            }
            ++i;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        char[] buffer = new char[length];
        builder.getChars(0, length, buffer, 0);
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < nbLoop) {
            int c3 = 0;
            while (c3 < length) {
                count2 += CharBuffer.getCharAt((char[])buffer, (int)length, (int)length, (int)c3);
                ++c3;
            }
            ++i2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += length)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("Read StringBuilder=%d ms, CharBuffer=%d ms\n", time1, time2);
    }

    protected static void randomInsertTest() {
        int nbLoop = 1;
        int maxLength = 65536;
        StringBuilder builder = new StringBuilder(maxLength);
        int[] insertIndexes = new int[maxLength];
        int i = 0;
        while (i < maxLength) {
            insertIndexes[i] = random.nextInt(i + 1);
            ++i;
        }
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        int l = 0;
        while (l < nbLoop) {
            int i2 = 0;
            while (i2 < maxLength) {
                builder.insert(insertIndexes[i2], 'X');
                ++i2;
            }
            builder.delete(0, maxLength);
            ++l;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        char[] buffer = new char[maxLength];
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        int l2 = 0;
        while (l2 < nbLoop) {
            int length = 0;
            int holeIdx = 0;
            int i3 = 0;
            while (i3 < maxLength) {
                int idx = insertIndexes[i3];
                buffer = CharBuffer.insert((char[])buffer, (int)holeIdx, (int)length, (int)idx, (int)1);
                buffer[idx] = 88;
                ++length;
                holeIdx = idx + 1;
                ++i3;
            }
            ++l2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += 0)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("RandomInsert StringBuilder=%d ms, CharBuffer=%d ms\n", time1, time2);
    }

    protected static void middleInsertTest() {
        int nbLoop1 = 1;
        int nbLoop2 = 500;
        int maxLength = 65536;
        StringBuilder builder = new StringBuilder(maxLength);
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        int l = 0;
        while (l < nbLoop1) {
            int i = 0;
            while (i < maxLength) {
                builder.insert(i >> 1, 'X');
                ++i;
            }
            builder.delete(0, maxLength);
            ++l;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        char[] buffer = new char[maxLength];
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        int l2 = 0;
        while (l2 < nbLoop2) {
            int length = 0;
            int holeIdx = 0;
            int i = 0;
            while (i < maxLength) {
                int idx = i >> 1;
                buffer = CharBuffer.insert((char[])buffer, (int)holeIdx, (int)length, (int)idx, (int)1);
                buffer[idx] = 88;
                ++length;
                holeIdx = idx + 1;
                ++i;
            }
            ++l2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += 0)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("MiddleInsert StringBuilder=%d ms, CharBuffer=%d ms\n", time1 * (long)nbLoop2 / (long)nbLoop1, time2);
    }

    protected static void beginInsertTest() {
        int nbLoop1 = 1;
        int nbLoop2 = 500;
        int maxLength = 65536;
        StringBuilder builder = new StringBuilder(maxLength);
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        int l = 0;
        while (l < nbLoop1) {
            int i = 0;
            while (i < maxLength) {
                builder.insert(0, 'X');
                ++i;
            }
            builder.delete(0, maxLength);
            ++l;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        char[] buffer = new char[maxLength];
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        int l2 = 0;
        while (l2 < nbLoop2) {
            int length = 0;
            int holeIdx = 0;
            int i = 0;
            while (i < maxLength) {
                int idx = 0;
                buffer = CharBuffer.insert((char[])buffer, (int)holeIdx, (int)length, (int)idx, (int)1);
                buffer[idx] = 88;
                ++length;
                holeIdx = idx + 1;
                ++i;
            }
            ++l2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += 0)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("BeginInsert StringBuilder=%d ms, CharBuffer=%d ms\n", time1 * (long)nbLoop2 / (long)nbLoop1, time2);
    }

    protected static void randomReplaceTest() {
        int i;
        int nbLoop = 1;
        int maxLength = 65536;
        StringBuilder builder = new StringBuilder(maxLength);
        int i2 = 0;
        while (i2 < maxLength) {
            builder.append('Y');
            ++i2;
        }
        String replacement = builder.toString();
        builder = new StringBuilder(maxLength);
        int i3 = 0;
        while (i3 < maxLength) {
            builder.append('X');
            ++i3;
        }
        int[] replaceIndexes = new int[maxLength * 3];
        int i4 = 0;
        while (i4 < maxLength) {
            int beginIdx = random.nextInt(maxLength);
            int endIdx = random.nextInt(maxLength);
            int j = i4 * 3;
            if (endIdx >= beginIdx) {
                replaceIndexes[j] = beginIdx;
                replaceIndexes[j + 1] = endIdx - beginIdx;
            } else {
                replaceIndexes[j] = endIdx;
                replaceIndexes[j + 1] = beginIdx - endIdx;
            }
            replaceIndexes[j + 2] = random.nextInt(maxLength);
            ++i4;
        }
        int count1 = 0;
        long time1 = System.currentTimeMillis();
        int l = 0;
        while (l < nbLoop) {
            i = 0;
            while (i < maxLength) {
                int j = 3 * i;
                int idx = replaceIndexes[j];
                int toDelete = replaceIndexes[j + 1];
                int toInsert = replaceIndexes[j + 2];
                builder.replace(idx, idx + toDelete, replacement.substring(0, toInsert));
                count1 += builder.length();
                builder.replace(idx, idx + toInsert, replacement.substring(0, toDelete));
                ++i;
            }
            ++l;
        }
        count1 += builder.length();
        time1 = System.currentTimeMillis() - time1;
        char[] buffer = new char[maxLength];
        i = 0;
        while (i < maxLength) {
            buffer[i] = 88;
            ++i;
        }
        int count2 = 0;
        long time2 = System.currentTimeMillis();
        int length = maxLength;
        int holeIdx = maxLength;
        int l2 = 0;
        while (l2 < nbLoop) {
            int i5 = 0;
            while (i5 < maxLength) {
                int j = 3 * i5;
                int idx = replaceIndexes[j];
                int toDelete = replaceIndexes[j + 1];
                int toInsert = replaceIndexes[j + 2];
                if (toDelete != toInsert) {
                    buffer = CharBuffer.replace((char[])buffer, (int)holeIdx, (int)length, (int)idx, (int)toDelete, (int)toInsert);
                    replacement.getChars(0, toInsert, buffer, idx);
                    holeIdx = idx + toInsert;
                    count2 += (length += toInsert - toDelete);
                    buffer = CharBuffer.replace((char[])buffer, (int)holeIdx, (int)length, (int)idx, (int)toInsert, (int)toDelete);
                    replacement.getChars(0, toDelete, buffer, idx);
                    length += toDelete - toInsert;
                    holeIdx = idx + toDelete;
                } else {
                    int endIdx = idx + toDelete;
                    if (endIdx <= holeIdx) {
                        replacement.getChars(0, toInsert, buffer, idx);
                    } else if (idx >= holeIdx) {
                        replacement.getChars(0, toInsert, buffer, idx + buffer.length - length);
                    } else {
                        replacement.getChars(0, holeIdx - idx, buffer, idx);
                        replacement.getChars(holeIdx - idx, toInsert, buffer, holeIdx + buffer.length - length);
                    }
                    count2 += length;
                    if (endIdx <= holeIdx) {
                        replacement.getChars(0, toInsert, buffer, idx);
                    } else if (idx >= holeIdx) {
                        replacement.getChars(0, toInsert, buffer, idx + buffer.length - length);
                    } else {
                        replacement.getChars(0, holeIdx - idx, buffer, idx);
                        replacement.getChars(holeIdx - idx, toInsert, buffer, holeIdx + buffer.length - length);
                    }
                }
                ++i5;
            }
            ++l2;
        }
        time2 = System.currentTimeMillis() - time2;
        if (count1 != (count2 += length)) {
            throw new RuntimeException("Wrong checksum at test #" + testCount);
        }
        fmt.format("RandomReplace StringBuilder=%d ms, CharBuffer=%d ms\n", time1, time2);
    }

    protected static int randomLength(int maxLength) {
        int count = 1;
        int j = maxLength;
        while (j > 1) {
            ++count;
            j >>= 1;
        }
        int shift = random.nextInt(count);
        int length = random.nextInt(maxLength);
        return length >> shift;
    }

    protected static String makeRandomString(int length, int alphabetSize) {
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            builder.append(PatchCharSequenceTest.randomChar(alphabetSize));
            ++i;
        }
        return builder.toString();
    }

    protected static char randomChar(int alphabetSize) {
        if (alphabetSize <= alphabet.length) {
            return alphabet[random.nextInt(alphabetSize)];
        }
        return (char)random.nextInt(alphabetSize);
    }
}

