/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.util.Strings;
import com.ibm.pdp.util.containers.CharBuffer;

public class PatchCharSequence
implements CharSequence {
    protected CharSequence original;
    protected char[] patch;
    protected int patchBeginIdx;
    protected int patchEndIdx;
    protected int lengthChange;
    protected int holeIdx;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PatchCharSequence() {
        this.original = "";
    }

    public PatchCharSequence(CharSequence text) {
        this.original = text;
    }

    @Override
    public int length() {
        return this.original.length() + this.lengthChange;
    }

    @Override
    public char charAt(int index) {
        if (this.patch == null || index < this.patchBeginIdx) {
            return this.original.charAt(index);
        }
        if (index >= this.patchEndIdx) {
            return this.original.charAt(index - this.lengthChange);
        }
        return CharBuffer.getCharAt((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)(index - this.patchBeginIdx));
    }

    @Override
    public CharSequence subSequence(int beginIdx, int endIdx) {
        if (beginIdx == 0 && endIdx == this.original.length() + this.lengthChange) {
            return this.getText();
        }
        return this.getTextInterval(beginIdx, endIdx);
    }

    public CharSequence getText() {
        if (this.patch != null) {
            this.rebuildText();
        }
        return this.original;
    }

    protected void rebuildText() {
        int patchLength;
        int textLength = this.original.length();
        int changeBeginIdx = this.patchBeginIdx;
        int changeEndIdx = this.patchEndIdx - this.lengthChange;
        StringBuilder builder = new StringBuilder(textLength + this.lengthChange);
        if (changeBeginIdx > 0) {
            builder.append(this.original, 0, changeBeginIdx);
        }
        if ((patchLength = this.patchEndIdx - this.patchBeginIdx) > 0) {
            this.appendPatchTo(0, patchLength, builder);
        }
        if (changeEndIdx < textLength) {
            builder.append(this.original, changeEndIdx, textLength);
        }
        this.discardChanges();
        this.original = builder.toString();
    }

    protected void replaceRebuildText(int beginIdx, int endIdx, CharSequence newText) {
        int originalLength = this.original.length();
        int newTextLength = newText.length();
        StringBuilder builder = new StringBuilder(originalLength + this.lengthChange + newTextLength - endIdx + beginIdx);
        if (this.patch == null) {
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            if (newTextLength > 0) {
                builder.append(newText);
            }
            if (originalLength > endIdx) {
                builder.append(this.original, endIdx, originalLength);
            }
            this.original = builder.toString();
            return;
        }
        int length = originalLength + this.lengthChange;
        if (endIdx <= this.patchBeginIdx) {
            int patchLength;
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            if (newTextLength > 0) {
                builder.append(newText);
            }
            if (this.patchBeginIdx > endIdx) {
                builder.append(this.original, endIdx, this.patchBeginIdx);
            }
            if ((patchLength = this.patchEndIdx - this.patchBeginIdx) > 0) {
                this.appendPatchTo(builder);
            }
            if (length > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
            }
        } else if (beginIdx >= this.patchEndIdx) {
            int patchLength;
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            if ((patchLength = this.patchEndIdx - this.patchBeginIdx) > 0) {
                this.appendPatchTo(builder);
            }
            if (beginIdx > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, beginIdx - this.lengthChange);
            }
            if (newTextLength > 0) {
                builder.append(newText);
            }
            if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else if (beginIdx <= this.patchBeginIdx) {
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            if (newTextLength > 0) {
                builder.append(newText);
            }
            if (this.patchEndIdx > endIdx) {
                this.appendPatchTo(endIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, builder);
                if (length > this.patchEndIdx) {
                    builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
                }
            } else if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else if (endIdx >= this.patchEndIdx) {
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            this.appendPatchTo(0, beginIdx - this.patchBeginIdx, builder);
            if (newTextLength > 0) {
                builder.append(newText);
            }
            if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else {
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            this.appendPatchTo(0, beginIdx - this.patchBeginIdx, builder);
            if (newTextLength > 0) {
                builder.append(newText);
            }
            this.appendPatchTo(endIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, builder);
            if (length > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
            }
        }
        this.discardChanges();
        this.original = builder.toString();
    }

    protected void replaceRebuildText(int beginIdx, int endIdx, char newChr) {
        int originalLength = this.original.length();
        StringBuilder builder = new StringBuilder(originalLength + this.lengthChange + 1 - endIdx + beginIdx);
        if (this.patch == null) {
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            builder.append(newChr);
            if (originalLength > endIdx) {
                builder.append(this.original, endIdx, originalLength);
            }
            this.original = builder.toString();
            return;
        }
        int length = originalLength + this.lengthChange;
        if (endIdx <= this.patchBeginIdx) {
            int patchLength;
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            builder.append(newChr);
            if (this.patchBeginIdx > endIdx) {
                builder.append(this.original, endIdx, this.patchBeginIdx);
            }
            if ((patchLength = this.patchEndIdx - this.patchBeginIdx) > 0) {
                this.appendPatchTo(builder);
            }
            if (length > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
            }
        } else if (beginIdx >= this.patchEndIdx) {
            int patchLength;
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            if ((patchLength = this.patchEndIdx - this.patchBeginIdx) > 0) {
                this.appendPatchTo(builder);
            }
            if (beginIdx > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, beginIdx - this.lengthChange);
            }
            builder.append(newChr);
            if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else if (beginIdx <= this.patchBeginIdx) {
            if (beginIdx > 0) {
                builder.append(this.original, 0, beginIdx);
            }
            builder.append(newChr);
            if (this.patchEndIdx > endIdx) {
                this.appendPatchTo(endIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, builder);
                if (length > this.patchEndIdx) {
                    builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
                }
            } else if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else if (endIdx >= this.patchEndIdx) {
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            this.appendPatchTo(0, beginIdx - this.patchBeginIdx, builder);
            builder.append(newChr);
            if (length > endIdx) {
                builder.append(this.original, endIdx - this.lengthChange, originalLength);
            }
        } else {
            if (this.patchBeginIdx > 0) {
                builder.append(this.original, 0, this.patchBeginIdx);
            }
            this.appendPatchTo(0, beginIdx - this.patchBeginIdx, builder);
            builder.append(newChr);
            this.appendPatchTo(endIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, builder);
            if (length > this.patchEndIdx) {
                builder.append(this.original, this.patchEndIdx - this.lengthChange, originalLength);
            }
        }
        this.discardChanges();
        this.original = builder.toString();
    }

    protected void appendPatchTo(StringBuilder builder) {
        int tailLength;
        int patchLength = this.patchEndIdx - this.patchBeginIdx;
        if (this.holeIdx > 0) {
            builder.append(this.patch, 0, this.holeIdx);
        }
        if (this.holeIdx < patchLength && (tailLength = patchLength - this.holeIdx) > 0) {
            builder.append(this.patch, this.patch.length - tailLength, tailLength);
        }
    }

    protected void appendPatchTo(int beginIdx, int endIdx, StringBuilder builder) {
        if (endIdx <= this.holeIdx) {
            builder.append(this.patch, beginIdx, endIdx - beginIdx);
        } else if (beginIdx >= this.holeIdx) {
            builder.append(this.patch, beginIdx + this.patch.length - this.patchEndIdx + this.patchBeginIdx, endIdx - beginIdx);
        } else {
            builder.append(this.patch, beginIdx, this.holeIdx - beginIdx);
            builder.append(this.patch, this.holeIdx + this.patch.length - this.patchEndIdx + this.patchBeginIdx, endIdx - this.holeIdx);
        }
    }

    public CharSequence getTextInterval(int beginIdx, int endIdx) {
        int newLength;
        if (this.patch == null || endIdx <= this.patchBeginIdx) {
            return this.original.subSequence(beginIdx, endIdx);
        }
        if (beginIdx >= this.patchEndIdx) {
            return this.original.subSequence(beginIdx - this.lengthChange, endIdx - this.lengthChange);
        }
        if (beginIdx >= this.patchBeginIdx && endIdx <= this.patchEndIdx && (newLength = this.original.length() + this.lengthChange) >> 8 > endIdx - beginIdx) {
            return CharBuffer.toString((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)(beginIdx - this.patchBeginIdx), (int)(endIdx - this.patchBeginIdx));
        }
        this.rebuildText();
        return this.original.subSequence(beginIdx, endIdx);
    }

    public void setText(CharSequence newText) {
        this.discardChanges();
        this.original = newText;
    }

    protected void discardChanges() {
        this.holeIdx = 0;
        this.lengthChange = 0;
        this.patchEndIdx = 0;
        this.patchBeginIdx = 0;
        this.patch = null;
    }

    public void append(CharSequence newText) {
        int length = this.original.length() + this.lengthChange;
        this.replace(length, length, newText);
    }

    public void append(char newChr) {
        int length = this.original.length() + this.lengthChange;
        this.replace(length, length, newChr);
    }

    public void insert(int idx, CharSequence newText) {
        this.replace(idx, idx, newText);
    }

    public void insert(int idx, char newChr) {
        this.replace(idx, idx, newChr);
    }

    public void delete(int idx) {
        this.replace(idx, idx + 1, "");
    }

    public void delete(int beginIdx, int endIdx) {
        this.replace(beginIdx, endIdx, "");
    }

    public void replace(int beginIdx, int endIdx, CharSequence newText) {
        int newPatchLength;
        int newLength = newText.length();
        int lengthVariation = newLength - endIdx + beginIdx;
        int newTotalLength = this.original.length() + this.lengthChange + lengthVariation;
        int n = newPatchLength = this.patch == null ? newLength : Math.max(endIdx, this.patchEndIdx) + lengthVariation - Math.min(beginIdx, this.patchBeginIdx);
        if (this.patchIsTooBig(newPatchLength, newTotalLength)) {
            this.replaceRebuildText(beginIdx, endIdx, newText);
            return;
        }
        if (this.patch == null) {
            char[] newPatch = new char[newLength + (newLength >> 4) + 8];
            Strings.copyCharSequence((CharSequence)newText, (char[])newPatch, (int)0);
            this.patch = newPatch;
            this.patchBeginIdx = beginIdx;
            this.patchEndIdx = endIdx;
            this.holeIdx = newLength;
        } else if (endIdx <= this.patchBeginIdx) {
            this.addChangeBefore(newText, endIdx, this.patchBeginIdx);
            this.patchBeginIdx = beginIdx;
        } else if (beginIdx >= this.patchEndIdx) {
            this.addChangeAfter(this.patchEndIdx - this.lengthChange, beginIdx - this.lengthChange, newText);
            this.patchEndIdx = endIdx;
        } else if (beginIdx <= this.patchBeginIdx) {
            if (endIdx >= this.patchEndIdx) {
                this.replaceChange(newText);
                this.patchEndIdx = endIdx;
            } else {
                this.replaceChange(0, endIdx - this.patchBeginIdx, newText);
            }
            this.patchBeginIdx = beginIdx;
        } else if (endIdx >= this.patchEndIdx) {
            this.replaceChange(beginIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, newText);
            this.patchEndIdx = endIdx;
        } else {
            this.replaceChange(beginIdx - this.patchBeginIdx, endIdx - this.patchBeginIdx, newText);
        }
        this.patchEndIdx += lengthVariation;
        this.lengthChange += lengthVariation;
    }

    public void replace(int beginIdx, int endIdx, char newChr) {
        int newPatchLength;
        int newLength = 1;
        int lengthVariation = newLength - endIdx + beginIdx;
        int newTotalLength = this.original.length() + this.lengthChange + lengthVariation;
        int n = newPatchLength = this.patch == null ? newLength : Math.max(endIdx, this.patchEndIdx) + lengthVariation - Math.min(beginIdx, this.patchBeginIdx);
        if (this.patchIsTooBig(newPatchLength, newTotalLength)) {
            this.replaceRebuildText(beginIdx, endIdx, newChr);
            return;
        }
        if (this.patch == null) {
            char[] newPatch = new char[8];
            newPatch[0] = newChr;
            this.patch = newPatch;
            this.patchBeginIdx = beginIdx;
            this.patchEndIdx = endIdx;
            this.holeIdx = newLength;
        } else if (endIdx <= this.patchBeginIdx) {
            this.addChangeBefore(newChr, endIdx, this.patchBeginIdx);
            this.patchBeginIdx = beginIdx;
        } else if (beginIdx >= this.patchEndIdx) {
            this.addChangeAfter(this.patchEndIdx - this.lengthChange, beginIdx - this.lengthChange, newChr);
            this.patchEndIdx = endIdx;
        } else if (beginIdx <= this.patchBeginIdx) {
            if (endIdx >= this.patchEndIdx) {
                this.replaceChange(newChr);
                this.patchEndIdx = endIdx;
            } else {
                this.replaceChange(0, endIdx - this.patchBeginIdx, newChr);
            }
            this.patchBeginIdx = beginIdx;
        } else if (endIdx >= this.patchEndIdx) {
            this.replaceChange(beginIdx - this.patchBeginIdx, this.patchEndIdx - this.patchBeginIdx, newChr);
            this.patchEndIdx = endIdx;
        } else {
            this.replaceChange(beginIdx - this.patchBeginIdx, endIdx - this.patchBeginIdx, newChr);
        }
        this.patchEndIdx += lengthVariation;
        this.lengthChange += lengthVariation;
    }

    protected boolean patchIsTooBig(int patchLength, int totalLength) {
        return patchLength > 1024 && patchLength << 1 > totalLength;
    }

    @Override
    public String toString() {
        return this.getText().toString();
    }

    protected void addChangeBefore(CharSequence newText, int originalBeginIdx, int originalEndIdx) {
        int newTextLength = newText.length();
        int toInsert = newTextLength + originalEndIdx - originalBeginIdx;
        this.patch = CharBuffer.insert((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)0, (int)toInsert);
        Strings.copySubSequence((CharSequence)newText, (int)0, (int)newTextLength, (char[])this.patch, (int)0);
        Strings.copySubSequence((CharSequence)this.original, (int)originalBeginIdx, (int)originalEndIdx, (char[])this.patch, (int)newTextLength);
        this.holeIdx = toInsert;
    }

    protected void addChangeBefore(char newChr, int originalBeginIdx, int originalEndIdx) {
        int toInsert = 1 + originalEndIdx - originalBeginIdx;
        this.patch = CharBuffer.insert((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)0, (int)toInsert);
        this.patch[0] = newChr;
        Strings.copySubSequence((CharSequence)this.original, (int)originalBeginIdx, (int)originalEndIdx, (char[])this.patch, (int)1);
        this.holeIdx = toInsert;
    }

    protected void addChangeAfter(int originalBeginIdx, int originalEndIdx, CharSequence newText) {
        int newTextLength = newText.length();
        int patchLength = this.patchEndIdx - this.patchBeginIdx;
        int intervalLength = originalEndIdx - originalBeginIdx;
        int toInsert = intervalLength + newTextLength;
        this.patch = CharBuffer.append((char[])this.patch, (int)this.holeIdx, (int)patchLength, (int)toInsert);
        Strings.copySubSequence((CharSequence)this.original, (int)originalBeginIdx, (int)originalEndIdx, (char[])this.patch, (int)patchLength);
        Strings.copySubSequence((CharSequence)newText, (int)0, (int)newTextLength, (char[])this.patch, (int)(patchLength + intervalLength));
        this.holeIdx = patchLength + toInsert;
    }

    protected void addChangeAfter(int originalBeginIdx, int originalEndIdx, char newChr) {
        int patchLength = this.patchEndIdx - this.patchBeginIdx;
        int intervalLength = originalEndIdx - originalBeginIdx;
        int toInsert = intervalLength + 1;
        this.patch = CharBuffer.append((char[])this.patch, (int)this.holeIdx, (int)patchLength, (int)toInsert);
        Strings.copySubSequence((CharSequence)this.original, (int)originalBeginIdx, (int)originalEndIdx, (char[])this.patch, (int)patchLength);
        this.patch[patchLength + intervalLength] = newChr;
        this.holeIdx = patchLength + toInsert;
    }

    protected void replaceChange(CharSequence newText) {
        int newTextLength = newText.length();
        int patchLength = this.patchEndIdx - this.patchBeginIdx;
        this.patch = CharBuffer.replace((char[])this.patch, (int)this.holeIdx, (int)patchLength, (int)0, (int)patchLength, (int)newTextLength);
        Strings.copySubSequence((CharSequence)newText, (int)0, (int)newTextLength, (char[])this.patch, (int)0);
        this.holeIdx = newTextLength;
    }

    protected void replaceChange(char newChr) {
        int newTextLength = 1;
        int patchLength = this.patchEndIdx - this.patchBeginIdx;
        this.patch = CharBuffer.replace((char[])this.patch, (int)this.holeIdx, (int)patchLength, (int)0, (int)patchLength, (int)newTextLength);
        this.patch[0] = newChr;
        this.holeIdx = newTextLength;
    }

    protected void replaceChange(int beginIdx, int endIdx, CharSequence newText) {
        int toDelete;
        int newTextLength = newText.length();
        if (newTextLength == (toDelete = endIdx - beginIdx)) {
            CharBuffer.fill((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)beginIdx, (CharSequence)newText);
            return;
        }
        this.patch = CharBuffer.replace((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)beginIdx, (int)toDelete, (int)newTextLength);
        Strings.copySubSequence((CharSequence)newText, (int)0, (int)newTextLength, (char[])this.patch, (int)beginIdx);
        this.holeIdx = beginIdx + newTextLength;
    }

    protected void replaceChange(int beginIdx, int endIdx, char newChr) {
        int toDelete = endIdx - beginIdx;
        if (toDelete == 1) {
            CharBuffer.setCharAt((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)beginIdx, (char)newChr);
            return;
        }
        this.patch = CharBuffer.replace((char[])this.patch, (int)this.holeIdx, (int)(this.patchEndIdx - this.patchBeginIdx), (int)beginIdx, (int)toDelete, (int)1);
        this.patch[beginIdx] = newChr;
        this.holeIdx = beginIdx + 1;
    }
}

