/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.turbo.core.BasicGeneratedInfoChange;
import com.ibm.pdp.engine.turbo.core.GeneratedChangePosition;
import java.util.ArrayList;
import java.util.List;

public class OpenTag
extends BasicGeneratedInfoChange {
    protected String positionTag;
    protected String tagToOpen;
    protected List<String> properties;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public OpenTag(GeneratedChangePosition position, String positionTag, String tagToOpen) {
        super(position);
        this.positionTag = positionTag;
        this.tagToOpen = tagToOpen;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(name);
        this.properties.add(value);
    }

    @Override
    public boolean acceptTagName(String candidate) {
        return this.positionTag.equals(candidate);
    }

    @Override
    public boolean process(IGeneratedInfoFactory factory) {
        factory.beginTag(this.tagToOpen);
        int p = 0;
        while (p < this.properties.size()) {
            factory.setProperty(this.properties.get(p), this.properties.get(p + 1));
            p += 2;
        }
        return false;
    }

    public String toString() {
        switch (this.position) {
            case BEFORE_TAG_OPEN: {
                return "Before opening " + this.positionTag + ", open tag " + this.tagToOpen + "\n";
            }
            case AFTER_TAG_OPEN: {
                return "After opening " + this.positionTag + ", open tag " + this.tagToOpen + "\n";
            }
            case BEFORE_TAG_CLOSE: {
                return "Before closing " + this.positionTag + ", open tag " + this.tagToOpen + "\n";
            }
            case AFTER_TAG_CLOSE: {
                return "After closing " + this.positionTag + ", open tag " + this.tagToOpen + "\n";
            }
        }
        return "Erroneous OpenTag\n";
    }
}

