/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class JavaToString {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        try {
            String fileName = args[0];
            FileInputStream in = new FileInputStream(fileName);
            FileOutputStream out = new FileOutputStream(String.valueOf(fileName) + ".txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            String line = reader.readLine();
            if (line == null) {
                return;
            }
            String newLine = JavaToString.convertFirstLine(line);
            writer.write(newLine);
            writer.newLine();
            while ((line = reader.readLine()) != null) {
                newLine = JavaToString.convertLine(line);
                writer.write(newLine);
                writer.newLine();
            }
            writer.flush();
            writer.close();
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected static String convertFirstLine(String line) {
        int idx = 0;
        int length = line.length();
        while (idx < length) {
            char chr = line.charAt(idx);
            if (chr == '\"' || chr == '\t' || chr == '\\') break;
            ++idx;
        }
        if (idx == length) {
            return "\"" + line + "\\n\"";
        }
        StringBuilder builder = new StringBuilder(length + 16);
        JavaToString.convert(line, idx, builder);
        return builder.toString();
    }

    protected static String convertLine(String line) {
        int idx = 0;
        int length = line.length();
        while (idx < length) {
            char chr = line.charAt(idx);
            if (chr == '\"' || chr == '\t' || chr == '\\') break;
            ++idx;
        }
        if (idx == length) {
            return "+ \"" + line + "\\n\"";
        }
        StringBuilder builder = new StringBuilder(length + 16);
        builder.append("+ ");
        JavaToString.convert(line, idx, builder);
        return builder.toString();
    }

    protected static void convert(String line, int idx, StringBuilder builder) {
        builder.append("\"");
        if (idx > 0) {
            builder.append(line.substring(0, idx));
        }
        int length = line.length();
        do {
            char chr = line.charAt(idx);
            switch (chr) {
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                default: {
                    builder.append(chr);
                }
            }
        } while (++idx < length);
        builder.append("\\n\"");
    }
}

