/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.turbo.core.GeneratedChangePosition;
import com.ibm.pdp.engine.turbo.core.GeneratedInfoChange;
import com.ibm.pdp.engine.util.geninfo.TagConversionMode;
import java.util.Iterator;

public class InsertDash900AfterTagClose
extends GeneratedInfoChange {
    protected IGeneratedTag dash900Tag;
    protected String tagName;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp.2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public InsertDash900AfterTagClose(IGeneratedTag dash900Tag, String tagName) {
        this.dash900Tag = dash900Tag;
        this.tagName = tagName;
    }

    @Override
    public GeneratedChangePosition getPosition() {
        return GeneratedChangePosition.AFTER_TAG_CLOSE;
    }

    @Override
    public boolean acceptTagName(String name) {
        return this.tagName.equals(name);
    }

    @Override
    public TagConversionMode tagConversionMode(String tagName) {
        return null;
    }

    @Override
    public boolean acceptInterval(int beginIdx, int endIdx) {
        return false;
    }

    @Override
    public int beginIndex() {
        return 0;
    }

    @Override
    public int endIndex() {
        return 0;
    }

    @Override
    public boolean process(IGeneratedInfoFactory factory) {
        factory.beginTag(this.dash900Tag.getName());
        Iterator propertyNames = this.dash900Tag.propertyNames();
        while (propertyNames.hasNext()) {
            String propertyName = (String)propertyNames.next();
            factory.setProperty(propertyName, this.dash900Tag.getProperty(propertyName));
        }
        factory.appendText(this.dash900Tag.getGeneratedInfo().getText().subSequence(this.dash900Tag.getBeginIndex(), this.dash900Tag.getEndIndex()));
        factory.endTag();
        return false;
    }

    public String toString() {
        return "After closing tag " + this.tagName + ", insert " + this.dash900Tag.getName() + " tag\n";
    }
}

