/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.engine.turbo.core;

import com.ibm.pdp.engine.extension.ITextPartitioner;
import com.ibm.pdp.engine.extension.TextToken;
import com.ibm.pdp.engine.turbo.core.Dictionary;
import com.ibm.pdp.engine.turbo.core.ISubTextPartition;
import com.ibm.pdp.engine.turbo.core.ITextPartition;
import com.ibm.pdp.engine.turbo.core.IWord;
import com.ibm.pdp.engine.turbo.core.IncrementalSubTextPartition;
import com.ibm.pdp.engine.turbo.core.PatchCharSequence;
import com.ibm.pdp.util.containers.IntBuffer;
import com.ibm.pdp.util.ints.ArrayIntSequence;
import com.ibm.pdp.util.ints.IntSequence;
import com.ibm.pdp.util.ints.PatchIntSequence;
import java.util.Arrays;

public class IncrementalTextPartition
implements ITextPartition {
    protected int modCount;
    protected ITextPartitioner partitioner;
    protected Dictionary dictionary;
    protected PatchCharSequence text;
    protected PatchIntSequence words;
    protected int[] wordBeginIdx;
    protected int[] wordEndIdx;
    protected int wordHoleIdx;
    protected int wordCount;
    protected int beforeChangeWordRank;
    protected int afterChangeWordRank;
    protected int wordIdxShift;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IncrementalTextPartition() {
    }

    public IncrementalTextPartition(Dictionary dict, ITextPartitioner part) {
        this(dict, part, new PatchCharSequence());
    }

    public IncrementalTextPartition(Dictionary dict, ITextPartitioner part, PatchCharSequence initialText) {
        this.dictionary = dict;
        this.partitioner = part;
        this.text = initialText;
        this.partitioner.setText((CharSequence)this.text);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(Dictionary newDictionary) {
        this.clearWords();
        this.dictionary = newDictionary;
    }

    public ITextPartitioner getTextPartitioner() {
        return this.partitioner;
    }

    public void setTextPartitioner(ITextPartitioner newPartitioner) {
        this.clearWords();
        this.partitioner = newPartitioner;
        newPartitioner.setText((CharSequence)this.text);
    }

    @Override
    public int getTextLength() {
        return this.text.length();
    }

    @Override
    public CharSequence getText() {
        return this.text.getText();
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public CharSequence getTextInterval(int beginIdx, int endIdx) {
        return this.text.getTextInterval(beginIdx, endIdx);
    }

    @Override
    public void setText(CharSequence newText) {
        this.clearWords();
        int nbRemoved = this.text.length();
        int nbAdded = newText.length();
        this.text.setText(newText);
        this.partitioner.textChanged(0, nbRemoved, nbAdded);
    }

    @Override
    public void replaceText(int beginIdx, int endIdx, CharSequence newText) {
        int nbRemoved = endIdx - beginIdx;
        int nbAdded = newText.length();
        this.updateWords(beginIdx, endIdx, nbAdded);
        this.text.replace(beginIdx, endIdx, newText);
        this.partitioner.textChanged(beginIdx, nbRemoved, nbAdded);
    }

    @Override
    public int getWordsCount() {
        if (this.words == null) {
            this.computeWords();
        } else if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            this.refreshWords();
        }
        return this.wordCount;
    }

    @Override
    public IntSequence getWords() {
        if (this.words == null) {
            this.computeWords();
        } else if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            this.refreshWords();
        }
        return this.words.getText();
    }

    @Override
    public int wordIdAt(int rank) {
        if (this.words == null) {
            this.computeWords();
        } else if (this.beforeChangeWordRank != this.afterChangeWordRank && rank > this.beforeChangeWordRank) {
            this.refreshWords();
        }
        return this.words.intAt(rank);
    }

    @Override
    public IntSequence getWordsInterval(int beginWordRank, int endWordRank) {
        if (this.words == null) {
            this.computeWords();
        } else if (this.beforeChangeWordRank != this.afterChangeWordRank && endWordRank > this.beforeChangeWordRank + 1) {
            this.refreshWords();
        }
        return this.words.getTextInterval(beginWordRank, endWordRank);
    }

    @Override
    public int wordBeginIndex(int wordRank) {
        if (this.words == null) {
            this.computeWords();
            return wordRank == this.wordCount ? this.text.length() : this.wordBeginIdx(wordRank);
        }
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            if (wordRank <= this.beforeChangeWordRank) {
                return this.wordBeginIdx(wordRank);
            }
            this.refreshWords();
        }
        return wordRank == this.wordCount ? this.text.length() : this.correctedWordBeginIdx(wordRank);
    }

    @Override
    public int wordEndIndex(int wordRank) {
        if (wordRank == -1) {
            return 0;
        }
        if (this.words == null) {
            this.computeWords();
            return this.wordEndIdx(wordRank);
        }
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            if (wordRank <= this.beforeChangeWordRank) {
                return this.wordEndIdx(wordRank);
            }
            this.refreshWords();
        }
        return this.correctedWordEndIdx(wordRank);
    }

    @Override
    public int wordLength(int wordRank) {
        if (this.words == null) {
            this.computeWords();
        } else if (this.beforeChangeWordRank != this.afterChangeWordRank && wordRank > this.beforeChangeWordRank) {
            this.refreshWords();
        }
        return this.wordEndIdx(wordRank) - this.wordBeginIdx(wordRank);
    }

    @Override
    public int spaceBeforeWord(int wordRank) {
        if (this.words == null) {
            this.computeWords();
            return this.spaceBefore(wordRank);
        }
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            if (wordRank <= this.beforeChangeWordRank) {
                return this.spaceBefore(wordRank);
            }
            this.refreshWords();
        }
        return this.correctedSpaceBefore(wordRank);
    }

    @Override
    public int spaceAfterWord(int wordRank) {
        return this.spaceBeforeWord(wordRank + 1);
    }

    @Override
    public int wordRankFromIndex(int index) {
        if (this.words == null) {
            this.computeWords();
            return this.wordAtIndex(index);
        }
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            if (this.beforeChangeWordRank >= 0 && index < this.wordEndIdx(this.beforeChangeWordRank)) {
                return this.wordAtIndex(index, 0, this.beforeChangeWordRank);
            }
            this.refreshWords();
        }
        return this.afterChangeWordRank == this.wordCount ? this.wordAtIndex(index) : this.correctedWordAtIndex(index);
    }

    protected int wordRankFromIndex(int index, int low, int high) {
        if (this.words == null) {
            this.computeWords();
            return this.wordAtIndex(index, low, high);
        }
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            if (this.beforeChangeWordRank >= 0 && index < this.wordEndIdx(this.beforeChangeWordRank)) {
                return this.wordAtIndex(index, low, high <= this.beforeChangeWordRank ? high : this.beforeChangeWordRank);
            }
            this.refreshWords();
        }
        return this.afterChangeWordRank == this.wordCount ? this.wordAtIndex(index, low, high) : this.correctedWordAtIndex(index, low, high);
    }

    @Override
    public int minWordId() {
        return 0;
    }

    @Override
    public int maxWordId() {
        return this.dictionary.nbOfWord() - 1;
    }

    @Override
    public ISubTextPartition subTextPartition(int beginIdx, int endIdx) {
        if (beginIdx < 0 || beginIdx > endIdx || endIdx > this.text.length()) {
            throw new IndexOutOfBoundsException("Wrong indexes interval");
        }
        return new IncrementalSubTextPartition(this, beginIdx, endIdx);
    }

    protected void computeWords() {
        int initialNbOfWord = Math.max(this.text.length() >> 6, 8);
        int[] wordSequence = new int[initialNbOfWord];
        int[] wordBeginIndexes = new int[initialNbOfWord];
        int[] wordEndIndexes = new int[initialNbOfWord];
        int count = 0;
        TextToken token = this.partitioner.newToken();
        while (this.partitioner.nextToken(token)) {
            IWord word = this.dictionary.addWord(this.text, token);
            if (count == wordSequence.length) {
                wordSequence = Arrays.copyOf(wordSequence, count + (count >> 4) + 4);
                wordBeginIndexes = Arrays.copyOf(wordBeginIndexes, wordSequence.length);
                wordEndIndexes = Arrays.copyOf(wordEndIndexes, wordSequence.length);
            }
            wordSequence[count] = word.getId();
            wordBeginIndexes[count] = token.beginIdx;
            wordEndIndexes[count] = token.endIdx;
            ++count;
        }
        if (wordSequence.length > count) {
            wordSequence = Arrays.copyOf(wordSequence, count);
        }
        this.words = new PatchIntSequence((IntSequence)new ArrayIntSequence(wordSequence));
        this.wordBeginIdx = wordBeginIndexes;
        this.wordEndIdx = wordEndIndexes;
        this.beforeChangeWordRank = this.afterChangeWordRank = count;
        this.wordCount = this.afterChangeWordRank;
        this.wordHoleIdx = this.afterChangeWordRank;
        this.wordIdxShift = 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshWords() {
        rank = this.beforeChangeWordRank;
        token = this.newToken(rank);
        stopRank = this.afterChangeWordRank;
        stopIdx = stopRank < this.wordCount ? this.wordBeginIdx(stopRank) + this.wordIdxShift : 0x7FFFFFFF;
        wordsToDelete = this.afterChangeWordRank - this.beforeChangeWordRank - 1;
        if (wordsToDelete > 0) {
            this.removeWords(this.beforeChangeWordRank + 1, this.afterChangeWordRank);
            stopRank -= wordsToDelete;
        }
        while (this.partitioner.nextToken(token)) {
            idx = token.endIdx;
            if (token.beginIdx != stopIdx) ** GOTO lbl22
            stopWord = this.word(stopRank);
            stopWordEndIdx = this.wordEndIdx(stopRank) + this.wordIdxShift;
            if (idx != stopWordEndIdx || token.hash != stopWord.getHash() || token.category != stopWord.getCategory() || token.ignoreCase != stopWord.isIgnoreCase()) ** GOTO lbl22
            this.beforeChangeWordRank = this.wordIdxShift == 0 ? (this.afterChangeWordRank = this.wordCount) : (this.afterChangeWordRank = stopRank);
            return;
lbl-1000:
            // 1 sources

            {
                this.removeWord(stopRank);
                if (stopRank == this.wordCount) {
                    stopIdx = 0x7FFFFFFF;
                    break;
                }
                stopIdx = this.wordBeginIdx(stopRank) + this.wordIdxShift;
lbl22:
                // 3 sources

                ** while (idx > stopIdx)
            }
lbl23:
            // 2 sources

            this.insertWord(++rank, token);
            ++stopRank;
        }
        if (rank + 1 != this.wordCount) {
            this.removeWords(rank + 1, this.wordCount);
        }
        this.beforeChangeWordRank = this.afterChangeWordRank = this.wordCount;
        this.wordIdxShift = 0;
    }

    protected int wordId(int wordRank) {
        return this.words.intAt(wordRank);
    }

    protected IWord word(int wordRank) {
        return this.dictionary.getWordFromId(this.words.intAt(wordRank));
    }

    protected int wordBeginIdx(int wordRank) {
        return IntBuffer.getIntAt((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank);
    }

    protected int wordEndIdx(int wordRank) {
        return IntBuffer.getIntAt((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank);
    }

    protected int spaceBefore(int wordRank) {
        int fromIdx = wordRank == 0 ? 0 : this.wordEndIdx(wordRank - 1);
        int toIdx = wordRank == this.wordCount ? this.text.length() : this.wordBeginIdx(wordRank);
        return toIdx - fromIdx;
    }

    protected int correctedWordBeginIdx(int wordRank) {
        int idx = IntBuffer.getIntAt((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank);
        return wordRank < this.afterChangeWordRank ? idx : idx + this.wordIdxShift;
    }

    protected int correctedWordEndIdx(int wordRank) {
        int idx = IntBuffer.getIntAt((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank);
        return wordRank < this.afterChangeWordRank ? idx : idx + this.wordIdxShift;
    }

    protected int correctedSpaceBefore(int wordRank) {
        int fromIdx = wordRank == 0 ? 0 : this.correctedWordEndIdx(wordRank - 1);
        int toIdx = wordRank == this.wordCount ? this.text.length() : this.correctedWordBeginIdx(wordRank);
        return toIdx - fromIdx;
    }

    protected TextToken newToken(int wordRank) {
        if (wordRank < 0) {
            return this.partitioner.newToken();
        }
        if (wordRank >= this.wordCount) {
            int length = this.text.length();
            return this.partitioner.newToken(length, length, 0, false, 0);
        }
        IWord word = this.word(wordRank);
        return this.partitioner.newToken(this.wordBeginIdx(wordRank), this.wordEndIdx(wordRank), word.getCategory(), word.isIgnoreCase(), word.getHash());
    }

    protected void insertWord(int wordRank, TextToken token) {
        IWord word = this.dictionary.addWord(this.text, token);
        this.words.insert(wordRank, word.getId());
        this.wordBeginIdx = IntBuffer.insert((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank, (int)1);
        this.wordBeginIdx[wordRank] = token.beginIdx;
        this.wordEndIdx = IntBuffer.insert((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank, (int)1);
        this.wordEndIdx[wordRank] = token.endIdx;
        this.wordHoleIdx = wordRank + 1;
        ++this.wordCount;
    }

    protected void removeWord(int wordRank) {
        this.words.delete(wordRank);
        this.wordBeginIdx = IntBuffer.delete((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank, (int)1);
        this.wordEndIdx = IntBuffer.delete((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)wordRank, (int)1);
        this.wordHoleIdx = wordRank;
        --this.wordCount;
    }

    protected void removeWords(int beginWordRank, int endWordRank) {
        int toDelete = endWordRank - beginWordRank;
        if (toDelete > 0) {
            this.words.delete(beginWordRank, endWordRank);
            this.wordBeginIdx = IntBuffer.delete((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)beginWordRank, (int)toDelete);
            this.wordEndIdx = IntBuffer.delete((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)beginWordRank, (int)toDelete);
            this.wordHoleIdx = beginWordRank;
            this.wordCount -= toDelete;
        }
    }

    protected void clearWords() {
        this.words = null;
        this.wordEndIdx = null;
        this.wordBeginIdx = null;
        this.afterChangeWordRank = 0;
        this.beforeChangeWordRank = 0;
        this.wordIdxShift = 0;
        this.wordHoleIdx = 0;
        this.wordCount = 0;
    }

    protected void updateWords(int beginIdx, int endIdx, int newTextLength) {
        if (this.words == null) {
            return;
        }
        this.updateWordChangeInterval(beginIdx, endIdx, newTextLength);
        if (this.afterChangeWordRank == this.wordCount) {
            if (this.beforeChangeWordRank == this.wordCount) {
                this.wordIdxShift = 0;
            } else if (this.beforeChangeWordRank == -1) {
                this.clearWords();
            }
        }
    }

    protected void updateWordChangeInterval(int beginIdx, int endIdx, int insertLength) {
        int rank;
        if (this.beforeChangeWordRank != this.afterChangeWordRank) {
            int oldBeginIdx;
            int n = oldBeginIdx = this.beforeChangeWordRank >= 0 ? this.wordEndIdx(this.beforeChangeWordRank) + 1 : 0;
            if (endIdx >= oldBeginIdx) {
                int oldEndIdx;
                int n2 = oldEndIdx = this.afterChangeWordRank < this.wordCount ? this.wordBeginIdx(this.afterChangeWordRank) + this.wordIdxShift - 1 : this.text.length();
                if (beginIdx <= oldEndIdx) {
                    this.enlargeWordChangeInterval(oldBeginIdx, oldEndIdx, beginIdx, endIdx, insertLength);
                    return;
                }
            }
            this.refreshWords();
        }
        if (this.afterChangeWordRank == this.wordCount) {
            this.computeWordChangeInterval(beginIdx, endIdx, insertLength);
            return;
        }
        int oldChangeIdx = this.wordBeginIdx(this.afterChangeWordRank) + this.wordIdxShift;
        if (endIdx < oldChangeIdx) {
            rank = this.afterChangeWordRank - 1;
            if (rank >= 0) {
                int wordBegin = this.wordBeginIdx(rank);
                while (endIdx < wordBegin) {
                    IntBuffer.setIntAt((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)rank, (int)(wordBegin - this.wordIdxShift));
                    IntBuffer.setIntAt((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)rank, (int)(this.wordEndIdx(rank) - this.wordIdxShift));
                    if (--rank < 0) break;
                    wordBegin = this.wordBeginIdx(rank);
                }
            }
            this.afterChangeWordRank = rank + 1;
            this.beforeChangeWordRank = this.wordRankBeforeIndex(beginIdx, 0, rank);
            this.wordIdxShift += insertLength - endIdx + beginIdx;
            return;
        }
        if (oldChangeIdx < beginIdx) {
            rank = this.afterChangeWordRank;
            int shiftedBeginIdx = beginIdx - this.wordIdxShift;
            int wordEnd = this.wordEndIdx(rank);
            while (wordEnd < shiftedBeginIdx) {
                IntBuffer.setIntAt((int[])this.wordBeginIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)rank, (int)(this.wordBeginIdx(rank) + this.wordIdxShift));
                IntBuffer.setIntAt((int[])this.wordEndIdx, (int)this.wordHoleIdx, (int)this.wordCount, (int)rank, (int)(wordEnd + this.wordIdxShift));
                if (++rank == this.wordCount) break;
                wordEnd = this.wordEndIdx(rank);
            }
            this.beforeChangeWordRank = rank - 1;
            this.afterChangeWordRank = this.wordRankAfterIndex(endIdx - this.wordIdxShift, rank, this.wordCount - 1);
            this.wordIdxShift += insertLength - endIdx + beginIdx;
            return;
        }
        this.beforeChangeWordRank = this.wordRankBeforeIndex(beginIdx, 0, this.afterChangeWordRank - 1);
        this.afterChangeWordRank = this.wordRankAfterIndex(endIdx - this.wordIdxShift, this.afterChangeWordRank, this.wordCount - 1);
        this.wordIdxShift += insertLength - endIdx + beginIdx;
    }

    protected void computeWordChangeInterval(int beginIdx, int endIdx, int newTextLength) {
        this.beforeChangeWordRank = this.wordRankBeforeIndex(beginIdx, 0, this.wordCount - 1);
        this.afterChangeWordRank = this.wordRankAfterIndex(endIdx, this.beforeChangeWordRank + 1, this.wordCount - 1);
        this.wordIdxShift = newTextLength - endIdx + beginIdx;
    }

    protected void enlargeWordChangeInterval(int previousBeginIdx, int previousEndIdx, int beginIdx, int endIdx, int newTextLength) {
        if (beginIdx < previousBeginIdx) {
            this.beforeChangeWordRank = this.wordRankBeforeIndex(beginIdx, 0, this.beforeChangeWordRank);
        }
        if (endIdx > previousEndIdx) {
            this.afterChangeWordRank = this.wordRankAfterIndex(endIdx - this.wordIdxShift, this.afterChangeWordRank, this.wordCount - 1);
        }
        this.wordIdxShift += newTextLength - endIdx + beginIdx;
    }

    protected int wordRankBeforeIndex(int index, int lowRank, int highRank) {
        int rank = this.wordAtIndex(index, lowRank, highRank);
        rank = rank < 0 ? ~rank - 1 : rank - 1;
        return rank >= 0 && this.wordEndIdx(rank) == index ? rank - 1 : rank;
    }

    protected int wordRankAfterIndex(int index, int lowRank, int highRank) {
        int rank = this.wordAtIndex(index, lowRank, highRank);
        return rank < 0 ? ~rank : rank + 1;
    }

    protected int wordAtIndex(int index) {
        return this.wordAtIndex(index, 0, this.wordCount - 1);
    }

    protected int wordAtIndex(int index, int low, int high) {
        while (low <= high) {
            int middle = low + high >> 1;
            if (index < this.wordBeginIdx(middle)) {
                high = middle - 1;
                continue;
            }
            if (index >= this.wordEndIdx(middle)) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return ~low;
    }

    protected int correctedWordAtIndex(int index) {
        return this.correctedWordAtIndex(index, 0, this.wordCount - 1);
    }

    /*
     * Unable to fully structure code
     */
    protected int correctedWordAtIndex(int index, int low, int high) {
        if (low >= this.afterChangeWordRank) {
            return this.wordAtIndex(index - this.wordIdxShift, low, high);
        }
        if (high >= this.afterChangeWordRank) ** GOTO lbl15
        return this.wordAtIndex(index, low, high);
lbl-1000:
        // 1 sources

        {
            middle = low + high >> 1;
            if (index < this.correctedWordBeginIdx(middle)) {
                high = middle - 1;
                if (high >= this.afterChangeWordRank) continue;
                return this.wordAtIndex(index, low, high);
            }
            if (index >= this.correctedWordEndIdx(middle)) {
                low = middle + 1;
                if (low < this.afterChangeWordRank) continue;
                return this.wordAtIndex(index - this.wordIdxShift, low, high);
            }
            return middle;
lbl15:
            // 3 sources

            ** while (low <= high)
        }
lbl16:
        // 1 sources

        return ~low;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int idx = 0;
        int nbWord = this.getWordsCount();
        int rank = 0;
        while (rank < nbWord) {
            int nextWordIdx = this.wordBeginIndex(rank);
            if (nextWordIdx > idx) {
                builder.append(this.text, idx, nextWordIdx);
            }
            idx = this.wordEndIdx(rank);
            builder.append('[');
            builder.append(this.text, nextWordIdx, idx);
            builder.append(']');
            ++rank;
        }
        if (idx < this.text.length()) {
            builder.append(this.text, idx, this.text.length());
        }
        return builder.toString();
    }
}

